/* Copyright (c) 2010, Code Aurora Forum. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above
 *       copyright notice, this list of conditions and the following
 *       disclaimer in the documentation and/or other materials provided
 *       with the distribution.
 *     * Neither the name of Code Aurora Forum, Inc. nor the names of its
 *       contributors may be used to endorse or promote products derived
 *       from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED "AS IS" AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
 * BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN
 * IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

#ifndef __ARCH_ARM_MACH_MSM_RPM_H
#define __ARCH_ARM_MACH_MSM_RPM_H

#include <linux/types.h>
#include <linux/list.h>
#include <linux/semaphore.h>


enum {
	MSM_RPM_PAGE_STATUS,
	MSM_RPM_PAGE_CTRL,
	MSM_RPM_PAGE_REQ,
	MSM_RPM_PAGE_ACK,
	MSM_RPM_PAGE_COUNT
};

enum {
	MSM_RPM_CTX_SET_0,
	MSM_RPM_CTX_SET_SLEEP,
	MSM_RPM_CTX_SET_COUNT,

	MSM_RPM_CTX_NOTIFICATION = 30,
	MSM_RPM_CTX_REJECTED = 31,
};

static inline uint32_t msm_rpm_get_ctx_mask(unsigned int ctx)
{
	return 1UL << ctx;
}

enum {
	MSM_RPM_SEL_NOTIFICATION,
	MSM_RPM_SEL_INVALIDATE,
	MSM_RPM_SEL_TRIGGER_TIMED,
	MSM_RPM_SEL_TRIGGER_SET,
	MSM_RPM_SEL_TRIGGER_CLEAR,

	MSM_RPM_SEL_CXO_CLK,
	MSM_RPM_SEL_PXO_CLK,
	MSM_RPM_SEL_PLL_4,
	MSM_RPM_SEL_APPS_FABRIC_CLK,
	MSM_RPM_SEL_SYSTEM_FABRIC_CLK,
	MSM_RPM_SEL_MM_FABRIC_CLK,
	MSM_RPM_SEL_DAYTONA_FABRIC_CLK,
	MSM_RPM_SEL_SFPB_CLK,
	MSM_RPM_SEL_CFPB_CLK,
	MSM_RPM_SEL_MMFPB_CLK,
	MSM_RPM_SEL_SMI_CLK,
	MSM_RPM_SEL_EBI1_CLK,

	MSM_RPM_SEL_APPS_L2_CACHE_CTL,

	MSM_RPM_SEL_APPS_FABRIC_HALT,
	MSM_RPM_SEL_APPS_FABRIC_CLOCK_MODE,
	MSM_RPM_SEL_APPS_FABRIC_IOCTL,
	MSM_RPM_SEL_APPS_FABRIC_ARB,

	MSM_RPM_SEL_SYSTEM_FABRIC_HALT,
	MSM_RPM_SEL_SYSTEM_FABRIC_CLOCK_MODE,
	MSM_RPM_SEL_SYSTEM_FABRIC_IOCTL,
	MSM_RPM_SEL_SYSTEM_FABRIC_ARB,

	MSM_RPM_SEL_MM_FABRIC_HALT,
	MSM_RPM_SEL_MM_FABRIC_CLOCK_MODE,
	MSM_RPM_SEL_MM_FABRIC_IOCTL,
	MSM_RPM_SEL_MM_FABRIC_ARB,

	MSM_RPM_SEL_SMPS0B,
	MSM_RPM_SEL_SMPS1B,
	MSM_RPM_SEL_SMPS2B,
	MSM_RPM_SEL_SMPS3B,
	MSM_RPM_SEL_SMPS4B,
	MSM_RPM_SEL_LDO0B,
	MSM_RPM_SEL_LDO1B,
	MSM_RPM_SEL_LDO2B,
	MSM_RPM_SEL_LDO3B,
	MSM_RPM_SEL_LDO4B,
	MSM_RPM_SEL_LDO5B,
	MSM_RPM_SEL_LDO6B,
	MSM_RPM_SEL_LVS0B,
	MSM_RPM_SEL_LVS1B,
	MSM_RPM_SEL_LVS2B,
	MSM_RPM_SEL_LVS3B,
	MSM_RPM_SEL_MVS,

	MSM_RPM_SEL_SMPS0,
	MSM_RPM_SEL_SMPS1,
	MSM_RPM_SEL_SMPS2,
	MSM_RPM_SEL_SMPS3,
	MSM_RPM_SEL_SMPS4,

	MSM_RPM_SEL_LDO0,
	MSM_RPM_SEL_LDO1,
	MSM_RPM_SEL_LDO2,
	MSM_RPM_SEL_LDO3,
	MSM_RPM_SEL_LDO4,
	MSM_RPM_SEL_LDO5,
	MSM_RPM_SEL_LDO6,
	MSM_RPM_SEL_LDO7,
	MSM_RPM_SEL_LDO8,
	MSM_RPM_SEL_LDO9,
	MSM_RPM_SEL_LDO10,
	MSM_RPM_SEL_LDO11,
	MSM_RPM_SEL_LDO12,
	MSM_RPM_SEL_LDO13,
	MSM_RPM_SEL_LDO14,
	MSM_RPM_SEL_LDO15,
	MSM_RPM_SEL_LDO16,
	MSM_RPM_SEL_LDO17,
	MSM_RPM_SEL_LDO18,
	MSM_RPM_SEL_LDO19,
	MSM_RPM_SEL_LDO20,
	MSM_RPM_SEL_LDO21,
	MSM_RPM_SEL_LDO22,
	MSM_RPM_SEL_LDO23,
	MSM_RPM_SEL_LDO24,
	MSM_RPM_SEL_LDO25,
	MSM_RPM_SEL_LVS0,
	MSM_RPM_SEL_LVS1,
	MSM_RPM_SEL_NCP,

	MSM_RPM_SEL_CXO_BUFFERS,

	MSM_RPM_SEL_LAST = MSM_RPM_SEL_CXO_BUFFERS,
};

#define MSM_RPM_SEL_MASK_SIZE  (MSM_RPM_SEL_LAST / 32 + 1)

static inline unsigned int msm_rpm_get_sel_mask_reg(unsigned int sel)
{
	return sel / 32;
}

static inline uint32_t msm_rpm_get_sel_mask(unsigned int sel)
{
	return 1UL << (sel % 32);
}

enum {
	MSM_RPM_ID_NOTIFICATION_CONFIGURED_0,
	MSM_RPM_ID_NOTIFICATION_CONFIGURED_7 =
		MSM_RPM_ID_NOTIFICATION_CONFIGURED_0 + 7,

	MSM_RPM_ID_NOTIFICATION_REGISTERED_0,
	MSM_RPM_ID_NOTIFICATION_REGISTERED_7 =
		MSM_RPM_ID_NOTIFICATION_REGISTERED_0 + 7,

	MSM_RPM_ID_INVALIDATE_0,
	MSM_RPM_ID_INVALIDATE_7 = MSM_RPM_ID_INVALIDATE_0 + 7,

	MSM_RPM_ID_TRIGGER_TIMED_TO,
	MSM_RPM_ID_TRIGGER_TIMED_SCLK_COUNT,

	MSM_RPM_ID_TRIGGER_SET_FROM,
	MSM_RPM_ID_TRIGGER_SET_TO,
	MSM_RPM_ID_TRIGGER_SET_TRIGGER,

	MSM_RPM_ID_TRIGGER_CLEAR_FROM,
	MSM_RPM_ID_TRIGGER_CLEAR_TO,
	MSM_RPM_ID_TRIGGER_CLEAR_TRIGGER,

	MSM_RPM_ID_CXO_CLK,
	MSM_RPM_ID_PXO_CLK,
	MSM_RPM_ID_PLL_4,
	MSM_RPM_ID_APPS_FABRIC_CLK,
	MSM_RPM_ID_SYSTEM_FABRIC_CLK,
	MSM_RPM_ID_MM_FABRIC_CLK,
	MSM_RPM_ID_DAYTONA_FABRIC_CLK,
	MSM_RPM_ID_SFPB_CLK,
	MSM_RPM_ID_CFPB_CLK,
	MSM_RPM_ID_MMFPB_CLK,
	MSM_RPM_ID_SMI_CLK,
	MSM_RPM_ID_EBI1_CLK,

	MSM_RPM_ID_APPS_L2_CACHE_CTL,

	MSM_RPM_ID_APPS_FABRIC_HALT_0,
	MSM_RPM_ID_APPS_FABRIC_HALT_1,
	MSM_RPM_ID_APPS_FABRIC_CLOCK_MODE_0,
	MSM_RPM_ID_APPS_FABRIC_CLOCK_MODE_1,
	MSM_RPM_ID_APPS_FABRIC_CLOCK_MODE_2,
	MSM_RPM_ID_APPS_FABRIC_RESERVED_A,
	MSM_RPM_ID_APPS_FABRIC_ARB_0,
	MSM_RPM_ID_APPS_FABRIC_ARB_5 = MSM_RPM_ID_APPS_FABRIC_ARB_0 + 5,
	MSM_RPM_ID_APPS_FABRIC_RESERVED_B_0,
	MSM_RPM_ID_APPS_FABRIC_RESERVED_B_5 =
		MSM_RPM_ID_APPS_FABRIC_RESERVED_B_0 + 5,

	MSM_RPM_ID_SYSTEM_FABRIC_HALT_0,
	MSM_RPM_ID_SYSTEM_FABRIC_HALT_1,
	MSM_RPM_ID_SYSTEM_FABRIC_CLOCK_MODE_0,
	MSM_RPM_ID_SYSTEM_FABRIC_CLOCK_MODE_1,
	MSM_RPM_ID_SYSTEM_FABRIC_CLOCK_MODE_2,
	MSM_RPM_ID_SYSTEM_FABRIC_RESERVED_A,
	MSM_RPM_ID_SYSTEM_FABRIC_ARB_0,
	MSM_RPM_ID_SYSTEM_FABRIC_ARB_21 = MSM_RPM_ID_SYSTEM_FABRIC_ARB_0 + 21,
	MSM_RPM_ID_SYSTEM_FABRIC_RESERVED_B_0,
	MSM_RPM_ID_SYSTEM_FABRIC_RESERVED_B_13 =
		MSM_RPM_ID_SYSTEM_FABRIC_RESERVED_B_0 + 13,

	MSM_RPM_ID_MM_FABRIC_HALT_0,
	MSM_RPM_ID_MM_FABRIC_HALT_1,
	MSM_RPM_ID_MM_FABRIC_CLOCK_MODE_0,
	MSM_RPM_ID_MM_FABRIC_CLOCK_MODE_1,
	MSM_RPM_ID_MM_FABRIC_CLOCK_MODE_2,
	MSM_RPM_ID_MM_FABRIC_RESERVED_A,
	MSM_RPM_ID_MM_FABRIC_ARB_0,
	MSM_RPM_ID_MM_FABRIC_ARB_14 = MSM_RPM_ID_MM_FABRIC_ARB_0 + 14,
	MSM_RPM_ID_MM_FABRIC_RESERVED_B_0,
	MSM_RPM_ID_MM_FABRIC_RESERVED_B_7 =
		MSM_RPM_ID_MM_FABRIC_RESERVED_B_0 + 7,

	/* pmic 8901 */
	MSM_RPM_ID_SMPS0B_0,
	MSM_RPM_ID_SMPS0B_1,
	MSM_RPM_ID_SMPS1B_0,
	MSM_RPM_ID_SMPS1B_1,
	MSM_RPM_ID_SMPS2B_0,
	MSM_RPM_ID_SMPS2B_1,
	MSM_RPM_ID_SMPS3B_0,
	MSM_RPM_ID_SMPS3B_1,
	MSM_RPM_ID_SMPS4B_0,
	MSM_RPM_ID_SMPS4B_1,
	MSM_RPM_ID_LDO0B_0,
	MSM_RPM_ID_LDO0B_1,
	MSM_RPM_ID_LDO1B_0,
	MSM_RPM_ID_LDO1B_1,
	MSM_RPM_ID_LDO2B_0,
	MSM_RPM_ID_LDO2B_1,
	MSM_RPM_ID_LDO3B_0,
	MSM_RPM_ID_LDO3B_1,
	MSM_RPM_ID_LDO4B_0,
	MSM_RPM_ID_LDO4B_1,
	MSM_RPM_ID_LDO5B_0,
	MSM_RPM_ID_LDO5B_1,
	MSM_RPM_ID_LDO6B_0,
	MSM_RPM_ID_LDO6B_1,
	MSM_RPM_ID_LVS0B,
	MSM_RPM_ID_LVS1B,
	MSM_RPM_ID_LVS2B,
	MSM_RPM_ID_LVS3B,
	MSM_RPM_ID_MVS,

	/* pmic 8058 */
	MSM_RPM_ID_SMPS0_0,
	MSM_RPM_ID_SMPS0_1,
	MSM_RPM_ID_SMPS1_0,
	MSM_RPM_ID_SMPS1_1,
	MSM_RPM_ID_SMPS2_0,
	MSM_RPM_ID_SMPS2_1,
	MSM_RPM_ID_SMPS3_0,
	MSM_RPM_ID_SMPS3_1,
	MSM_RPM_ID_SMPS4_0,
	MSM_RPM_ID_SMPS4_1,
	MSM_RPM_ID_LDO0_0,
	MSM_RPM_ID_LDO0_1,
	MSM_RPM_ID_LDO1_0,
	MSM_RPM_ID_LDO1_1,
	MSM_RPM_ID_LDO2_0,
	MSM_RPM_ID_LDO2_1,
	MSM_RPM_ID_LDO3_0,
	MSM_RPM_ID_LDO3_1,
	MSM_RPM_ID_LDO4_0,
	MSM_RPM_ID_LDO4_1,
	MSM_RPM_ID_LDO5_0,
	MSM_RPM_ID_LDO5_1,
	MSM_RPM_ID_LDO6_0,
	MSM_RPM_ID_LDO6_1,
	MSM_RPM_ID_LDO7_0,
	MSM_RPM_ID_LDO7_1,
	MSM_RPM_ID_LDO8_0,
	MSM_RPM_ID_LDO8_1,
	MSM_RPM_ID_LDO9_0,
	MSM_RPM_ID_LDO9_1,
	MSM_RPM_ID_LDO10_0,
	MSM_RPM_ID_LDO10_1,
	MSM_RPM_ID_LDO11_0,
	MSM_RPM_ID_LDO11_1,
	MSM_RPM_ID_LDO12_0,
	MSM_RPM_ID_LDO12_1,
	MSM_RPM_ID_LDO13_0,
	MSM_RPM_ID_LDO13_1,
	MSM_RPM_ID_LDO14_0,
	MSM_RPM_ID_LDO14_1,
	MSM_RPM_ID_LDO15_0,
	MSM_RPM_ID_LDO15_1,
	MSM_RPM_ID_LDO16_0,
	MSM_RPM_ID_LDO16_1,
	MSM_RPM_ID_LDO17_0,
	MSM_RPM_ID_LDO17_1,
	MSM_RPM_ID_LDO18_0,
	MSM_RPM_ID_LDO18_1,
	MSM_RPM_ID_LDO19_0,
	MSM_RPM_ID_LDO19_1,
	MSM_RPM_ID_LDO20_0,
	MSM_RPM_ID_LDO20_1,
	MSM_RPM_ID_LDO21_0,
	MSM_RPM_ID_LDO21_1,
	MSM_RPM_ID_LDO22_0,
	MSM_RPM_ID_LDO22_1,
	MSM_RPM_ID_LDO23_0,
	MSM_RPM_ID_LDO23_1,
	MSM_RPM_ID_LDO24_0,
	MSM_RPM_ID_LDO24_1,
	MSM_RPM_ID_LDO25_0,
	MSM_RPM_ID_LDO25_1,
	MSM_RPM_ID_LVS0,
	MSM_RPM_ID_LVS1,
	MSM_RPM_ID_NCP_0,
	MSM_RPM_ID_NCP_1,

	MSM_RPM_ID_CXO_BUFFERS,

	MSM_RPM_ID_LAST = MSM_RPM_ID_CXO_BUFFERS
};

enum {
	MSM_RPM_STATUS_ID_VERSION_MAJOR,
	MSM_RPM_STATUS_ID_VERSION_MINOR,
	MSM_RPM_STATUS_ID_VERSION_BUILD,
	MSM_RPM_STATUS_ID_SUPPORTED_RESOURCES_0,
	MSM_RPM_STATUS_ID_SUPPORTED_RESOURCES_1,
	MSM_RPM_STATUS_ID_SUPPORTED_RESOURCES_2,
	MSM_RPM_STATUS_ID_RESERVED_0,
	MSM_RPM_STATUS_ID_RESERVED_4 = MSM_RPM_STATUS_ID_RESERVED_0 + 4,
	MSM_RPM_STATUS_ID_SEQUENCE,

	MSM_RPM_STATUS_ID_CXO_CLK,
	MSM_RPM_STATUS_ID_PXO_CLK,
	MSM_RPM_STATUS_ID_PLL_4,
	MSM_RPM_STATUS_ID_APPS_FABRIC_CLK,
	MSM_RPM_STATUS_ID_SYSTEM_FABRIC_CLK,
	MSM_RPM_STATUS_ID_MM_FABRIC_CLK,
	MSM_RPM_STATUS_ID_DAYTONA_FABRIC_CLK,
	MSM_RPM_STATUS_ID_SFPB_CLK,
	MSM_RPM_STATUS_ID_CFPB_CLK,
	MSM_RPM_STATUS_ID_MMFPB_CLK,
	MSM_RPM_STATUS_ID_SMI_CLK,
	MSM_RPM_STATUS_ID_EBI1_CLK,

	MSM_RPM_STATUS_ID_APPS_L2_CACHE_CTL,

	MSM_RPM_STATUS_ID_APPS_FABRIC_HALT,
	MSM_RPM_STATUS_ID_APPS_FABRIC_CLOCK_MODE,
	MSM_RPM_STATUS_ID_APPS_FABRIC_RESERVED,
	MSM_RPM_STATUS_ID_APPS_FABRIC_ARB,

	MSM_RPM_STATUS_ID_SYSTEM_FABRIC_HALT,
	MSM_RPM_STATUS_ID_SYSTEM_FABRIC_CLOCK_MODE,
	MSM_RPM_STATUS_ID_SYSTEM_FABRIC_RESERVED,
	MSM_RPM_STATUS_ID_SYSTEM_FABRIC_ARB,

	MSM_RPM_STATUS_ID_MM_FABRIC_HALT,
	MSM_RPM_STATUS_ID_MM_FABRIC_CLOCK_MODE,
	MSM_RPM_STATUS_ID_MM_FABRIC_RESERVED,
	MSM_RPM_STATUS_ID_MM_FABRIC_ARB,

	/* pmic 8901 */
	MSM_RPM_STATUS_ID_SMPS0B_0,
	MSM_RPM_STATUS_ID_SMPS0B_1,
	MSM_RPM_STATUS_ID_SMPS1B_0,
	MSM_RPM_STATUS_ID_SMPS1B_1,
	MSM_RPM_STATUS_ID_SMPS2B_0,
	MSM_RPM_STATUS_ID_SMPS2B_1,
	MSM_RPM_STATUS_ID_SMPS3B_0,
	MSM_RPM_STATUS_ID_SMPS3B_1,
	MSM_RPM_STATUS_ID_SMPS4B_0,
	MSM_RPM_STATUS_ID_SMPS4B_1,
	MSM_RPM_STATUS_ID_LDO0B_0,
	MSM_RPM_STATUS_ID_LDO0B_1,
	MSM_RPM_STATUS_ID_LDO1B_0,
	MSM_RPM_STATUS_ID_LDO1B_1,
	MSM_RPM_STATUS_ID_LDO2B_0,
	MSM_RPM_STATUS_ID_LDO2B_1,
	MSM_RPM_STATUS_ID_LDO3B_0,
	MSM_RPM_STATUS_ID_LDO3B_1,
	MSM_RPM_STATUS_ID_LDO4B_0,
	MSM_RPM_STATUS_ID_LDO4B_1,
	MSM_RPM_STATUS_ID_LDO5B_0,
	MSM_RPM_STATUS_ID_LDO5B_1,
	MSM_RPM_STATUS_ID_LDO6B_0,
	MSM_RPM_STATUS_ID_LDO6B_1,
	MSM_RPM_STATUS_ID_LVS0B,
	MSM_RPM_STATUS_ID_LVS1B,
	MSM_RPM_STATUS_ID_LVS2B,
	MSM_RPM_STATUS_ID_LVS3B,
	MSM_RPM_STATUS_ID_MVS,

	/* pmic 8058 */
	MSM_RPM_STATUS_ID_SMPS0_0,
	MSM_RPM_STATUS_ID_SMPS0_1,
	MSM_RPM_STATUS_ID_SMPS1_0,
	MSM_RPM_STATUS_ID_SMPS1_1,
	MSM_RPM_STATUS_ID_SMPS2_0,
	MSM_RPM_STATUS_ID_SMPS2_1,
	MSM_RPM_STATUS_ID_SMPS3_0,
	MSM_RPM_STATUS_ID_SMPS3_1,
	MSM_RPM_STATUS_ID_SMPS4_0,
	MSM_RPM_STATUS_ID_SMPS4_1,
	MSM_RPM_STATUS_ID_LDO0_0,
	MSM_RPM_STATUS_ID_LDO0_1,
	MSM_RPM_STATUS_ID_LDO1_0,
	MSM_RPM_STATUS_ID_LDO1_1,
	MSM_RPM_STATUS_ID_LDO2_0,
	MSM_RPM_STATUS_ID_LDO2_1,
	MSM_RPM_STATUS_ID_LDO3_0,
	MSM_RPM_STATUS_ID_LDO3_1,
	MSM_RPM_STATUS_ID_LDO4_0,
	MSM_RPM_STATUS_ID_LDO4_1,
	MSM_RPM_STATUS_ID_LDO5_0,
	MSM_RPM_STATUS_ID_LDO5_1,
	MSM_RPM_STATUS_ID_LDO6_0,
	MSM_RPM_STATUS_ID_LDO6_1,
	MSM_RPM_STATUS_ID_LDO7_0,
	MSM_RPM_STATUS_ID_LDO7_1,
	MSM_RPM_STATUS_ID_LDO8_0,
	MSM_RPM_STATUS_ID_LDO8_1,
	MSM_RPM_STATUS_ID_LDO9_0,
	MSM_RPM_STATUS_ID_LDO9_1,
	MSM_RPM_STATUS_ID_LDO10_0,
	MSM_RPM_STATUS_ID_LDO10_1,
	MSM_RPM_STATUS_ID_LDO11_0,
	MSM_RPM_STATUS_ID_LDO11_1,
	MSM_RPM_STATUS_ID_LDO12_0,
	MSM_RPM_STATUS_ID_LDO12_1,
	MSM_RPM_STATUS_ID_LDO13_0,
	MSM_RPM_STATUS_ID_LDO13_1,
	MSM_RPM_STATUS_ID_LDO14_0,
	MSM_RPM_STATUS_ID_LDO14_1,
	MSM_RPM_STATUS_ID_LDO15_0,
	MSM_RPM_STATUS_ID_LDO15_1,
	MSM_RPM_STATUS_ID_LDO16_0,
	MSM_RPM_STATUS_ID_LDO16_1,
	MSM_RPM_STATUS_ID_LDO17_0,
	MSM_RPM_STATUS_ID_LDO17_1,
	MSM_RPM_STATUS_ID_LDO18_0,
	MSM_RPM_STATUS_ID_LDO18_1,
	MSM_RPM_STATUS_ID_LDO19_0,
	MSM_RPM_STATUS_ID_LDO19_1,
	MSM_RPM_STATUS_ID_LDO20_0,
	MSM_RPM_STATUS_ID_LDO20_1,
	MSM_RPM_STATUS_ID_LDO21_0,
	MSM_RPM_STATUS_ID_LDO21_1,
	MSM_RPM_STATUS_ID_LDO22_0,
	MSM_RPM_STATUS_ID_LDO22_1,
	MSM_RPM_STATUS_ID_LDO23_0,
	MSM_RPM_STATUS_ID_LDO23_1,
	MSM_RPM_STATUS_ID_LDO24_0,
	MSM_RPM_STATUS_ID_LDO24_1,
	MSM_RPM_STATUS_ID_LDO25_0,
	MSM_RPM_STATUS_ID_LDO25_1,
	MSM_RPM_STATUS_ID_LVS0,
	MSM_RPM_STATUS_ID_LVS1,
	MSM_RPM_STATUS_ID_NCP_0,
	MSM_RPM_STATUS_ID_NCP_1,

	MSM_RPM_STATUS_ID_CXO_BUFFERS,

	MSM_RPM_STATUS_ID_LAST = MSM_RPM_STATUS_ID_CXO_BUFFERS
};

struct msm_rpm_iv_pair {
	uint32_t id;
	uint32_t value;
};

struct msm_rpm_notification {
	struct list_head list;  /* reserved for RPM use */
	struct semaphore sem;
	uint32_t sel_masks[MSM_RPM_SEL_MASK_SIZE];  /* reserved for RPM use */
};

struct msm_rpm_platform_data {
	void __iomem *reg_base_addrs[MSM_RPM_PAGE_COUNT];

	unsigned int irq_ack;
	unsigned int irq_err;
	unsigned int irq_vmpm;
};

int msm_rpm_has_outstanding_request(void);
int msm_rpm_get_status(struct msm_rpm_iv_pair *status, int count);
int msm_rpm_set(int ctx, struct msm_rpm_iv_pair *req, int count);
int msm_rpm_set_noirq(int ctx, struct msm_rpm_iv_pair *req, int count);
int msm_rpm_clear(int ctx, struct msm_rpm_iv_pair *req, int count);
int msm_rpm_clear_noirq(int ctx, struct msm_rpm_iv_pair *req, int count);
int msm_rpm_register_notification(struct msm_rpm_notification *n,
	struct msm_rpm_iv_pair *req, int count);
int msm_rpm_unregister_notification(struct msm_rpm_notification *n);
int msm_rpm_init(struct msm_rpm_platform_data *data);

#endif /* __ARCH_ARM_MACH_MSM_RPM_H */
