/* Copyright (c) 2013, The Linux Foundation. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 and
 * only version 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 */
#include "msm_sensor.h"
#include "msm_cci.h"
#include "msm_camera_io_util.h"
#define HI256_SENSOR_NAME "hi256"
#define PLATFORM_DRIVER_NAME "msm_camera_hi256"

#define CONFIG_MSMB_CAMERA_DEBUG
#undef CDBG
#ifdef CONFIG_MSMB_CAMERA_DEBUG
#define CDBG(fmt, args...) pr_err(fmt, ##args)
#else
#define CDBG(fmt, args...) do { } while (0)
#endif


DEFINE_MSM_MUTEX(hi256_mut);
static struct msm_sensor_ctrl_t hi256_s_ctrl;

static struct msm_sensor_power_setting hi256_power_setting[] = {
	{
		.seq_type = SENSOR_GPIO,
		.seq_val = SENSOR_GPIO_STANDBY,
		.config_val = GPIO_OUT_LOW,
		.delay = 0,
	},
	{
		.seq_type = SENSOR_GPIO,
		.seq_val = SENSOR_GPIO_STANDBY,
		.config_val = GPIO_OUT_HIGH,
		.delay = 0,
	},
	{
		.seq_type = SENSOR_VREG,
		.seq_val = CAM_VIO,
		.config_val = 0,
		.delay = 0,
	},
	{
		.seq_type = SENSOR_VREG,
		.seq_val = CAM_VANA,
		.config_val = 0,
		.delay = 0,
	},
	{
		.seq_type = SENSOR_VREG,
		.seq_val = CAM_VDIG,
		.config_val = 0,
		.delay = 0,
	},
	{
		.seq_type = SENSOR_CLK,
		.seq_val = SENSOR_CAM_MCLK,
		.config_val = 24000000,
		.delay = 5,
	},
	{
		.seq_type = SENSOR_GPIO,
		.seq_val = SENSOR_GPIO_STANDBY,
		.config_val = GPIO_OUT_LOW,
		.delay = 0,
	},
	{
		.seq_type = SENSOR_GPIO,
		.seq_val = SENSOR_GPIO_RESET,
		.config_val = GPIO_OUT_LOW,
		.delay = 10,
	},
	{
		.seq_type = SENSOR_GPIO,
		.seq_val = SENSOR_GPIO_RESET,
		.config_val = GPIO_OUT_HIGH,
		.delay = 1,
	},
	{
		.seq_type = SENSOR_I2C_MUX,
		.seq_val = 0,
		.config_val = 0,
		.delay = 0,
	},
};

static struct msm_camera_i2c_reg_conf hi256_uxga_settings[] = {
	{0x03, 0x00},
	{0x01, 0xf1},
	{0x03, 0x20},
	{0x10, 0x1c},
	{0x03, 0x22},
	{0x10, 0x69},
	{0x03, 0x00},
	{0x12, 0x00},
	{0x20, 0x00},
	{0x21, 0x0a},
	{0x22, 0x00},
	{0x23, 0x0a},
	{0x40, 0x01},
	{0x41, 0x68},
	{0x42, 0x00},
	{0x43, 0x12},
	{0x03, 0x10},
	{0x3f, 0x00},
	{0x03, 0x12},
	{0x20, 0x0f},
	{0x21, 0x0f},
	{0x90, 0x5d},
	{0x03, 0x13},
	{0x80, 0xfd},
	{0x03, 0x00},
	{0x10, 0x00},
	{0x03, 0x48},
	{0x72, 0x81},
	{0x30, 0x0c},
	{0x31, 0x80},
	{0x03, 0x20},
	{0x10, 0x9c},
	{0x03, 0x22},
	{0x10, 0xe9},
};

static struct msm_camera_i2c_reg_conf hi256_start_settings[] = {
	{0x03, 0x00},
	{0x01, 0xf0},
};

static struct msm_camera_i2c_reg_conf hi256_stop_settings[] = {
	{0x03, 0x00},
	{0x01, 0xf1},
};

static struct msm_camera_i2c_reg_conf hi256_recommend_settings[] = {
	{0x01, 0xf1},
	{0x01, 0xf3},
	{0x01, 0xf1},

	{0x08, 0x0f},
	{0x0a, 0x00},

	{0x03, 0x20},
	{0x10, 0x1c},
	{0x03, 0x22},
	{0x10, 0x69},

	{0x03, 0x00},
	{0x10, 0x13},
	{0x11, 0x90}, /* no H/V flip */
	{0x12, 0x00},
	{0x0b, 0xaa},
	{0x0c, 0xaa},
	{0x0d, 0xaa},
	{0x20, 0x00},
	{0x21, 0x06},
	{0x22, 0x00},
	{0x23, 0x05},
	{0x24, 0x04},
	{0x25, 0xb0},
	{0x26, 0x06},
	{0x27, 0x40},
	{0x40, 0x01},
	{0x41, 0x18},
	{0x42, 0x00},
	{0x43, 0x02},
	{0x45, 0x04},
	{0x46, 0x18},
	{0x47, 0xd8},
	{0x80, 0x2e},
	{0x81, 0x7e},
	{0x82, 0x90},
	{0x83, 0x00},
	{0x84, 0x0c},
	{0x85, 0x00},
	{0x90, 0x0a},
	{0x91, 0x0a},
	{0x92, 0x78},
	{0x93, 0x70},
	{0x94, 0xff},
	{0x95, 0xff},
	{0x96, 0xdc},
	{0x97, 0xfe},
	{0x98, 0x38},
	{0xa0, 0x48},
	{0xa2, 0x48},
	{0xa4, 0x48},
	{0xa6, 0x48},
	{0xa8, 0x49},
	{0xaa, 0x49},
	{0xac, 0x49},
	{0xae, 0x49},
	{0x99, 0x43},
	{0x9a, 0x43},
	{0x9b, 0x43},
	{0x9c, 0x43},
	{0x03, 0x02},
	{0x12, 0x03},
	{0x13, 0x03},
	{0x16, 0x00},
	{0x17, 0x8C},
	{0x18, 0x4c},
	{0x19, 0x00},
	{0x1a, 0x39},
	{0x1c, 0x09},
	{0x1d, 0x40},
	{0x1e, 0x30},
	{0x1f, 0x10},
	{0x20, 0x77},
	{0x21, 0xde},
	{0x22, 0xa7},
	{0x23, 0x30},
	{0x27, 0x3c},
	{0x2b, 0x80},
	{0x2e, 0x11},
	{0x2f, 0xa1},
	{0x30, 0x05},
	{0x50, 0x20},
	{0x52, 0x01},
	{0x53, 0xc1},
	{0x55, 0x1c},
	{0x56, 0x11},
	{0x5d, 0xa2},
	{0x5e, 0x5a},
	{0x60, 0x87},
	{0x61, 0x99},
	{0x62, 0x88},
	{0x63, 0x97},
	{0x64, 0x88},
	{0x65, 0x97},
	{0x67, 0x0c},
	{0x68, 0x0c},
	{0x69, 0x0c},
	{0x72, 0x89},
	{0x73, 0x96},
	{0x74, 0x89},
	{0x75, 0x96},
	{0x76, 0x89},
	{0x77, 0x96},
	{0x7c, 0x85},
	{0x7d, 0xaf},
	{0x80, 0x01},
	{0x81, 0x7f},
	{0x82, 0x13},
	{0x83, 0x24},
	{0x84, 0x7d},
	{0x85, 0x81},
	{0x86, 0x7d},
	{0x87, 0x81},
	{0x92, 0x48},
	{0x93, 0x54},
	{0x94, 0x7d},
	{0x95, 0x81},
	{0x96, 0x7d},
	{0x97, 0x81},
	{0xa0, 0x02},
	{0xa1, 0x7b},
	{0xa2, 0x02},
	{0xa3, 0x7b},
	{0xa4, 0x7b},
	{0xa5, 0x02},
	{0xa6, 0x7b},
	{0xa7, 0x02},
	{0xa8, 0x85},
	{0xa9, 0x8c},
	{0xaa, 0x85},
	{0xab, 0x8c},
	{0xac, 0x10},
	{0xad, 0x16},
	{0xae, 0x10},
	{0xaf, 0x16},
	{0xb0, 0x99},
	{0xb1, 0xa3},
	{0xb2, 0xa4},
	{0xb3, 0xae},
	{0xb4, 0x9b},
	{0xb5, 0xa2},
	{0xb6, 0xa6},
	{0xb7, 0xac},
	{0xb8, 0x9b},
	{0xb9, 0x9f},
	{0xba, 0xa6},
	{0xbb, 0xaa},
	{0xbc, 0x9b},
	{0xbd, 0x9f},
	{0xbe, 0xa6},
	{0xbf, 0xaa},
	{0xc4, 0x2c},
	{0xc5, 0x43},
	{0xc6, 0x63},
	{0xc7, 0x79},
	{0xc8, 0x2d},
	{0xc9, 0x42},
	{0xca, 0x2d},
	{0xcb, 0x42},
	{0xcc, 0x64},
	{0xcd, 0x78},
	{0xce, 0x64},
	{0xcf, 0x78},
	{0xd0, 0x0a},
	{0xd1, 0x09},
	{0xd4, 0x0a},
	{0xd5, 0x0a},
	{0xd6, 0x78},
	{0xd7, 0x70},
	{0xe0, 0xc4},
	{0xe1, 0xc4},
	{0xe2, 0xc4},
	{0xe3, 0xc4},
	{0xe4, 0x00},
	{0xe8, 0x80},
	{0xe9, 0x40},
	{0xea, 0x7f},
	{0xf0, 0x01},
	{0xf1, 0x01},
	{0xf2, 0x01},
	{0xf3, 0x01},
	{0xf4, 0x01},
	{0x03, 0x03},
	{0x10, 0x10},
	{0x03, 0x10},
	{0x10, 0x03},
	{0x12, 0x30},
	{0x13, 0x0a},
	{0x20, 0x00},
	{0x30, 0x00},
	{0x31, 0x00},
	{0x32, 0x00},
	{0x33, 0x00},
	{0x34, 0x30},
	{0x35, 0x00},
	{0x36, 0x00},
	{0x38, 0x00},
	{0x3e, 0x58},
	{0x3f, 0x00},
	{0x40, 0x80},
	{0x41, 0x00},
	{0x48, 0x90},
	{0x60, 0x67},
	{0x61, 0x95},
	{0x62, 0x95},
	{0x63, 0x50},
	{0x64, 0x41},
	{0x66, 0x42},
	{0x67, 0x20},
	{0x6a, 0x80},
	{0x6b, 0x80},
	{0x6c, 0x80},
	{0x6d, 0x80},
	{0x03, 0x11},
	{0x10, 0x7f},
	{0x11, 0x40},
	{0x12, 0x0a},
	{0x13, 0xbb},
	{0x26, 0x31},
	{0x27, 0x34},
	{0x28, 0x0f},
	{0x29, 0x10},
	{0x2b, 0x30},
	{0x2c, 0x32},
	{0x30, 0x70},
	{0x31, 0x10},
	{0x32, 0x58},
	{0x33, 0x09},
	{0x34, 0x06},
	{0x35, 0x03},
	{0x36, 0x70},
	{0x37, 0x18},
	{0x38, 0x58},
	{0x39, 0x09},
	{0x3a, 0x06},
	{0x3b, 0x03},
	{0x3c, 0x80},
	{0x3d, 0x18},
	{0x3e, 0x80},
	{0x3f, 0x0D},
	{0x40, 0x0A},
	{0x41, 0x08},
	{0x42, 0x80},
	{0x43, 0x18},
	{0x44, 0x80},
	{0x45, 0x12},
	{0x46, 0x10},
	{0x47, 0x10},
	{0x48, 0x90},
	{0x49, 0x40},
	{0x4a, 0x80},
	{0x4b, 0x13},
	{0x4c, 0x10},
	{0x4d, 0x11},
	{0x4e, 0x80},
	{0x4f, 0x30},
	{0x50, 0x80},
	{0x51, 0x13},
	{0x52, 0x10},
	{0x53, 0x13},
	{0x54, 0x11},
	{0x55, 0x17},
	{0x56, 0x20},
	{0x57, 0x01},
	{0x58, 0x00},
	{0x59, 0x00},
	{0x5a, 0x1f},
	{0x5b, 0x3f},
	{0x5c, 0x00},
	{0x60, 0x3f},
	{0x62, 0x10},
	{0x70, 0x06},
	{0x03, 0x12},
	{0x20, 0x0f},
	{0x21, 0x0f},
	{0x25, 0x30},
	{0x28, 0x00},
	{0x29, 0x00},
	{0x2a, 0x00},
	{0x30, 0x30},
	{0x31, 0x38},
	{0x32, 0x42},
	{0x33, 0x60},
	{0x34, 0x70},
	{0x35, 0x80},
	{0x36, 0xa0},
	{0x40, 0xa0},
	{0x41, 0x40},
	{0x42, 0xa0},
	{0x43, 0x90},
	{0x44, 0x90},
	{0x45, 0x80},
	{0x46, 0xb0},
	{0x47, 0x55},
	{0x48, 0xa0},
	{0x49, 0x90},
	{0x4a, 0x90},
	{0x4b, 0x80},
	{0x4c, 0xb0},
	{0x4d, 0x40},
	{0x4e, 0xb0},
	{0x4f, 0xb0},
	{0x50, 0xc0},
	{0x51, 0x80},
	{0x52, 0xb0},
	{0x53, 0x60},
	{0x54, 0xc0},
	{0x55, 0xc0},
	{0x56, 0xb0},
	{0x57, 0x70},
	{0x58, 0x90},
	{0x59, 0x40},
	{0x5a, 0xd0},
	{0x5b, 0xd0},
	{0x5c, 0xc0},
	{0x5d, 0x70},
	{0x5e, 0x88},
	{0x5f, 0x40},
	{0x60, 0xe0},
	{0x61, 0xe0},
	{0x62, 0xe0},
	{0x63, 0x80},
	{0x70, 0x15},
	{0x71, 0x01},
	{0x72, 0x18},
	{0x73, 0x01},
	{0x74, 0x25},
	{0x75, 0x15},
	{0x80, 0x20},
	{0x81, 0x40},
	{0x82, 0x65},
	{0x85, 0x1a},
	{0x88, 0x00},
	{0x89, 0x00},
	{0x90, 0x5d},
	{0xD0, 0x0c},
	{0xD1, 0x80},
	{0xD2, 0x67},
	{0xD3, 0x00},
	{0xD4, 0x00},
	{0xD5, 0x02},
	{0xD6, 0xff},
	{0xD7, 0x18},
	{0x3b, 0x06},
	{0x3c, 0x06},
	{0xc5, 0x00},
	{0xc6, 0x00},
	{0x03, 0x13},
	{0x10, 0xcb},
	{0x11, 0x7b},
	{0x12, 0x07},
	{0x14, 0x00},
	{0x20, 0x15},
	{0x21, 0x13},
	{0x22, 0x33},
	{0x23, 0x05},
	{0x24, 0x09},
	{0x25, 0x0a},
	{0x26, 0x18},
	{0x27, 0x30},
	{0x29, 0x12},
	{0x2a, 0x50},
	{0x2b, 0x02},
	{0x2c, 0x02},
	{0x25, 0x06},
	{0x2d, 0x0c},
	{0x2e, 0x12},
	{0x2f, 0x12},
	{0x50, 0x10},
	{0x51, 0x14},
	{0x52, 0x12},
	{0x53, 0x0c},
	{0x54, 0x0f},
	{0x55, 0x0c},
	{0x56, 0x10},
	{0x57, 0x13},
	{0x58, 0x12},
	{0x59, 0x0c},
	{0x5a, 0x0f},
	{0x5b, 0x0c},
	{0x5c, 0x25},
	{0x5d, 0x25},
	{0x5e, 0x25},
	{0x5f, 0x25},
	{0x60, 0x25},
	{0x61, 0x25},
	{0x62, 0x25},
	{0x63, 0x25},
	{0x64, 0x25},
	{0x65, 0x25},
	{0x66, 0x25},
	{0x67, 0x25},
	{0x68, 0x07},
	{0x69, 0x07},
	{0x6a, 0x07},
	{0x6b, 0x05},
	{0x6c, 0x05},
	{0x6d, 0x05},
	{0x6e, 0x07},
	{0x6f, 0x07},
	{0x70, 0x07},
	{0x71, 0x05},
	{0x72, 0x05},
	{0x73, 0x05},
	{0x80, 0x01},
	{0x81, 0x1f},
	{0x82, 0x05},
	{0x83, 0x31},
	{0x90, 0x05},
	{0x91, 0x05},
	{0x92, 0x33},
	{0x93, 0x30},
	{0x94, 0x03},
	{0x95, 0x14},
	{0x97, 0x20},
	{0x99, 0x20},
	{0xa0, 0x01},
	{0xa1, 0x02},
	{0xa2, 0x01},
	{0xa3, 0x02},
	{0xa4, 0x05},
	{0xa5, 0x05},
	{0xa6, 0x07},
	{0xa7, 0x08},
	{0xa8, 0x07},
	{0xa9, 0x08},
	{0xaa, 0x07},
	{0xab, 0x08},
	{0xb0, 0x22},
	{0xb1, 0x2a},
	{0xb2, 0x28},
	{0xb3, 0x22},
	{0xb4, 0x2a},
	{0xb5, 0x28},
	{0xb6, 0x22},
	{0xb7, 0x2a},
	{0xb8, 0x28},
	{0xb9, 0x22},
	{0xba, 0x2a},
	{0xbb, 0x28},
	{0xbc, 0x25},
	{0xbd, 0x2a},
	{0xbe, 0x27},
	{0xbf, 0x25},
	{0xc0, 0x2a},
	{0xc1, 0x27},
	{0xc2, 0x1e},
	{0xc3, 0x24},
	{0xc4, 0x20},
	{0xc5, 0x1e},
	{0xc6, 0x24},
	{0xc7, 0x20},
	{0xc8, 0x18},
	{0xc9, 0x20},
	{0xca, 0x1e},
	{0xcb, 0x18},
	{0xcc, 0x20},
	{0xcd, 0x1e},
	{0xce, 0x18},
	{0xcf, 0x20},
	{0xd0, 0x1e},
	{0xd1, 0x18},
	{0xd2, 0x20},
	{0xd3, 0x1e},
	{0x03, 0x14},
	{0x10, 0x11},
	{0x14, 0x80},
	{0x15, 0x80},
	{0x16, 0x80},
	{0x17, 0x80},
	{0x18, 0x80},
	{0x19, 0x80},
	{0x20, 0x80},
	{0x21, 0x95},
	{0x22, 0xdc},
	{0x23, 0xcb},
	{0x24, 0xcf},
	{0x30, 0xc8},
	{0x31, 0x2b},
	{0x32, 0x00},
	{0x33, 0x00},
	{0x34, 0x90},
	{0x40, 0x54},
	{0x50, 0x4b},
	{0x60, 0x42},
	{0x70, 0x4b},
	{0x03, 0x15},
	{0x10, 0x0f},
	{0x14, 0x46},
	{0x15, 0x36},
	{0x16, 0x26},
	{0x17, 0x2f},
	{0x30, 0x8f},
	{0x31, 0x59},
	{0x32, 0x0a},
	{0x33, 0x15},
	{0x34, 0x5b},
	{0x35, 0x06},
	{0x36, 0x07},
	{0x37, 0x40},
	{0x38, 0x87},
	{0x40, 0x94},
	{0x41, 0x20},
	{0x42, 0x89},
	{0x43, 0x84},
	{0x44, 0x03},
	{0x45, 0x01},
	{0x46, 0x88},
	{0x47, 0x9c},
	{0x48, 0x28},
	{0x50, 0x02},
	{0x51, 0x82},
	{0x52, 0x00},
	{0x53, 0x07},
	{0x54, 0x11},
	{0x55, 0x98},
	{0x56, 0x00},
	{0x57, 0x0b},
	{0x58, 0x8b},
	{0x80, 0x03},
	{0x85, 0x40},
	{0x87, 0x02},
	{0x88, 0x00},
	{0x89, 0x00},
	{0x8a, 0x00},
	{0x03, 0x16},
	{0x10, 0x31},
	{0x18, 0x5e},
	{0x19, 0x5d},
	{0x1a, 0x0e},
	{0x1b, 0x01},
	{0x1c, 0xdc},
	{0x1d, 0xfe},
	{0x30, 0x00},
	{0x31, 0x0a},
	{0x32, 0x1f},
	{0x33, 0x33},
	{0x34, 0x53},
	{0x35, 0x6c},
	{0x36, 0x81},
	{0x37, 0x94},
	{0x38, 0xa4},
	{0x39, 0xb3},
	{0x3a, 0xc0},
	{0x3b, 0xcb},
	{0x3c, 0xd5},
	{0x3d, 0xde},
	{0x3e, 0xe6},
	{0x3f, 0xee},
	{0x40, 0xf5},
	{0x41, 0xfc},
	{0x42, 0xff},
	{0x50, 0x00},
	{0x51, 0x08},
	{0x52, 0x1e},
	{0x53, 0x36},
	{0x54, 0x5a},
	{0x55, 0x75},
	{0x56, 0x8d},
	{0x57, 0xa1},
	{0x58, 0xb2},
	{0x59, 0xbe},
	{0x5a, 0xc9},
	{0x5b, 0xd2},
	{0x5c, 0xdb},
	{0x5d, 0xe3},
	{0x5e, 0xeb},
	{0x5f, 0xf0},
	{0x60, 0xf5},
	{0x61, 0xf7},
	{0x62, 0xf8},
	{0x70, 0x00},
	{0x71, 0x08},
	{0x72, 0x17},
	{0x73, 0x2f},
	{0x74, 0x53},
	{0x75, 0x6c},
	{0x76, 0x81},
	{0x77, 0x94},
	{0x78, 0xa4},
	{0x79, 0xb3},
	{0x7a, 0xc0},
	{0x7b, 0xcb},
	{0x7c, 0xd5},
	{0x7d, 0xde},
	{0x7e, 0xe6},
	{0x7f, 0xee},
	{0x80, 0xf4},
	{0x81, 0xfa},
	{0x82, 0xff},
	{0x03, 0x17},
	{0x10, 0xf7},
	{0xC4, 0x66},
	{0xC5, 0x55},
	{0x03, 0x20},
	{0x11, 0x1c},
	{0x1a, 0x08},
	{0x20, 0x05},
	{0x21, 0x30},
	{0x22, 0x10},
	{0x23, 0x00},
	{0x24, 0x00},
	{0x28, 0xe7},
	{0x29, 0x0d},
	{0x2a, 0xf0},
	{0x2b, 0x34},
	{0x30, 0x78},
	{0x2c, 0xc2},
	{0x2d, 0xff},
	{0x2e, 0x33},
	{0x30, 0xf8},
	{0x32, 0x03},
	{0x33, 0x2e},
	{0x34, 0x30},
	{0x35, 0xd4},
	{0x36, 0xfe},
	{0x37, 0x32},
	{0x38, 0x04},
	{0x39, 0x22},
	{0x3a, 0xde},
	{0x3b, 0x22},
	{0x3c, 0xde},
	{0x50, 0x45},
	{0x51, 0x88},
	{0x56, 0x03},
	{0x57, 0xf7},
	{0x58, 0x14},
	{0x59, 0x88},
	{0x5a, 0x04},
	{0x60, 0x55},
	{0x61, 0x55},
	{0x62, 0x6A},
	{0x63, 0xA9},
	{0x64, 0x6A},
	{0x65, 0xA9},
	{0x66, 0x6B},
	{0x67, 0xE9},
	{0x68, 0x6B},
	{0x69, 0xE9},
	{0x6a, 0x6A},
	{0x6b, 0xA9},
	{0x6c, 0x6A},
	{0x6d, 0xA9},
	{0x6e, 0x55},
	{0x6f, 0x55},
	{0x70, 0x76},
	{0x71, 0x82},
	{0x76, 0x43},
	{0x77, 0x04},
	{0x78, 0x23},
	{0x79, 0x46},
	{0x7a, 0x23},
	{0x7b, 0x22},
	{0x7d, 0x23},
	{0x83, 0x01},
	{0x84, 0x5f},
	{0x85, 0x90},
	{0x86, 0x01},
	{0x87, 0xe0},
	{0x88, 0x04},
	{0x89, 0x93},
	{0x8a, 0xe0},
	{0x8B, 0x75},
	{0x8C, 0x30},
	{0x8D, 0x61},
	{0x8E, 0x80},
	{0x9c, 0x16},
	{0x9d, 0x80},
	{0x9e, 0x01},
	{0x9f, 0xe0},
	{0xb0, 0x18},
	{0xb1, 0x14},
	{0xb2, 0x80},
	{0xb3, 0x18},
	{0xb4, 0x1a},
	{0xb5, 0x44},
	{0xb6, 0x2f},
	{0xb7, 0x28},
	{0xb8, 0x25},
	{0xb9, 0x22},
	{0xba, 0x21},
	{0xbb, 0x20},
	{0xbc, 0x32},
	{0xbd, 0x30},
	{0xc0, 0x10},
	{0xc1, 0x2b},
	{0xc2, 0x2b},
	{0xc3, 0x2b},
	{0xc4, 0x08},
	{0xc8, 0x40},
	{0xc9, 0x40},
	{0x03, 0x22},
	{0x10, 0xfd},
	{0x11, 0x2e},
	{0x19, 0x01},
	{0x20, 0x10},
	{0x21, 0x80},
	{0x24, 0x01},
	{0x30, 0x80},
	{0x31, 0x80},
	{0x38, 0x11},
	{0x39, 0x34},
	{0x40, 0xfa},
	{0x41, 0x44},
	{0x42, 0x33},
	{0x43, 0xf6},
	{0x44, 0x44},
	{0x45, 0x33},
	{0x46, 0x00},
	{0x50, 0xb2},
	{0x51, 0x81},
	{0x52, 0x98},
	{0x80, 0x38},
	{0x81, 0x20},
	{0x82, 0x38},
	{0x83, 0x60},
	{0x84, 0x0a},
	{0x85, 0x60},
	{0x86, 0x15},
	{0x87, 0x49},
	{0x88, 0x10},
	{0x89, 0x50},
	{0x8a, 0x20},
	{0x8b, 0x41},
	{0x8c, 0x39},
	{0x8d, 0x34},
	{0x8e, 0x28},
	{0x8f, 0x52},
	{0x90, 0x50},
	{0x91, 0x4c},
	{0x92, 0x49},
	{0x93, 0x44},
	{0x94, 0x3b},
	{0x95, 0x37},
	{0x96, 0x31},
	{0x97, 0x28},
	{0x98, 0x24},
	{0x99, 0x20},
	{0x9a, 0x20},
	{0x9b, 0x88},
	{0x9c, 0x88},
	{0x9d, 0x48},
	{0x9e, 0x38},
	{0x9f, 0x30},
	{0x8f, 0x53},
	{0x90, 0x52},
	{0x91, 0x51},
	{0x92, 0x4e},
	{0x93, 0x46},
	{0x94, 0x3d},
	{0x95, 0x34},
	{0x96, 0x2e},
	{0x97, 0x29},
	{0x98, 0x22},
	{0x99, 0x1c},
	{0x9a, 0x18},
	{0xa0, 0x60},
	{0xa1, 0x34},
	{0xa2, 0x6f},
	{0xa3, 0xff},
	{0xa4, 0x14},
	{0xa5, 0x2c},
	{0xa6, 0xcf},
	{0xad, 0x40},
	{0xae, 0x4a},
	{0xaf, 0x28},
	{0xb0, 0x26},
	{0xb1, 0x00},
	{0xb4, 0xea},
	{0xb8, 0xa0},
	{0xb9, 0x00},
	{0x03, 0x48},
	{0x70, 0x03},
	{0x71, 0x30},
	{0x72, 0x81},
	{0x73, 0x10},
	{0x70, 0x85},
	{0x03, 0x48},
	{0x03, 0x48},
	{0x03, 0x48},
	{0x03, 0x48},
	{0x70, 0x95},
	{0x10, 0x1c},
	{0x11, 0x10},
	{0x12, 0x00},
	{0x14, 0x00},
	{0x16, 0x04},
	{0x18, 0x80},
	{0x19, 0x00},
	{0x1a, 0xa0},
	{0x1b, 0x0d},
	{0x1c, 0x01},
	{0x1d, 0x0a},
	{0x1e, 0x07},
	{0x1f, 0x0b},
	{0x23, 0x01},
	{0x24, 0x1e},
	{0x25, 0x00},
	{0x26, 0x00},
	{0x27, 0x08},
	{0x28, 0x00},
	{0x30, 0x06},
	{0x31, 0x40},
	{0x32, 0x13},
	{0x33, 0x0c},
	{0x34, 0x04},
	{0x35, 0x06},
	{0x36, 0x01},
	{0x37, 0x06},
	{0x39, 0x4f},
	{0x03, 0x20},
	{0x10, 0x9c},
	{0x03, 0x22},
	{0x10, 0xe9},
	{0x03, 0x00},
	{0x03, 0x00},
	{0x03, 0x00},
	{0x03, 0x00},
	{0x03, 0x00},
	{0x03, 0x00},
	{0x03, 0x00},
	{0x03, 0x00},
	{0x03, 0x00},
	{0x03, 0x00},
	{0x03, 0x00},
	{0x0e, 0x03},
	{0x0e, 0x73},
	{0x03, 0x20},
	{0x88, 0x01},
	{0x89, 0x5f},
	{0x8a, 0x90},
	{0x03, 0x20},
	{0x10, 0x9c},
	{0x03, 0x22},
	{0x10, 0xe9},
	{0x03, 0x00},
	{0x01, 0xf0},
};

static struct v4l2_subdev_info hi256_subdev_info[] = {
	{
		.code   = V4L2_MBUS_FMT_YUYV8_2X8,
		.colorspace = V4L2_COLORSPACE_JPEG,
		.fmt	= 1,
		.order	= 0,
	},
};

static struct msm_camera_i2c_reg_conf hi256_svga_settings[] = {
	{0x03, 0x20},
	{0x10, 0x1c},
	{0x03, 0x22},
	{0x10, 0x69},
	{0x03, 0x00},
	{0x10, 0x13},
	{0x12, 0x00},
	{0x20, 0x00},
	{0x21, 0x04},
	{0x22, 0x00},
	{0x23, 0x07},
	{0x40, 0x01},
	{0x41, 0x78},
	{0x42, 0x00},
	{0x43, 0x14},
	{0x03, 0x10},
	{0x3f, 0x02},
	{0x03, 0x12},
	{0x20, 0x0f},
	{0x21, 0x0f},
	{0x90, 0x5d},
	{0x03, 0x13},
	{0x80, 0x00},
	{0x03, 0x48},
	{0x72, 0x81},
	{0x30, 0x06},
	{0x31, 0x40},
	{0x03, 0x20},
	{0x10, 0x9c},
	{0x03, 0x22},
	{0x10, 0xe9},
};

static struct msm_camera_i2c_reg_conf hi256_sleep_settings[] = {

	{0x03, 0x00},
	{0x01, 0xf1},
	{0x03, 0x02},
	{0x55, 0x10},

	{0x01, 0xf1},
	{0x01, 0xf3},
	{0x01, 0xf1},

};

static struct msm_camera_i2c_reg_conf HI256_reg_saturation[11][3] = {
	{
		{0x03, 0x10},
		{0x61, 0x1c},
		{0x62, 0x1c},
	},
	{
		{0x03, 0x10},
		{0x61, 0x30},
		{0x62, 0x30},
	},
	{
		{0x03, 0x10},
		{0x61, 0x44},
		{0x62, 0x44},
	},
	{
		{0x03, 0x10},
		{0x61, 0x58},
		{0x62, 0x58},
	},
	{
		{0x03, 0x10},
		{0x61, 0x6c},
		{0x62, 0x6c},
	},
	{
		{0x03, 0x10},
		{0x61, 0x95},
		{0x62, 0x95},
	},
	{
		{0x03, 0x10},
		{0x61, 0xa0},
		{0x62, 0xa0},
	},
	{
		{0x03, 0x10},
		{0x61, 0xa8},
		{0x62, 0xa8},
	},
	{
		{0x03, 0x10},
		{0x61, 0xbc},
		{0x62, 0xbc},
	},
	{
		{0x03, 0x10},
		{0x61, 0xd0},
		{0x62, 0xd0},
	},
	{
		{0x03, 0x10},
		{0x61, 0xe4},
		{0x62, 0xe4},
	},
};

static struct msm_camera_i2c_reg_conf HI256_reg_contrast[11][3] = {
	{
		{0x03, 0x10},
		{0x13, 0x02},
		{0x48, 0x1c},
	},
	{
		{0x03, 0x10},
		{0x13, 0x02},
		{0x48, 0x30},
	},
	{
		{0x03, 0x10},
		{0x13, 0x02},
		{0x48, 0x44},
	},
	{
		{0x03, 0x10},
		{0x13, 0x02},
		{0x48, 0x58},
	},
	{
		{0x03, 0x10},
		{0x13, 0x02},
		{0x48, 0x6c},
	},
	{
		{0x03, 0x10},
		{0x13, 0x02},
		{0x48, 0x90},
	},
	{
		{0x03, 0x10},
		{0x13, 0x02},
		{0x48, 0x94},
	},
	{
		{0x03, 0x10},
		{0x13, 0x02},
		{0x48, 0xa8},
	},
	{
		{0x03, 0x10},
		{0x13, 0x02},
		{0x48, 0xbc},
	},
	{
		{0x03, 0x10},
		{0x13, 0x02},
		{0x48, 0xd0},
	},
	{
		{0x03, 0x10},
		{0x13, 0x02},
		{0x48, 0xe4},
	},
};

static struct msm_camera_i2c_reg_conf HI256_reg_sharpness[7][9] = {
	{
		{0x03, 0x13},
		{0x20, 0x00},
		{0x21, 0x00},
		{0x23, 0x04},
		{0x24, 0x80},
		{0x90, 0x00},
		{0x91, 0x00},
		{0x94, 0x24},
		{0x95, 0x65},
	}, /* SHARPNESS LEVEL 0*/
	{
		{0x03, 0x13},
		{0x20, 0x04},
		{0x21, 0x03},
		{0x23, 0x04},
		{0x24, 0x80},
		{0x90, 0x08},
		{0x91, 0x08},
		{0x94, 0x24},
		{0x95, 0x65},
	}, /* SHARPNESS LEVEL 1*/
	{
		{0x03, 0x13},
		{0x20, 0x08},
		{0x21, 0x07},
		{0x23, 0x04},
		{0x24, 0x80},
		{0x90, 0x32},
		{0x91, 0x32},
		{0x94, 0x04},
		{0x95, 0x0a},
	}, /* SHARPNESS LEVEL 2*/
	{
		{0x03, 0x13},
		{0x20, 0x15},
		{0x21, 0x15},
		{0x23, 0x09},
		{0x24, 0x11},
		{0x90, 0x05},
		{0x91, 0x05},
		{0x94, 0x10},
		{0x95, 0x5a},
	}, /* SHARPNESS LEVEL 3*/
	{
		{0x03, 0x13},
		{0x20, 0x15},
		{0x21, 0x15},
		{0x23, 0x04},
		{0x24, 0x80},
		{0x90, 0xaf},
		{0x91, 0xaf},
		{0x94, 0x24},
		{0x95, 0x65},
	}, /* SHARPNESS LEVEL 4*/
	{
		{0x03, 0x13},
		{0x20, 0x20},
		{0x21, 0x20},
		{0x23, 0x04},
		{0x24, 0x80},
		{0x90, 0xdf},
		{0x91, 0xdf},
		{0x94, 0x24},
		{0x95, 0x65},
	}, /* SHARPNESS LEVEL 5*/
	{
		{0x03, 0x13},
		{0x20, 0x25},
		{0x21, 0x25},
		{0x23, 0x04},
		{0x24, 0x80},
		{0x90, 0xff},
		{0x91, 0xff},
		{0x94, 0x24},
		{0x95, 0x65},
	}, /* SHARPNESS LEVEL 6*/
};

static struct msm_camera_i2c_reg_conf HI256_reg_iso[7][3] = {
	/* auto */
	{
		{0x03, 0x20},
		{0x10, 0x9c},
		{0xb0, 0x18},
	},
	/* auto hjt */
	{
		{0x03, 0x20},
		{0x10, 0x9c},
		{0xb0, 0x18},
	},
	/* iso 100 */
	{
		{0x03, 0x20},
		{0x10, 0x0c},
		{0xb0, 0x1B},
	},
	/* iso 200 */
	{
		{0x03, 0x20},
		{0x10, 0x0c},
		{0xb0, 0x35},
	},
	/* iso 400 */
	{
		{0x03, 0x20},
		{0x10, 0x0c},
		{0xb0, 0x65},
	},
	/* iso 800 */
	{
		{0x03, 0x20},
		{0x10, 0x0c},
		{0xb0, 0x95},
	},
	/* iso 1600 */
	{
		{0x03, 0x20},
		{0x10, 0x0c},
		{0xb0, 0xd0},
	},
};

static struct msm_camera_i2c_reg_conf HI256_reg_exposure_compensation[5][2] = {
	/* -2 */
	{
		{0x03, 0x10},
		{0x40, 0x94},
	},
	/* -1 */
	{
		{0x03, 0x10},
		{0x40, 0x80},
	},
	/* 0 */
	{
		{0x03, 0x10},
		{0x40, 0x14},
	},
	/* 1 */
	{
		{0x03, 0x10},
		{0x40, 0x24},
	},
	/* 2 */
	{
		{0x03, 0x10},
		{0x40, 0x34},
	},
};

static struct msm_camera_i2c_reg_conf HI256_reg_antibanding[][2] = {
	/* OFF */
	{
		{0x03, 0x20},
		{0x10, 0xcc},
	},
	/* 50Hz */
	{
		{0x03, 0x20},
		{0x10, 0x9c},
	},
	/* 60Hz */
	{
		{0x03, 0x20},
		{0x10, 0x8c},
	},
	/* AUTO */
	{
		{0x03, 0x20},
		{0x10, 0xcc},
	},
};

static struct msm_camera_i2c_reg_conf HI256_reg_effect_normal[] = {
	/* normal: */
	{0x03, 0x20},
	{0x28, 0xe7},
	{0x03, 0x10},
	{0x11, 0x03},
	{0x12, 0X30},
	{0x13, 0x0a},
	{0x44, 0x80},
	{0x45, 0x80},
};

static struct msm_camera_i2c_reg_conf HI256_reg_effect_black_white[] = {
	/* B&W: */
	{0x03, 0x20},
	{0x28, 0xe7},
	{0x03, 0x10},
	{0x11, 0x03},
	{0x12, 0x33},
	{0x13, 0x02},
	{0x44, 0x80},
	{0x45, 0x80},
};

static struct msm_camera_i2c_reg_conf HI256_reg_effect_negative[] = {
	/* Negative: */
	{0x03, 0x20},
	{0x28, 0xe7},
	{0x03, 0x10},
	{0x11, 0x03},
	{0x12, 0x08},
	{0x13, 0x0a},
	{0x14, 0x00},
};

static struct msm_camera_i2c_reg_conf HI256_reg_effect_old_movie[] = {
	/* Sepia(antique): */
	{0x03, 0x20},
	{0x28, 0xe7},
	{0x03, 0x10},
	{0x11, 0x03},
	{0x12, 0x33},
	{0x13, 0x0a},
	{0x44, 0x25},
	{0x45, 0xa6},
};

static struct msm_camera_i2c_reg_conf HI256_reg_effect_solarize[] = {
	{0x03, 0x20},
	{0x28, 0xe7},
	{0x03, 0x10},
	{0x11, 0x0b},
	{0x12, 0x00},
	{0x13, 0x00},
	{0x14, 0x00},
};

static struct msm_camera_i2c_reg_conf HI256_reg_scene_auto[] = {
	/* <SCENE_auto> */
	{0x03, 0x20},
	{0x10, 0x1c},
	{0x18, 0x38},
	{0x88, 0x01},
	{0x89, 0x5f},
	{0x8a, 0x90},
	{0x10, 0x9c},
	{0x18, 0x30},
};

static struct msm_camera_i2c_reg_conf HI256_reg_scene_portrait[] = {
	/* <CAMTUNING_SCENE_PORTRAIT> */
	{0x03, 0x20},
	{0x10, 0x1c},
	{0x18, 0x38},
	{0x88, 0x05},
	{0x89, 0x7e},
	{0x8a, 0x40},
	{0x10, 0x9c},
	{0x18, 0x30},
};

static struct msm_camera_i2c_reg_conf HI256_reg_scene_landscape[] = {
	/* <CAMTUNING_SCENE_LANDSCAPE> */
	{0x03, 0x20},
	{0x10, 0x1c},
	{0x18, 0x38},
	{0x88, 0x05},
	{0x89, 0x7e},
	{0x8a, 0x40},
	{0x10, 0x9c},
	{0x18, 0x30},
};

static struct msm_camera_i2c_reg_conf HI256_reg_scene_night[] = {
	/* <SCENE_NIGHT> */
	{0x03, 0x20},
	{0x10, 0x1c},
	{0x18, 0x38},
	{0x88, 0x09},
	{0x89, 0x27},
	{0x8a, 0xc0},
	{0x10, 0x9c},
	{0x18, 0x30},
};

static struct msm_camera_i2c_reg_conf HI256_reg_wb_auto[] = {
	/* Auto: */
	{0x03, 0x22},
	{0x11, 0x2e},
	{0x83, 0x60},
	{0x84, 0x0a},
	{0x85, 0x60},
	{0x86, 0x15},
	{0x10, 0xfd},
};

static struct msm_camera_i2c_reg_conf HI256_reg_wb_sunny[] = {
	/* Sunny: */
	{0x03, 0x22},
	{0x11, 0x28},
	{0x80, 0x33},
	{0x82, 0x3d},
	{0x83, 0x2e},
	{0x84, 0x24},
	{0x85, 0x43},
	{0x86, 0x3d},
};

static struct msm_camera_i2c_reg_conf HI256_reg_wb_cloudy[] = {
	/* Cloudy: */
	{0x03, 0x22},
	{0x11, 0x28},
	{0x80, 0x49},
	{0x82, 0x24},
	{0x83, 0x50},
	{0x84, 0x45},
	{0x85, 0x24},
	{0x86, 0x1E},
};

static struct msm_camera_i2c_reg_conf HI256_reg_wb_office[] = {
	/* Office: */
	{0x03, 0x22},
	{0x11, 0x28},
	{0x80, 0x20},
	{0x82, 0x58},
	{0x83, 0x27},
	{0x84, 0x22},
	{0x85, 0x58},
	{0x86, 0x52},
};

static struct msm_camera_i2c_reg_conf HI256_reg_wb_home[] = {
	/* Home: */
	{0x03, 0x22},
	{0x11, 0x28},
	{0x80, 0x29},
	{0x82, 0x54},
	{0x83, 0x2e},
	{0x84, 0x23},
	{0x85, 0x58},
	{0x86, 0x4f},
};


static const struct i2c_device_id hi256_i2c_id[] = {
	{HI256_SENSOR_NAME, (kernel_ulong_t)&hi256_s_ctrl},
	{ }
};

static int32_t msm_hi256_i2c_probe(struct i2c_client *client,
	   const struct i2c_device_id *id)
{
	   return msm_sensor_i2c_probe(client, id, &hi256_s_ctrl);
}

static struct i2c_driver hi256_i2c_driver = {
	.id_table = hi256_i2c_id,
	.probe  = msm_hi256_i2c_probe,
	.driver = {
		.name = HI256_SENSOR_NAME,
	},
};

static struct msm_camera_i2c_client hi256_sensor_i2c_client = {
	.addr_type = MSM_CAMERA_I2C_BYTE_ADDR,
};

static const struct of_device_id hi256_dt_match[] = {
	{.compatible = "shinetech,hi256", .data = &hi256_s_ctrl},
	{}
};

MODULE_DEVICE_TABLE(of, hi256_dt_match);

static struct platform_driver hi256_platform_driver = {
	.driver = {
		.name = "shinetech,hi256",
		.owner = THIS_MODULE,
		.of_match_table = hi256_dt_match,
	},
};

static void hi256_i2c_write_table(struct msm_sensor_ctrl_t *s_ctrl,
		struct msm_camera_i2c_reg_conf *table,
		int num)
{
	int i = 0;
	int rc = 0;
	for (i = 0; i < num; ++i) {
		rc = s_ctrl->sensor_i2c_client->i2c_func_tbl->
			i2c_write(
			s_ctrl->sensor_i2c_client, table->reg_addr,
			table->reg_data,
			MSM_CAMERA_I2C_BYTE_DATA);
		if (rc < 0) {
			msleep(100);
			rc = s_ctrl->sensor_i2c_client->i2c_func_tbl->
			i2c_write(
				s_ctrl->sensor_i2c_client, table->reg_addr,
				table->reg_data,
				MSM_CAMERA_I2C_BYTE_DATA);
		}
		table++;
	}
}

static int32_t hi256_sensor_power_down(struct msm_sensor_ctrl_t *s_ctrl)
{
	hi256_i2c_write_table(s_ctrl, &hi256_sleep_settings[0],
		ARRAY_SIZE(hi256_sleep_settings));
	return msm_sensor_power_down(s_ctrl);
}

static int32_t hi256_platform_probe(struct platform_device *pdev)
{
	int32_t rc;
	const struct of_device_id *match;
	match = of_match_device(hi256_dt_match, &pdev->dev);
	rc = msm_sensor_platform_probe(pdev, match->data);
	return rc;
}

static int __init hi256_init_module(void)
{
	int32_t rc;
	pr_info("%s:%d\n", __func__, __LINE__);
	rc = platform_driver_probe(&hi256_platform_driver,
		hi256_platform_probe);
	if (!rc)
		return rc;
	return i2c_add_driver(&hi256_i2c_driver);
}

static void __exit hi256_exit_module(void)
{
	pr_info("%s:%d\n", __func__, __LINE__);
	if (hi256_s_ctrl.pdev) {
		msm_sensor_free_sensor_data(&hi256_s_ctrl);
		platform_driver_unregister(&hi256_platform_driver);
	} else
		i2c_del_driver(&hi256_i2c_driver);
	return;
}

static int32_t hi256_sensor_match_id(struct msm_sensor_ctrl_t *s_ctrl)
{
	int32_t rc = 0;
	uint16_t chipid = 0;
	rc = s_ctrl->sensor_i2c_client->i2c_func_tbl->i2c_read(
		s_ctrl->sensor_i2c_client,
		s_ctrl->sensordata->slave_info->sensor_id_reg_addr,
		&chipid, MSM_CAMERA_I2C_BYTE_DATA);
	if (rc < 0) {
		pr_err("%s: %s: hi256 read id failed\n", __func__,
			s_ctrl->sensordata->sensor_name);
		return rc;
	}

	CDBG("%s: read id: %x expected id %x:\n", __func__, chipid,
		s_ctrl->sensordata->slave_info->sensor_id);
	if (chipid != s_ctrl->sensordata->slave_info->sensor_id) {
		pr_err("msm_sensor_match_id chip id doesnot match\n");
		return -ENODEV;
	}
	return rc;
}

static void hi256_set_stauration(struct msm_sensor_ctrl_t *s_ctrl, int value)
{
	pr_debug("%s %d", __func__, value);
	hi256_i2c_write_table(s_ctrl, &HI256_reg_saturation[value][0],
		ARRAY_SIZE(HI256_reg_saturation[value]));
}

static void hi256_set_contrast(struct msm_sensor_ctrl_t *s_ctrl, int value)
{
	pr_debug("%s %d", __func__, value);
	hi256_i2c_write_table(s_ctrl, &HI256_reg_contrast[value][0],
		ARRAY_SIZE(HI256_reg_contrast[value]));
}

static void hi256_set_sharpness(struct msm_sensor_ctrl_t *s_ctrl, int value)
{
	int val = value / 6;
	pr_debug("%s %d", __func__, value);
	hi256_i2c_write_table(s_ctrl, &HI256_reg_sharpness[val][0],
		ARRAY_SIZE(HI256_reg_sharpness[val]));
}


static void hi256_set_iso(struct msm_sensor_ctrl_t *s_ctrl, int value)
{
	pr_debug("%s %d", __func__, value);
	hi256_i2c_write_table(s_ctrl, &HI256_reg_iso[value][0],
		ARRAY_SIZE(HI256_reg_iso[value]));
}

static void hi256_set_exposure_compensation(struct msm_sensor_ctrl_t *s_ctrl,
	int value)
{
	int val = (value + 12) / 6;
	pr_debug("%s %d", __func__, val);
	hi256_i2c_write_table(s_ctrl, &HI256_reg_exposure_compensation[val][0],
		ARRAY_SIZE(HI256_reg_exposure_compensation[val]));
}

static void hi256_set_effect(struct msm_sensor_ctrl_t *s_ctrl, int value)
{
	pr_debug("%s %d", __func__, value);
	switch (value) {
	case MSM_CAMERA_EFFECT_MODE_OFF: {
		hi256_i2c_write_table(s_ctrl, &HI256_reg_effect_normal[0],
			ARRAY_SIZE(HI256_reg_effect_normal));
		break;
	}
	case MSM_CAMERA_EFFECT_MODE_MONO: {
		hi256_i2c_write_table(s_ctrl, &HI256_reg_effect_black_white[0],
			ARRAY_SIZE(HI256_reg_effect_black_white));
		break;
	}
	case MSM_CAMERA_EFFECT_MODE_NEGATIVE: {
		hi256_i2c_write_table(s_ctrl, &HI256_reg_effect_negative[0],
			ARRAY_SIZE(HI256_reg_effect_negative));
		break;
	}
	case MSM_CAMERA_EFFECT_MODE_SEPIA: {
		hi256_i2c_write_table(s_ctrl, &HI256_reg_effect_old_movie[0],
			ARRAY_SIZE(HI256_reg_effect_old_movie));
		break;
	}
	case MSM_CAMERA_EFFECT_MODE_SOLARIZE: {
		hi256_i2c_write_table(s_ctrl, &HI256_reg_effect_solarize[0],
			ARRAY_SIZE(HI256_reg_effect_solarize));
		break;
	}
	default:
		hi256_i2c_write_table(s_ctrl, &HI256_reg_effect_normal[0],
			ARRAY_SIZE(HI256_reg_effect_normal));
	}
}

static void hi256_set_antibanding(struct msm_sensor_ctrl_t *s_ctrl, int value)
{
	pr_debug("%s %d", __func__, value);
	hi256_i2c_write_table(s_ctrl, &HI256_reg_antibanding[value][0],
		ARRAY_SIZE(HI256_reg_antibanding[value]));
}

static void hi256_set_scene_mode(struct msm_sensor_ctrl_t *s_ctrl, int value)
{
	pr_debug("%s %d", __func__, value);
	switch (value) {
	case MSM_CAMERA_SCENE_MODE_OFF: {
		hi256_i2c_write_table(s_ctrl, &HI256_reg_scene_auto[0],
			ARRAY_SIZE(HI256_reg_scene_auto));
		break;
	}
	case MSM_CAMERA_SCENE_MODE_NIGHT: {
		hi256_i2c_write_table(s_ctrl, &HI256_reg_scene_night[0],
			ARRAY_SIZE(HI256_reg_scene_night));
					break;
	}
	case MSM_CAMERA_SCENE_MODE_LANDSCAPE: {
		hi256_i2c_write_table(s_ctrl, &HI256_reg_scene_landscape[0],
			ARRAY_SIZE(HI256_reg_scene_landscape));
		break;
	}
	case MSM_CAMERA_SCENE_MODE_PORTRAIT: {
		hi256_i2c_write_table(s_ctrl, &HI256_reg_scene_portrait[0],
			ARRAY_SIZE(HI256_reg_scene_portrait));
		break;
	}
	default:
		hi256_i2c_write_table(s_ctrl, &HI256_reg_scene_auto[0],
			ARRAY_SIZE(HI256_reg_scene_auto));
	}
}

static void hi256_set_white_balance_mode(struct msm_sensor_ctrl_t *s_ctrl,
	int value)
{
	pr_debug("%s %d", __func__, value);
	switch (value) {
	case MSM_CAMERA_WB_MODE_AUTO: {
		hi256_i2c_write_table(s_ctrl, &HI256_reg_wb_auto[0],
			ARRAY_SIZE(HI256_reg_wb_auto));
		break;
	}
	case MSM_CAMERA_WB_MODE_INCANDESCENT: {
		hi256_i2c_write_table(s_ctrl, &HI256_reg_wb_home[0],
			ARRAY_SIZE(HI256_reg_wb_home));
		break;
	}
	case MSM_CAMERA_WB_MODE_DAYLIGHT: {
		hi256_i2c_write_table(s_ctrl, &HI256_reg_wb_sunny[0],
			ARRAY_SIZE(HI256_reg_wb_sunny));
					break;
	}
	case MSM_CAMERA_WB_MODE_FLUORESCENT: {
		hi256_i2c_write_table(s_ctrl, &HI256_reg_wb_office[0],
			ARRAY_SIZE(HI256_reg_wb_office));
					break;
	}
	case MSM_CAMERA_WB_MODE_CLOUDY_DAYLIGHT: {
		hi256_i2c_write_table(s_ctrl, &HI256_reg_wb_cloudy[0],
			ARRAY_SIZE(HI256_reg_wb_cloudy));
					break;
	}
	default:
		hi256_i2c_write_table(s_ctrl, &HI256_reg_wb_auto[0],
		ARRAY_SIZE(HI256_reg_wb_auto));
	}
}

int32_t hi256_sensor_config(struct msm_sensor_ctrl_t *s_ctrl,
	void __user *argp)
{
	struct sensorb_cfg_data *cdata = (struct sensorb_cfg_data *)argp;
	long rc = 0;
	int32_t i = 0;
	mutex_lock(s_ctrl->msm_sensor_mutex);
	CDBG("%s:%d %s cfgtype = %d\n", __func__, __LINE__,
		s_ctrl->sensordata->sensor_name, cdata->cfgtype);
	switch (cdata->cfgtype) {
	case CFG_GET_SENSOR_INFO:
		memcpy(cdata->cfg.sensor_info.sensor_name,
			s_ctrl->sensordata->sensor_name,
			sizeof(cdata->cfg.sensor_info.sensor_name));
		cdata->cfg.sensor_info.session_id =
			s_ctrl->sensordata->sensor_info->session_id;
		for (i = 0; i < SUB_MODULE_MAX; i++)
			cdata->cfg.sensor_info.subdev_id[i] =
				s_ctrl->sensordata->sensor_info->subdev_id[i];
		CDBG("%s:%d sensor name %s\n", __func__, __LINE__,
			cdata->cfg.sensor_info.sensor_name);
		CDBG("%s:%d session id %d\n", __func__, __LINE__,
			cdata->cfg.sensor_info.session_id);
		for (i = 0; i < SUB_MODULE_MAX; i++)
			CDBG("%s:%d subdev_id[%d] %d\n", __func__, __LINE__, i,
				cdata->cfg.sensor_info.subdev_id[i]);
		break;
	case CFG_SET_INIT_SETTING:
		CDBG("init setting");
		hi256_i2c_write_table(s_ctrl,
				&hi256_recommend_settings[0],
				ARRAY_SIZE(hi256_recommend_settings));
		CDBG("init setting X");
		break;
	case CFG_SET_RESOLUTION: {
		int val = 0;
		if (copy_from_user(&val,
			(void *)cdata->cfg.setting, sizeof(int))) {
			pr_err("%s:%d failed\n", __func__, __LINE__);
			rc = -EFAULT;
			break;
		}
		if (val == 0)
			hi256_i2c_write_table(s_ctrl, &hi256_uxga_settings[0],
				ARRAY_SIZE(hi256_uxga_settings));
		else if (val == 1)
			hi256_i2c_write_table(s_ctrl, &hi256_svga_settings[0],
				ARRAY_SIZE(hi256_svga_settings));
		break;
	}
	case CFG_SET_STOP_STREAM:
		hi256_i2c_write_table(s_ctrl,
			&hi256_stop_settings[0],
			ARRAY_SIZE(hi256_stop_settings));
		break;
	case CFG_SET_START_STREAM:
		hi256_i2c_write_table(s_ctrl,
			&hi256_start_settings[0],
			ARRAY_SIZE(hi256_start_settings));
		break;
	case CFG_GET_SENSOR_INIT_PARAMS:
		cdata->cfg.sensor_init_params =
			*s_ctrl->sensordata->sensor_init_params;
		CDBG("%s:%d init params mode %d pos %d mount %d\n", __func__,
			__LINE__,
			cdata->cfg.sensor_init_params.modes_supported,
			cdata->cfg.sensor_init_params.position,
			cdata->cfg.sensor_init_params.sensor_mount_angle);
		break;
	case CFG_SET_SLAVE_INFO: {
		struct msm_camera_sensor_slave_info sensor_slave_info;
		struct msm_sensor_power_setting_array *power_setting_array;
		int slave_index = 0;
		if (copy_from_user(&sensor_slave_info,
			(void *)cdata->cfg.setting,
			sizeof(struct msm_camera_sensor_slave_info))) {
			pr_err("%s:%d failed\n", __func__, __LINE__);
			rc = -EFAULT;
			break;
		}
		/* Update sensor slave address */
		if (sensor_slave_info.slave_addr) {
			s_ctrl->sensor_i2c_client->cci_client->sid =
				sensor_slave_info.slave_addr >> 1;
		}

		/* Update sensor address type */
		s_ctrl->sensor_i2c_client->addr_type =
			sensor_slave_info.addr_type;

		/* Update power up / down sequence */
		s_ctrl->power_setting_array =
			sensor_slave_info.power_setting_array;
		power_setting_array = &s_ctrl->power_setting_array;
		power_setting_array->power_setting = kzalloc(
			power_setting_array->size *
			sizeof(struct msm_sensor_power_setting), GFP_KERNEL);
		if (!power_setting_array->power_setting) {
			pr_err("%s:%d failed\n", __func__, __LINE__);
			rc = -ENOMEM;
			break;
		}
		if (copy_from_user(power_setting_array->power_setting,
			(void *)
			sensor_slave_info.power_setting_array.power_setting,
			power_setting_array->size *
			sizeof(struct msm_sensor_power_setting))) {
			kfree(power_setting_array->power_setting);
			pr_err("%s:%d failed\n", __func__, __LINE__);
			rc = -EFAULT;
			break;
		}
		s_ctrl->free_power_setting = true;
		CDBG("%s sensor id %x\n", __func__,
			sensor_slave_info.slave_addr);
		CDBG("%s sensor addr type %d\n", __func__,
			sensor_slave_info.addr_type);
		CDBG("%s sensor reg %x\n", __func__,
			sensor_slave_info.sensor_id_info.sensor_id_reg_addr);
		CDBG("%s sensor id %x\n", __func__,
			sensor_slave_info.sensor_id_info.sensor_id);
		for (slave_index = 0; slave_index <
			power_setting_array->size; slave_index++) {
			CDBG("%s i %d power setting %d %d %ld %d\n", __func__,
			slave_index,
			power_setting_array->power_setting[slave_index].
			seq_type,
			power_setting_array->power_setting[slave_index].
			seq_val,
			power_setting_array->power_setting[slave_index].
			config_val,
			power_setting_array->power_setting[slave_index].
			delay);
		}
		kfree(power_setting_array->power_setting);
		break;
	}
	case CFG_WRITE_I2C_ARRAY: {
		struct msm_camera_i2c_reg_setting conf_array;
		struct msm_camera_i2c_reg_array *reg_setting = NULL;

		if (copy_from_user(&conf_array,
			(void *)cdata->cfg.setting,
			sizeof(struct msm_camera_i2c_reg_setting))) {
			pr_err("%s:%d failed\n", __func__, __LINE__);
			rc = -EFAULT;
			break;
		}

		reg_setting = kzalloc(conf_array.size *
			(sizeof(struct msm_camera_i2c_reg_array)), GFP_KERNEL);
		if (!reg_setting) {
			pr_err("%s:%d failed\n", __func__, __LINE__);
			rc = -ENOMEM;
			break;
		}
		if (copy_from_user(reg_setting, (void *)conf_array.reg_setting,
			conf_array.size *
			sizeof(struct msm_camera_i2c_reg_array))) {
			pr_err("%s:%d failed\n", __func__, __LINE__);
			kfree(reg_setting);
			rc = -EFAULT;
			break;
		}

		conf_array.reg_setting = reg_setting;
		rc = s_ctrl->sensor_i2c_client->i2c_func_tbl->i2c_write_table(
			s_ctrl->sensor_i2c_client, &conf_array);
		kfree(reg_setting);
		break;
	}
	case CFG_WRITE_I2C_SEQ_ARRAY: {
		struct msm_camera_i2c_seq_reg_setting conf_array;
		struct msm_camera_i2c_seq_reg_array *reg_setting = NULL;

		if (copy_from_user(&conf_array,
			(void *)cdata->cfg.setting,
			sizeof(struct msm_camera_i2c_seq_reg_setting))) {
			pr_err("%s:%d failed\n", __func__, __LINE__);
			rc = -EFAULT;
			break;
		}

		reg_setting = kzalloc(conf_array.size *
			(sizeof(struct msm_camera_i2c_seq_reg_array)),
			GFP_KERNEL);
		if (!reg_setting) {
			pr_err("%s:%d failed\n", __func__, __LINE__);
			rc = -ENOMEM;
			break;
		}
		if (copy_from_user(reg_setting, (void *)conf_array.reg_setting,
			conf_array.size *
			sizeof(struct msm_camera_i2c_seq_reg_array))) {
			pr_err("%s:%d failed\n", __func__, __LINE__);
			kfree(reg_setting);
			rc = -EFAULT;
			break;
		}

		conf_array.reg_setting = reg_setting;
		rc = s_ctrl->sensor_i2c_client->i2c_func_tbl->
			i2c_write_seq_table(s_ctrl->sensor_i2c_client,
			&conf_array);
		kfree(reg_setting);
		break;
	}

	case CFG_POWER_UP:
		if (s_ctrl->func_tbl->sensor_power_up)
			rc = s_ctrl->func_tbl->sensor_power_up(s_ctrl);
		else
			rc = -EFAULT;
		break;

	case CFG_POWER_DOWN:
		if (s_ctrl->func_tbl->sensor_power_down)
			rc = s_ctrl->func_tbl->sensor_power_down(s_ctrl);
		else
			rc = -EFAULT;
		break;

	case CFG_SET_STOP_STREAM_SETTING: {
		struct msm_camera_i2c_reg_setting *stop_setting =
			&s_ctrl->stop_setting;
		struct msm_camera_i2c_reg_array *reg_setting = NULL;
		if (copy_from_user(stop_setting, (void *)cdata->cfg.setting,
			sizeof(struct msm_camera_i2c_reg_setting))) {
			pr_err("%s:%d failed\n", __func__, __LINE__);
			rc = -EFAULT;
			break;
		}

		reg_setting = stop_setting->reg_setting;
		stop_setting->reg_setting = kzalloc(stop_setting->size *
			(sizeof(struct msm_camera_i2c_reg_array)), GFP_KERNEL);
		if (!stop_setting->reg_setting) {
			pr_err("%s:%d failed\n", __func__, __LINE__);
			rc = -ENOMEM;
			break;
		}
		if (copy_from_user(stop_setting->reg_setting,
			(void *)reg_setting, stop_setting->size *
			sizeof(struct msm_camera_i2c_reg_array))) {
			pr_err("%s:%d failed\n", __func__, __LINE__);
			kfree(stop_setting->reg_setting);
			stop_setting->reg_setting = NULL;
			stop_setting->size = 0;
			rc = -EFAULT;
			break;
		}
		break;
	}
	case CFG_SET_SATURATION: {
		int32_t sat_lev;
		if (copy_from_user(&sat_lev, (void *)cdata->cfg.setting,
			sizeof(int32_t))) {
			pr_err("%s:%d failed\n", __func__, __LINE__);
			rc = -EFAULT;
			break;
		}
		pr_debug("%s: Saturation Value is %d", __func__, sat_lev);
		hi256_set_stauration(s_ctrl, sat_lev);
		break;
	}
	case CFG_SET_CONTRAST: {
		int32_t con_lev;
		if (copy_from_user(&con_lev, (void *)cdata->cfg.setting,
			sizeof(int32_t))) {
			pr_err("%s:%d failed\n", __func__, __LINE__);
			rc = -EFAULT;
			break;
		}
		pr_debug("%s: Contrast Value is %d", __func__, con_lev);
		hi256_set_contrast(s_ctrl, con_lev);
		break;
	}
	case CFG_SET_SHARPNESS: {
		int32_t shp_lev;
		if (copy_from_user(&shp_lev, (void *)cdata->cfg.setting,
			sizeof(int32_t))) {
			pr_err("%s:%d failed\n", __func__, __LINE__);
			rc = -EFAULT;
			break;
		}
		pr_debug("%s: Sharpness Value is %d", __func__, shp_lev);
		hi256_set_sharpness(s_ctrl, shp_lev);
		break;
	}
	case CFG_SET_ISO: {
		int32_t iso_lev;
		if (copy_from_user(&iso_lev, (void *)cdata->cfg.setting,
			sizeof(int32_t))) {
			pr_err("%s:%d failed\n", __func__, __LINE__);
			rc = -EFAULT;
			break;
		}
		pr_debug("%s: ISO Value is %d", __func__, iso_lev);
		hi256_set_iso(s_ctrl, iso_lev);
		break;
	}
	case CFG_SET_EXPOSURE_COMPENSATION: {
		int32_t ec_lev;
		if (copy_from_user(&ec_lev, (void *)cdata->cfg.setting,
			sizeof(int32_t))) {
			pr_err("%s:%d failed\n", __func__, __LINE__);
			rc = -EFAULT;
			break;
		}
		pr_debug("%s: Exposure compensation Value is %d",
			__func__, ec_lev);
		hi256_set_exposure_compensation(s_ctrl, ec_lev);
		break;
	}
	case CFG_SET_EFFECT: {
		int32_t effect_mode;
		if (copy_from_user(&effect_mode, (void *)cdata->cfg.setting,
			sizeof(int32_t))) {
			pr_err("%s:%d failed\n", __func__, __LINE__);
			rc = -EFAULT;
			break;
		}
		pr_debug("%s: Effect mode is %d", __func__, effect_mode);
		hi256_set_effect(s_ctrl, effect_mode);
		break;
	}
	case CFG_SET_ANTIBANDING: {
		int32_t antibanding_mode;
		if (copy_from_user(&antibanding_mode,
			(void *)cdata->cfg.setting,
			sizeof(int32_t))) {
			pr_err("%s:%d failed\n", __func__, __LINE__);
			rc = -EFAULT;
			break;
		}
		pr_debug("%s: anti-banding mode is %d", __func__,
			antibanding_mode);
		hi256_set_antibanding(s_ctrl, antibanding_mode);
		break;
	}
	case CFG_SET_BESTSHOT_MODE: {
		int32_t bs_mode;
		if (copy_from_user(&bs_mode, (void *)cdata->cfg.setting,
			sizeof(int32_t))) {
			pr_err("%s:%d failed\n", __func__, __LINE__);
			rc = -EFAULT;
			break;
		}
		pr_debug("%s: best shot mode is %d", __func__, bs_mode);
		hi256_set_scene_mode(s_ctrl, bs_mode);
		break;
	}
	case CFG_SET_WHITE_BALANCE: {
		int32_t wb_mode;
		if (copy_from_user(&wb_mode, (void *)cdata->cfg.setting,
			sizeof(int32_t))) {
			pr_err("%s:%d failed\n", __func__, __LINE__);
			rc = -EFAULT;
			break;
		}
		pr_debug("%s: white balance is %d", __func__, wb_mode);
		hi256_set_white_balance_mode(s_ctrl, wb_mode);
		break;
	}
	default:
		rc = -EFAULT;
		break;
	}

	mutex_unlock(s_ctrl->msm_sensor_mutex);

	return rc;
}

static struct msm_sensor_fn_t hi256_sensor_func_tbl = {
	.sensor_config = hi256_sensor_config,
	.sensor_power_up = msm_sensor_power_up,
	.sensor_power_down = hi256_sensor_power_down,
	.sensor_match_id = hi256_sensor_match_id,
};

static struct msm_sensor_ctrl_t hi256_s_ctrl = {
	.sensor_i2c_client = &hi256_sensor_i2c_client,
	.power_setting_array.power_setting = hi256_power_setting,
	.power_setting_array.size = ARRAY_SIZE(hi256_power_setting),
	.msm_sensor_mutex = &hi256_mut,
	.sensor_v4l2_subdev_info = hi256_subdev_info,
	.sensor_v4l2_subdev_info_size = ARRAY_SIZE(hi256_subdev_info),
	.func_tbl = &hi256_sensor_func_tbl,
};

module_init(hi256_init_module);
module_exit(hi256_exit_module);
MODULE_DESCRIPTION("Hi256 2MP YUV sensor driver");
MODULE_LICENSE("GPL v2");
