# Copyright (c) 2012 The Chromium Authors. All rights reserved.
#
# Use of this source code is governed by a BSD-style license that can be
# found in the LICENSE file.

{
  'targets': [
    {
      'target_name': 'browser_chromeos',
      'type': 'static_library',
      'variables': {
        'conditions': [
          ['sysroot!=""', {
            'pkg-config': '../build/linux/pkg-config-wrapper "<(sysroot)" "<(target_arch)"',
          }, {
            'pkg-config': 'pkg-config'
          }],
        ],
        # Override to dynamically link the cras (ChromeOS audio) library.
        'use_cras%': 0,
        'enable_wexit_time_destructors': 1,
      },
      'dependencies': [
        # TODO(tbarzic): Cleanup this list.
        'attestation_proto',
        'app/policy/cloud_policy_codegen.gyp:policy',
        'browser/performance_monitor/performance_monitor.gyp:performance_monitor',
        'browser_extensions',
        'cert_logger_proto',
        'chrome_resources.gyp:chrome_extra_resources',
        'chrome_resources.gyp:chrome_resources',
        'chrome_resources.gyp:platform_locale_settings',
        'chrome_resources.gyp:theme_resources',
        'common',
        'common/extensions/api/api.gyp:api',
        'common_net',
        'contacts_proto',
        'debugger',
        'device_policy_proto',
        'drive_proto',
        'feedback_proto',
        'in_memory_url_index_cache_proto',
        'installer_util',
        'safe_browsing_proto',
        'safe_browsing_report_proto',
        'variations_seed_proto',
        '../breakpad/breakpad.gyp:breakpad_client',
        '../build/linux/system.gyp:dbus',
        '../chromeos/chromeos.gyp:chromeos',
        '../chromeos/chromeos.gyp:chromeos_memory',
        # browser_chromeos #includes power_supply_properties.pb.h directly.
        '../chromeos/chromeos.gyp:power_manager_proto',
        '../chromeos/ime/input_method.gyp:gencode',
        '../content/content.gyp:content_browser',
        '../content/content.gyp:content_common',
        '../crypto/crypto.gyp:crypto',
        '../dbus/dbus.gyp:dbus',
        '../device/bluetooth/bluetooth.gyp:device_bluetooth',
        '../media/media.gyp:media',
        '../net/net.gyp:net',
        '../ppapi/ppapi_internal.gyp:ppapi_ipc',  # For PpapiMsg_LoadPlugin
        '../printing/printing.gyp:printing',
        '../skia/skia.gyp:skia',
        '../sync/sync.gyp:sync',
        '../third_party/adobe/flash/flash_player.gyp:flapper_version_h',
        '../third_party/cacheinvalidation/cacheinvalidation.gyp:cacheinvalidation',
        '../third_party/cacheinvalidation/cacheinvalidation.gyp:cacheinvalidation_proto_cpp',
        '../third_party/expat/expat.gyp:expat',
        '../third_party/hunspell/hunspell.gyp:hunspell',
        '../third_party/icu/icu.gyp:icui18n',
        '../third_party/icu/icu.gyp:icuuc',
        '../third_party/leveldatabase/leveldatabase.gyp:leveldatabase',
        '../third_party/libevent/libevent.gyp:libevent',
        '../third_party/libjingle/libjingle.gyp:libjingle',
        '../third_party/libphonenumber/libphonenumber.gyp:libphonenumber',
        '../third_party/libusb/libusb.gyp:libusb',
        '../third_party/libxml/libxml.gyp:libxml',
        '../third_party/npapi/npapi.gyp:npapi',
        '../third_party/protobuf/protobuf.gyp:protobuf_lite',
        '../third_party/protobuf/protobuf.gyp:protoc#host',
        '../third_party/re2/re2.gyp:re2',
        '../third_party/zlib/zlib.gyp:zlib',
        '../ui/base/strings/ui_strings.gyp:ui_strings',
        '../ui/surface/surface.gyp:surface',
        '../ui/ui.gyp:ui',
        '../ui/ui.gyp:ui_resources',
        '../ui/views/controls/webview/webview.gyp:webview',
        '../ui/web_dialogs/web_dialogs.gyp:web_dialogs',
        '../url/url.gyp:url_lib',
        '../v8/tools/gyp/v8.gyp:v8',
        '../ui/views/controls/webview/webview.gyp:webview',
        '../webkit/common/user_agent/webkit_user_agent.gyp:user_agent',
        '../webkit/storage_browser.gyp:webkit_storage_browser',
        '../webkit/storage_common.gyp:webkit_storage_common',
        '../webkit/support/webkit_support.gyp:glue',
        '../webkit/webkit_resources.gyp:webkit_resources',
        'chrome_resources.gyp:chrome_strings',
      ],
      'defines': [
        '<@(nacl_defines)',
      ],
      'direct_dependent_settings': {
        'defines': [
          '<@(nacl_defines)',
        ],
      },
      'export_dependent_settings': [
        '../sync/sync.gyp:sync',
      ],
      'include_dirs': [
        # breakpad_linux.cc uses generated file_version_info_linux.h.
        '<(SHARED_INTERMEDIATE_DIR)',
        '../breakpad/src',
      ],
      'sources': [
        # All .cc, .h, .m, and .mm files under browser/chromeos, except for tests
        # and mocks.
        'browser/chromeos/accessibility/accessibility_manager.cc',
        'browser/chromeos/accessibility/accessibility_manager.h',
        'browser/chromeos/accessibility/accessibility_util.cc',
        'browser/chromeos/accessibility/accessibility_util.h',
        'browser/chromeos/accessibility/magnification_manager.cc',
        'browser/chromeos/accessibility/magnification_manager.h',
        'browser/chromeos/app_mode/app_session_lifetime.cc',
        'browser/chromeos/app_mode/app_session_lifetime.h',
        'browser/chromeos/app_mode/kiosk_app_data.cc',
        'browser/chromeos/app_mode/kiosk_app_data.h',
        'browser/chromeos/app_mode/kiosk_app_data_delegate.h',
        'browser/chromeos/app_mode/kiosk_app_launcher.cc',
        'browser/chromeos/app_mode/kiosk_app_launcher.h',
        'browser/chromeos/app_mode/kiosk_app_launch_error.cc',
        'browser/chromeos/app_mode/kiosk_app_launch_error.h',
        'browser/chromeos/app_mode/kiosk_app_manager.cc',
        'browser/chromeos/app_mode/kiosk_app_manager.h',
        'browser/chromeos/app_mode/kiosk_app_manager_observer.h',
        'browser/chromeos/app_mode/kiosk_app_update_service.cc',
        'browser/chromeos/app_mode/kiosk_app_update_service.h',
        'browser/chromeos/app_mode/startup_app_launcher.cc',
        'browser/chromeos/app_mode/startup_app_launcher.h',
        'browser/chromeos/attestation/attestation_ca_client.cc',
        'browser/chromeos/attestation/attestation_ca_client.h',
        'browser/chromeos/attestation/attestation_policy_observer.cc',
        'browser/chromeos/attestation/attestation_policy_observer.h',
        'browser/chromeos/audio/audio_devices_pref_handler_impl.cc',
        'browser/chromeos/audio/audio_devices_pref_handler_impl.h',
        'browser/chromeos/background/ash_user_wallpaper_delegate.cc',
        'browser/chromeos/background/ash_user_wallpaper_delegate.h',
        'browser/chromeos/bluetooth/bluetooth_pairing_dialog.cc',
        'browser/chromeos/bluetooth/bluetooth_pairing_dialog.h',
        'browser/chromeos/boot_times_loader.cc',
        'browser/chromeos/boot_times_loader.h',
        'browser/chromeos/camera_detector.cc',
        'browser/chromeos/camera_detector.h',
        'browser/chromeos/choose_mobile_network_dialog.cc',
        'browser/chromeos/choose_mobile_network_dialog.h',
        'browser/chromeos/chrome_browser_main_chromeos.cc',
        'browser/chromeos/chrome_browser_main_chromeos.h',
        'browser/chromeos/contacts/contact_database.cc',
        'browser/chromeos/contacts/contact_database.h',
        'browser/chromeos/contacts/contact_manager.cc',
        'browser/chromeos/contacts/contact_manager.h',
        'browser/chromeos/contacts/contact_manager_observer.h',
        'browser/chromeos/contacts/contact_map.cc',
        'browser/chromeos/contacts/contact_map.h',
        'browser/chromeos/contacts/contact_store.h',
        'browser/chromeos/contacts/contact_store_observer.h',
        'browser/chromeos/contacts/gdata_contacts_service.cc',
        'browser/chromeos/contacts/gdata_contacts_service.h',
        'browser/chromeos/contacts/google_contact_store.cc',
        'browser/chromeos/contacts/google_contact_store.h',
        'browser/chromeos/cros/cert_library.cc',
        'browser/chromeos/cros/cert_library.h',
        'browser/chromeos/cros/enum_mapper.h',
        'browser/chromeos/cros/native_network_constants.cc',
        'browser/chromeos/cros/native_network_constants.h',
        'browser/chromeos/cros/native_network_parser.cc',
        'browser/chromeos/cros/native_network_parser.h',
        'browser/chromeos/cros/network_constants.h',
        'browser/chromeos/cros/network_library.cc',
        'browser/chromeos/cros/network_library.h',
        'browser/chromeos/cros/network_library_impl_base.cc',
        'browser/chromeos/cros/network_library_impl_base.h',
        'browser/chromeos/cros/network_library_impl_cros.cc',
        'browser/chromeos/cros/network_library_impl_cros.h',
        'browser/chromeos/cros/network_library_impl_stub.cc',
        'browser/chromeos/cros/network_library_impl_stub.h',
        'browser/chromeos/cros/network_parser.cc',
        'browser/chromeos/cros/network_parser.h',
        'browser/chromeos/cros/network_property_ui_data.cc',
        'browser/chromeos/cros/network_property_ui_data.h',
        'browser/chromeos/customization_document.cc',
        'browser/chromeos/customization_document.h',
        'browser/chromeos/display/display_configuration_observer.cc',
        'browser/chromeos/display/display_configuration_observer.h',
        'browser/chromeos/display/display_preferences.cc',
        'browser/chromeos/display/display_preferences.h',
        'browser/chromeos/display/overscan_calibrator.cc',
        'browser/chromeos/display/overscan_calibrator.h',
        'browser/chromeos/dbus/cros_dbus_service.cc',
        'browser/chromeos/dbus/cros_dbus_service.h',
        'browser/chromeos/dbus/display_power_service_provider.cc',
        'browser/chromeos/dbus/display_power_service_provider.h',
        'browser/chromeos/dbus/liveness_service_provider.cc',
        'browser/chromeos/dbus/liveness_service_provider.h',
        'browser/chromeos/dbus/printer_service_provider.cc',
        'browser/chromeos/dbus/printer_service_provider.h',
        'browser/chromeos/dbus/proxy_resolution_service_provider.cc',
        'browser/chromeos/dbus/proxy_resolution_service_provider.h',
        'browser/chromeos/device_hierarchy_observer.h',
        'browser/chromeos/device_uma.cc',
        'browser/chromeos/device_uma.h',
        'browser/chromeos/drive/async_file_util.cc',
        'browser/chromeos/drive/async_file_util.h',
        'browser/chromeos/drive/change_list_loader.cc',
        'browser/chromeos/drive/change_list_loader.h',
        'browser/chromeos/drive/change_list_loader_observer.h',
        'browser/chromeos/drive/change_list_processor.cc',
        'browser/chromeos/drive/change_list_processor.h',
        'browser/chromeos/drive/debug_info_collector.cc',
        'browser/chromeos/drive/debug_info_collector.h',
        'browser/chromeos/drive/download_handler.cc',
        'browser/chromeos/drive/download_handler.h',
        'browser/chromeos/drive/drive_app_registry.cc',
        'browser/chromeos/drive/drive_app_registry.h',
        'browser/chromeos/drive/drive_file_stream_reader.cc',
        'browser/chromeos/drive/drive_file_stream_reader.h',
        'browser/chromeos/drive/drive_integration_service.cc',
        'browser/chromeos/drive/drive_integration_service.h',
        'browser/chromeos/drive/drive_protocol_handler.cc',
        'browser/chromeos/drive/drive_protocol_handler.h',
        'browser/chromeos/drive/drive_url_request_job.cc',
        'browser/chromeos/drive/drive_url_request_job.h',
        'browser/chromeos/drive/file_cache.cc',
        'browser/chromeos/drive/file_cache.h',
        'browser/chromeos/drive/file_cache_metadata.cc',
        'browser/chromeos/drive/file_cache_metadata.h',
        'browser/chromeos/drive/file_change.cc',
        'browser/chromeos/drive/file_change.h',
        'browser/chromeos/drive/file_errors.cc',
        'browser/chromeos/drive/file_errors.h',
        'browser/chromeos/drive/file_system.cc',
        'browser/chromeos/drive/file_system.h',
        'browser/chromeos/drive/file_system/copy_operation.cc',
        'browser/chromeos/drive/file_system/copy_operation.h',
        'browser/chromeos/drive/file_system/create_directory_operation.cc',
        'browser/chromeos/drive/file_system/create_directory_operation.h',
        'browser/chromeos/drive/file_system/create_file_operation.cc',
        'browser/chromeos/drive/file_system/create_file_operation.h',
        'browser/chromeos/drive/file_system/download_operation.cc',
        'browser/chromeos/drive/file_system/download_operation.h',
        'browser/chromeos/drive/file_system/get_file_for_saving_operation.cc',
        'browser/chromeos/drive/file_system/get_file_for_saving_operation.h',
        'browser/chromeos/drive/file_system/move_operation.cc',
        'browser/chromeos/drive/file_system/move_operation.h',
        'browser/chromeos/drive/file_system/open_file_operation.cc',
        'browser/chromeos/drive/file_system/open_file_operation.h',
        'browser/chromeos/drive/file_system/operation_observer.h',
        'browser/chromeos/drive/file_system/remove_operation.cc',
        'browser/chromeos/drive/file_system/remove_operation.h',
        'browser/chromeos/drive/file_system/search_operation.cc',
        'browser/chromeos/drive/file_system/search_operation.h',
        'browser/chromeos/drive/file_system/touch_operation.cc',
        'browser/chromeos/drive/file_system/touch_operation.h',
        'browser/chromeos/drive/file_system/truncate_operation.cc',
        'browser/chromeos/drive/file_system/truncate_operation.h',
        'browser/chromeos/drive/file_system/update_operation.cc',
        'browser/chromeos/drive/file_system/update_operation.h',
        'browser/chromeos/drive/file_system_backend_delegate.cc',
        'browser/chromeos/drive/file_system_backend_delegate.h',
        'browser/chromeos/drive/file_system_interface.h',
        'browser/chromeos/drive/file_system_metadata.cc',
        'browser/chromeos/drive/file_system_metadata.h',
        'browser/chromeos/drive/file_system_observer.h',
        'browser/chromeos/drive/file_system_util.cc',
        'browser/chromeos/drive/file_system_util.h',
        'browser/chromeos/drive/file_task_executor.cc',
        'browser/chromeos/drive/file_task_executor.h',
        'browser/chromeos/drive/file_write_helper.cc',
        'browser/chromeos/drive/file_write_helper.h',
        'browser/chromeos/drive/file_write_watcher.cc',
        'browser/chromeos/drive/file_write_watcher.h',
        'browser/chromeos/drive/fileapi_worker.cc',
        'browser/chromeos/drive/fileapi_worker.h',
        'browser/chromeos/drive/job_list.cc',
        'browser/chromeos/drive/job_list.h',
        'browser/chromeos/drive/job_queue.cc',
        'browser/chromeos/drive/job_queue.h',
        'browser/chromeos/drive/job_scheduler.cc',
        'browser/chromeos/drive/job_scheduler.h',
        'browser/chromeos/drive/local_file_reader.cc',
        'browser/chromeos/drive/local_file_reader.h',
        'browser/chromeos/drive/logging.cc',
        'browser/chromeos/drive/logging.h',
        'browser/chromeos/drive/remove_stale_cache_files.cc',
        'browser/chromeos/drive/remove_stale_cache_files.h',
        'browser/chromeos/drive/resource_entry_conversion.cc',
        'browser/chromeos/drive/resource_entry_conversion.h',
        'browser/chromeos/drive/resource_metadata.cc',
        'browser/chromeos/drive/resource_metadata.h',
        'browser/chromeos/drive/resource_metadata_storage.cc',
        'browser/chromeos/drive/resource_metadata_storage.h',
        'browser/chromeos/drive/search_metadata.cc',
        'browser/chromeos/drive/search_metadata.h',
        'browser/chromeos/drive/sync_client.cc',
        'browser/chromeos/drive/sync_client.h',
        'browser/chromeos/drive/webkit_file_stream_reader_impl.cc',
        'browser/chromeos/drive/webkit_file_stream_reader_impl.h',
        'browser/chromeos/drive/webkit_file_stream_writer_impl.cc',
        'browser/chromeos/drive/webkit_file_stream_writer_impl.h',
        'browser/chromeos/enrollment_dialog_view.cc',
        'browser/chromeos/enrollment_dialog_view.h',
        'browser/chromeos/enterprise_extension_observer.cc',
        'browser/chromeos/enterprise_extension_observer.h',
        'browser/chromeos/extensions/default_app_order.cc',
        'browser/chromeos/extensions/default_app_order.h',
        'browser/chromeos/extensions/echo_private_api.cc',
        'browser/chromeos/extensions/echo_private_api.h',
        'browser/chromeos/extensions/external_cache.cc',
        'browser/chromeos/extensions/external_cache.h',
        'browser/chromeos/extensions/external_pref_cache_loader.cc',
        'browser/chromeos/extensions/external_pref_cache_loader.h',
        'browser/chromeos/extensions/file_manager/desktop_notifications.cc',
        'browser/chromeos/extensions/file_manager/desktop_notifications.h',
        'browser/chromeos/extensions/file_manager/event_router.cc',
        'browser/chromeos/extensions/file_manager/event_router.h',
        'browser/chromeos/extensions/file_manager/file_browser_handlers.cc',
        'browser/chromeos/extensions/file_manager/file_browser_handlers.h',
        'browser/chromeos/extensions/file_manager/file_manager_util.cc',
        'browser/chromeos/extensions/file_manager/file_manager_util.h',
        'browser/chromeos/extensions/file_manager/file_tasks.cc',
        'browser/chromeos/extensions/file_manager/file_tasks.h',
        'browser/chromeos/extensions/file_manager/file_watcher.cc',
        'browser/chromeos/extensions/file_manager/file_watcher.h',
        'browser/chromeos/extensions/file_manager/fileapi_util.cc',
        'browser/chromeos/extensions/file_manager/fileapi_util.h',
        'browser/chromeos/extensions/file_manager/mounted_disk_monitor.cc',
        'browser/chromeos/extensions/file_manager/mounted_disk_monitor.h',
        'browser/chromeos/extensions/file_manager/zip_file_creator.cc',
        'browser/chromeos/extensions/file_manager/zip_file_creator.h',
        'browser/chromeos/extensions/info_private_api.cc',
        'browser/chromeos/extensions/info_private_api.h',
        'browser/chromeos/extensions/input_method_event_router.cc',
        'browser/chromeos/extensions/input_method_event_router.h',
        'browser/chromeos/extensions/install_limiter.cc',
        'browser/chromeos/extensions/install_limiter.h',
        'browser/chromeos/extensions/install_limiter_factory.cc',
        'browser/chromeos/extensions/install_limiter_factory.h',
        'browser/chromeos/extensions/media_player_event_router.cc',
        'browser/chromeos/extensions/media_player_event_router.h',
        'browser/chromeos/external_metrics.cc',
        'browser/chromeos/external_metrics.h',
        'browser/chromeos/external_protocol_dialog.cc',
        'browser/chromeos/external_protocol_dialog.h',
        'browser/chromeos/fileapi/file_access_permissions.cc',
        'browser/chromeos/fileapi/file_access_permissions.h',
        'browser/chromeos/fileapi/file_system_backend.cc',
        'browser/chromeos/fileapi/file_system_backend.h',
        'browser/chromeos/fileapi/file_system_backend_delegate.h',
        'browser/chromeos/imageburner/burn_controller.cc',
        'browser/chromeos/imageburner/burn_controller.h',
        'browser/chromeos/imageburner/burn_device_handler.cc',
        'browser/chromeos/imageburner/burn_device_handler.h',
        'browser/chromeos/imageburner/burn_manager.cc',
        'browser/chromeos/imageburner/burn_manager.h',
        'browser/chromeos/input_method/browser_state_monitor.cc',
        'browser/chromeos/input_method/browser_state_monitor.h',
        'browser/chromeos/input_method/candidate_window_controller.cc',
        'browser/chromeos/input_method/candidate_window_controller.h',
        'browser/chromeos/input_method/candidate_window_controller_impl.cc',
        'browser/chromeos/input_method/candidate_window_controller_impl.h',
        'browser/chromeos/input_method/candidate_window_view.cc',
        'browser/chromeos/input_method/candidate_window_view.h',
        'browser/chromeos/input_method/delayable_widget.cc',
        'browser/chromeos/input_method/delayable_widget.h',
        'browser/chromeos/input_method/hidable_area.cc',
        'browser/chromeos/input_method/hidable_area.h',
        'browser/chromeos/input_method/ibus_controller.cc',
        'browser/chromeos/input_method/ibus_controller.h',
        'browser/chromeos/input_method/ibus_controller_base.cc',
        'browser/chromeos/input_method/ibus_controller_base.h',
        'browser/chromeos/input_method/ibus_controller_impl.cc',
        'browser/chromeos/input_method/ibus_controller_impl.h',
        'browser/chromeos/input_method/infolist_window_view.cc',
        'browser/chromeos/input_method/infolist_window_view.h',
        'browser/chromeos/input_method/input_method_engine_ibus.cc',
        'browser/chromeos/input_method/input_method_engine_ibus.h',
        'browser/chromeos/input_method/input_method_configuration.cc',
        'browser/chromeos/input_method/input_method_configuration.h',
        'browser/chromeos/input_method/input_method_delegate_impl.cc',
        'browser/chromeos/input_method/input_method_delegate_impl.h',
        'browser/chromeos/input_method/input_method_engine.cc',
        'browser/chromeos/input_method/input_method_engine.h',
        'browser/chromeos/input_method/input_method_manager_impl.cc',
        'browser/chromeos/input_method/input_method_manager_impl.h',
        'browser/chromeos/input_method/input_method_manager_impl_ll.cc',
        'browser/chromeos/input_method/input_method_manager_impl_ll.h',
        'browser/chromeos/input_method/input_method_persistence.cc',
        'browser/chromeos/input_method/input_method_persistence.h',
        'browser/chromeos/input_method/input_method_util.cc',
        'browser/chromeos/input_method/input_method_util.h',
        'browser/chromeos/input_method/component_extension_ime_manager_impl.cc',
        'browser/chromeos/input_method/component_extension_ime_manager_impl.h',
        'browser/chromeos/input_method/mock_ibus_controller.cc',
        'browser/chromeos/input_method/mock_ibus_controller.h',
        'browser/chromeos/keyboard_driven_event_rewriter.cc',
        'browser/chromeos/keyboard_driven_event_rewriter.h',
        'browser/chromeos/kiosk_mode/kiosk_mode_idle_logout.cc',
        'browser/chromeos/kiosk_mode/kiosk_mode_idle_logout.h',
        'browser/chromeos/kiosk_mode/kiosk_mode_screensaver.cc',
        'browser/chromeos/kiosk_mode/kiosk_mode_screensaver.h',
        'browser/chromeos/kiosk_mode/kiosk_mode_settings.cc',
        'browser/chromeos/kiosk_mode/kiosk_mode_settings.h',
        'browser/chromeos/language_preferences.cc',
        'browser/chromeos/language_preferences.h',
        'browser/chromeos/locale_change_guard.cc',
        'browser/chromeos/locale_change_guard.h',
        'browser/chromeos/login/auth_attempt_state.cc',
        'browser/chromeos/login/auth_attempt_state.h',
        'browser/chromeos/login/auth_attempt_state_resolver.cc',
        'browser/chromeos/login/auth_attempt_state_resolver.h',
        'browser/chromeos/login/auth_prewarmer.cc',
        'browser/chromeos/login/auth_prewarmer.h',
        'browser/chromeos/login/authentication_notification_details.h',
        'browser/chromeos/login/authenticator.cc',
        'browser/chromeos/login/authenticator.h',
        'browser/chromeos/login/captive_portal_view.cc',
        'browser/chromeos/login/captive_portal_view.h',
        'browser/chromeos/login/captive_portal_window_proxy.cc',
        'browser/chromeos/login/captive_portal_window_proxy.h',
        'browser/chromeos/login/chrome_restart_request.cc',
        'browser/chromeos/login/chrome_restart_request.h',
        'browser/chromeos/login/default_pinned_apps_field_trial.cc',
        'browser/chromeos/login/default_pinned_apps_field_trial.h',
        'browser/chromeos/login/default_user_images.cc',
        'browser/chromeos/login/default_user_images.h',
        'browser/chromeos/login/enrollment/enrollment_screen.cc',
        'browser/chromeos/login/enrollment/enrollment_screen.h',
        'browser/chromeos/login/enrollment/enrollment_screen_actor.h',
        'browser/chromeos/login/existing_user_controller.cc',
        'browser/chromeos/login/existing_user_controller.h',
        'browser/chromeos/login/help_app_launcher.cc',
        'browser/chromeos/login/help_app_launcher.h',
        'browser/chromeos/login/helper.cc',
        'browser/chromeos/login/helper.h',
        'browser/chromeos/login/hwid_checker.cc',
        'browser/chromeos/login/hwid_checker.h',
        'browser/chromeos/login/language_list.cc',
        'browser/chromeos/login/language_list.h',
        'browser/chromeos/login/language_switch_menu.cc',
        'browser/chromeos/login/language_switch_menu.h',
        'browser/chromeos/login/lock_window.cc',
        'browser/chromeos/login/lock_window.h',
        'browser/chromeos/login/lock_window_aura.cc',
        'browser/chromeos/login/lock_window_aura.h',
        'browser/chromeos/login/login_display.cc',
        'browser/chromeos/login/login_display.h',
        'browser/chromeos/login/login_display_host.h',
        'browser/chromeos/login/login_display_host_impl.cc',
        'browser/chromeos/login/login_display_host_impl.h',
        'browser/chromeos/login/login_performer.cc',
        'browser/chromeos/login/login_performer.h',
        'browser/chromeos/login/login_status_consumer.cc',
        'browser/chromeos/login/login_status_consumer.h',
        'browser/chromeos/login/login_utils.cc',
        'browser/chromeos/login/login_utils.h',
        'browser/chromeos/login/login_web_dialog.cc',
        'browser/chromeos/login/login_web_dialog.h',
        'browser/chromeos/login/login_wizard.h',
        'browser/chromeos/login/managed/locally_managed_user_constants.cc',
        'browser/chromeos/login/managed/locally_managed_user_constants.h',
        'browser/chromeos/login/managed/locally_managed_user_creation_controller.cc',
        'browser/chromeos/login/managed/locally_managed_user_creation_controller.h',
        'browser/chromeos/login/managed/locally_managed_user_creation_flow.cc',
        'browser/chromeos/login/managed/locally_managed_user_creation_flow.h',
        'browser/chromeos/login/managed/locally_managed_user_creation_screen.cc',
        'browser/chromeos/login/managed/locally_managed_user_creation_screen.h',
        'browser/chromeos/login/managed/locally_managed_user_login_flow.cc',
        'browser/chromeos/login/managed/locally_managed_user_login_flow.h',
        'browser/chromeos/login/managed/managed_user_authenticator.cc',
        'browser/chromeos/login/managed/managed_user_authenticator.h',
        'browser/chromeos/login/merge_session_load_page.cc',
        'browser/chromeos/login/merge_session_load_page.h',
        'browser/chromeos/login/merge_session_throttle.cc',
        'browser/chromeos/login/merge_session_throttle.h',
        'browser/chromeos/login/mount_manager.cc',
        'browser/chromeos/login/mount_manager.h',
        'browser/chromeos/login/oauth2_login_manager.cc',
        'browser/chromeos/login/oauth2_login_manager.h',
        'browser/chromeos/login/oauth_login_manager.cc',
        'browser/chromeos/login/oauth_login_manager.h',
        'browser/chromeos/login/oauth2_login_verifier.cc',
        'browser/chromeos/login/oauth2_login_verifier.h',
        'browser/chromeos/login/oauth2_token_fetcher.cc',
        'browser/chromeos/login/oauth2_token_fetcher.h',
        'browser/chromeos/login/online_attempt.cc',
        'browser/chromeos/login/online_attempt.h',
        'browser/chromeos/login/online_attempt_host.cc',
        'browser/chromeos/login/online_attempt_host.h',
        'browser/chromeos/login/oobe_display.h',
        'browser/chromeos/login/parallel_authenticator.cc',
        'browser/chromeos/login/parallel_authenticator.h',
        'browser/chromeos/login/profile_auth_data.cc',
        'browser/chromeos/login/profile_auth_data.h',
        'browser/chromeos/login/proxy_settings_dialog.cc',
        'browser/chromeos/login/proxy_settings_dialog.h',
        'browser/chromeos/login/remove_user_delegate.h',
        'browser/chromeos/login/screen_locker.cc',
        'browser/chromeos/login/screen_locker.h',
        'browser/chromeos/login/screen_locker_delegate.cc',
        'browser/chromeos/login/screen_locker_delegate.h',
        'browser/chromeos/login/screens/base_screen.cc',
        'browser/chromeos/login/screens/base_screen.h',
        'browser/chromeos/login/screens/core_oobe_actor.h',
        'browser/chromeos/login/screens/error_screen.cc',
        'browser/chromeos/login/screens/error_screen.h',
        'browser/chromeos/login/screens/error_screen_actor.cc',
        'browser/chromeos/login/screens/error_screen_actor.h',
        'browser/chromeos/login/screens/eula_screen.cc',
        'browser/chromeos/login/screens/eula_screen.h',
        'browser/chromeos/login/screens/eula_screen_actor.h',
        'browser/chromeos/login/screens/kiosk_autolaunch_screen.cc',
        'browser/chromeos/login/screens/kiosk_autolaunch_screen.h',
        'browser/chromeos/login/screens/kiosk_autolaunch_screen_actor.h',
        'browser/chromeos/login/screens/kiosk_enable_screen.cc',
        'browser/chromeos/login/screens/kiosk_enable_screen.h',
        'browser/chromeos/login/screens/kiosk_enable_screen_actor.h',
        'browser/chromeos/login/screens/network_screen.cc',
        'browser/chromeos/login/screens/network_screen.h',
        'browser/chromeos/login/screens/network_screen_actor.h',
        'browser/chromeos/login/screens/reset_screen.cc',
        'browser/chromeos/login/screens/reset_screen.h',
        'browser/chromeos/login/screens/reset_screen_actor.h',
        'browser/chromeos/login/screens/screen_context.cc',
        'browser/chromeos/login/screens/screen_context.h',
        'browser/chromeos/login/screens/screen_factory.cc',
        'browser/chromeos/login/screens/screen_factory.h',
        'browser/chromeos/login/screens/screen_flow.h',
        'browser/chromeos/login/screens/screen_manager.cc',
        'browser/chromeos/login/screens/screen_manager.h',
        'browser/chromeos/login/screens/screen_observer.h',
        'browser/chromeos/login/screens/terms_of_service_screen.cc',
        'browser/chromeos/login/screens/terms_of_service_screen.h',
        'browser/chromeos/login/screens/terms_of_service_screen_actor.h',
        'browser/chromeos/login/screens/update_screen.cc',
        'browser/chromeos/login/screens/update_screen.h',
        'browser/chromeos/login/screens/update_screen_actor.h',
        'browser/chromeos/login/screens/user_image_screen.cc',
        'browser/chromeos/login/screens/user_image_screen.h',
        'browser/chromeos/login/screens/user_image_screen_actor.h',
        'browser/chromeos/login/screens/wizard_screen.cc',
        'browser/chromeos/login/screens/wizard_screen.h',
        'browser/chromeos/login/screens/wrong_hwid_screen.cc',
        'browser/chromeos/login/screens/wrong_hwid_screen.h',
        'browser/chromeos/login/screens/wrong_hwid_screen_actor.h',
        'browser/chromeos/login/simple_web_view_dialog.cc',
        'browser/chromeos/login/simple_web_view_dialog.h',
        'browser/chromeos/login/startup_utils.cc',
        'browser/chromeos/login/startup_utils.h',
        'browser/chromeos/login/test_attempt_state.cc',
        'browser/chromeos/login/test_attempt_state.h',
        'browser/chromeos/login/tpm_password_fetcher.cc',
        'browser/chromeos/login/tpm_password_fetcher.h',
        'browser/chromeos/login/user.cc',
        'browser/chromeos/login/user.h',
        'browser/chromeos/login/user_adding_screen.cc',
        'browser/chromeos/login/user_adding_screen.h',
        'browser/chromeos/login/user_image.cc',
        'browser/chromeos/login/user_image.h',
        'browser/chromeos/login/user_image_loader.cc',
        'browser/chromeos/login/user_image_loader.h',
        'browser/chromeos/login/user_image_manager.h',
        'browser/chromeos/login/user_image_manager.cc',
        'browser/chromeos/login/user_image_manager_impl.cc',
        'browser/chromeos/login/user_image_manager_impl.h',
        'browser/chromeos/login/user_flow.cc',
        'browser/chromeos/login/user_flow.h',
        'browser/chromeos/login/user_manager.cc',
        'browser/chromeos/login/user_manager.h',
        'browser/chromeos/login/user_manager_impl.cc',
        'browser/chromeos/login/user_manager_impl.h',
        'browser/chromeos/login/version_info_updater.cc',
        'browser/chromeos/login/version_info_updater.h',
        'browser/chromeos/login/wallpaper_manager.cc',
        'browser/chromeos/login/wallpaper_manager.h',
        'browser/chromeos/login/webui_login_display.cc',
        'browser/chromeos/login/webui_login_display.h',
        'browser/chromeos/login/webui_login_view.cc',
        'browser/chromeos/login/webui_login_view.h',
        'browser/chromeos/login/webui_screen_locker.cc',
        'browser/chromeos/login/webui_screen_locker.h',
        'browser/chromeos/login/wizard_controller.cc',
        'browser/chromeos/login/wizard_controller.h',
        'browser/chromeos/media/media_player.cc',
        'browser/chromeos/media/media_player.h',
        'browser/chromeos/memory/oom_priority_manager.cc',
        'browser/chromeos/memory/oom_priority_manager.h',
        'browser/chromeos/mobile/mobile_activator.cc',
        'browser/chromeos/mobile/mobile_activator.h',
        'browser/chromeos/mobile_config.cc',
        'browser/chromeos/mobile_config.h',
        'browser/chromeos/net/network_portal_detector.cc',
        'browser/chromeos/net/network_portal_detector.h',
        'browser/chromeos/net/network_portal_detector_impl.cc',
        'browser/chromeos/net/network_portal_detector_impl.h',
        'browser/chromeos/net/network_portal_detector_stub.cc',
        'browser/chromeos/net/network_portal_detector_stub.h',
        'browser/chromeos/net/onc_utils.cc',
        'browser/chromeos/net/onc_utils.h',
        'browser/chromeos/net/proxy_config_handler.cc',
        'browser/chromeos/net/proxy_config_handler.h',
        'browser/chromeos/notifications/balloon_view_host_chromeos.cc',
        'browser/chromeos/notifications/balloon_view_host_chromeos.h',
        'browser/chromeos/offline/offline_load_page.cc',
        'browser/chromeos/offline/offline_load_page.h',
        'browser/chromeos/options/network_config_view.cc',
        'browser/chromeos/options/network_config_view.h',
        'browser/chromeos/options/network_connect.cc',
        'browser/chromeos/options/network_connect.h',
        'browser/chromeos/options/passphrase_textfield.cc',
        'browser/chromeos/options/passphrase_textfield.h',
        'browser/chromeos/options/vpn_config_view.cc',
        'browser/chromeos/options/vpn_config_view.h',
        'browser/chromeos/options/wifi_config_view.cc',
        'browser/chromeos/options/wifi_config_view.h',
        'browser/chromeos/options/wimax_config_view.cc',
        'browser/chromeos/options/wimax_config_view.h',
        'browser/chromeos/policy/app_pack_updater.cc',
        'browser/chromeos/policy/app_pack_updater.h',
        'browser/chromeos/policy/auto_enrollment_client.cc',
        'browser/chromeos/policy/auto_enrollment_client.h',
        'browser/chromeos/policy/configuration_policy_handler_chromeos.cc',
        'browser/chromeos/policy/configuration_policy_handler_chromeos.h',
        'browser/chromeos/policy/device_cloud_policy_manager_chromeos.cc',
        'browser/chromeos/policy/device_cloud_policy_manager_chromeos.h',
        'browser/chromeos/policy/device_cloud_policy_store_chromeos.cc',
        'browser/chromeos/policy/device_cloud_policy_store_chromeos.h',
        'browser/chromeos/policy/device_cloud_policy_validator.cc',
        'browser/chromeos/policy/device_cloud_policy_validator.h',
        'browser/chromeos/policy/device_local_account.cc',
        'browser/chromeos/policy/device_local_account.h',
        'browser/chromeos/policy/device_local_account_policy_provider.cc',
        'browser/chromeos/policy/device_local_account_policy_provider.h',
        'browser/chromeos/policy/device_local_account_policy_service.cc',
        'browser/chromeos/policy/device_local_account_policy_service.h',
        'browser/chromeos/policy/device_local_account_policy_store.cc',
        'browser/chromeos/policy/device_local_account_policy_store.h',
        'browser/chromeos/policy/device_policy_decoder_chromeos.cc',
        'browser/chromeos/policy/device_policy_decoder_chromeos.h',
        'browser/chromeos/policy/device_status_collector.cc',
        'browser/chromeos/policy/device_status_collector.h',
        'browser/chromeos/policy/enrollment_handler_chromeos.cc',
        'browser/chromeos/policy/enrollment_handler_chromeos.h',
        'browser/chromeos/policy/enrollment_status_chromeos.cc',
        'browser/chromeos/policy/enrollment_status_chromeos.h',
        'browser/chromeos/policy/enterprise_install_attributes.cc',
        'browser/chromeos/policy/enterprise_install_attributes.h',
        'browser/chromeos/policy/login_profile_policy_provider.cc',
        'browser/chromeos/policy/login_profile_policy_provider.h',
        'browser/chromeos/policy/login_screen_power_management_policy.cc',
        'browser/chromeos/policy/login_screen_power_management_policy.h',
        'browser/chromeos/policy/network_configuration_updater.cc',
        'browser/chromeos/policy/network_configuration_updater.h',
        'browser/chromeos/policy/network_configuration_updater_impl.cc',
        'browser/chromeos/policy/network_configuration_updater_impl.h',
        'browser/chromeos/policy/network_configuration_updater_impl_cros.cc',
        'browser/chromeos/policy/network_configuration_updater_impl_cros.h',
        'browser/chromeos/policy/policy_cert_verifier.cc',
        'browser/chromeos/policy/policy_cert_verifier.h',
        'browser/chromeos/policy/policy_oauth2_token_fetcher.cc',
        'browser/chromeos/policy/policy_oauth2_token_fetcher.h',
        'browser/chromeos/policy/proxy_policy_provider.cc',
        'browser/chromeos/policy/proxy_policy_provider.h',
        'browser/chromeos/policy/recommendation_restorer.cc',
        'browser/chromeos/policy/recommendation_restorer.h',
        'browser/chromeos/policy/recommendation_restorer_factory.cc',
        'browser/chromeos/policy/recommendation_restorer_factory.h',
        'browser/chromeos/policy/user_cloud_policy_manager_chromeos.cc',
        'browser/chromeos/policy/user_cloud_policy_manager_chromeos.h',
        'browser/chromeos/policy/user_cloud_policy_manager_factory_chromeos.cc',
        'browser/chromeos/policy/user_cloud_policy_manager_factory_chromeos.h',
        'browser/chromeos/policy/user_cloud_policy_store_chromeos.cc',
        'browser/chromeos/policy/user_cloud_policy_store_chromeos.h',
        'browser/chromeos/policy/user_cloud_policy_token_forwarder.cc',
        'browser/chromeos/policy/user_cloud_policy_token_forwarder.h',
        'browser/chromeos/policy/user_cloud_policy_token_forwarder_factory.cc',
        'browser/chromeos/policy/user_cloud_policy_token_forwarder_factory.h',
        'browser/chromeos/policy/user_policy_disk_cache.cc',
        'browser/chromeos/policy/user_policy_disk_cache.h',
        'browser/chromeos/policy/user_policy_token_loader.cc',
        'browser/chromeos/policy/user_policy_token_loader.h',
        'browser/chromeos/power/brightness_observer.cc',
        'browser/chromeos/power/brightness_observer.h',
        'browser/chromeos/power/idle_action_warning_dialog_view.cc',
        'browser/chromeos/power/idle_action_warning_dialog_view.h',
        'browser/chromeos/power/idle_action_warning_observer.cc',
        'browser/chromeos/power/idle_action_warning_observer.h',
        'browser/chromeos/power/peripheral_battery_observer.cc',
        'browser/chromeos/power/peripheral_battery_observer.h',
        'browser/chromeos/power/power_button_observer.cc',
        'browser/chromeos/power/power_button_observer.h',
        'browser/chromeos/power/power_prefs.cc',
        'browser/chromeos/power/power_prefs.h',
        'browser/chromeos/power/resume_observer.cc',
        'browser/chromeos/power/resume_observer.h',
        'browser/chromeos/power/screen_lock_observer.cc',
        'browser/chromeos/power/screen_lock_observer.h',
        'browser/chromeos/power/session_state_controller_delegate_chromeos.cc',
        'browser/chromeos/power/session_state_controller_delegate_chromeos.h',
        'browser/chromeos/power/suspend_observer.cc',
        'browser/chromeos/power/suspend_observer.h',
        'browser/chromeos/power/user_activity_notifier.cc',
        'browser/chromeos/power/user_activity_notifier.h',
        'browser/chromeos/power/video_activity_notifier.cc',
        'browser/chromeos/power/video_activity_notifier.h',
        'browser/chromeos/preferences.cc',
        'browser/chromeos/preferences.h',
        'browser/chromeos/prerender_condition_network.cc',
        'browser/chromeos/prerender_condition_network.h',
        'browser/chromeos/profiles/profile_helper.cc',
        'browser/chromeos/profiles/profile_helper.h',
        'browser/chromeos/profiles/profile_util.cc',
        'browser/chromeos/profiles/profile_util.h',
        'browser/chromeos/proxy_config_service_impl.cc',
        'browser/chromeos/proxy_config_service_impl.h',
        'browser/chromeos/proxy_cros_settings_parser.cc',
        'browser/chromeos/proxy_cros_settings_parser.h',
        'browser/chromeos/screensaver/screensaver_controller.cc',
        'browser/chromeos/screensaver/screensaver_controller.h',
        'browser/chromeos/session_length_limiter.cc',
        'browser/chromeos/session_length_limiter.h',
        'browser/chromeos/settings/cros_settings.cc',
        'browser/chromeos/settings/cros_settings.h',
        'browser/chromeos/settings/cros_settings_names.cc',
        'browser/chromeos/settings/cros_settings_names.h',
        'browser/chromeos/settings/cros_settings_provider.cc',
        'browser/chromeos/settings/cros_settings_provider.h',
        'browser/chromeos/settings/device_oauth2_token_service.cc',
        'browser/chromeos/settings/device_oauth2_token_service.h',
        'browser/chromeos/settings/device_oauth2_token_service_factory.cc',
        'browser/chromeos/settings/device_oauth2_token_service_factory.h',
        'browser/chromeos/settings/device_settings_cache.cc',
        'browser/chromeos/settings/device_settings_cache.h',
        'browser/chromeos/settings/device_settings_provider.cc',
        'browser/chromeos/settings/device_settings_provider.h',
        'browser/chromeos/settings/device_settings_service.cc',
        'browser/chromeos/settings/device_settings_service.h',
        'browser/chromeos/settings/owner_flags_storage.cc',
        'browser/chromeos/settings/owner_flags_storage.h',
        'browser/chromeos/settings/owner_key_util.cc',
        'browser/chromeos/settings/owner_key_util.h',
        'browser/chromeos/settings/session_manager_operation.cc',
        'browser/chromeos/settings/session_manager_operation.h',
        'browser/chromeos/settings/stub_cros_settings_provider.cc',
        'browser/chromeos/settings/stub_cros_settings_provider.h',
        'browser/chromeos/settings/system_settings_provider.cc',
        'browser/chromeos/settings/system_settings_provider.h',
        'browser/chromeos/sim_dialog_delegate.cc',
        'browser/chromeos/sim_dialog_delegate.h',
        'browser/chromeos/sms_observer.cc',
        'browser/chromeos/sms_observer.h',
        'browser/chromeos/status/data_promo_notification.cc',
        'browser/chromeos/status/data_promo_notification.h',
        'browser/chromeos/status/network_menu.cc',
        'browser/chromeos/status/network_menu.h',
        'browser/chromeos/swap_metrics.cc',
        'browser/chromeos/swap_metrics.h',
        'browser/chromeos/system/ash_system_tray_delegate.cc',
        'browser/chromeos/system/ash_system_tray_delegate.h',
        'browser/chromeos/system/automatic_reboot_manager.cc',
        'browser/chromeos/system/automatic_reboot_manager.h',
        'browser/chromeos/system/automatic_reboot_manager_observer.h',
        'browser/chromeos/system/device_change_handler.cc',
        'browser/chromeos/system/device_change_handler.h',
        'browser/chromeos/system/input_device_settings.cc',
        'browser/chromeos/system/input_device_settings.h',
        'browser/chromeos/system/pointer_device_observer.cc',
        'browser/chromeos/system/pointer_device_observer.h',
        'browser/chromeos/system/statistics_provider.cc',
        'browser/chromeos/system/statistics_provider.h',
        'browser/chromeos/system/syslogs_provider.cc',
        'browser/chromeos/system/syslogs_provider.h',
        'browser/chromeos/system/timezone_settings.cc',
        'browser/chromeos/system/timezone_settings.h',
        'browser/chromeos/system_key_event_listener.cc',
        'browser/chromeos/system_key_event_listener.h',
        'browser/chromeos/system_logs/about_system_logs_fetcher.cc',
        'browser/chromeos/system_logs/about_system_logs_fetcher.h',
        'browser/chromeos/system_logs/chrome_internal_log_source.cc',
        'browser/chromeos/system_logs/chrome_internal_log_source.h',
        'browser/chromeos/system_logs/command_line_log_source.cc',
        'browser/chromeos/system_logs/command_line_log_source.h',
        'browser/chromeos/system_logs/dbus_log_source.cc',
        'browser/chromeos/system_logs/dbus_log_source.h',
        'browser/chromeos/system_logs/debug_daemon_log_source.cc',
        'browser/chromeos/system_logs/debug_daemon_log_source.h',
        'browser/chromeos/system_logs/lsb_release_log_source.cc',
        'browser/chromeos/system_logs/lsb_release_log_source.h',
        'browser/chromeos/system_logs/memory_details_log_source.cc',
        'browser/chromeos/system_logs/memory_details_log_source.h',
        'browser/chromeos/system_logs/network_event_log_source.cc',
        'browser/chromeos/system_logs/network_event_log_source.h',
        'browser/chromeos/system_logs/scrubbed_system_logs_fetcher.cc',
        'browser/chromeos/system_logs/scrubbed_system_logs_fetcher.h',
        'browser/chromeos/system_logs/system_logs_fetcher_base.cc',
        'browser/chromeos/system_logs/system_logs_fetcher_base.h',
        'browser/chromeos/system_logs/touch_log_source.cc',
        'browser/chromeos/system_logs/touch_log_source.h',
        'browser/chromeos/ui/app_launch_view.cc',
        'browser/chromeos/ui/app_launch_view.h',
        'browser/chromeos/ui/echo_dialog_listener.h',
        'browser/chromeos/ui/echo_dialog_view.cc',
        'browser/chromeos/ui/echo_dialog_view.h',
        'browser/chromeos/ui/focus_ring_controller.cc',
        'browser/chromeos/ui/focus_ring_controller.h',
        'browser/chromeos/ui/focus_ring_layer.cc',
        'browser/chromeos/ui/focus_ring_layer.h',
        'browser/chromeos/ui/idle_logout_dialog_view.cc',
        'browser/chromeos/ui/idle_logout_dialog_view.h',
        'browser/chromeos/ui/screen_capture_notification_ui_chromeos.cc',
        'browser/chromeos/ui/screen_capture_notification_ui_chromeos.h',
        'browser/chromeos/ui_proxy_config.cc',
        'browser/chromeos/ui_proxy_config.h',
        'browser/chromeos/ui_proxy_config_service.cc',
        'browser/chromeos/ui_proxy_config_service.h',
        'browser/chromeos/upgrade_detector_chromeos.cc',
        'browser/chromeos/upgrade_detector_chromeos.h',
        'browser/chromeos/version_loader.cc',
        'browser/chromeos/version_loader.h',
        'browser/chromeos/xinput_hierarchy_changed_event_listener.cc',
        'browser/chromeos/xinput_hierarchy_changed_event_listener.h',
        'browser/chromeos/xinput_hierarchy_changed_event_listener_aura.cc',
      ],
      'conditions': [
        ['enable_extensions==1', {
          'sources': [
            # Only extension API implementations should go here.
            'browser/chromeos/extensions/echo_private_api.cc',
            'browser/chromeos/extensions/echo_private_api.h',
            'browser/chromeos/extensions/file_manager/file_browser_handler_api.cc',
            'browser/chromeos/extensions/file_manager/file_browser_handler_api.h',
            'browser/chromeos/extensions/file_manager/file_browser_private_api.cc',
            'browser/chromeos/extensions/file_manager/file_browser_private_api.h',
            'browser/chromeos/extensions/file_manager/file_browser_private_api_factory.cc',
            'browser/chromeos/extensions/file_manager/file_browser_private_api_factory.h',
            'browser/chromeos/extensions/file_manager/private_api_base.cc',
            'browser/chromeos/extensions/file_manager/private_api_base.h',
            'browser/chromeos/extensions/file_manager/private_api_dialog.cc',
            'browser/chromeos/extensions/file_manager/private_api_dialog.h',
            'browser/chromeos/extensions/file_manager/private_api_drive.cc',
            'browser/chromeos/extensions/file_manager/private_api_drive.h',
            'browser/chromeos/extensions/file_manager/private_api_file_system.cc',
            'browser/chromeos/extensions/file_manager/private_api_file_system.h',
            'browser/chromeos/extensions/file_manager/private_api_misc.cc',
            'browser/chromeos/extensions/file_manager/private_api_misc.h',
            'browser/chromeos/extensions/file_manager/private_api_mount.cc',
            'browser/chromeos/extensions/file_manager/private_api_mount.h',
            'browser/chromeos/extensions/file_manager/private_api_strings.cc',
            'browser/chromeos/extensions/file_manager/private_api_strings.h',
            'browser/chromeos/extensions/file_manager/private_api_tasks.cc',
            'browser/chromeos/extensions/file_manager/private_api_tasks.h',
            'browser/chromeos/extensions/file_manager/private_api_util.cc',
            'browser/chromeos/extensions/file_manager/private_api_util.h',
            'browser/chromeos/extensions/input_method_api.cc',
            'browser/chromeos/extensions/input_method_api.h',
            'browser/chromeos/extensions/media_player_api.cc',
            'browser/chromeos/extensions/media_player_api.h',
            'browser/chromeos/extensions/wallpaper_manager_util.cc',
            'browser/chromeos/extensions/wallpaper_manager_util.h',
            'browser/chromeos/extensions/wallpaper_private_api.cc',
            'browser/chromeos/extensions/wallpaper_private_api.h',
          ],
        }],
        ['use_x11==0', {
          'sources!': [
            'browser/chromeos/device_uma.cc',
            'browser/chromeos/device_uma.h',
          ],
        }],
        ['use_cras==1', {
          'defines': [
            'USE_CRAS',
          ],          
        }],
        ['file_manager_extension==0', {
          'sources/': [
            ['exclude', 'browser/chromeos/extensions/file_manager/file_browser_handler_api.cc'],
            ['exclude', 'browser/chromeos/extensions/file_manager/file_browser_handler_api.h'],
            ['exclude', 'browser/chromeos/extensions/file_manager/file_browser_private_api.cc'],
            ['exclude', 'browser/chromeos/extensions/file_manager/file_browser_private_api.h'],
            ['exclude', 'browser/chromeos/extensions/file_manager/file_browser_private_api_factory.cc'],
            ['exclude', 'browser/chromeos/extensions/file_manager/file_browser_private_api_factory.h'],
            ['exclude', 'browser/chromeos/extensions/file_manager/file_manager_util.cc'],
            ['exclude', 'browser/chromeos/extensions/file_manager/file_manager_util.h'],
            ['exclude', 'browser/chromeos/extensions/file_manager/file_tasks.cc'],
            ['exclude', 'browser/chromeos/extensions/file_manager/file_tasks.h'],
            ['exclude', 'browser/chromeos/extensions/file_manager/zip_file_creator.cc'],
            ['exclude', 'browser/chromeos/extensions/file_manager/zip_file_creator.h'],
            ['exclude', 'browser/chromeos/extensions/media_player_api.cc'],
            ['exclude', 'browser/chromeos/extensions/media_player_api.h'],
          ],
        }],
        ['use_ash==1', {
          'dependencies': [
            '../ash/ash.gyp:ash',
            '../ash/ash.gyp:ash_resources',
            '../ash/ash_strings.gyp:ash_strings',
            '../ui/app_list/app_list.gyp:app_list',
            '../ui/message_center/message_center.gyp:message_center',
          ],
        }],
        ['use_aura==1', {
          'dependencies': [
            '../ui/aura/aura.gyp:aura',
            '../ui/compositor/compositor.gyp:compositor',
          ],
        }],
        ['ui_compositor_image_transport==1', {
          'dependencies': [
            '../ui/gl/gl.gyp:gl',
          ],
        }],
        ['use_aura==1',{
          'dependencies': [
            '../build/linux/system.gyp:dbus',
            '../build/linux/system.gyp:fontconfig',
            '../build/linux/system.gyp:x11',
            '../ui/views/views.gyp:views',
          ],
          'include_dirs': [
            '<(INTERMEDIATE_DIR)',
            '<(INTERMEDIATE_DIR)/chrome',
          ],
          'sources/': [
            ['include', '^browser/chromeos/status/memory_menu_button.cc'],
            ['include', '^browser/chromeos/status/memory_menu_button.h'],
          ],
        }],
      ],
    },
    {
      # Protobuf compiler / generator for the Drive protocol buffer.
      'target_name': 'drive_proto',
      'type': 'static_library',
      'sources': [ 'browser/chromeos/drive/drive.proto' ],
      'variables': {
        'proto_in_dir': 'browser/chromeos/drive',
        'proto_out_dir': 'chrome/browser/chromeos/drive',
      },
      'includes': [ '../build/protoc.gypi' ]
    },
    {
      # Protobuf compiler / generator for device settings protocol buffers.
      'target_name': 'device_policy_proto',
      'type': 'static_library',
      'sources': [
        'browser/policy/proto/chromeos/chrome_device_policy.proto',
        'browser/policy/proto/chromeos/install_attributes.proto',
      ],
      'variables': {
        'proto_in_dir': 'browser/policy/proto/chromeos',
        'proto_out_dir': 'chrome/browser/policy/proto/chromeos',
      },
      'includes': [ '../build/protoc.gypi' ]
    },
    {
      # Protobuf compiler / generator for attestation protocol buffers.
      'target_name': 'attestation_proto',
      'type': 'static_library',
      'sources': [
        'browser/chromeos/attestation/attestation_key_payload.proto',
      ],
      'variables': {
        'proto_in_dir': 'browser/chromeos/attestation',
        'proto_out_dir': 'chrome/browser/chromeos/attestation',
      },
      'includes': [ '../build/protoc.gypi' ]
    },
  ],
}
