/* Copyright (c) 2011-2013, The Linux Foundation. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 and
 * only version 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */

#include <linux/batterydata-lib.h>

static struct single_row_lut fcc_temp = {
	.x		= {-20, 0, 25, 40, 60},
	.y		= {8200, 8251, 8261, 8240, 8183},
	.cols	= 5
};

static struct single_row_lut fcc_sf = {
	.x		= {0},
	.y		= {100},
	.cols	= 1
};

static struct sf_lut rbatt_sf = {
	.rows		= 30,
	.cols		= 5,
	.row_entries		= {-20, 0, 25, 40, 60},
	.percent	= {100, 95, 90, 85, 80, 75, 70, 65, 60, 55, 50, 45, 40, 35, 30, 25, 20, 16, 13, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1},
	.sf		= {
				{689, 161, 100, 96, 97},
				{689, 161, 100, 96, 97},
				{684, 164, 101, 96, 97},
				{677, 167, 102, 97, 97},
				{662, 172, 103, 97, 98},
				{636, 183, 104, 98, 98},
				{624, 194, 107, 100, 100},
				{618, 197, 112, 102, 101},
				{616, 175, 117, 104, 102},
				{624, 156, 111, 104, 100},
				{647, 155, 100, 97, 97},
				{687, 156, 100, 97, 97},
				{745, 156, 101, 97, 98},
				{831, 158, 101, 98, 100},
				{952, 162, 101, 97, 100},
				{1124, 164, 100, 96, 97},
				{1367, 170, 100, 96, 97},
				{1635, 176, 100, 96, 97},
				{1844, 180, 100, 95, 96},
				{1968, 190, 100, 97, 97},
				{2090, 196, 101, 97, 98},
				{2252, 205, 101, 98, 101},
				{2560, 220, 103, 100, 102},
				{3082, 242, 104, 102, 105},
				{3744, 276, 108, 105, 102},
				{4672, 311, 105, 100, 101},
				{6071, 356, 104, 100, 103},
				{8395, 457, 108, 101, 105},
				{12863, 661, 114, 105, 128},
				{22961, 1368, 214, 127, 827}
	}
};


static struct pc_temp_ocv_lut pc_temp_ocv = {
	.rows		= 31,
	.cols		= 5,
	.temp		= {-20, 0, 25, 40, 60},
	.percent	= {100, 95, 90, 85, 80, 75, 70, 65, 60, 55, 50, 45, 40, 35, 30, 25, 20, 16, 13, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0},
	.ocv		= {
				{4335, 4333, 4328, 4324, 4318},
				{4229, 4259, 4262, 4260, 4255},
				{4153, 4201, 4205, 4203, 4199},
				{4087, 4145, 4149, 4147, 4144},
				{4025, 4093, 4097, 4095, 4092},
				{3966, 4044, 4048, 4046, 4043},
				{3917, 3996, 4003, 4002, 3999},
				{3876, 3950, 3964, 3963, 3960},
				{3842, 3901, 3924, 3924, 3921},
				{3816, 3861, 3876, 3878, 3872},
				{3797, 3834, 3840, 3841, 3840},
				{3784, 3812, 3818, 3819, 3818},
				{3771, 3794, 3800, 3801, 3799},
				{3758, 3781, 3786, 3786, 3784},
				{3743, 3771, 3774, 3771, 3764},
				{3726, 3760, 3760, 3752, 3738},
				{3705, 3740, 3741, 3731, 3714},
				{3686, 3714, 3715, 3706, 3686},
				{3668, 3691, 3690, 3682, 3669},
				{3653, 3683, 3686, 3679, 3667},
				{3644, 3680, 3685, 3678, 3665},
				{3634, 3676, 3684, 3676, 3663},
				{3623, 3670, 3682, 3674, 3660},
				{3608, 3665, 3678, 3670, 3650},
				{3587, 3656, 3671, 3660, 3624},
				{3560, 3636, 3646, 3629, 3578},
				{3521, 3592, 3596, 3578, 3516},
				{3463, 3526, 3529, 3509, 3434},
				{3378, 3434, 3434, 3414, 3314},
				{3250, 3289, 3275, 3264, 3157},
				{3000, 3000, 3000, 3000, 3000}
	}
};


struct bms_battery_data LGE_BL_T13_8000mAh_TOCAD_data = {
	.fcc				= 8000,
	.fcc_temp_lut			= &fcc_temp,
	.fcc_sf_lut				= &fcc_sf,
	.pc_temp_ocv_lut		= &pc_temp_ocv,
	.rbatt_sf_lut			= &rbatt_sf,
	.default_rbatt_mohm	= 85,
	.flat_ocv_threshold_uv	= 3800000,
};
