/*
 * Copyright 2013 Google Inc.
 *
 * Use of this source code is governed by a BSD-style license that can be
 * found in the LICENSE file.
 */

#include "SkStream.h"
#include "SkStreamHelpers.h"
#include "SkTypes.h"

// 2013.12.18, YoungGon Kim, cut to big BMP file[START]
#define MAX_STREAM_LENGTH 75000200  // max bytes length (5000(width) * 5000(height)) * 3byte + margin
// 2013.12.18, YoungGon Kim, cut to big BMP file[END]

size_t CopyStreamToStorage(SkAutoMalloc* storage, SkStream* stream) {
    SkASSERT(storage != NULL);
    SkASSERT(stream != NULL);

    // 2013.11.25, YoungGon Kim, cut to big BMP file[START]
    {
        if (stream->getLength() > MAX_STREAM_LENGTH) {
            return 0;
        }
    }
    // 2013.11.25, YoungGon Kim, cut to big BMP file[END]

    if (stream->hasLength()) {
        const size_t length = stream->getLength();
        void* dst = storage->reset(length);
        if (stream->read(dst, length) != length) {
            return 0;
        }
        return length;
    }

    SkDynamicMemoryWStream tempStream;
    // Arbitrary buffer size.
    const size_t bufferSize = 256 * 1024; // 256KB
    char buffer[bufferSize];
    SkDEBUGCODE(size_t debugLength = 0;)

    // 2013.12.18, YoungGon Kim, cut to big BMP file[START]
    size_t total_bytesRead = 0;
    // 2013.12.18, YoungGon Kim, cut to big BMP file[END]

    do {
        size_t bytesRead = stream->read(buffer, bufferSize);


        // 2013.12.18, YoungGon Kim, cut to big BMP file[START]
        total_bytesRead += bytesRead;
        if (total_bytesRead > MAX_STREAM_LENGTH){
            return 0;
        }
        // 2013.12.18, YoungGon Kim, cut to big BMP file[END]

        tempStream.write(buffer, bytesRead);
        SkDEBUGCODE(debugLength += bytesRead);
        SkASSERT(tempStream.bytesWritten() == debugLength);
    } while (!stream->isAtEnd());
    const size_t length = tempStream.bytesWritten();
    void* dst = storage->reset(length);
    tempStream.copyTo(dst);
    return length;
}
