/*
 * SX9311 Cap Touch
 * Currently Supports:
 *  SX9311
 *
 * Copyright 2012 Semtech Corp.
 *
 * Licensed under the GPL-2 or later.
 */

#ifndef _SX9311_I2C_REG_H_
#define _SX9311_I2C_REG_H_

/*
 *  I2C Registers
 */
#define SX9311_IRQSTAT_REG    0x00
#define SX9311_TCHCMPSTAT_REG 0x01
#define SX9311_IRQ_ENABLE_REG 0x03
#define SX9311_IRQFUNC_REG 0x04
#define SX9311_CPS_CTRL0_REG  0x10
#define SX9311_CPS_CTRL1_REG  0x11
#define SX9311_CPS_CTRL2_REG  0x12
#define SX9311_CPS_CTRL3_REG  0x13
#define SX9311_CPS_CTRL4_REG  0x14
#define SX9311_CPS_CTRL5_REG  0x15
#define SX9311_CPS_CTRL6_REG  0x16
#define SX9311_CPS_CTRL7_REG  0x17
#define SX9311_CPS_CTRL8_REG  0x18
#define SX9311_CPS_CTRL9_REG  0x19
#define SX9311_CPS_CTRL10_REG  0x1A
#define SX9311_CPS_CTRL11_REG  0x1B
#define SX9311_CPS_CTRL12_REG  0x1C
#define SX9311_CPS_CTRL13_REG  0x1D
#define SX9311_CPS_CTRL14_REG  0x1E
#define SX9311_CPS_CTRL15_REG  0x1F
#define SX9311_CPS_CTRL16_REG  0x20
#define SX9311_CPS_CTRL17_REG  0x21
#define SX9311_CPS_CTRL18_REG  0x22
#define SX9311_CPS_CTRL19_REG  0x23
#define SX9311_CPS_SAR_CTRL0_REG  0x2A
#define SX9311_CPS_SAR_CTRL1_REG  0x2B
#define SX9311_CPS_SAR_CTRL2_REG  0x2C
#define SX9311_SOFTRESET_REG  0x7F

/* Sensor Readback */
#define SX9311_SENSORSEL_REG  0x30

#define SX9311_USEMSB_REG     0x31
#define SX9311_USELSB_REG     0x32

#define SX9311_AVGMSB_REG     0x33
#define SX9311_AVGLSB_REG     0x34

#define SX9311_DIFFMSB_REG    0x35
#define SX9311_DIFFLSB_REG    0x36

#define SX9311_OFFSETMSB_REG  0x37
#define SX9311_OFFSETLSB_REG  0x38

/* IrqStat 0:Inactive 1:Active     */
#define SX9311_IRQSTAT_RESET_FLAG      0x80
#define SX9311_IRQSTAT_TOUCH_FLAG      0x40
#define SX9311_IRQSTAT_RELEASE_FLAG    0x20
#define SX9311_IRQSTAT_COMPDONE_FLAG   0x10
#define SX9311_IRQSTAT_CONV_FLAG       0x08
#define SX9311_IRQSTAT_TXENSTAT_FLAG   0x01


/* CpsStat  */
#define SX9311_TCHCMPSTAT_TCHSTAT3_FLAG   0x08
#define SX9311_TCHCMPSTAT_TCHSTAT2_FLAG   0x04
#define SX9311_TCHCMPSTAT_TCHSTAT1_FLAG   0x02
#define SX9311_TCHCMPSTAT_TCHSTAT0_FLAG   0x01

/* SoftReset */
#define SX9311_SOFTRESET  0xDE

/* CSx PIN */
#define SENSORSEL_CS0  0x00
#define SENSORSEL_CS1  0x01
#define SENSORSEL_CS2  0x02
#define SENSORSEL_CS3  0x03

#define SENSOREN_DISABLE_ALL 0x00
#define SENSOREN_CS0   0x01
#define SENSOREN_CS1   0x02
#define SENSOREN_CS2   0x04
#define SENSOREN_CS3   0x08

/* Input Capacitance Range */
#define REG_RANGE_LARGE        0x00
#define REG_RANGE_MEDIUM_LARGE 0x01
#define REG_RANGE_MEDIUM_SMALL 0x02
#define REG_RANGE_SMALL        0x03

#define RANGE_LARGE            146000
#define RANGE_MEDIUM_LARGE     74000
#define RANGE_MEDIUM_SMALL     60000
#define RANGE_SMALL            50000

/* Input Capacitance Range */
#define REG_GAIN_1X  0x00
#define REG_GAIN_2X  0x01
#define REG_GAIN_4X  0x02
#define REG_GAIN_8X  0x03

#define GAIN_1X      1
#define GAIN_2X      2
#define GAIN_4X      4
#define GAIN_8X      8

#endif /* _SX9311_I2C_REG_H_*/
