/*
 * Copyright (c) 2011-2014 The Linux Foundation. All rights reserved.
 *
 * Previously licensed under the ISC license by Qualcomm Atheros, Inc.
 *
 *
 * Permission to use, copy, modify, and/or distribute this software for
 * any purpose with or without fee is hereby granted, provided that the
 * above copyright notice and this permission notice appear in all
 * copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL
 * WARRANTIES WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE
 * AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL
 * DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR
 * PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 */

/*
 * This file was originally distributed by Qualcomm Atheros, Inc.
 * under proprietary terms before Copyright ownership was assigned
 * to the Linux Foundation.
 */

/*
 *
 * This file contains CFG functions for processing host messages.
 *
 * Author:      Kevin Nguyen
 * Date:        04/09/02
 * History:-
 * 04/09/02        Created.
 * --------------------------------------------------------------------
 */
#include "palTypes.h"
#include "aniGlobal.h"
#include "cfgPriv.h"
#include "cfgDebug.h"
#include "wlan_qct_wda.h"

#define SEM_0 0x00000000
#define SEM_1 0x00001000
#define SEM_2 0x00002000
#define SEM_3 0x00003000
#define SEM_4 0x00004000
#define SEM_5 0x00005000
#define SEM_6 0x00006000
#define SEM_7 0x00007000
#define SEM_8 0x00008000
#define SEM_9 0x00009000
#define SEM_10 0x0000a000
#define SEM_11 0x0000b000
#define SEM_12 0x0000c000
#define SEM_13 0x0000d000
#define SEM_14 0x0000e000
#define SEM_15 0x0000f000

tAniSirCgStatic cfgStatic[CFG_PARAM_MAX_NUM] =
{
    {WNI_CFG_STA_ID,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_RELOAD | CFG_CTL_NTF_HAL | SEM_1,
     0, 255, 1},
    {WNI_CFG_CF_POLLABLE,
     CFG_CTL_RE | CFG_CTL_INT | CFG_CTL_RESTART | SEM_1,
     0, 255, 1},
    {WNI_CFG_CFP_PERIOD,
     CFG_CTL_VALID  | CFG_CTL_RE | CFG_CTL_INT | SEM_1,
     WNI_CFG_CFP_PERIOD_STAMIN,
     WNI_CFG_CFP_PERIOD_STAMAX,
     WNI_CFG_CFP_PERIOD_STADEF},
    {WNI_CFG_CFP_MAX_DURATION,
     CFG_CTL_VALID  | CFG_CTL_RE | CFG_CTL_INT | SEM_1,
     WNI_CFG_CFP_MAX_DURATION_STAMIN,
     WNI_CFG_CFP_MAX_DURATION_STAMAX,
     WNI_CFG_CFP_MAX_DURATION_STADEF},
    {WNI_CFG_SSID,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_RESTART | SEM_1,
     0, 255, 6},
    {WNI_CFG_BEACON_INTERVAL,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | CFG_CTL_NTF_SCH | SEM_2,
     WNI_CFG_BEACON_INTERVAL_STAMIN,
     WNI_CFG_BEACON_INTERVAL_STAMAX,
     WNI_CFG_BEACON_INTERVAL_STADEF},
    {WNI_CFG_DTIM_PERIOD,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_INT | SEM_2,
     WNI_CFG_DTIM_PERIOD_STAMIN,
     WNI_CFG_DTIM_PERIOD_STAMAX,
     WNI_CFG_DTIM_PERIOD_STADEF},
    {WNI_CFG_WEP_KEY_LENGTH,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | CFG_CTL_RESTART | SEM_5,
     WNI_CFG_WEP_KEY_LENGTH_STAMIN,
     WNI_CFG_WEP_KEY_LENGTH_STAMAX,
     WNI_CFG_WEP_KEY_LENGTH_STADEF},
    {WNI_CFG_WEP_DEFAULT_KEY_1,
     CFG_CTL_VALID | CFG_CTL_WE | CFG_CTL_RESTART | SEM_4,
     0, 65535, 0},
    {WNI_CFG_WEP_DEFAULT_KEY_2,
     CFG_CTL_VALID | CFG_CTL_WE | CFG_CTL_RESTART | SEM_4,
     1, 1, 1},
    {WNI_CFG_WEP_DEFAULT_KEY_3,
     CFG_CTL_VALID | CFG_CTL_WE | CFG_CTL_RESTART | SEM_4,
     0, 5, 5},
    {WNI_CFG_WEP_DEFAULT_KEY_4,
     CFG_CTL_VALID | CFG_CTL_WE | CFG_CTL_RESTART | SEM_4,
     0, 1, 0},
    {WNI_CFG_WEP_DEFAULT_KEYID,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | CFG_CTL_NTF_LIM | SEM_5,
     WNI_CFG_WEP_DEFAULT_KEYID_STAMIN,
     WNI_CFG_WEP_DEFAULT_KEYID_STAMAX,
     WNI_CFG_WEP_DEFAULT_KEYID_STADEF},
    {WNI_CFG_EXCLUDE_UNENCRYPTED,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | CFG_CTL_NTF_LIM | SEM_5,
     WNI_CFG_EXCLUDE_UNENCRYPTED_STAMIN,
     WNI_CFG_EXCLUDE_UNENCRYPTED_STAMAX,
     WNI_CFG_EXCLUDE_UNENCRYPTED_STADEF},
    {WNI_CFG_RTS_THRESHOLD,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | CFG_CTL_NTF_HAL | SEM_6,
     WNI_CFG_RTS_THRESHOLD_STAMIN,
     WNI_CFG_RTS_THRESHOLD_STAMAX,
     WNI_CFG_RTS_THRESHOLD_STADEF},
    {WNI_CFG_SHORT_RETRY_LIMIT,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | CFG_CTL_NTF_HAL | SEM_6,
     WNI_CFG_SHORT_RETRY_LIMIT_STAMIN,
     WNI_CFG_SHORT_RETRY_LIMIT_STAMAX,
     WNI_CFG_SHORT_RETRY_LIMIT_STADEF},
    {WNI_CFG_LONG_RETRY_LIMIT,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | CFG_CTL_NTF_HAL | SEM_6,
     WNI_CFG_LONG_RETRY_LIMIT_STAMIN,
     WNI_CFG_LONG_RETRY_LIMIT_STAMAX,
     WNI_CFG_LONG_RETRY_LIMIT_STADEF},
    {WNI_CFG_FRAGMENTATION_THRESHOLD,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | CFG_CTL_NTF_HAL | SEM_6,
     WNI_CFG_FRAGMENTATION_THRESHOLD_STAMIN,
     WNI_CFG_FRAGMENTATION_THRESHOLD_STAMAX,
     WNI_CFG_FRAGMENTATION_THRESHOLD_STADEF},
    {WNI_CFG_ACTIVE_MINIMUM_CHANNEL_TIME,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | SEM_9,
     WNI_CFG_ACTIVE_MINIMUM_CHANNEL_TIME_STAMIN,
     WNI_CFG_ACTIVE_MINIMUM_CHANNEL_TIME_STAMAX,
     WNI_CFG_ACTIVE_MINIMUM_CHANNEL_TIME_STADEF},
    {WNI_CFG_ACTIVE_MAXIMUM_CHANNEL_TIME,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | SEM_9,
     WNI_CFG_ACTIVE_MAXIMUM_CHANNEL_TIME_STAMIN,
     WNI_CFG_ACTIVE_MAXIMUM_CHANNEL_TIME_STAMAX,
     WNI_CFG_ACTIVE_MAXIMUM_CHANNEL_TIME_STADEF},
    {WNI_CFG_PASSIVE_MINIMUM_CHANNEL_TIME,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | SEM_9,
     WNI_CFG_PASSIVE_MINIMUM_CHANNEL_TIME_STAMIN,
     WNI_CFG_PASSIVE_MINIMUM_CHANNEL_TIME_STAMAX,
     WNI_CFG_PASSIVE_MINIMUM_CHANNEL_TIME_STADEF},
    {WNI_CFG_PASSIVE_MAXIMUM_CHANNEL_TIME,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | SEM_9,
     WNI_CFG_PASSIVE_MAXIMUM_CHANNEL_TIME_STAMIN,
     WNI_CFG_PASSIVE_MAXIMUM_CHANNEL_TIME_STAMAX,
     WNI_CFG_PASSIVE_MAXIMUM_CHANNEL_TIME_STADEF},
    {WNI_CFG_JOIN_FAILURE_TIMEOUT,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | SEM_7,
     WNI_CFG_JOIN_FAILURE_TIMEOUT_STAMIN,
     WNI_CFG_JOIN_FAILURE_TIMEOUT_STAMAX,
     WNI_CFG_JOIN_FAILURE_TIMEOUT_STADEF},
    {WNI_CFG_AUTHENTICATE_FAILURE_TIMEOUT,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | SEM_7,
     WNI_CFG_AUTHENTICATE_FAILURE_TIMEOUT_STAMIN,
     WNI_CFG_AUTHENTICATE_FAILURE_TIMEOUT_STAMAX,
     WNI_CFG_AUTHENTICATE_FAILURE_TIMEOUT_STADEF},
    {WNI_CFG_AUTHENTICATE_RSP_TIMEOUT,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | SEM_7,
     WNI_CFG_AUTHENTICATE_RSP_TIMEOUT_STAMIN,
     WNI_CFG_AUTHENTICATE_RSP_TIMEOUT_STAMAX,
     WNI_CFG_AUTHENTICATE_RSP_TIMEOUT_STADEF},
    {WNI_CFG_ASSOCIATION_FAILURE_TIMEOUT,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | CFG_CTL_NTF_LIM | SEM_8,
     WNI_CFG_ASSOCIATION_FAILURE_TIMEOUT_STAMIN,
     WNI_CFG_ASSOCIATION_FAILURE_TIMEOUT_STAMAX,
     WNI_CFG_ASSOCIATION_FAILURE_TIMEOUT_STADEF},
    {WNI_CFG_REASSOCIATION_FAILURE_TIMEOUT,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | SEM_7,
     WNI_CFG_REASSOCIATION_FAILURE_TIMEOUT_STAMIN,
     WNI_CFG_REASSOCIATION_FAILURE_TIMEOUT_STAMAX,
     WNI_CFG_REASSOCIATION_FAILURE_TIMEOUT_STADEF},
    {WNI_CFG_RA_PERIODICITY_TIMEOUT_IN_PS,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | CFG_CTL_NTF_HAL | SEM_7,
     WNI_CFG_RA_PERIODICITY_TIMEOUT_IN_PS_STAMIN,
     WNI_CFG_RA_PERIODICITY_TIMEOUT_IN_PS_STAMAX,
     WNI_CFG_RA_PERIODICITY_TIMEOUT_IN_PS_STADEF},
    {WNI_CFG_PS_ENABLE_BCN_FILTER,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | CFG_CTL_NTF_HAL | SEM_7,
     WNI_CFG_PS_ENABLE_BCN_FILTER_STAMIN,
     WNI_CFG_PS_ENABLE_BCN_FILTER_STAMAX,
     WNI_CFG_PS_ENABLE_BCN_FILTER_STADEF},
    {WNI_CFG_PS_ENABLE_HEART_BEAT,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | CFG_CTL_NTF_HAL | SEM_7,
     WNI_CFG_PS_ENABLE_HEART_BEAT_STAMIN,
     WNI_CFG_PS_ENABLE_HEART_BEAT_STAMAX,
     WNI_CFG_PS_ENABLE_HEART_BEAT_STADEF},
    {WNI_CFG_PS_ENABLE_RSSI_MONITOR,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | CFG_CTL_NTF_HAL | SEM_7,
     WNI_CFG_PS_ENABLE_RSSI_MONITOR_STAMIN,
     WNI_CFG_PS_ENABLE_RSSI_MONITOR_STAMAX,
     WNI_CFG_PS_ENABLE_RSSI_MONITOR_STADEF},
    {WNI_CFG_PS_DATA_INACTIVITY_TIMEOUT,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | CFG_CTL_NTF_HAL | SEM_7,
     WNI_CFG_PS_DATA_INACTIVITY_TIMEOUT_STAMIN,
     WNI_CFG_PS_DATA_INACTIVITY_TIMEOUT_STAMAX,
     WNI_CFG_PS_DATA_INACTIVITY_TIMEOUT_STADEF},
    {WNI_CFG_RF_SETTLING_TIME_CLK,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | CFG_CTL_NTF_HAL | SEM_7,
     WNI_CFG_RF_SETTLING_TIME_CLK_STAMIN,
     WNI_CFG_RF_SETTLING_TIME_CLK_STAMAX,
     WNI_CFG_RF_SETTLING_TIME_CLK_STADEF},
    {WNI_CFG_SUPPORTED_RATES_11B,
     CFG_CTL_VALID | CFG_CTL_RE |  SEM_2,
     0, 3, 1},
    {WNI_CFG_SUPPORTED_RATES_11A, CFG_CTL_VALID | CFG_CTL_RE |  SEM_7,
     0, 255, 15},
    {WNI_CFG_PHY_MODE,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | CFG_CTL_RESTART | SEM_9,
     WNI_CFG_PHY_MODE_STAMIN,
     WNI_CFG_PHY_MODE_STAMAX,
     WNI_CFG_PHY_MODE_STADEF},
    {WNI_CFG_DOT11_MODE,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | CFG_CTL_RESTART | CFG_CTL_NTF_LIM | SEM_9,
     WNI_CFG_DOT11_MODE_STAMIN,
     WNI_CFG_DOT11_MODE_STAMAX,
     WNI_CFG_DOT11_MODE_STADEF},
    {WNI_CFG_OPERATIONAL_RATE_SET,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_RESTART | SEM_2,
     0, 1, 1},
    {WNI_CFG_EXTENDED_OPERATIONAL_RATE_SET,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_RESTART | SEM_7,
     0, 65535, 65534},
    {WNI_CFG_PROPRIETARY_OPERATIONAL_RATE_SET,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_RESTART | SEM_7,
     0, 0, 0},
    {WNI_CFG_BSSID,
     CFG_CTL_VALID |  CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_RESTART | SEM_7,
     0,0,0},
    {WNI_CFG_LISTEN_INTERVAL,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | CFG_CTL_RESTART | SEM_7,
     WNI_CFG_LISTEN_INTERVAL_STAMIN,
     WNI_CFG_LISTEN_INTERVAL_STAMAX,
     WNI_CFG_LISTEN_INTERVAL_STADEF},
    {WNI_CFG_VALID_CHANNEL_LIST,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_RESTART | CFG_CTL_NTF_LIM | SEM_8,
     0, 1, 1},
    {WNI_CFG_CURRENT_CHANNEL,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_INT | SEM_9,
     WNI_CFG_CURRENT_CHANNEL_STAMIN,
     WNI_CFG_CURRENT_CHANNEL_STAMAX,
     WNI_CFG_CURRENT_CHANNEL_STADEF},
    {WNI_CFG_DEFAULT_RATE_INDEX_5GHZ,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | SEM_9,
     WNI_CFG_DEFAULT_RATE_INDEX_5GHZ_STAMIN,
     WNI_CFG_DEFAULT_RATE_INDEX_5GHZ_STAMAX,
     WNI_CFG_DEFAULT_RATE_INDEX_5GHZ_STADEF},
    {WNI_CFG_DEFAULT_RATE_INDEX_24GHZ,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | SEM_9,
     WNI_CFG_DEFAULT_RATE_INDEX_24GHZ_STAMIN,
     WNI_CFG_DEFAULT_RATE_INDEX_24GHZ_STAMAX,
     WNI_CFG_DEFAULT_RATE_INDEX_24GHZ_STADEF},
    {WNI_CFG_RATE_ADAPTATION_TYPE,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | CFG_CTL_NTF_SCH | SEM_0,
     WNI_CFG_RATE_ADAPTATION_TYPE_STAMIN,
     WNI_CFG_RATE_ADAPTATION_TYPE_STAMAX,
     WNI_CFG_RATE_ADAPTATION_TYPE_STADEF},
    {WNI_CFG_FIXED_RATE,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | CFG_CTL_NTF_HAL | SEM_0,
     WNI_CFG_FIXED_RATE_STAMIN,
     WNI_CFG_FIXED_RATE_STAMAX,
     WNI_CFG_FIXED_RATE_STADEF},
    {WNI_CFG_FIXED_RATE_MULTICAST_24GHZ,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | CFG_CTL_NTF_HAL | SEM_8,
     WNI_CFG_FIXED_RATE_MULTICAST_24GHZ_STAMIN,
     WNI_CFG_FIXED_RATE_MULTICAST_24GHZ_STAMAX,
     WNI_CFG_FIXED_RATE_MULTICAST_24GHZ_STADEF},
    {WNI_CFG_FIXED_RATE_MULTICAST_5GHZ,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | CFG_CTL_NTF_HAL | SEM_8,
     WNI_CFG_FIXED_RATE_MULTICAST_5GHZ_STAMIN,
     WNI_CFG_FIXED_RATE_MULTICAST_5GHZ_STAMAX,
     WNI_CFG_FIXED_RATE_MULTICAST_5GHZ_STADEF},
    {WNI_CFG_RETRYRATE_POLICY,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | CFG_CTL_NTF_HAL | SEM_0,
     WNI_CFG_RETRYRATE_POLICY_STAMIN,
     WNI_CFG_RETRYRATE_POLICY_STAMAX,
     WNI_CFG_RETRYRATE_POLICY_STADEF},
    {WNI_CFG_RETRYRATE_SECONDARY,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | CFG_CTL_NTF_HAL | SEM_0,
     WNI_CFG_RETRYRATE_SECONDARY_STAMIN,
     WNI_CFG_RETRYRATE_SECONDARY_STAMAX,
     WNI_CFG_RETRYRATE_SECONDARY_STADEF},
    {WNI_CFG_RETRYRATE_TERTIARY,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | CFG_CTL_NTF_HAL | SEM_0,
     WNI_CFG_RETRYRATE_TERTIARY_STAMIN,
     WNI_CFG_RETRYRATE_TERTIARY_STAMAX,
     WNI_CFG_RETRYRATE_TERTIARY_STADEF},
    {WNI_CFG_APSD_ENABLED,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | SEM_0,
     WNI_CFG_APSD_ENABLED_STAMIN,
     WNI_CFG_APSD_ENABLED_STAMAX,
     WNI_CFG_APSD_ENABLED_STADEF},
    {WNI_CFG_SHARED_KEY_AUTH_ENABLE,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | SEM_8,
     WNI_CFG_SHARED_KEY_AUTH_ENABLE_STAMIN,
     WNI_CFG_SHARED_KEY_AUTH_ENABLE_STAMAX,
     WNI_CFG_SHARED_KEY_AUTH_ENABLE_STADEF},
    {WNI_CFG_OPEN_SYSTEM_AUTH_ENABLE,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | SEM_8,
     WNI_CFG_OPEN_SYSTEM_AUTH_ENABLE_STAMIN,
     WNI_CFG_OPEN_SYSTEM_AUTH_ENABLE_STAMAX,
     WNI_CFG_OPEN_SYSTEM_AUTH_ENABLE_STADEF},
    {WNI_CFG_AUTHENTICATION_TYPE,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | CFG_CTL_RESTART | SEM_8,
     WNI_CFG_AUTHENTICATION_TYPE_STAMIN,
     WNI_CFG_AUTHENTICATION_TYPE_STAMAX,
     WNI_CFG_AUTHENTICATION_TYPE_STADEF},
    {WNI_CFG_CF_POLL_REQUEST,
     CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | CFG_CTL_RESTART | SEM_8,
     0, 255, 1},
    {WNI_CFG_PRIVACY_ENABLED,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | CFG_CTL_RESTART | SEM_8,
     WNI_CFG_PRIVACY_ENABLED_STAMIN,
     WNI_CFG_PRIVACY_ENABLED_STAMAX,
     WNI_CFG_PRIVACY_ENABLED_STADEF},
    {WNI_CFG_SHORT_PREAMBLE,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | CFG_CTL_RESTART | SEM_8,
     WNI_CFG_SHORT_PREAMBLE_STAMIN,
     WNI_CFG_SHORT_PREAMBLE_STAMAX,
     WNI_CFG_SHORT_PREAMBLE_STADEF},
    {WNI_CFG_SHORT_SLOT_TIME,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | SEM_8,
     WNI_CFG_SHORT_SLOT_TIME_STAMIN,
     WNI_CFG_SHORT_SLOT_TIME_STAMAX,
     WNI_CFG_SHORT_SLOT_TIME_STADEF},
    {WNI_CFG_ACCEPT_SHORT_SLOT_ASSOC_ONLY,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | CFG_CTL_RESTART | SEM_9,
     WNI_CFG_ACCEPT_SHORT_SLOT_ASSOC_ONLY_STAMIN,
     WNI_CFG_ACCEPT_SHORT_SLOT_ASSOC_ONLY_STAMAX,
     WNI_CFG_ACCEPT_SHORT_SLOT_ASSOC_ONLY_STADEF},
    {WNI_CFG_QOS_ENABLED,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | CFG_CTL_RESTART | SEM_8,
     WNI_CFG_QOS_ENABLED_STAMIN,
     WNI_CFG_QOS_ENABLED_STAMAX,
     WNI_CFG_QOS_ENABLED_STADEF},
    {WNI_CFG_HCF_ENABLED,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | CFG_CTL_RESTART | SEM_8,
     WNI_CFG_HCF_ENABLED_STAMIN,
     WNI_CFG_HCF_ENABLED_STAMAX,
     WNI_CFG_HCF_ENABLED_STADEF},
    {WNI_CFG_RSN_ENABLED,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | CFG_CTL_RESTART | SEM_8,
     WNI_CFG_RSN_ENABLED_STAMIN,
     WNI_CFG_RSN_ENABLED_STAMAX,
     WNI_CFG_RSN_ENABLED_STADEF},
    {WNI_CFG_BACKGROUND_SCAN_PERIOD,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | CFG_CTL_NTF_LIM | SEM_8,
     WNI_CFG_BACKGROUND_SCAN_PERIOD_STAMIN,
     WNI_CFG_BACKGROUND_SCAN_PERIOD_STAMAX,
     WNI_CFG_BACKGROUND_SCAN_PERIOD_STADEF},
    {WNI_CFG_MAX_NUM_PRE_AUTH,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | CFG_CTL_RESTART | SEM_8,
     WNI_CFG_MAX_NUM_PRE_AUTH_STAMIN,
     WNI_CFG_MAX_NUM_PRE_AUTH_STAMAX,
     WNI_CFG_MAX_NUM_PRE_AUTH_STADEF},
    {WNI_CFG_PREAUTH_CLNUP_TIMEOUT,
     CFG_CTL_INT | SEM_8,
     0, 255, 1},
    {WNI_CFG_RELEASE_AID_TIMEOUT,
     CFG_CTL_INT | SEM_8,
     0, 255, 1},
    {WNI_CFG_HEART_BEAT_THRESHOLD,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | CFG_CTL_NTF_LIM | SEM_8,
     WNI_CFG_HEART_BEAT_THRESHOLD_STAMIN,
     WNI_CFG_HEART_BEAT_THRESHOLD_STAMAX,
     WNI_CFG_HEART_BEAT_THRESHOLD_STADEF},
    {WNI_CFG_PROBE_AFTER_HB_FAIL_TIMEOUT,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | SEM_8,
     WNI_CFG_PROBE_AFTER_HB_FAIL_TIMEOUT_STAMIN,
     WNI_CFG_PROBE_AFTER_HB_FAIL_TIMEOUT_STAMAX,
     WNI_CFG_PROBE_AFTER_HB_FAIL_TIMEOUT_STADEF},
    {WNI_CFG_MANUFACTURER_OUI,
     CFG_CTL_VALID | CFG_CTL_RE | SEM_8,
     0, 0, 0},
    {WNI_CFG_MANUFACTURER_NAME,
     CFG_CTL_VALID | CFG_CTL_RE | SEM_8,
     0, 0, 0},
    {WNI_CFG_MODEL_NUMBER,
     CFG_CTL_VALID | CFG_CTL_RE | SEM_8,
     0, 0, 0},
    {WNI_CFG_MODEL_NAME,
     CFG_CTL_VALID | CFG_CTL_RE | SEM_8,
     0, 0, 0},
    {WNI_CFG_MANUFACTURER_PRODUCT_NAME,
     CFG_CTL_VALID | CFG_CTL_RE | SEM_8,
     0, 0, 0},
    {WNI_CFG_MANUFACTURER_PRODUCT_VERSION,
     CFG_CTL_VALID | CFG_CTL_RE | SEM_8,
     0, 0, 0},
    {WNI_CFG_11D_ENABLED,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | CFG_CTL_RESTART | SEM_9,
     WNI_CFG_11D_ENABLED_STAMIN,
     WNI_CFG_11D_ENABLED_STAMAX,
     WNI_CFG_11D_ENABLED_STADEF},
    {WNI_CFG_MAX_TX_POWER_2_4,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | SEM_8,
     0, 0, 0},
    {WNI_CFG_MAX_TX_POWER_5,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | SEM_8,
     0, 0, 0},
    {WNI_CFG_NETWORK_DENSITY,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | CFG_CTL_NTF_HAL | SEM_9,
     WNI_CFG_NETWORK_DENSITY_STAMIN,
     WNI_CFG_NETWORK_DENSITY_STAMAX,
     WNI_CFG_NETWORK_DENSITY_STADEF},
    {WNI_CFG_ADAPTIVE_THRESHOLD_ALGORITHM,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | CFG_CTL_NTF_HAL | SEM_9,
     WNI_CFG_ADAPTIVE_THRESHOLD_ALGORITHM_STAMIN,
     WNI_CFG_ADAPTIVE_THRESHOLD_ALGORITHM_STAMAX,
     WNI_CFG_ADAPTIVE_THRESHOLD_ALGORITHM_STADEF},
    {WNI_CFG_CURRENT_TX_ANTENNA,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | CFG_CTL_NTF_HAL | SEM_9,
     WNI_CFG_CURRENT_TX_ANTENNA_STAMIN,
     WNI_CFG_CURRENT_TX_ANTENNA_STAMAX,
     WNI_CFG_CURRENT_TX_ANTENNA_STADEF},
    {WNI_CFG_CURRENT_RX_ANTENNA,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | CFG_CTL_NTF_HAL | SEM_9,
     WNI_CFG_CURRENT_RX_ANTENNA_STAMIN,
     WNI_CFG_CURRENT_RX_ANTENNA_STAMAX,
     WNI_CFG_CURRENT_RX_ANTENNA_STADEF},
    {WNI_CFG_CURRENT_TX_POWER_LEVEL,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_INT | SEM_9,
     WNI_CFG_CURRENT_TX_POWER_LEVEL_STAMIN,
     WNI_CFG_CURRENT_TX_POWER_LEVEL_STAMAX,
     WNI_CFG_CURRENT_TX_POWER_LEVEL_STADEF},
    {WNI_CFG_POWER_STATE_PER_CHAIN,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | CFG_CTL_NTF_HAL | SEM_9,
     WNI_CFG_POWER_STATE_PER_CHAIN_STAMIN,
     WNI_CFG_POWER_STATE_PER_CHAIN_STAMAX,
     WNI_CFG_POWER_STATE_PER_CHAIN_STADEF},
    {WNI_CFG_NEW_BSS_FOUND_IND,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | SEM_9,
     WNI_CFG_NEW_BSS_FOUND_IND_STAMIN,
     WNI_CFG_NEW_BSS_FOUND_IND_STAMAX,
     WNI_CFG_NEW_BSS_FOUND_IND_STADEF},
    {WNI_CFG_PROPRIETARY_ANI_FEATURES_ENABLED,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | CFG_CTL_RESTART | SEM_12,
     WNI_CFG_PROPRIETARY_ANI_FEATURES_ENABLED_STAMIN,
     WNI_CFG_PROPRIETARY_ANI_FEATURES_ENABLED_STAMAX,
     WNI_CFG_PROPRIETARY_ANI_FEATURES_ENABLED_STADEF},
    {WNI_CFG_PROPRIETARY_RATES_ENABLED,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | CFG_CTL_RESTART | SEM_12,
     WNI_CFG_PROPRIETARY_RATES_ENABLED_STAMIN,
     WNI_CFG_PROPRIETARY_RATES_ENABLED_STAMAX,
     WNI_CFG_PROPRIETARY_RATES_ENABLED_STADEF},
    {WNI_CFG_AP_NODE_NAME,
     CFG_CTL_RE | SEM_8,
     0, 255, 1},
    {WNI_CFG_COUNTRY_CODE,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | SEM_8,
     0, 0, 0},
    {WNI_CFG_11H_ENABLED,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | CFG_CTL_RESTART | SEM_12,
     WNI_CFG_11H_ENABLED_STAMIN,
     WNI_CFG_11H_ENABLED_STAMAX,
     WNI_CFG_11H_ENABLED_STADEF},
    {WNI_CFG_WT_CNF_TIMEOUT,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | SEM_12,
     WNI_CFG_WT_CNF_TIMEOUT_STAMIN,
     WNI_CFG_WT_CNF_TIMEOUT_STAMAX,
     WNI_CFG_WT_CNF_TIMEOUT_STADEF},
    {WNI_CFG_KEEPALIVE_TIMEOUT,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | SEM_12,
     WNI_CFG_KEEPALIVE_TIMEOUT_STAMIN,
     WNI_CFG_KEEPALIVE_TIMEOUT_STAMAX,
     WNI_CFG_KEEPALIVE_TIMEOUT_STADEF},
    {WNI_CFG_PROXIMITY,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | CFG_CTL_NTF_HAL | SEM_12,
     WNI_CFG_PROXIMITY_STAMIN,
     WNI_CFG_PROXIMITY_STAMAX,
     WNI_CFG_PROXIMITY_STADEF},
    {WNI_CFG_LOG_LEVEL,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | SEM_12,
     WNI_CFG_LOG_LEVEL_STAMIN,
     WNI_CFG_LOG_LEVEL_STAMAX,
     WNI_CFG_LOG_LEVEL_STADEF},
    {WNI_CFG_OLBC_DETECT_TIMEOUT,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | SEM_12,
     WNI_CFG_OLBC_DETECT_TIMEOUT_STAMIN,
     WNI_CFG_OLBC_DETECT_TIMEOUT_STAMAX,
     WNI_CFG_OLBC_DETECT_TIMEOUT_STADEF},
    {WNI_CFG_PROTECTION_ENABLED,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | CFG_CTL_RESTART | CFG_CTL_NTF_LIM | SEM_9,
     WNI_CFG_PROTECTION_ENABLED_STAMIN,
     WNI_CFG_PROTECTION_ENABLED_STAMAX,
     WNI_CFG_PROTECTION_ENABLED_STADEF},
    {WNI_CFG_11G_PROTECTION_ALWAYS,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | CFG_CTL_RESTART | SEM_9,
     WNI_CFG_11G_PROTECTION_ALWAYS_STAMIN,
     WNI_CFG_11G_PROTECTION_ALWAYS_STAMAX,
     WNI_CFG_11G_PROTECTION_ALWAYS_STADEF},
    {WNI_CFG_FORCE_POLICY_PROTECTION,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | CFG_CTL_RESTART | CFG_CTL_NTF_HAL | SEM_9,
     WNI_CFG_FORCE_POLICY_PROTECTION_STAMIN,
     WNI_CFG_FORCE_POLICY_PROTECTION_STAMAX,
     WNI_CFG_FORCE_POLICY_PROTECTION_STADEF},
    {WNI_CFG_11G_SHORT_PREAMBLE_ENABLED,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | CFG_CTL_RESTART | SEM_9,
     WNI_CFG_11G_SHORT_PREAMBLE_ENABLED_STAMIN,
     WNI_CFG_11G_SHORT_PREAMBLE_ENABLED_STAMAX,
     WNI_CFG_11G_SHORT_PREAMBLE_ENABLED_STADEF},
    {WNI_CFG_11G_SHORT_SLOT_TIME_ENABLED,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | CFG_CTL_RESTART | SEM_9,
     WNI_CFG_11G_SHORT_SLOT_TIME_ENABLED_STAMIN,
     WNI_CFG_11G_SHORT_SLOT_TIME_ENABLED_STAMAX,
     WNI_CFG_11G_SHORT_SLOT_TIME_ENABLED_STADEF},
    {WNI_CFG_CAL_PERIOD,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | CFG_CTL_NTF_HAL | SEM_12,
     WNI_CFG_CAL_PERIOD_STAMIN,
     WNI_CFG_CAL_PERIOD_STAMAX,
     WNI_CFG_CAL_PERIOD_STADEF},
    {WNI_CFG_STATS_PERIOD,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | CFG_CTL_NTF_HAL | SEM_12,
     WNI_CFG_STATS_PERIOD_STAMIN,
     WNI_CFG_STATS_PERIOD_STAMAX,
     WNI_CFG_STATS_PERIOD_STADEF},
    {WNI_CFG_CAL_CONTROL,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | CFG_CTL_NTF_HAL | SEM_12,
     WNI_CFG_CAL_CONTROL_STAMIN,
     WNI_CFG_CAL_CONTROL_STAMAX,
     WNI_CFG_CAL_CONTROL_STADEF},
    {WNI_CFG_11G_ONLY_POLICY,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | SEM_12,
     WNI_CFG_11G_ONLY_POLICY_STAMIN,
     WNI_CFG_11G_ONLY_POLICY_STAMAX,
     WNI_CFG_11G_ONLY_POLICY_STADEF},
    {WNI_CFG_PACKET_CLASSIFICATION,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | CFG_CTL_NTF_HAL | SEM_12,
     WNI_CFG_PACKET_CLASSIFICATION_STAMIN,
     WNI_CFG_PACKET_CLASSIFICATION_STAMAX,
     WNI_CFG_PACKET_CLASSIFICATION_STADEF},
    {WNI_CFG_WME_ENABLED,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | CFG_CTL_RESTART | SEM_8,
     WNI_CFG_WME_ENABLED_STAMIN,
     WNI_CFG_WME_ENABLED_STAMAX,
     WNI_CFG_WME_ENABLED_STADEF},
    {WNI_CFG_ADDTS_RSP_TIMEOUT,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | SEM_8,
     WNI_CFG_ADDTS_RSP_TIMEOUT_STAMIN,
     WNI_CFG_ADDTS_RSP_TIMEOUT_STAMAX,
     WNI_CFG_ADDTS_RSP_TIMEOUT_STADEF},
    {WNI_CFG_MAX_SP_LENGTH,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | SEM_8,
     WNI_CFG_MAX_SP_LENGTH_STAMIN,
     WNI_CFG_MAX_SP_LENGTH_STAMAX,
     WNI_CFG_MAX_SP_LENGTH_STADEF},
    {WNI_CFG_KEEP_ALIVE_STA_LIMIT_THRESHOLD,
     CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | SEM_8,
     0, 255, 1},
    {WNI_CFG_SEND_SINGLE_SSID_ALWAYS,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | SEM_12,
     WNI_CFG_SEND_SINGLE_SSID_ALWAYS_STAMIN,
     WNI_CFG_SEND_SINGLE_SSID_ALWAYS_STAMAX,
     WNI_CFG_SEND_SINGLE_SSID_ALWAYS_STADEF},
    {WNI_CFG_WSM_ENABLED,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | SEM_8,
     WNI_CFG_WSM_ENABLED_STAMIN,
     WNI_CFG_WSM_ENABLED_STAMAX,
     WNI_CFG_WSM_ENABLED_STADEF},
    {WNI_CFG_PROP_CAPABILITY,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | SEM_8,
     WNI_CFG_PROP_CAPABILITY_STAMIN,
     WNI_CFG_PROP_CAPABILITY_STAMAX,
     WNI_CFG_PROP_CAPABILITY_STADEF},
    {WNI_CFG_EDCA_PROFILE,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | CFG_CTL_NTF_SCH | SEM_8,
     WNI_CFG_EDCA_PROFILE_STAMIN,
     WNI_CFG_EDCA_PROFILE_STAMAX,
     WNI_CFG_EDCA_PROFILE_STADEF},
    {WNI_CFG_EDCA_ANI_ACBK_LOCAL,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_RESTART | SEM_8,
     0, 0, 0},
    {WNI_CFG_EDCA_ANI_ACBE_LOCAL,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_RESTART | SEM_8,
     0, 0, 0},
    {WNI_CFG_EDCA_ANI_ACVI_LOCAL,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_RESTART | SEM_8,
     0, 0, 0},
    {WNI_CFG_EDCA_ANI_ACVO_LOCAL,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_RESTART | SEM_8,
     0, 0, 0},
    {WNI_CFG_EDCA_ANI_ACBK,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_RESTART | SEM_8,
     0, 0, 0},
    {WNI_CFG_EDCA_ANI_ACBE,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_RESTART | SEM_8,
     0, 0, 0},
    {WNI_CFG_EDCA_ANI_ACVI,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_RESTART | SEM_8,
     0, 0, 0},
    {WNI_CFG_EDCA_ANI_ACVO,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_RESTART | SEM_8,
     0, 0, 0},
    {WNI_CFG_EDCA_WME_ACBK_LOCAL,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_RESTART | SEM_8,
     0, 0, 0},
    {WNI_CFG_EDCA_WME_ACBE_LOCAL,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_RESTART | SEM_8,
     0, 0, 0},
    {WNI_CFG_EDCA_WME_ACVI_LOCAL,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_RESTART | SEM_8,
     0, 0, 0},
    {WNI_CFG_EDCA_WME_ACVO_LOCAL,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_RESTART | SEM_8,
     0, 0, 0},
    {WNI_CFG_EDCA_WME_ACBK,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_RESTART | SEM_8,
     0, 0, 0},
    {WNI_CFG_EDCA_WME_ACBE,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_RESTART | SEM_8,
     0, 0, 0},
    {WNI_CFG_EDCA_WME_ACVI,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_RESTART | SEM_8,
     0, 0, 0},
    {WNI_CFG_EDCA_WME_ACVO,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_RESTART | SEM_8,
     0, 0, 0},
    {WNI_CFG_EDCA_TIT_DEMO_ACBK_LOCAL,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_RESTART | SEM_8,
     0, 0, 0},
    {WNI_CFG_EDCA_TIT_DEMO_ACBE_LOCAL,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_RESTART | SEM_8,
     0, 0, 0},
    {WNI_CFG_EDCA_TIT_DEMO_ACVI_LOCAL,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_RESTART | SEM_8,
     0, 0, 0},
    {WNI_CFG_EDCA_TIT_DEMO_ACVO_LOCAL,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_RESTART | SEM_8,
     0, 0, 0},
    {WNI_CFG_EDCA_TIT_DEMO_ACBK,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_RESTART | SEM_8,
     0, 0, 0},
    {WNI_CFG_EDCA_TIT_DEMO_ACBE,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_RESTART | SEM_8,
     0, 0, 0},
    {WNI_CFG_EDCA_TIT_DEMO_ACVI,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_RESTART | SEM_8,
     0, 0, 0},
    {WNI_CFG_EDCA_TIT_DEMO_ACVO,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_RESTART | SEM_8,
     0, 0, 0},
    {WNI_CFG_RDET_FLAG,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | SEM_9,
     WNI_CFG_RDET_FLAG_STAMIN,
     WNI_CFG_RDET_FLAG_STAMAX,
     WNI_CFG_RDET_FLAG_STADEF},
    {WNI_CFG_RADAR_CHANNEL_LIST,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_RESTART | SEM_8,
     0, 0, 0},
    {WNI_CFG_LOCAL_POWER_CONSTRAINT,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | CFG_CTL_RESTART | SEM_12,
     WNI_CFG_LOCAL_POWER_CONSTRAINT_STAMIN,
     WNI_CFG_LOCAL_POWER_CONSTRAINT_STAMAX,
     WNI_CFG_LOCAL_POWER_CONSTRAINT_STADEF},
    {WNI_CFG_ADMIT_POLICY,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | CFG_CTL_RESTART | SEM_8,
     WNI_CFG_ADMIT_POLICY_STAMIN,
     WNI_CFG_ADMIT_POLICY_STAMAX,
     WNI_CFG_ADMIT_POLICY_STADEF},
    {WNI_CFG_ADMIT_BWFACTOR,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | CFG_CTL_RESTART | SEM_8,
     WNI_CFG_ADMIT_BWFACTOR_STAMIN,
     WNI_CFG_ADMIT_BWFACTOR_STAMAX,
     WNI_CFG_ADMIT_BWFACTOR_STADEF},
    {WNI_CFG_MAX_CONSECUTIVE_BACKGROUND_SCAN_FAILURE,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | CFG_CTL_RESTART | SEM_8,
     WNI_CFG_MAX_CONSECUTIVE_BACKGROUND_SCAN_FAILURE_STAMIN,
     WNI_CFG_MAX_CONSECUTIVE_BACKGROUND_SCAN_FAILURE_STAMAX,
     WNI_CFG_MAX_CONSECUTIVE_BACKGROUND_SCAN_FAILURE_STADEF},
    {WNI_CFG_CHANNEL_BONDING_MODE,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | CFG_CTL_RESTART | CFG_CTL_NTF_LIM | SEM_12,
     WNI_CFG_CHANNEL_BONDING_MODE_STAMIN,
     WNI_CFG_CHANNEL_BONDING_MODE_STAMAX,
     WNI_CFG_CHANNEL_BONDING_MODE_STADEF},
    {WNI_CFG_CB_SECONDARY_CHANNEL_STATE,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | SEM_12,
     WNI_CFG_CB_SECONDARY_CHANNEL_STATE_STAMIN,
     WNI_CFG_CB_SECONDARY_CHANNEL_STATE_STAMAX,
     WNI_CFG_CB_SECONDARY_CHANNEL_STATE_STADEF},
    {WNI_CFG_DYNAMIC_THRESHOLD_ZERO,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | CFG_CTL_NTF_HAL | SEM_12,
     WNI_CFG_DYNAMIC_THRESHOLD_ZERO_STAMIN,
     WNI_CFG_DYNAMIC_THRESHOLD_ZERO_STAMAX,
     WNI_CFG_DYNAMIC_THRESHOLD_ZERO_STADEF},
    {WNI_CFG_DYNAMIC_THRESHOLD_ONE,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | CFG_CTL_NTF_HAL | SEM_12,
     WNI_CFG_DYNAMIC_THRESHOLD_ONE_STAMIN,
     WNI_CFG_DYNAMIC_THRESHOLD_ONE_STAMAX,
     WNI_CFG_DYNAMIC_THRESHOLD_ONE_STADEF},
    {WNI_CFG_DYNAMIC_THRESHOLD_TWO,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | CFG_CTL_NTF_HAL | SEM_12,
     WNI_CFG_DYNAMIC_THRESHOLD_TWO_STAMIN,
     WNI_CFG_DYNAMIC_THRESHOLD_TWO_STAMAX,
     WNI_CFG_DYNAMIC_THRESHOLD_TWO_STADEF},
    {WNI_CFG_TRIG_STA_BK_SCAN,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | CFG_CTL_NTF_LIM | SEM_12,
     WNI_CFG_TRIG_STA_BK_SCAN_STAMIN,
     WNI_CFG_TRIG_STA_BK_SCAN_STAMAX,
     WNI_CFG_TRIG_STA_BK_SCAN_STADEF},
    {WNI_CFG_DYNAMIC_PROFILE_SWITCHING,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | CFG_CTL_RESTART | SEM_8,
     WNI_CFG_DYNAMIC_PROFILE_SWITCHING_STAMIN,
     WNI_CFG_DYNAMIC_PROFILE_SWITCHING_STAMAX,
     WNI_CFG_DYNAMIC_PROFILE_SWITCHING_STADEF},
    {WNI_CFG_SCAN_CONTROL_LIST,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_RESTART | CFG_CTL_NTF_LIM | SEM_8,
     0, 0, 0},
    {WNI_CFG_MIMO_ENABLED,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | CFG_CTL_RELOAD | SEM_9,
     WNI_CFG_MIMO_ENABLED_STAMIN,
     WNI_CFG_MIMO_ENABLED_STAMAX,
     WNI_CFG_MIMO_ENABLED_STADEF},
    {WNI_CFG_BLOCK_ACK_ENABLED,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | CFG_CTL_RESTART | CFG_CTL_NTF_LIM | SEM_8,
     WNI_CFG_BLOCK_ACK_ENABLED_STAMIN,
     WNI_CFG_BLOCK_ACK_ENABLED_STAMAX,
     WNI_CFG_BLOCK_ACK_ENABLED_STADEF},
    {WNI_CFG_BA_ACTIVITY_CHECK_TIMEOUT,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | CFG_CTL_NTF_HAL | SEM_7,
     WNI_CFG_BA_ACTIVITY_CHECK_TIMEOUT_STAMIN,
     WNI_CFG_BA_ACTIVITY_CHECK_TIMEOUT_STAMAX,
     WNI_CFG_BA_ACTIVITY_CHECK_TIMEOUT_STADEF},
    {WNI_CFG_HT_RX_STBC,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | CFG_CTL_RESTART | CFG_CTL_NTF_LIM | SEM_7,
     WNI_CFG_HT_RX_STBC_STAMIN,
     WNI_CFG_HT_RX_STBC_STAMAX,
     WNI_CFG_HT_RX_STBC_STADEF},
    {WNI_CFG_HT_CAP_INFO,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | CFG_CTL_RESTART | CFG_CTL_NTF_LIM | SEM_10,
     WNI_CFG_HT_CAP_INFO_STAMIN,
     WNI_CFG_HT_CAP_INFO_STAMAX,
     WNI_CFG_HT_CAP_INFO_STADEF},
    {WNI_CFG_HT_AMPDU_PARAMS,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | CFG_CTL_RESTART | CFG_CTL_NTF_LIM | SEM_7,
     WNI_CFG_HT_AMPDU_PARAMS_STAMIN,
     WNI_CFG_HT_AMPDU_PARAMS_STAMAX,
     WNI_CFG_HT_AMPDU_PARAMS_STADEF},
    {WNI_CFG_SUPPORTED_MCS_SET,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_SAVE | CFG_CTL_RESTART | CFG_CTL_NTF_LIM | SEM_7,
     0, 0, 0},
    {WNI_CFG_EXT_HT_CAP_INFO,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | CFG_CTL_SAVE | CFG_CTL_RESTART | CFG_CTL_NTF_LIM | SEM_10,
     WNI_CFG_EXT_HT_CAP_INFO_STAMIN,
     WNI_CFG_EXT_HT_CAP_INFO_STAMAX,
     WNI_CFG_EXT_HT_CAP_INFO_STADEF},
    {WNI_CFG_TX_BF_CAP,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_INT | CFG_CTL_RESTART | CFG_CTL_NTF_LIM | SEM_7,
     WNI_CFG_TX_BF_CAP_STAMIN,
     4294967295u,
     WNI_CFG_TX_BF_CAP_STADEF},
    {WNI_CFG_AS_CAP,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | CFG_CTL_SAVE | CFG_CTL_RESTART | CFG_CTL_NTF_LIM | SEM_7,
     WNI_CFG_AS_CAP_STAMIN,
     WNI_CFG_AS_CAP_STAMAX,
     WNI_CFG_AS_CAP_STADEF},
    {WNI_CFG_HT_INFO_FIELD1,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | CFG_CTL_RESTART | CFG_CTL_NTF_LIM | SEM_10,
     WNI_CFG_HT_INFO_FIELD1_STAMIN,
     WNI_CFG_HT_INFO_FIELD1_STAMAX,
     WNI_CFG_HT_INFO_FIELD1_STADEF},
    {WNI_CFG_HT_INFO_FIELD2,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | CFG_CTL_SAVE | CFG_CTL_NTF_LIM | SEM_10,
     WNI_CFG_HT_INFO_FIELD2_STAMIN,
     WNI_CFG_HT_INFO_FIELD2_STAMAX,
     WNI_CFG_HT_INFO_FIELD2_STADEF},
    {WNI_CFG_HT_INFO_FIELD3,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | CFG_CTL_SAVE | CFG_CTL_NTF_LIM | SEM_10,
     WNI_CFG_HT_INFO_FIELD3_STAMIN,
     WNI_CFG_HT_INFO_FIELD3_STAMAX,
     WNI_CFG_HT_INFO_FIELD3_STADEF},
    {WNI_CFG_BASIC_MCS_SET,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_SAVE | CFG_CTL_RESTART | CFG_CTL_NTF_LIM | SEM_7,
     0, 0, 0},
    {WNI_CFG_CURRENT_MCS_SET,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_SAVE | CFG_CTL_RESTART | CFG_CTL_NTF_LIM | SEM_7,
     0, 0, 0},
    {WNI_CFG_GREENFIELD_CAPABILITY,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | CFG_CTL_RESTART | CFG_CTL_NTF_LIM | SEM_7,
     WNI_CFG_GREENFIELD_CAPABILITY_STAMIN,
     WNI_CFG_GREENFIELD_CAPABILITY_STAMAX,
     WNI_CFG_GREENFIELD_CAPABILITY_STADEF},
    {WNI_CFG_VHT_MAX_MPDU_LENGTH,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | CFG_CTL_NTF_LIM | SEM_3,
     WNI_CFG_VHT_MAX_MPDU_LENGTH_STAMIN,
     WNI_CFG_VHT_MAX_MPDU_LENGTH_STAMAX,
     WNI_CFG_VHT_MAX_MPDU_LENGTH_STADEF},
    {WNI_CFG_VHT_SUPPORTED_CHAN_WIDTH_SET,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | CFG_CTL_NTF_LIM | SEM_3,
     WNI_CFG_VHT_SUPPORTED_CHAN_WIDTH_SET_STAMIN,
     WNI_CFG_VHT_SUPPORTED_CHAN_WIDTH_SET_STAMAX,
     WNI_CFG_VHT_SUPPORTED_CHAN_WIDTH_SET_STADEF},
    {WNI_CFG_VHT_LDPC_CODING_CAP,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | CFG_CTL_NTF_LIM | SEM_3,
     WNI_CFG_VHT_LDPC_CODING_CAP_STAMIN,
     WNI_CFG_VHT_LDPC_CODING_CAP_STAMAX,
     WNI_CFG_VHT_LDPC_CODING_CAP_STADEF},
    {WNI_CFG_VHT_SHORT_GI_80MHZ,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | CFG_CTL_NTF_LIM | SEM_3,
     WNI_CFG_VHT_SHORT_GI_80MHZ_STAMIN,
     WNI_CFG_VHT_SHORT_GI_80MHZ_STAMAX,
     WNI_CFG_VHT_SHORT_GI_80MHZ_STADEF},
    {WNI_CFG_VHT_SHORT_GI_160_AND_80_PLUS_80MHZ,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | CFG_CTL_NTF_LIM | SEM_3,
     WNI_CFG_VHT_SHORT_GI_160_AND_80_PLUS_80MHZ_STAMIN,
     WNI_CFG_VHT_SHORT_GI_160_AND_80_PLUS_80MHZ_STAMAX,
     WNI_CFG_VHT_SHORT_GI_160_AND_80_PLUS_80MHZ_STADEF},
    {WNI_CFG_VHT_TXSTBC,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | CFG_CTL_NTF_LIM | SEM_3,
     WNI_CFG_VHT_TXSTBC_STAMIN,
     WNI_CFG_VHT_TXSTBC_STAMAX,
     WNI_CFG_VHT_TXSTBC_STADEF},
    {WNI_CFG_VHT_RXSTBC,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | CFG_CTL_NTF_LIM | SEM_3,
     WNI_CFG_VHT_RXSTBC_STAMIN,
     WNI_CFG_VHT_RXSTBC_STAMAX,
     WNI_CFG_VHT_RXSTBC_STADEF},
    {WNI_CFG_VHT_SU_BEAMFORMER_CAP,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | CFG_CTL_NTF_LIM | SEM_3,
     WNI_CFG_VHT_SU_BEAMFORMER_CAP_STAMIN,
     WNI_CFG_VHT_SU_BEAMFORMER_CAP_STAMAX,
     WNI_CFG_VHT_SU_BEAMFORMER_CAP_STADEF},
    {WNI_CFG_VHT_SU_BEAMFORMEE_CAP,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | CFG_CTL_NTF_LIM | SEM_3,
     WNI_CFG_VHT_SU_BEAMFORMEE_CAP_STAMIN,
     WNI_CFG_VHT_SU_BEAMFORMEE_CAP_STAMAX,
     WNI_CFG_VHT_SU_BEAMFORMEE_CAP_STADEF},
    {WNI_CFG_VHT_CSN_BEAMFORMEE_ANT_SUPPORTED,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | CFG_CTL_NTF_LIM | SEM_3,
     WNI_CFG_VHT_CSN_BEAMFORMEE_ANT_SUPPORTED_STAMIN,
     WNI_CFG_VHT_CSN_BEAMFORMEE_ANT_SUPPORTED_STAMAX,
     WNI_CFG_VHT_CSN_BEAMFORMEE_ANT_SUPPORTED_STADEF},
    {WNI_CFG_VHT_NUM_SOUNDING_DIMENSIONS,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | CFG_CTL_NTF_LIM | SEM_3,
     WNI_CFG_VHT_NUM_SOUNDING_DIMENSIONS_STAMIN,
     WNI_CFG_VHT_NUM_SOUNDING_DIMENSIONS_STAMAX,
     WNI_CFG_VHT_NUM_SOUNDING_DIMENSIONS_STADEF},
    {WNI_CFG_VHT_MU_BEAMFORMER_CAP,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | CFG_CTL_NTF_LIM | SEM_3,
     WNI_CFG_VHT_MU_BEAMFORMER_CAP_STAMIN,
     WNI_CFG_VHT_MU_BEAMFORMER_CAP_STAMAX,
     WNI_CFG_VHT_MU_BEAMFORMER_CAP_STADEF},
    {WNI_CFG_VHT_MU_BEAMFORMEE_CAP,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | CFG_CTL_NTF_LIM | SEM_3,
     WNI_CFG_VHT_MU_BEAMFORMEE_CAP_STAMIN,
     WNI_CFG_VHT_MU_BEAMFORMEE_CAP_STAMAX,
     WNI_CFG_VHT_MU_BEAMFORMEE_CAP_STADEF},
    {WNI_CFG_VHT_TXOP_PS,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | CFG_CTL_NTF_LIM | SEM_3,
     WNI_CFG_VHT_TXOP_PS_STAMIN,
     WNI_CFG_VHT_TXOP_PS_STAMAX,
     WNI_CFG_VHT_TXOP_PS_STADEF},
    {WNI_CFG_VHT_HTC_VHTC_CAP,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | CFG_CTL_NTF_LIM | SEM_3,
     WNI_CFG_VHT_HTC_VHTC_CAP_STAMIN,
     WNI_CFG_VHT_HTC_VHTC_CAP_STAMAX,
     WNI_CFG_VHT_HTC_VHTC_CAP_STADEF},
    {WNI_CFG_VHT_AMPDU_LEN_EXPONENT,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | CFG_CTL_NTF_LIM | SEM_3,
     WNI_CFG_VHT_AMPDU_LEN_EXPONENT_STAMIN,
     WNI_CFG_VHT_AMPDU_LEN_EXPONENT_STAMAX,
     WNI_CFG_VHT_AMPDU_LEN_EXPONENT_STADEF},
    {WNI_CFG_VHT_LINK_ADAPTATION_CAP,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | CFG_CTL_NTF_LIM | SEM_3,
     WNI_CFG_VHT_LINK_ADAPTATION_CAP_STAMIN,
     WNI_CFG_VHT_LINK_ADAPTATION_CAP_STAMAX,
     WNI_CFG_VHT_LINK_ADAPTATION_CAP_STADEF},
    {WNI_CFG_VHT_RX_ANT_PATTERN,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | CFG_CTL_NTF_LIM | SEM_3,
     WNI_CFG_VHT_RX_ANT_PATTERN_STAMIN,
     WNI_CFG_VHT_RX_ANT_PATTERN_STAMAX,
     WNI_CFG_VHT_RX_ANT_PATTERN_STADEF},
    {WNI_CFG_VHT_TX_ANT_PATTERN,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | CFG_CTL_NTF_LIM | SEM_3,
     WNI_CFG_VHT_TX_ANT_PATTERN_STAMIN,
     WNI_CFG_VHT_TX_ANT_PATTERN_STAMAX,
     WNI_CFG_VHT_TX_ANT_PATTERN_STADEF},
    {WNI_CFG_VHT_RX_MCS_MAP,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | CFG_CTL_NTF_LIM | SEM_3,
     WNI_CFG_VHT_RX_MCS_MAP_STAMIN,
     WNI_CFG_VHT_RX_MCS_MAP_STAMAX,
     WNI_CFG_VHT_RX_MCS_MAP_STADEF},
    {WNI_CFG_VHT_TX_MCS_MAP,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | CFG_CTL_NTF_LIM | SEM_3,
     WNI_CFG_VHT_TX_MCS_MAP_STAMIN,
     WNI_CFG_VHT_TX_MCS_MAP_STAMAX,
     WNI_CFG_VHT_TX_MCS_MAP_STADEF},
    {WNI_CFG_VHT_RX_HIGHEST_SUPPORTED_DATA_RATE,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | CFG_CTL_NTF_LIM | SEM_3,
     WNI_CFG_VHT_RX_HIGHEST_SUPPORTED_DATA_RATE_STAMIN,
     WNI_CFG_VHT_RX_HIGHEST_SUPPORTED_DATA_RATE_STAMAX,
     WNI_CFG_VHT_RX_HIGHEST_SUPPORTED_DATA_RATE_STADEF},
    {WNI_CFG_VHT_TX_HIGHEST_SUPPORTED_DATA_RATE,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | CFG_CTL_NTF_LIM | SEM_3,
     WNI_CFG_VHT_TX_HIGHEST_SUPPORTED_DATA_RATE_STAMIN,
     WNI_CFG_VHT_TX_HIGHEST_SUPPORTED_DATA_RATE_STAMAX,
     WNI_CFG_VHT_TX_HIGHEST_SUPPORTED_DATA_RATE_STADEF},
    {WNI_CFG_VHT_CHANNEL_WIDTH,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | CFG_CTL_NTF_LIM | SEM_3,
     WNI_CFG_VHT_CHANNEL_WIDTH_STAMIN,
     WNI_CFG_VHT_CHANNEL_WIDTH_STAMAX,
     WNI_CFG_VHT_CHANNEL_WIDTH_STADEF},
    {WNI_CFG_VHT_CHANNEL_CENTER_FREQ_SEGMENT1,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | CFG_CTL_NTF_LIM | SEM_3,
     WNI_CFG_VHT_CHANNEL_CENTER_FREQ_SEGMENT1_STAMIN,
     WNI_CFG_VHT_CHANNEL_CENTER_FREQ_SEGMENT1_STAMAX,
     WNI_CFG_VHT_CHANNEL_CENTER_FREQ_SEGMENT1_STADEF},
    {WNI_CFG_VHT_CHANNEL_CENTER_FREQ_SEGMENT2,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | CFG_CTL_NTF_LIM | SEM_3,
     WNI_CFG_VHT_CHANNEL_CENTER_FREQ_SEGMENT2_STAMIN,
     WNI_CFG_VHT_CHANNEL_CENTER_FREQ_SEGMENT2_STAMAX,
     WNI_CFG_VHT_CHANNEL_CENTER_FREQ_SEGMENT2_STADEF},
    {WNI_CFG_VHT_BASIC_MCS_SET,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | CFG_CTL_NTF_LIM | SEM_3,
     WNI_CFG_VHT_BASIC_MCS_SET_STAMIN,
     WNI_CFG_VHT_BASIC_MCS_SET_STAMAX,
     WNI_CFG_VHT_BASIC_MCS_SET_STADEF},
    {WNI_CFG_VHT_MU_MIMO_CAP_STA_COUNT,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | CFG_CTL_NTF_LIM | SEM_3,
     WNI_CFG_VHT_MU_MIMO_CAP_STA_COUNT_STAMIN,
     WNI_CFG_VHT_MU_MIMO_CAP_STA_COUNT_STAMAX,
     WNI_CFG_VHT_MU_MIMO_CAP_STA_COUNT_STADEF},
    {WNI_CFG_VHT_SS_UNDER_UTIL,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | CFG_CTL_NTF_LIM | SEM_3,
     WNI_CFG_VHT_SS_UNDER_UTIL_STAMIN,
     WNI_CFG_VHT_SS_UNDER_UTIL_STAMAX,
     WNI_CFG_VHT_SS_UNDER_UTIL_STADEF},
    {WNI_CFG_VHT_40MHZ_UTILIZATION,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | CFG_CTL_NTF_LIM | SEM_3,
     WNI_CFG_VHT_40MHZ_UTILIZATION_STAMIN,
     WNI_CFG_VHT_40MHZ_UTILIZATION_STAMAX,
     WNI_CFG_VHT_40MHZ_UTILIZATION_STADEF},
    {WNI_CFG_VHT_80MHZ_UTILIZATION,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | CFG_CTL_NTF_LIM | SEM_3,
     WNI_CFG_VHT_80MHZ_UTILIZATION_STAMIN,
     WNI_CFG_VHT_80MHZ_UTILIZATION_STAMAX,
     WNI_CFG_VHT_80MHZ_UTILIZATION_STADEF},
    {WNI_CFG_VHT_160MHZ_UTILIZATION,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | CFG_CTL_NTF_LIM | SEM_3,
     WNI_CFG_VHT_80MHZ_UTILIZATION_STADEF,
     WNI_CFG_VHT_160MHZ_UTILIZATION_STAMAX,
     WNI_CFG_VHT_160MHZ_UTILIZATION_STADEF},
    {WNI_CFG_MAX_AMSDU_LENGTH,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | CFG_CTL_RESTART | CFG_CTL_NTF_LIM | SEM_7,
     WNI_CFG_MAX_AMSDU_LENGTH_STAMIN,
     WNI_CFG_MAX_AMSDU_LENGTH_STAMAX,
     WNI_CFG_MAX_AMSDU_LENGTH_STADEF},
    {WNI_CFG_MPDU_DENSITY,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | CFG_CTL_RESTART | CFG_CTL_NTF_LIM | SEM_7,
     WNI_CFG_MPDU_DENSITY_STAMIN,
     WNI_CFG_MPDU_DENSITY_STAMAX,
     WNI_CFG_MPDU_DENSITY_STADEF},
    {WNI_CFG_NUM_BUFF_ADVERT,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | CFG_CTL_NTF_LIM | SEM_7,
     WNI_CFG_NUM_BUFF_ADVERT_STAMIN,
     WNI_CFG_NUM_BUFF_ADVERT_STAMAX,
     WNI_CFG_NUM_BUFF_ADVERT_STADEF},
    {WNI_CFG_MAX_RX_AMPDU_FACTOR,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | CFG_CTL_RESTART | CFG_CTL_NTF_LIM | SEM_7,
     WNI_CFG_MAX_RX_AMPDU_FACTOR_STAMIN,
     WNI_CFG_MAX_RX_AMPDU_FACTOR_STAMAX,
     WNI_CFG_MAX_RX_AMPDU_FACTOR_STAMAX},
    {WNI_CFG_SHORT_GI_20MHZ,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | CFG_CTL_RESTART | CFG_CTL_NTF_LIM | SEM_7,
     WNI_CFG_SHORT_GI_20MHZ_STAMIN,
     WNI_CFG_SHORT_GI_20MHZ_STAMAX,
     WNI_CFG_SHORT_GI_20MHZ_STADEF},
    {WNI_CFG_SHORT_GI_40MHZ,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | CFG_CTL_RESTART | CFG_CTL_NTF_LIM | SEM_7,
     WNI_CFG_SHORT_GI_40MHZ_STAMIN,
     WNI_CFG_SHORT_GI_40MHZ_STAMAX,
     WNI_CFG_SHORT_GI_40MHZ_STADEF},
    {WNI_CFG_RIFS_ENABLED,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | CFG_CTL_RESTART | SEM_7,
     WNI_CFG_RIFS_ENABLED_STAMIN,
     WNI_CFG_RIFS_ENABLED_STAMAX,
     WNI_CFG_RIFS_ENABLED_STADEF},
    {WNI_CFG_MAX_PS_POLL,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | CFG_CTL_NTF_LIM | SEM_5,
     WNI_CFG_MAX_PS_POLL_STAMIN,
     WNI_CFG_MAX_PS_POLL_STAMAX,
     WNI_CFG_MAX_PS_POLL_STADEF},
    {WNI_CFG_NUM_BEACON_PER_RSSI_AVERAGE,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | CFG_CTL_NTF_LIM | SEM_5,
     WNI_CFG_NUM_BEACON_PER_RSSI_AVERAGE_STAMIN,
     WNI_CFG_NUM_BEACON_PER_RSSI_AVERAGE_STAMAX,
     WNI_CFG_NUM_BEACON_PER_RSSI_AVERAGE_STADEF},
    {WNI_CFG_RSSI_FILTER_PERIOD,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | CFG_CTL_NTF_LIM | SEM_5,
     WNI_CFG_RSSI_FILTER_PERIOD_STAMIN,
     WNI_CFG_RSSI_FILTER_PERIOD_STAMAX,
     WNI_CFG_RSSI_FILTER_PERIOD_STADEF},
    {WNI_CFG_MIN_RSSI_THRESHOLD,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | CFG_CTL_NTF_LIM | SEM_5,
     WNI_CFG_MIN_RSSI_THRESHOLD_STAMIN,
     WNI_CFG_MIN_RSSI_THRESHOLD_STAMAX,
     WNI_CFG_MIN_RSSI_THRESHOLD_STADEF},
    {WNI_CFG_NTH_BEACON_FILTER,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | CFG_CTL_NTF_LIM | SEM_5,
     WNI_CFG_NTH_BEACON_FILTER_STAMIN,
     WNI_CFG_NTH_BEACON_FILTER_STAMAX,
     WNI_CFG_NTH_BEACON_FILTER_STADEF},
    {WNI_CFG_BROADCAST_FRAME_FILTER_ENABLE,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | CFG_CTL_NTF_LIM | SEM_5,
     WNI_CFG_BROADCAST_FRAME_FILTER_ENABLE_STAMIN,
     WNI_CFG_BROADCAST_FRAME_FILTER_ENABLE_STAMAX,
     WNI_CFG_BROADCAST_FRAME_FILTER_ENABLE_STADEF},
    {WNI_CFG_SCAN_IN_POWERSAVE,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | CFG_CTL_NTF_LIM | SEM_5,
     WNI_CFG_SCAN_IN_POWERSAVE_STAMIN,
     WNI_CFG_SCAN_IN_POWERSAVE_STAMAX,
     WNI_CFG_SCAN_IN_POWERSAVE_STADEF},
    {WNI_CFG_IGNORE_DTIM,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | SEM_5,
     WNI_CFG_IGNORE_DTIM_STAMIN,
     WNI_CFG_IGNORE_DTIM_STAMAX,
     WNI_CFG_IGNORE_DTIM_STADEF},
    {WNI_CFG_WOWLAN_UCAST_PATTERN_FILTER_ENABLE,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | SEM_5,
     WNI_CFG_WOWLAN_UCAST_PATTERN_FILTER_ENABLE_STAMIN,
     WNI_CFG_WOWLAN_UCAST_PATTERN_FILTER_ENABLE_STAMAX,
     WNI_CFG_WOWLAN_UCAST_PATTERN_FILTER_ENABLE_STADEF},
    {WNI_CFG_WOWLAN_CHANNEL_SWITCH_ENABLE,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | SEM_5,
     WNI_CFG_WOWLAN_CHANNEL_SWITCH_ENABLE_STAMIN,
     WNI_CFG_WOWLAN_CHANNEL_SWITCH_ENABLE_STAMAX,
     WNI_CFG_WOWLAN_CHANNEL_SWITCH_ENABLE_STADEF},
    {WNI_CFG_WOWLAN_DEAUTH_ENABLE,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | SEM_5,
     WNI_CFG_WOWLAN_DEAUTH_ENABLE_STAMIN,
     WNI_CFG_WOWLAN_DEAUTH_ENABLE_STAMAX,
     WNI_CFG_WOWLAN_DEAUTH_ENABLE_STADEF},
    {WNI_CFG_WOWLAN_DISASSOC_ENABLE,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | SEM_5,
     WNI_CFG_WOWLAN_DISASSOC_ENABLE_STAMIN,
     WNI_CFG_WOWLAN_DISASSOC_ENABLE_STAMAX,
     WNI_CFG_WOWLAN_DISASSOC_ENABLE_STADEF},
    {WNI_CFG_WOWLAN_MAX_MISSED_BEACON,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | SEM_5,
     WNI_CFG_WOWLAN_MAX_MISSED_BEACON_STAMIN,
     WNI_CFG_WOWLAN_MAX_MISSED_BEACON_STAMAX,
     WNI_CFG_WOWLAN_MAX_MISSED_BEACON_STADEF},
    {WNI_CFG_WOWLAN_MAX_SLEEP_PERIOD,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | SEM_5,
     WNI_CFG_WOWLAN_MAX_SLEEP_PERIOD_STAMIN,
     WNI_CFG_WOWLAN_MAX_SLEEP_PERIOD_STAMAX,
     WNI_CFG_WOWLAN_MAX_SLEEP_PERIOD_STADEF},
    {WNI_CFG_BA_TIMEOUT,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | CFG_CTL_RESTART | CFG_CTL_NTF_HAL | SEM_7,
     WNI_CFG_BA_TIMEOUT_STAMIN,
     WNI_CFG_BA_TIMEOUT_STAMAX,
     WNI_CFG_BA_TIMEOUT_STADEF},
    {WNI_CFG_BA_THRESHOLD_HIGH,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | CFG_CTL_RESTART | CFG_CTL_NTF_HAL | SEM_7,
     WNI_CFG_BA_THRESHOLD_HIGH_STAMIN,
     WNI_CFG_BA_THRESHOLD_HIGH_STAMAX,
     WNI_CFG_BA_THRESHOLD_HIGH_STADEF},
    {WNI_CFG_MAX_BA_BUFFERS,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | CFG_CTL_RESTART | CFG_CTL_NTF_HAL | SEM_7,
     WNI_CFG_MAX_BA_BUFFERS_STAMIN,
     WNI_CFG_MAX_BA_BUFFERS_STAMAX,
     WNI_CFG_MAX_BA_BUFFERS_STADEF},
    {WNI_CFG_MAX_BA_SESSIONS,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | CFG_CTL_RESTART | CFG_CTL_NTF_HAL | SEM_7,
     WNI_CFG_MAX_BA_SESSIONS_STAMIN,
     WNI_CFG_MAX_BA_SESSIONS_STAMAX,
     WNI_CFG_MAX_BA_SESSIONS_STADEF},
    {WNI_CFG_BA_AUTO_SETUP,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | CFG_CTL_RESTART | CFG_CTL_NTF_HAL | SEM_7,
     WNI_CFG_BA_AUTO_SETUP_STAMIN,
     WNI_CFG_BA_AUTO_SETUP_STAMAX,
     WNI_CFG_BA_AUTO_SETUP_STADEF},
    {WNI_CFG_ADDBA_REQ_DECLINE,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | CFG_CTL_RESTART | CFG_CTL_NTF_LIM | SEM_7,
     WNI_CFG_ADDBA_REQ_DECLINE_STAMIN,
     WNI_CFG_ADDBA_REQ_DECLINE_STAMAX,
     WNI_CFG_ADDBA_REQ_DECLINE_STADEF},
    {WNI_CFG_DEL_ALL_RX_TX_BA_SESSIONS_2_4_G_BTC,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | CFG_CTL_NTF_LIM | SEM_7,
     WNI_CFG_DEL_ALL_RX_TX_BA_SESSIONS_2_4_G_BTC_STAMIN,
     WNI_CFG_DEL_ALL_RX_TX_BA_SESSIONS_2_4_G_BTC_STAMAX,
     WNI_CFG_DEL_ALL_RX_TX_BA_SESSIONS_2_4_G_BTC_STADEF},
    {WNI_CFG_BG_SCAN_CHANNEL_LIST,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_NTF_LIM | SEM_8,
     0, 0, 0},
    {WNI_CFG_MAX_MEDIUM_TIME,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | CFG_CTL_NTF_HAL | SEM_8,
     WNI_CFG_MAX_MEDIUM_TIME_STAMIN,
     WNI_CFG_MAX_MEDIUM_TIME_STAMAX,
     WNI_CFG_MAX_MEDIUM_TIME_STADEF},
    {WNI_CFG_MAX_MPDUS_IN_AMPDU,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | CFG_CTL_NTF_HAL | SEM_8,
     WNI_CFG_MAX_MPDUS_IN_AMPDU_STAMIN,
     WNI_CFG_MAX_MPDUS_IN_AMPDU_STAMAX,
     WNI_CFG_MAX_MPDUS_IN_AMPDU_STADEF},
    {WNI_CFG_IBSS_AUTO_BSSID,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | SEM_0,
     WNI_CFG_IBSS_AUTO_BSSID_STAMIN,
     WNI_CFG_IBSS_AUTO_BSSID_STAMAX,
     WNI_CFG_IBSS_AUTO_BSSID_STADEF},
    {WNI_CFG_PROBE_REQ_ADDNIE_FLAG,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | SEM_0,
     WNI_CFG_PROBE_REQ_ADDNIE_FLAG_STAMIN,
     WNI_CFG_PROBE_REQ_ADDNIE_FLAG_STAMAX,
     WNI_CFG_PROBE_REQ_ADDNIE_FLAG_STADEF},
    {WNI_CFG_PROBE_REQ_ADDNIE_DATA,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | SEM_0,
     0, 0, 0},
    {WNI_CFG_PROBE_RSP_ADDNIE_FLAG,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | SEM_0,
     WNI_CFG_PROBE_RSP_ADDNIE_FLAG_STAMIN,
     WNI_CFG_PROBE_RSP_ADDNIE_FLAG_STAMAX,
     WNI_CFG_PROBE_RSP_ADDNIE_FLAG_STADEF},
    {WNI_CFG_PROBE_RSP_ADDNIE_DATA1,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | SEM_0,
     0, 0, 0},
    {WNI_CFG_PROBE_RSP_ADDNIE_DATA2,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | SEM_0,
     0, 0, 0},
    {WNI_CFG_PROBE_RSP_ADDNIE_DATA3,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | SEM_0,
     0, 0, 0},
    {WNI_CFG_ASSOC_RSP_ADDNIE_FLAG,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | SEM_0,
     WNI_CFG_ASSOC_RSP_ADDNIE_FLAG_STAMIN,
     WNI_CFG_ASSOC_RSP_ADDNIE_FLAG_STAMAX,
     WNI_CFG_ASSOC_RSP_ADDNIE_FLAG_STADEF},
    {WNI_CFG_ASSOC_RSP_ADDNIE_DATA,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | SEM_0,
     0, 0, 0},
    {WNI_CFG_PROBE_REQ_ADDNP2PIE_FLAG,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | SEM_0,
     WNI_CFG_PROBE_REQ_ADDNP2PIE_FLAG_STAMIN,
     WNI_CFG_PROBE_REQ_ADDNP2PIE_FLAG_STAMAX,
     WNI_CFG_PROBE_REQ_ADDNP2PIE_FLAG_STADEF},
    {WNI_CFG_PROBE_REQ_ADDNP2PIE_DATA,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | SEM_0,
     0, 0, 0},
    {WNI_CFG_PROBE_RSP_BCN_ADDNIE_FLAG,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | CFG_CTL_NTF_LIM | SEM_0,
     WNI_CFG_PROBE_RSP_BCN_ADDNIE_FLAG_STAMIN,
     WNI_CFG_PROBE_RSP_BCN_ADDNIE_FLAG_STAMAX,
     WNI_CFG_PROBE_RSP_BCN_ADDNIE_FLAG_STADEF},
    {WNI_CFG_PROBE_RSP_BCN_ADDNIE_DATA,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_NTF_LIM | SEM_0,
     0, 0, 0},
    {WNI_CFG_WPS_ENABLE,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | CFG_CTL_NTF_LIM | SEM_7,
     WNI_CFG_WPS_ENABLE_STAMIN,
     WNI_CFG_WPS_ENABLE_STAMAX,
     WNI_CFG_WPS_ENABLE_STADEF},
    {WNI_CFG_WPS_STATE,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | CFG_CTL_NTF_LIM | SEM_7,
     WNI_CFG_WPS_STATE_STAMIN,
     WNI_CFG_WPS_STATE_STAMAX,
     WNI_CFG_WPS_STATE_STADEF},
    {WNI_CFG_WPS_PROBE_REQ_FLAG,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | CFG_CTL_NTF_LIM | SEM_7,
     WNI_CFG_WPS_PROBE_REQ_FLAG_STAMIN,
     WNI_CFG_WPS_PROBE_REQ_FLAG_STAMAX,
     WNI_CFG_WPS_PROBE_REQ_FLAG_STADEF},
    {WNI_CFG_WPS_VERSION,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | CFG_CTL_NTF_LIM | SEM_7,
     WNI_CFG_WPS_VERSION_STAMIN,
     WNI_CFG_WPS_VERSION_STAMAX,
     WNI_CFG_WPS_VERSION_STADEF},
    {WNI_CFG_WPS_REQUEST_TYPE,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | CFG_CTL_NTF_LIM | SEM_7,
     WNI_CFG_WPS_REQUEST_TYPE_STAMIN,
     WNI_CFG_WPS_REQUEST_TYPE_STAMAX,
     WNI_CFG_WPS_REQUEST_TYPE_STADEF},
    {WNI_CFG_WPS_CFG_METHOD,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | CFG_CTL_NTF_LIM | SEM_7,
     WNI_CFG_WPS_CFG_METHOD_STAMIN,
     4294967295u,
     WNI_CFG_WPS_CFG_METHOD_STADEF},
    {WNI_CFG_WPS_UUID,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_NTF_LIM | SEM_8,
     0, 0, 0},
    {WNI_CFG_WPS_PRIMARY_DEVICE_CATEGORY,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | CFG_CTL_NTF_LIM | SEM_7,
     WNI_CFG_WPS_PRIMARY_DEVICE_CATEGORY_STAMIN,
     WNI_CFG_WPS_PRIMARY_DEVICE_CATEGORY_STAMAX,
     WNI_CFG_WPS_PRIMARY_DEVICE_CATEGORY_STADEF},
    {WNI_CFG_WPS_PIMARY_DEVICE_OUI,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | CFG_CTL_NTF_LIM | SEM_7,
     WNI_CFG_WPS_PIMARY_DEVICE_OUI_STAMIN,
     4294967295u,
     WNI_CFG_WPS_PIMARY_DEVICE_OUI_STADEF},
    {WNI_CFG_WPS_DEVICE_SUB_CATEGORY,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | CFG_CTL_NTF_LIM | SEM_7,
     WNI_CFG_WPS_DEVICE_SUB_CATEGORY_STAMIN,
     WNI_CFG_WPS_DEVICE_SUB_CATEGORY_STAMAX,
     WNI_CFG_WPS_DEVICE_SUB_CATEGORY_STADEF},
    {WNI_CFG_WPS_ASSOCIATION_STATE,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | CFG_CTL_NTF_LIM | SEM_7,
     WNI_CFG_WPS_ASSOCIATION_STATE_STAMIN,
     WNI_CFG_WPS_ASSOCIATION_STATE_STAMAX,
     WNI_CFG_WPS_ASSOCIATION_STATE_STADEF},
    {WNI_CFG_WPS_CONFIGURATION_ERROR,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | CFG_CTL_NTF_LIM | SEM_7,
     WNI_CFG_WPS_CONFIGURATION_ERROR_STAMIN,
     WNI_CFG_WPS_CONFIGURATION_ERROR_STAMAX,
     WNI_CFG_WPS_CONFIGURATION_ERROR_STADEF},
    {WNI_CFG_WPS_DEVICE_PASSWORD_ID,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | CFG_CTL_NTF_LIM | SEM_7,
     WNI_CFG_WPS_DEVICE_PASSWORD_ID_STAMIN,
     4294967295u,
     WNI_CFG_WPS_DEVICE_PASSWORD_ID_STADEF},
    {WNI_CFG_WPS_ASSOC_METHOD,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | CFG_CTL_NTF_LIM | SEM_7,
     WNI_CFG_WPS_ASSOC_METHOD_STAMIN,
     WNI_CFG_WPS_ASSOC_METHOD_STAMAX,
     WNI_CFG_WPS_ASSOC_METHOD_STADEF},
    {WNI_CFG_LOW_GAIN_OVERRIDE,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | CFG_CTL_NTF_HAL | SEM_9,
     WNI_CFG_LOW_GAIN_OVERRIDE_STAMIN,
     WNI_CFG_LOW_GAIN_OVERRIDE_STAMAX,
     WNI_CFG_LOW_GAIN_OVERRIDE_STADEF},
    {WNI_CFG_ENABLE_PHY_AGC_LISTEN_MODE,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | CFG_CTL_NTF_HAL | SEM_7,
     WNI_CFG_ENABLE_PHY_AGC_LISTEN_MODE_STAMIN,
     WNI_CFG_ENABLE_PHY_AGC_LISTEN_MODE_STAMAX,
     WNI_CFG_ENABLE_PHY_AGC_LISTEN_MODE_STADEF},
    {WNI_CFG_RPE_POLLING_THRESHOLD,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | CFG_CTL_NTF_HAL | SEM_2,
     WNI_CFG_RPE_POLLING_THRESHOLD_STAMIN,
     WNI_CFG_RPE_POLLING_THRESHOLD_STAMAX,
     WNI_CFG_RPE_POLLING_THRESHOLD_STADEF},
    {WNI_CFG_RPE_AGING_THRESHOLD_FOR_AC0_REG,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | CFG_CTL_NTF_HAL | SEM_2,
     WNI_CFG_RPE_AGING_THRESHOLD_FOR_AC0_REG_STAMIN,
     WNI_CFG_RPE_AGING_THRESHOLD_FOR_AC0_REG_STAMAX,
     WNI_CFG_RPE_AGING_THRESHOLD_FOR_AC0_REG_STADEF},
    {WNI_CFG_RPE_AGING_THRESHOLD_FOR_AC1_REG,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | CFG_CTL_NTF_HAL | SEM_2,
     WNI_CFG_RPE_AGING_THRESHOLD_FOR_AC1_REG_STAMIN,
     WNI_CFG_RPE_AGING_THRESHOLD_FOR_AC1_REG_STAMAX,
     WNI_CFG_RPE_AGING_THRESHOLD_FOR_AC1_REG_STADEF},
    {WNI_CFG_RPE_AGING_THRESHOLD_FOR_AC2_REG,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | CFG_CTL_NTF_HAL | SEM_2,
     WNI_CFG_RPE_AGING_THRESHOLD_FOR_AC2_REG_STAMIN,
     WNI_CFG_RPE_AGING_THRESHOLD_FOR_AC2_REG_STAMAX,
     WNI_CFG_RPE_AGING_THRESHOLD_FOR_AC2_REG_STADEF},
    {WNI_CFG_RPE_AGING_THRESHOLD_FOR_AC3_REG,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | CFG_CTL_NTF_HAL | SEM_2,
     WNI_CFG_RPE_AGING_THRESHOLD_FOR_AC3_REG_STAMIN,
     WNI_CFG_RPE_AGING_THRESHOLD_FOR_AC3_REG_STAMAX,
     WNI_CFG_RPE_AGING_THRESHOLD_FOR_AC3_REG_STADEF},
    {WNI_CFG_NO_OF_ONCHIP_REORDER_SESSIONS,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | CFG_CTL_NTF_HAL | SEM_2,
     WNI_CFG_NO_OF_ONCHIP_REORDER_SESSIONS_STAMIN,
     WNI_CFG_NO_OF_ONCHIP_REORDER_SESSIONS_STAMAX,
     WNI_CFG_NO_OF_ONCHIP_REORDER_SESSIONS_STADEF},
    {WNI_CFG_SINGLE_TID_RC,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | SEM_7,
     WNI_CFG_SINGLE_TID_RC_STAMIN,
     WNI_CFG_SINGLE_TID_RC_STAMAX,
     WNI_CFG_SINGLE_TID_RC_STADEF},
    {WNI_CFG_RRM_ENABLED,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | SEM_8,
     WNI_CFG_RRM_ENABLED_STAMIN,
     WNI_CFG_RRM_ENABLED_STAMAX,
     WNI_CFG_RRM_ENABLED_STADEF},
    {WNI_CFG_RRM_OPERATING_CHAN_MAX,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | SEM_8,
     WNI_CFG_RRM_OPERATING_CHAN_MAX_STAMIN,
     WNI_CFG_RRM_OPERATING_CHAN_MAX_STAMAX,
     WNI_CFG_RRM_OPERATING_CHAN_MAX_STADEF},
    {WNI_CFG_RRM_NON_OPERATING_CHAN_MAX,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | SEM_8,
     WNI_CFG_RRM_NON_OPERATING_CHAN_MAX_STAMIN,
     WNI_CFG_RRM_NON_OPERATING_CHAN_MAX_STAMAX,
     WNI_CFG_RRM_NON_OPERATING_CHAN_MAX_STADEF},
    {WNI_CFG_TX_PWR_CTRL_ENABLE,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | SEM_8,
     WNI_CFG_TX_PWR_CTRL_ENABLE_STAMIN,
     WNI_CFG_TX_PWR_CTRL_ENABLE_STAMAX,
     WNI_CFG_TX_PWR_CTRL_ENABLE_STADEF},
    {WNI_CFG_MCAST_BCAST_FILTER_SETTING,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | CFG_CTL_NTF_HAL | SEM_7,
     WNI_CFG_MCAST_BCAST_FILTER_SETTING_STAMIN,
     WNI_CFG_MCAST_BCAST_FILTER_SETTING_STAMAX,
     WNI_CFG_MCAST_BCAST_FILTER_SETTING_STADEF},
    {WNI_CFG_BTC_DHCP_BT_SLOTS_TO_BLOCK,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | CFG_CTL_NTF_HAL | SEM_7,
     WNI_CFG_BTC_DHCP_BT_SLOTS_TO_BLOCK_STAMIN,
     WNI_CFG_BTC_DHCP_BT_SLOTS_TO_BLOCK_STAMAX,
     WNI_CFG_BTC_DHCP_BT_SLOTS_TO_BLOCK_STADEF},
    {WNI_CFG_DYNAMIC_PS_POLL_VALUE,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | CFG_CTL_NTF_HAL | SEM_7,
     WNI_CFG_DYNAMIC_PS_POLL_VALUE_STAMIN,
     WNI_CFG_DYNAMIC_PS_POLL_VALUE_STAMAX,
     WNI_CFG_DYNAMIC_PS_POLL_VALUE_STADEF},
    {WNI_CFG_PS_NULLDATA_AP_RESP_TIMEOUT,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | CFG_CTL_NTF_HAL | SEM_7,
     WNI_CFG_PS_NULLDATA_AP_RESP_TIMEOUT_STAMIN,
     WNI_CFG_PS_NULLDATA_AP_RESP_TIMEOUT_STAMAX,
     WNI_CFG_PS_NULLDATA_AP_RESP_TIMEOUT_STADEF},
    {WNI_CFG_TELE_BCN_WAKEUP_EN,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | CFG_CTL_NTF_HAL | SEM_7,
     WNI_CFG_TELE_BCN_WAKEUP_EN_STAMIN,
     WNI_CFG_TELE_BCN_WAKEUP_EN_STAMAX,
     WNI_CFG_TELE_BCN_WAKEUP_EN_STADEF},
    {WNI_CFG_TELE_BCN_TRANS_LI,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | CFG_CTL_NTF_HAL | SEM_7,
     WNI_CFG_TELE_BCN_TRANS_LI_STAMIN,
     WNI_CFG_TELE_BCN_TRANS_LI_STAMAX,
     WNI_CFG_TELE_BCN_TRANS_LI_STADEF},
    {WNI_CFG_TELE_BCN_TRANS_LI_IDLE_BCNS,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | CFG_CTL_NTF_HAL | SEM_7,
     WNI_CFG_TELE_BCN_TRANS_LI_IDLE_BCNS_STAMIN,
     WNI_CFG_TELE_BCN_TRANS_LI_IDLE_BCNS_STAMAX,
     WNI_CFG_TELE_BCN_TRANS_LI_IDLE_BCNS_STADEF},
    {WNI_CFG_TELE_BCN_MAX_LI,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | CFG_CTL_NTF_HAL | SEM_7,
     WNI_CFG_TELE_BCN_MAX_LI_STAMIN,
     WNI_CFG_TELE_BCN_MAX_LI_STAMAX,
     WNI_CFG_TELE_BCN_MAX_LI_STADEF},
    {WNI_CFG_TELE_BCN_MAX_LI_IDLE_BCNS,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | CFG_CTL_NTF_HAL | SEM_7,
     WNI_CFG_TELE_BCN_MAX_LI_IDLE_BCNS_STAMIN,
     WNI_CFG_TELE_BCN_MAX_LI_IDLE_BCNS_STAMAX,
     WNI_CFG_TELE_BCN_MAX_LI_IDLE_BCNS_STADEF},
    {WNI_CFG_BTC_A2DP_DHCP_BT_SUB_INTERVALS,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | CFG_CTL_NTF_HAL | SEM_7,
     WNI_CFG_BTC_A2DP_DHCP_BT_SUB_INTERVALS_STAMIN,
     WNI_CFG_BTC_A2DP_DHCP_BT_SUB_INTERVALS_STAMAX,
     WNI_CFG_BTC_A2DP_DHCP_BT_SUB_INTERVALS_STADEF},
    {WNI_CFG_INFRA_STA_KEEP_ALIVE_PERIOD,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | CFG_CTL_NTF_HAL | SEM_7,
     WNI_CFG_INFRA_STA_KEEP_ALIVE_PERIOD_STAMIN,
     WNI_CFG_INFRA_STA_KEEP_ALIVE_PERIOD_STAMAX,
     WNI_CFG_INFRA_STA_KEEP_ALIVE_PERIOD_STADEF},
    {WNI_CFG_ASSOC_STA_LIMIT,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | CFG_CTL_NTF_LIM | SEM_8,
     WNI_CFG_ASSOC_STA_LIMIT_STAMIN,
     WNI_CFG_ASSOC_STA_LIMIT_STAMAX,
     WNI_CFG_ASSOC_STA_LIMIT_STADEF},
    {WNI_CFG_SAP_CHANNEL_SELECT_START_CHANNEL,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | SEM_7,
     WNI_CFG_SAP_CHANNEL_SELECT_START_CHANNEL_STAMIN,
     WNI_CFG_SAP_CHANNEL_SELECT_START_CHANNEL_STAMAX,
     WNI_CFG_SAP_CHANNEL_SELECT_START_CHANNEL_STADEF},
    {WNI_CFG_SAP_CHANNEL_SELECT_END_CHANNEL,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | SEM_7,
     WNI_CFG_SAP_CHANNEL_SELECT_END_CHANNEL_STAMIN,
     WNI_CFG_SAP_CHANNEL_SELECT_END_CHANNEL_STAMAX,
     WNI_CFG_SAP_CHANNEL_SELECT_END_CHANNEL_STADEF},
    {WNI_CFG_SAP_CHANNEL_SELECT_OPERATING_BAND,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | SEM_7,
     WNI_CFG_SAP_CHANNEL_SELECT_OPERATING_BAND_STAMIN,
     WNI_CFG_SAP_CHANNEL_SELECT_OPERATING_BAND_STAMAX,
     WNI_CFG_SAP_CHANNEL_SELECT_OPERATING_BAND_STADEF},
    {WNI_CFG_AP_DATA_AVAIL_POLL_PERIOD,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | SEM_8,
     WNI_CFG_AP_DATA_AVAIL_POLL_PERIOD_STAMIN,
     WNI_CFG_AP_DATA_AVAIL_POLL_PERIOD_STAMAX,
     WNI_CFG_AP_DATA_AVAIL_POLL_PERIOD_STADEF},
    {WNI_CFG_ENABLE_CLOSE_LOOP,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | SEM_0,
     WNI_CFG_ENABLE_CLOSE_LOOP_STAMIN,
     WNI_CFG_ENABLE_CLOSE_LOOP_STAMAX,
     WNI_CFG_ENABLE_CLOSE_LOOP_STADEF},
    {WNI_CFG_ENABLE_LTE_COEX,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | SEM_0,
     WNI_CFG_ENABLE_LTE_COEX_STAMIN,
     WNI_CFG_ENABLE_LTE_COEX_STAMAX,
     WNI_CFG_ENABLE_LTE_COEX_STADEF},
    {WNI_CFG_AP_KEEP_ALIVE_TIMEOUT,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | CFG_CTL_NTF_HAL | SEM_7,
     WNI_CFG_AP_KEEP_ALIVE_TIMEOUT_STAMIN,
     WNI_CFG_AP_KEEP_ALIVE_TIMEOUT_STAMAX,
     WNI_CFG_AP_KEEP_ALIVE_TIMEOUT_STADEF},
    {WNI_CFG_GO_KEEP_ALIVE_TIMEOUT,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | CFG_CTL_NTF_HAL | SEM_7,
     WNI_CFG_GO_KEEP_ALIVE_TIMEOUT_STAMIN,
     WNI_CFG_GO_KEEP_ALIVE_TIMEOUT_STAMAX,
     WNI_CFG_GO_KEEP_ALIVE_TIMEOUT_STADEF},
    {WNI_CFG_ENABLE_MC_ADDR_LIST,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | CFG_CTL_NTF_HAL | SEM_0,
     WNI_CFG_ENABLE_MC_ADDR_LIST_STAMIN,
     WNI_CFG_ENABLE_MC_ADDR_LIST_STAMAX,
     WNI_CFG_ENABLE_MC_ADDR_LIST_STADEF},
    {WNI_CFG_ENABLE_UC_FILTER,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | CFG_CTL_NTF_HAL | SEM_0,
     WNI_CFG_ENABLE_UC_FILTER_STAMIN,
     WNI_CFG_ENABLE_UC_FILTER_STAMAX,
     WNI_CFG_ENABLE_UC_FILTER_STADEF},
    {WNI_CFG_ENABLE_LPWR_IMG_TRANSITION,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | SEM_0,
     WNI_CFG_ENABLE_LPWR_IMG_TRANSITION_STAMIN,
     WNI_CFG_ENABLE_LPWR_IMG_TRANSITION_STAMAX,
     WNI_CFG_ENABLE_LPWR_IMG_TRANSITION_STADEF},
    {WNI_CFG_ENABLE_MCC_ADAPTIVE_SCHED,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | SEM_0,
     WNI_CFG_ENABLE_MCC_ADAPTIVE_SCHED_STAMIN,
     WNI_CFG_ENABLE_MCC_ADAPTIVE_SCHED_STAMAX,
     WNI_CFG_ENABLE_MCC_ADAPTIVE_SCHED_STADEF},
    {WNI_CFG_DISABLE_LDPC_WITH_TXBF_AP,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | SEM_0,
     WNI_CFG_DISABLE_LDPC_WITH_TXBF_AP_STAMIN,
     WNI_CFG_DISABLE_LDPC_WITH_TXBF_AP_STAMAX,
     WNI_CFG_DISABLE_LDPC_WITH_TXBF_AP_STADEF},
    {WNI_CFG_AP_LINK_MONITOR_TIMEOUT,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | CFG_CTL_NTF_HAL | SEM_7,
     WNI_CFG_AP_LINK_MONITOR_TIMEOUT_STAMIN,
     WNI_CFG_AP_LINK_MONITOR_TIMEOUT_STAMAX,
     WNI_CFG_AP_LINK_MONITOR_TIMEOUT_STADEF},
    {WNI_CFG_TDLS_QOS_WMM_UAPSD_MASK,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | CFG_CTL_NTF_LIM | SEM_7,
     WNI_CFG_TDLS_QOS_WMM_UAPSD_MASK_STAMIN,
     WNI_CFG_TDLS_QOS_WMM_UAPSD_MASK_STAMAX,
     WNI_CFG_TDLS_QOS_WMM_UAPSD_MASK_STADEF},
    {WNI_CFG_TDLS_BUF_STA_ENABLED,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | CFG_CTL_NTF_LIM | SEM_7,
     WNI_CFG_TDLS_BUF_STA_ENABLED_STAMIN,
     WNI_CFG_TDLS_BUF_STA_ENABLED_STAMAX,
     WNI_CFG_TDLS_BUF_STA_ENABLED_STADEF},
    {WNI_CFG_TDLS_PUAPSD_INACT_TIME,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | CFG_CTL_NTF_LIM | SEM_7,
     WNI_CFG_TDLS_PUAPSD_INACT_TIME_STAMIN,
     WNI_CFG_TDLS_PUAPSD_INACT_TIME_STAMAX,
     WNI_CFG_TDLS_PUAPSD_INACT_TIME_STADEF},
    {WNI_CFG_TDLS_RX_FRAME_THRESHOLD,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | CFG_CTL_NTF_LIM | SEM_7,
     WNI_CFG_TDLS_RX_FRAME_THRESHOLD_STAMIN,
     WNI_CFG_TDLS_RX_FRAME_THRESHOLD_STAMAX,
     WNI_CFG_TDLS_RX_FRAME_THRESHOLD_STADEF},
    {WNI_CFG_ENABLE_ADAPT_RX_DRAIN,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | CFG_CTL_NTF_HAL | SEM_7,
     WNI_CFG_ENABLE_ADAPT_RX_DRAIN_STAMIN,
     WNI_CFG_ENABLE_ADAPT_RX_DRAIN_STAMAX,
     WNI_CFG_ENABLE_ADAPT_RX_DRAIN_STADEF},
    {WNI_CFG_FLEX_CONNECT_POWER_FACTOR,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | SEM_0,
     WNI_CFG_FLEX_CONNECT_POWER_FACTOR_STAMIN,
     WNI_CFG_FLEX_CONNECT_POWER_FACTOR_STAMAX,
     WNI_CFG_FLEX_CONNECT_POWER_FACTOR_STADEF},
    {WNI_CFG_ANTENNA_DIVESITY,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | CFG_CTL_NTF_HAL | SEM_7,
     WNI_CFG_ANTENNA_DIVESITY_STAMIN,
     WNI_CFG_ANTENNA_DIVESITY_STAMAX,
     WNI_CFG_ANTENNA_DIVESITY_STADEF},
    {WNI_CFG_GO_LINK_MONITOR_TIMEOUT,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | CFG_CTL_NTF_HAL | SEM_7,
     WNI_CFG_GO_LINK_MONITOR_TIMEOUT_STAMIN,
     WNI_CFG_GO_LINK_MONITOR_TIMEOUT_STAMAX,
     WNI_CFG_GO_LINK_MONITOR_TIMEOUT_STADEF},
    {WNI_CFG_ATH_DISABLE,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | SEM_7,
     WNI_CFG_ATH_DISABLE_STAMIN,
     WNI_CFG_ATH_DISABLE_STAMAX,
     WNI_CFG_ATH_DISABLE_STADEF},
    {WNI_CFG_BTC_ACTIVE_WLAN_LEN,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | CFG_CTL_NTF_HAL | SEM_7,
     WNI_CFG_BTC_ACTIVE_WLAN_LEN_STAMIN,
     WNI_CFG_BTC_ACTIVE_WLAN_LEN_STAMAX,
     WNI_CFG_BTC_ACTIVE_WLAN_LEN_STADEF},
    {WNI_CFG_BTC_ACTIVE_BT_LEN,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | CFG_CTL_NTF_HAL | SEM_7,
     WNI_CFG_BTC_ACTIVE_BT_LEN_STAMIN,
     WNI_CFG_BTC_ACTIVE_BT_LEN_STAMAX,
     WNI_CFG_BTC_ACTIVE_BT_LEN_STADEF},
    {WNI_CFG_BTC_SAP_ACTIVE_WLAN_LEN,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | CFG_CTL_NTF_HAL | SEM_7,
     WNI_CFG_BTC_SAP_ACTIVE_WLAN_LEN_STAMIN,
     WNI_CFG_BTC_SAP_ACTIVE_WLAN_LEN_STAMAX,
     WNI_CFG_BTC_SAP_ACTIVE_WLAN_LEN_STADEF},
    {WNI_CFG_BTC_SAP_ACTIVE_BT_LEN,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | CFG_CTL_NTF_HAL | SEM_7,
     WNI_CFG_BTC_SAP_ACTIVE_BT_LEN_STAMIN,
     WNI_CFG_BTC_SAP_ACTIVE_BT_LEN_STAMAX,
     WNI_CFG_BTC_SAP_ACTIVE_BT_LEN_STADEF},
    {WNI_CFG_RMC_ACTION_PERIOD_FREQUENCY,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | CFG_CTL_NTF_HAL | SEM_7,
     WNI_CFG_RMC_ACTION_PERIOD_FREQUENCY_STAMIN,
     4294967295u,
     WNI_CFG_RMC_ACTION_PERIOD_FREQUENCY_STADEF},
    {WNI_CFG_ASD_PROBE_INTERVAL,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | CFG_CTL_NTF_HAL | SEM_7,
     WNI_CFG_ASD_PROBE_INTERVAL_STAMIN,
     WNI_CFG_ASD_PROBE_INTERVAL_STAMAX,
     WNI_CFG_ASD_PROBE_INTERVAL_STADEF},
    {WNI_CFG_ASD_TRIGGER_THRESHOLD,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | CFG_CTL_NTF_HAL | SEM_7,
     WNI_CFG_ASD_TRIGGER_THRESHOLD_STAMIN,
     WNI_CFG_ASD_TRIGGER_THRESHOLD_STAMAX,
     WNI_CFG_ASD_TRIGGER_THRESHOLD_STADEF},
    {WNI_CFG_ASD_RTT_RSSI_HYST_THRESHOLD,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | CFG_CTL_NTF_HAL | SEM_7,
     WNI_CFG_ASD_RTT_RSSI_HYST_THRESHOLD_STAMIN,
     WNI_CFG_ASD_RTT_RSSI_HYST_THRESHOLD_STAMAX,
     WNI_CFG_ASD_RTT_RSSI_HYST_THRESHOLD_STADEF},
    {WNI_CFG_DEBUG_P2P_REMAIN_ON_CHANNEL,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | SEM_7,
     WNI_CFG_DEBUG_P2P_REMAIN_ON_CHANNEL_STAMIN,
     WNI_CFG_DEBUG_P2P_REMAIN_ON_CHANNEL_STAMAX,
     WNI_CFG_DEBUG_P2P_REMAIN_ON_CHANNEL_STADEF},
    {WNI_CFG_BTC_CTS2S_DURING_SCO,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | CFG_CTL_NTF_HAL | SEM_7,
     WNI_CFG_BTC_CTS2S_DURING_SCO_STAMIN,
     WNI_CFG_BTC_CTS2S_DURING_SCO_STAMAX,
     WNI_CFG_BTC_CTS2S_DURING_SCO_STADEF},
    {WNI_CFG_CHANNEL_BONDING_24G,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | CFG_CTL_RESTART | CFG_CTL_NTF_LIM | SEM_12,
     WNI_CFG_CHANNEL_BONDING_24G_STAMIN,
     WNI_CFG_CHANNEL_BONDING_24G_STAMAX,
     WNI_CFG_CHANNEL_BONDING_24G_STADEF},
    {WNI_CFG_OBSS_HT40_SCAN_PASSIVE_DWELL_TIME,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | SEM_9,
     WNI_CFG_OBSS_HT40_SCAN_PASSIVE_DWELL_TIME_STAMIN,
     WNI_CFG_OBSS_HT40_SCAN_PASSIVE_DWELL_TIME_STAMAX,
     WNI_CFG_OBSS_HT40_SCAN_PASSIVE_DWELL_TIME_STADEF},
    {WNI_CFG_OBSS_HT40_SCAN_ACTIVE_DWELL_TIME,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | SEM_9,
     WNI_CFG_OBSS_HT40_SCAN_ACTIVE_DWELL_TIME_STAMIN,
     WNI_CFG_OBSS_HT40_SCAN_ACTIVE_DWELL_TIME_STAMAX,
     WNI_CFG_OBSS_HT40_SCAN_ACTIVE_DWELL_TIME_STADEF},
    {WNI_CFG_OBSS_HT40_SCAN_WIDTH_TRIGGER_INTERVAL,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | SEM_9,
     WNI_CFG_OBSS_HT40_SCAN_WIDTH_TRIGGER_INTERVAL_STAMIN,
     WNI_CFG_OBSS_HT40_SCAN_WIDTH_TRIGGER_INTERVAL_STAMAX,
     WNI_CFG_OBSS_HT40_SCAN_WIDTH_TRIGGER_INTERVAL_STADEF},
    {WNI_CFG_OBSS_HT40_SCAN_PASSIVE_TOTAL_PER_CHANNEL,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | SEM_9,
     WNI_CFG_OBSS_HT40_SCAN_PASSIVE_TOTAL_PER_CHANNEL_STAMIN,
     WNI_CFG_OBSS_HT40_SCAN_PASSIVE_TOTAL_PER_CHANNEL_STAMAX,
     WNI_CFG_OBSS_HT40_SCAN_PASSIVE_TOTAL_PER_CHANNEL_STADEF},
    {WNI_CFG_OBSS_HT40_SCAN_ACTIVE_TOTAL_PER_CHANNEL,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | SEM_9,
     WNI_CFG_OBSS_HT40_SCAN_ACTIVE_TOTAL_PER_CHANNEL_STAMIN,
     WNI_CFG_OBSS_HT40_SCAN_ACTIVE_TOTAL_PER_CHANNEL_STAMAX,
     WNI_CFG_OBSS_HT40_SCAN_ACTIVE_TOTAL_PER_CHANNEL_STADEF},
    {WNI_CFG_OBSS_HT40_WIDTH_CHANNEL_TRANSITION_DELAY_FACTOR,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | SEM_9,
     WNI_CFG_OBSS_HT40_WIDTH_CHANNEL_TRANSITION_DELAY_FACTOR_STAMIN,
     WNI_CFG_OBSS_HT40_WIDTH_CHANNEL_TRANSITION_DELAY_FACTOR_STAMAX,
     WNI_CFG_OBSS_HT40_WIDTH_CHANNEL_TRANSITION_DELAY_FACTOR_STADEF},
    {WNI_CFG_OBSS_HT40_SCAN_ACTIVITY_THRESHOLD,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | SEM_9,
     WNI_CFG_OBSS_HT40_SCAN_ACTIVITY_THRESHOLD_STAMIN,
     WNI_CFG_OBSS_HT40_SCAN_ACTIVITY_THRESHOLD_STAMAX,
     WNI_CFG_OBSS_HT40_SCAN_ACTIVITY_THRESHOLD_STADEF},
    {WNI_CFG_TDLS_OFF_CHANNEL_ENABLED,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | CFG_CTL_NTF_LIM | SEM_7,
     WNI_CFG_TDLS_OFF_CHANNEL_ENABLED_STAMIN,
     WNI_CFG_TDLS_OFF_CHANNEL_ENABLED_STAMAX,
     WNI_CFG_TDLS_OFF_CHANNEL_ENABLED_STADEF},
    {WNI_CFG_PMF_SA_QUERY_MAX_RETRIES,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | CFG_CTL_RESTART | SEM_1,
     WNI_CFG_PMF_SA_QUERY_MAX_RETRIES_STAMIN,
     WNI_CFG_PMF_SA_QUERY_MAX_RETRIES_STAMAX,
     WNI_CFG_PMF_SA_QUERY_MAX_RETRIES_STADEF},
    {WNI_CFG_PMF_SA_QUERY_RETRY_INTERVAL,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | CFG_CTL_RESTART | SEM_1,
     WNI_CFG_PMF_SA_QUERY_RETRY_INTERVAL_STAMIN,
     WNI_CFG_PMF_SA_QUERY_RETRY_INTERVAL_STAMAX,
     WNI_CFG_PMF_SA_QUERY_RETRY_INTERVAL_STADEF},
    {WNI_CFG_RA_FILTER_ENABLE,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | CFG_CTL_NTF_HAL | SEM_7,
     WNI_CFG_RA_FILTER_ENABLE_STAMIN,
     WNI_CFG_RA_FILTER_ENABLE_STAMAX,
     WNI_CFG_RA_FILTER_ENABLE_STADEF},
    {WNI_CFG_RA_RATE_LIMIT_INTERVAL,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | CFG_CTL_NTF_HAL | SEM_7,
     WNI_CFG_RA_RATE_LIMIT_INTERVAL_STAMIN,
     WNI_CFG_RA_RATE_LIMIT_INTERVAL_STAMAX,
     WNI_CFG_RA_RATE_LIMIT_INTERVAL_STADEF},
    {WNI_CFG_BTC_FATAL_HID_NSNIFF_BLK_GUIDANCE,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | CFG_CTL_NTF_HAL | SEM_7,
     WNI_CFG_BTC_FATAL_HID_NSNIFF_BLK_GUIDANCE_STAMIN,
     WNI_CFG_BTC_FATAL_HID_NSNIFF_BLK_GUIDANCE_STAMAX,
     WNI_CFG_BTC_FATAL_HID_NSNIFF_BLK_GUIDANCE_STADEF},
    {WNI_CFG_BTC_CRITICAL_HID_NSNIFF_BLK_GUIDANCE,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | CFG_CTL_NTF_HAL | SEM_7,
     WNI_CFG_BTC_CRITICAL_HID_NSNIFF_BLK_GUIDANCE_STAMIN,
     WNI_CFG_BTC_CRITICAL_HID_NSNIFF_BLK_GUIDANCE_STAMAX,
     WNI_CFG_BTC_CRITICAL_HID_NSNIFF_BLK_GUIDANCE_STADEF},
    {WNI_CFG_BTC_DYN_A2DP_TX_QUEUE_THOLD,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | CFG_CTL_NTF_HAL | SEM_7,
     WNI_CFG_BTC_DYN_A2DP_TX_QUEUE_THOLD_STAMIN,
     WNI_CFG_BTC_DYN_A2DP_TX_QUEUE_THOLD_STAMAX,
     WNI_CFG_BTC_DYN_A2DP_TX_QUEUE_THOLD_STADEF},
    {WNI_CFG_BTC_DYN_OPP_TX_QUEUE_THOLD,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | CFG_CTL_NTF_HAL | SEM_7,
     WNI_CFG_BTC_DYN_OPP_TX_QUEUE_THOLD_STAMIN,
     WNI_CFG_BTC_DYN_OPP_TX_QUEUE_THOLD_STAMAX,
     WNI_CFG_BTC_DYN_OPP_TX_QUEUE_THOLD_STADEF},
    {WNI_CFG_TDLS_WMM_MODE_ENABLED,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | CFG_CTL_NTF_LIM | SEM_7,
     WNI_CFG_TDLS_WMM_MODE_ENABLED_STAMIN,
     WNI_CFG_TDLS_WMM_MODE_ENABLED_STAMAX,
     WNI_CFG_TDLS_WMM_MODE_ENABLED_STADEF},


    {WNI_CFG_MAX_UAPSD_CONSEC_SP,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | CFG_CTL_NTF_HAL | SEM_7,
     WNI_CFG_MAX_UAPSD_CONSEC_SP_STAMIN,
     WNI_CFG_MAX_UAPSD_CONSEC_SP_STAMAX,
     WNI_CFG_MAX_UAPSD_CONSEC_SP_STADEF},
    {WNI_CFG_MAX_UAPSD_CONSEC_RX_CNT,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | CFG_CTL_NTF_HAL | SEM_7,
     WNI_CFG_MAX_UAPSD_CONSEC_RX_CNT_STAMIN,
     WNI_CFG_MAX_UAPSD_CONSEC_RX_CNT_STAMAX,
     WNI_CFG_MAX_UAPSD_CONSEC_RX_CNT_STADEF},
    {WNI_CFG_MAX_UAPSD_CONSEC_TX_CNT,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | CFG_CTL_NTF_HAL | SEM_7,
     WNI_CFG_MAX_UAPSD_CONSEC_TX_CNT_STAMIN,
     WNI_CFG_MAX_UAPSD_CONSEC_TX_CNT_STAMAX,
     WNI_CFG_MAX_UAPSD_CONSEC_TX_CNT_STADEF},
    {WNI_CFG_MAX_UAPSD_CONSEC_TX_CNT_MEAS_WINDOW,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | CFG_CTL_NTF_HAL | SEM_7,
     WNI_CFG_MAX_UAPSD_CONSEC_TX_CNT_MEAS_WINDOW_STAMIN,
     WNI_CFG_MAX_UAPSD_CONSEC_TX_CNT_MEAS_WINDOW_STAMAX,
     WNI_CFG_MAX_UAPSD_CONSEC_TX_CNT_MEAS_WINDOW_STADEF},
    {WNI_CFG_MAX_UAPSD_CONSEC_RX_CNT_MEAS_WINDOW,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | CFG_CTL_NTF_HAL | SEM_7,
     WNI_CFG_MAX_UAPSD_CONSEC_RX_CNT_MEAS_WINDOW_STAMIN,
     WNI_CFG_MAX_UAPSD_CONSEC_RX_CNT_MEAS_WINDOW_STAMAX,
     WNI_CFG_MAX_UAPSD_CONSEC_RX_CNT_MEAS_WINDOW_STADEF},
    {WNI_CFG_MAX_PSPOLL_IN_WMM_UAPSD_PS_MODE,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | CFG_CTL_NTF_HAL | SEM_7,
     WNI_CFG_MAX_PSPOLL_IN_WMM_UAPSD_PS_MODE_STAMIN,
     WNI_CFG_MAX_PSPOLL_IN_WMM_UAPSD_PS_MODE_STAMAX,
     WNI_CFG_MAX_PSPOLL_IN_WMM_UAPSD_PS_MODE_STADEF},
    {WNI_CFG_MAX_UAPSD_INACTIVITY_INTERVALS,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | CFG_CTL_NTF_HAL | SEM_7,
     WNI_CFG_MAX_UAPSD_INACTIVITY_INTERVALS_STAMIN,
     WNI_CFG_MAX_UAPSD_INACTIVITY_INTERVALS_STAMAX,
     WNI_CFG_MAX_UAPSD_INACTIVITY_INTERVALS_STADEF},
    {WNI_CFG_ENABLE_DYNAMIC_WMMPS,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | CFG_CTL_NTF_HAL | SEM_7,
     WNI_CFG_ENABLE_DYNAMIC_WMMPS_STAMIN,
     WNI_CFG_ENABLE_DYNAMIC_WMMPS_STAMAX,
     WNI_CFG_ENABLE_DYNAMIC_WMMPS_STADEF},
    {WNI_CFG_BURST_MODE_BE_TXOP_VALUE,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | CFG_CTL_NTF_HAL | SEM_7,
     WNI_CFG_BURST_MODE_BE_TXOP_VALUE_STAMIN,
     WNI_CFG_BURST_MODE_BE_TXOP_VALUE_STAMAX,
     WNI_CFG_BURST_MODE_BE_TXOP_VALUE_STADEF},
    {WNI_CFG_ENABLE_DYNAMIC_RA_START_RATE,
     CFG_CTL_VALID | CFG_CTL_RE | CFG_CTL_WE | CFG_CTL_INT | CFG_CTL_NTF_HAL | SEM_7,
     WNI_CFG_ENABLE_DYNAMIC_RA_START_RATE_STAMIN,
     WNI_CFG_ENABLE_DYNAMIC_RA_START_RATE_STAMAX,
     WNI_CFG_ENABLE_DYNAMIC_RA_START_RATE_STADEF},

};

tAniSirCfgStaticString cfgStaticString[CFG_MAX_STATIC_STRING] =
{

{WNI_CFG_STA_ID,
 WNI_CFG_STA_ID_LEN,
 6,
 {0x22, 0x22, 0x44, 0x44, 0x33, 0x33}},
{WNI_CFG_SSID,
 WNI_CFG_SSID_LEN,
 10,
 {1, 2, 3, 4, 5, 6, 7, 8, 9, 0}},
{WNI_CFG_WEP_DEFAULT_KEY_1,
 WNI_CFG_WEP_DEFAULT_KEY_1_LEN,
 0,
 {0}},
{WNI_CFG_WEP_DEFAULT_KEY_2,
 WNI_CFG_WEP_DEFAULT_KEY_2_LEN,
 0,
 {0}},
{WNI_CFG_WEP_DEFAULT_KEY_3,
 WNI_CFG_WEP_DEFAULT_KEY_3_LEN,
 0,
 {0}},
{WNI_CFG_WEP_DEFAULT_KEY_4,
 WNI_CFG_WEP_DEFAULT_KEY_4_LEN,
 0,
 {0}},
{WNI_CFG_SUPPORTED_RATES_11B,
 WNI_CFG_SUPPORTED_RATES_11B_LEN,
 4,
 {2, 4, 11, 22}},
{WNI_CFG_SUPPORTED_RATES_11A,
 WNI_CFG_SUPPORTED_RATES_11A_LEN,
 8,
 {12, 18, 24, 36, 48, 72, 96, 108}},
{WNI_CFG_OPERATIONAL_RATE_SET,
 WNI_CFG_OPERATIONAL_RATE_SET_LEN,
 0,
 {0}},
{WNI_CFG_EXTENDED_OPERATIONAL_RATE_SET,
 WNI_CFG_EXTENDED_OPERATIONAL_RATE_SET_LEN,
 0,
 {0}},
{WNI_CFG_PROPRIETARY_OPERATIONAL_RATE_SET,
 WNI_CFG_PROPRIETARY_OPERATIONAL_RATE_SET_LEN,
 4,
 {1, 3, 5, 7}},
{WNI_CFG_BSSID,
 WNI_CFG_BSSID_LEN,
 6,
 {0x22, 0x22, 0x11, 0x11, 0x33, 0x33}},
{WNI_CFG_VALID_CHANNEL_LIST,
 WNI_CFG_VALID_CHANNEL_LIST_LEN,
 55,
{36, 40, 44, 48, 52, 56, 60, 64, 1, 6, 11, 34, 38, 42, 46, 2, 3, 4, 5, 7, 8,
 9, 10, 12, 13, 14, 100, 104, 108, 112, 116, 120, 124, 128, 132, 136, 140,
 149, 151, 153, 155, 157, 159, 161, 50, 54, 58, 62, 240, 242, 244, 246, 248,
  250, 252}},

{WNI_CFG_MANUFACTURER_OUI,
 WNI_CFG_MANUFACTURER_OUI_LEN,
 3,
 {0x0, 0xa, 0xf5}},
{WNI_CFG_MANUFACTURER_NAME,
 WNI_CFG_MANUFACTURER_NAME_LEN,
 8,
 {0x51, 0x75, 0x61, 0x6c, 0x63, 0x6f, 0x6d, 0x6d}},
{WNI_CFG_MODEL_NUMBER,
 WNI_CFG_MODEL_NUMBER_LEN,
 6,
 {0x4d, 0x4e, 0x31, 0x32, 0x33, 0x34}},
{WNI_CFG_MODEL_NAME,
 WNI_CFG_MODEL_NAME_LEN,
 7,
 {0x57, 0x46, 0x52, 0x34, 0x30, 0x33, 0x31}},
{WNI_CFG_MANUFACTURER_PRODUCT_NAME,
 WNI_CFG_MANUFACTURER_PRODUCT_NAME_LEN,
 6,
 {0x31, 0x31, 0x6e, 0x2d, 0x41, 0x50}},
{WNI_CFG_MANUFACTURER_PRODUCT_VERSION,
 WNI_CFG_MANUFACTURER_PRODUCT_VERSION_LEN,
 6,
 {0x53, 0x4e, 0x31, 0x32, 0x33, 0x34}},
{WNI_CFG_MAX_TX_POWER_2_4,
 WNI_CFG_MAX_TX_POWER_2_4_LEN,
 3,
 {0x1, 0xe, 0x14}},
{WNI_CFG_MAX_TX_POWER_5,
 WNI_CFG_MAX_TX_POWER_5_LEN,
 3,
 {0x24, 0x7e, 0x14}},
{WNI_CFG_AP_NODE_NAME,
 WNI_CFG_AP_NODE_NAME_LEN,
 0,
 {0}},
{WNI_CFG_COUNTRY_CODE,
 WNI_CFG_COUNTRY_CODE_LEN,
 0,
 {0}},
{WNI_CFG_EDCA_ANI_ACBK_LOCAL,
 WNI_CFG_EDCA_ANI_ACBK_LOCAL_LEN,
 17,
 {0x0, 0x7, 0x0, 0xf, 0x3, 0xff, 0x0, 0x0, 0x1f, 0x3, 0xff, 0x0, 0x0, 0xf, 0x3, 0xff, 0x0}},
{WNI_CFG_EDCA_ANI_ACBE_LOCAL,
 WNI_CFG_EDCA_ANI_ACBE_LOCAL_LEN,
 17,
 {0x0, 0x2, 0x0, 0xf, 0x3, 0xff, 0x64, 0x0, 0x1f, 0x3, 0xff, 0x64, 0x0, 0xf, 0x3, 0xff, 0x64}},
{WNI_CFG_EDCA_ANI_ACVI_LOCAL,
 WNI_CFG_EDCA_ANI_ACVI_LOCAL_LEN,
 17,
 {0x0, 0x2, 0x0, 0x7, 0x0, 0xf, 0xc8, 0x0, 0xf, 0x0, 0x1f, 0xbc, 0x0, 0x7, 0x0, 0xf, 0xc8}},
{WNI_CFG_EDCA_ANI_ACVO_LOCAL,
 WNI_CFG_EDCA_ANI_ACVO_LOCAL_LEN,
 17,
 {0x0, 0x2, 0x0, 0x3, 0x0, 0x7, 0x64, 0x0, 0x7, 0x0, 0xf, 0x66, 0x0, 0x3, 0x0, 0x7, 0x64}},
{WNI_CFG_EDCA_ANI_ACBK,
 WNI_CFG_EDCA_ANI_ACBK_LEN,
 17,
 {0x0, 0x7, 0x0, 0xf, 0x3, 0xff, 0x0, 0x0, 0x1f, 0x3, 0xff, 0x0, 0x0, 0xf, 0x3, 0xff, 0x0}},
{WNI_CFG_EDCA_ANI_ACBE,
 WNI_CFG_EDCA_ANI_ACBE_LEN,
 17,
 {0x0, 0x2, 0x0, 0xf, 0x3, 0xff, 0x64, 0x0, 0x1f, 0x3, 0xff, 0x64, 0x0, 0xf, 0x3, 0xff, 0x64}},
{WNI_CFG_EDCA_ANI_ACVI,
 WNI_CFG_EDCA_ANI_ACVI_LEN,
 17,
 {0x0, 0x2, 0x0, 0x7, 0x0, 0xf, 0xc8, 0x0, 0xf, 0x0, 0x1f, 0xbc, 0x0, 0x7, 0x0, 0xf, 0xc8}},
{WNI_CFG_EDCA_ANI_ACVO,
 WNI_CFG_EDCA_ANI_ACVO_LEN,
 17,
 {0x0, 0x2, 0x0, 0x3, 0x0, 0x7, 0x64, 0x0, 0x7, 0x0, 0xf, 0x66, 0x0, 0x3, 0x0, 0x7, 0x64}},
{WNI_CFG_EDCA_WME_ACBK_LOCAL,
 WNI_CFG_EDCA_WME_ACBK_LOCAL_LEN,
 17,
 {0x0, 0x7, 0x0, 0xf, 0x3, 0xff, 0x0, 0x0, 0x1f, 0x3, 0xff, 0x0, 0x0, 0xf, 0x3, 0xff, 0x0}},
{WNI_CFG_EDCA_WME_ACBE_LOCAL,
 WNI_CFG_EDCA_WME_ACBE_LOCAL_LEN,
 17,
 {0x0, 0x3, 0x0, 0xf, 0x0, 0x3f, 0x0, 0x0, 0x1f, 0x3, 0xff,0x0, 0x0, 0xf, 0x0, 0x3f, 0x0}},
{WNI_CFG_EDCA_WME_ACVI_LOCAL,
 WNI_CFG_EDCA_WME_ACVI_LOCAL_LEN,
 17,
 {0x0, 0x1, 0x0, 0x7, 0x0, 0xf, 0x5e, 0x0, 0x7, 0x0, 0xf, 0xbc, 0x0, 0x7, 0x0, 0xf, 0x5e}},
{WNI_CFG_EDCA_WME_ACVO_LOCAL,
 WNI_CFG_EDCA_WME_ACVO_LOCAL_LEN,
 17,
 {0x0, 0x1, 0x0, 0x3, 0x0, 0x7, 0x2f, 0x0, 0x3, 0x0, 0x7, 0x66, 0x0, 0x3, 0x0, 0x7, 0x2f}},
{WNI_CFG_EDCA_WME_ACBK,
 WNI_CFG_EDCA_WME_ACBK_LEN,
 17,
 {0x0, 0x7, 0x0, 0xf, 0x3, 0xff, 0x0, 0x0, 0xf, 0x3, 0xff, 0x0, 0x0, 0xf, 0x3, 0xff, 0x0}},
{WNI_CFG_EDCA_WME_ACBE,
 WNI_CFG_EDCA_WME_ACBE_LEN,
 17,
 {0x0, 0x3, 0x0, 0xf, 0x3, 0xff, 0x0, 0x0, 0xf, 0x3, 0xff, 0x0, 0x0, 0xf, 0x3, 0xff, 0x0}},
{WNI_CFG_EDCA_WME_ACVI,
 WNI_CFG_EDCA_WME_ACVI_LEN,
 17,
 {0x0, 0x2, 0x0, 0x7, 0x0, 0xf, 0x5e, 0x0, 0x7, 0x0, 0xf, 0xbc, 0x0, 0x7, 0x0, 0xf, 0x5e}},
{WNI_CFG_EDCA_WME_ACVO,
 WNI_CFG_EDCA_WME_ACVO_LEN,
 17,
 {0x0, 0x2, 0x0, 0x3, 0x0, 0x7, 0x2f, 0x0, 0x3, 0x0, 0x7, 0x66, 0x0, 0x3, 0x0, 0x7, 0x2f}},
{WNI_CFG_EDCA_TIT_DEMO_ACBK_LOCAL,
 WNI_CFG_EDCA_TIT_DEMO_ACBK_LOCAL_LEN,
 17,
 {0x0, 0x7, 0x0, 0x8, 0x0, 0xff, 0xc8, 0x0, 0x1f, 0x0, 0xff, 0xc8, 0x0, 0x8, 0x0, 0xff, 0xc8}},
{WNI_CFG_EDCA_TIT_DEMO_ACBE_LOCAL,
 WNI_CFG_EDCA_TIT_DEMO_ACBE_LOCAL_LEN,
 17,
 {0x0, 0x2, 0x0, 0x8, 0x0, 0xff, 0xc8, 0x0, 0x1f, 0x0, 0xff, 0xc8, 0x0, 0x8, 0x0, 0xff, 0xc8}},
{WNI_CFG_EDCA_TIT_DEMO_ACVI_LOCAL,
 WNI_CFG_EDCA_TIT_DEMO_ACVI_LOCAL_LEN,
 17,
 {0x0, 0x2, 0x0, 0x8, 0x0, 0xff, 0xc8, 0x0, 0x8, 0x0, 0xff, 0xc8, 0x0, 0x8, 0x0, 0xff, 0xc8}},
{WNI_CFG_EDCA_TIT_DEMO_ACVO_LOCAL,
 WNI_CFG_EDCA_TIT_DEMO_ACVO_LOCAL_LEN,
 17,
 {0x0, 0x2, 0x0, 0x8, 0x0, 0xff, 0xc8, 0x0, 0x8, 0x0, 0xff, 0xc8, 0x0, 0x8, 0x0, 0xff, 0xc8}},
{WNI_CFG_EDCA_TIT_DEMO_ACBK,
 WNI_CFG_EDCA_TIT_DEMO_ACVO_LOCAL_LEN,
 17,
 {0x0, 0x7, 0x0, 0x8, 0x0, 0xff, 0xc8, 0x0, 0x8, 0x0, 0xff, 0xc8, 0x0,0x8, 0x0, 0xff, 0xc8}},
{WNI_CFG_EDCA_TIT_DEMO_ACBE,
 WNI_CFG_EDCA_TIT_DEMO_ACBE_LEN,
 17,
 {0x0, 0x2, 0x0, 0x8, 0x0, 0xff, 0xc8, 0x0, 0x8, 0x0, 0xff, 0xc8, 0x0, 0x8, 0x0, 0xff, 0xc8}},
{WNI_CFG_EDCA_TIT_DEMO_ACVI,
 WNI_CFG_EDCA_TIT_DEMO_ACVI_LEN,
 17,
 {0x0, 0x2, 0x0, 0x8, 0x0, 0xff, 0xc8, 0x0, 0x8, 0x0, 0xff, 0xc8, 0x0, 0x8, 0x0, 0xff, 0xc8}},
{WNI_CFG_EDCA_TIT_DEMO_ACVO,
 WNI_CFG_EDCA_TIT_DEMO_ACVO_LEN,
 17,
 {0x0, 0x2, 0x0, 0x8, 0x0, 0xff, 0xc8, 0x0, 0x8, 0x0, 0xff, 0xc8, 0x0, 0x8, 0x0, 0xff, 0xc8}},
{WNI_CFG_RADAR_CHANNEL_LIST,
 WNI_CFG_RADAR_CHANNEL_LIST_LEN,
 15,
 {0x34, 0x38, 0x3c, 0x40, 0x64, 0x68, 0x6c, 0x70, 0x74, 0x78, 0x7c, 0x80, 0x84, 0x88, 0x8c}},
{WNI_CFG_SCAN_CONTROL_LIST,
 WNI_CFG_SCAN_CONTROL_LIST_LEN,
 114,
 {0x1, 0x1, 0x2, 0x1, 0x3, 0x1, 0x4, 0x1, 0x5, 0x1, 0x6, 0x1, 0x7, 0x1, 0x8,
  0x1, 0x9,0x1, 0xa, 0x1, 0xb, 0x1, 0xc, 0x1, 0xd, 0x1, 0xe, 0x1, 0x22, 0x1,
  0x24, 0x1, 0x26, 0x1, 0x28,0x1, 0x2a, 0x1, 0x2c, 0x1, 0x2e, 0x1, 0x30, 0x1,
  0x32, 0x1, 0x34, 0x0, 0x36, 0x0, 0x38, 0x0,0x3a, 0x0, 0x3c, 0x0, 0x3e, 0x0,
  0x40, 0x0, 0x64, 0x0, 0x68, 0x0, 0x6c, 0x0, 0x70, 0x0, 0x74,0x0, 0x78, 0x0,
  0x7c, 0x0, 0x80, 0x0, 0x84, 0x0, 0x88, 0x0, 0x8c, 0x0, 0x90, 0x0,0x95, 0x1,
  0x97, 0x1, 0x99, 0x1, 0x9b, 0x1, 0x9d, 0x1, 0x9f, 0x1, 0xa1, 0x1,0xa5, 0x1,
  0xf0, 0x1, 0xf2, 0x1, 0xf4, 0x1, 0xf6, 0x1, 0xf8, 0x1, 0xfa, 0x1, 0xfc, 0x1}},
{WNI_CFG_SUPPORTED_MCS_SET,
 WNI_CFG_SUPPORTED_MCS_SET_LEN,
 16,
 {0xff, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}},
{WNI_CFG_BASIC_MCS_SET,
 WNI_CFG_BASIC_MCS_SET_LEN,
 16,
 {0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}},
{WNI_CFG_CURRENT_MCS_SET,
 WNI_CFG_CURRENT_MCS_SET_LEN,
 16,
 {0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0}},
{WNI_CFG_BG_SCAN_CHANNEL_LIST,
 WNI_CFG_BG_SCAN_CHANNEL_LIST_LEN,
 55,
 {0x24, 0x28, 0x2c, 0x30, 0x34, 0x38, 0x3c,0x40, 0x1, 0x6, 0xb, 0x22, 0x26,
  0x2a, 0x2e, 0x2,  0x3, 0x4, 0x5, 0x7, 0x8, 0x9, 0xa, 0xc, 0xd, 0xe, 0x64,
  0x68, 0x6c, 0x70, 0x74,0x78, 0x7c, 0x80, 0x84, 0x88, 0x8c, 0x95, 0x97,
  0x99, 0x9b, 0x9d, 0x9f, 0xa1, 0x32, 0x36,0x3a, 0x3e, 0xf0, 0xf2, 0xf4,
  0xf6, 0xf8, 0xfa, 0xfc}},
{WNI_CFG_PROBE_REQ_ADDNIE_DATA,
 WNI_CFG_PROBE_REQ_ADDNIE_DATA_LEN,
 0,
 {0}},
{WNI_CFG_PROBE_RSP_ADDNIE_DATA1,
 WNI_CFG_PROBE_RSP_ADDNIE_DATA1_LEN,
 0,
 {0}},
{WNI_CFG_PROBE_RSP_ADDNIE_DATA2,
 WNI_CFG_PROBE_RSP_ADDNIE_DATA2_LEN,
 0,
 {0}},
{WNI_CFG_PROBE_RSP_ADDNIE_DATA3,
 WNI_CFG_PROBE_RSP_ADDNIE_DATA3_LEN,
 0,
 {0}},
{WNI_CFG_ASSOC_RSP_ADDNIE_DATA,
 WNI_CFG_ASSOC_RSP_ADDNIE_DATA_LEN,
 0,
 {0}},
{WNI_CFG_PROBE_REQ_ADDNP2PIE_DATA,
 WNI_CFG_PROBE_REQ_ADDNP2PIE_DATA_LEN,
 0,
 {0}},
{WNI_CFG_PROBE_RSP_BCN_ADDNIE_DATA,
 WNI_CFG_PROBE_RSP_BCN_ADDNIE_DATA_LEN,
 0,
 {0}},
{WNI_CFG_WPS_UUID,
 WNI_CFG_WPS_UUID_LEN,
 6,
 {0xa, 0xb, 0xc, 0xd, 0xe, 0xf}}
};

/*--------------------------------------------------------------------*/
/* Static function prototypes                                         */
/*--------------------------------------------------------------------*/
static void ProcDnldRsp        (tpAniSirGlobal, tANI_U16, tANI_U32*);
static void ProcGetReq         (tpAniSirGlobal, tANI_U16, tANI_U32*);
static void ProcSetReq         (tpAniSirGlobal, tANI_U16, tANI_U32*);
static void ProcSetReqNoRsp    (tpAniSirGlobal, tANI_U16, tANI_U32*);

static tANI_U8 CheckParam(tpAniSirGlobal, tANI_U16, tANI_U32, tANI_U32, tANI_U32*);
static void GetStrValue(tANI_U8*, tANI_U8*, tANI_U32);


/*--------------------------------------------------------------------*/
/* Module global variables                                            */
/*--------------------------------------------------------------------*/

// CFG function table
void    (*gCfgFunc[])(tpAniSirGlobal, tANI_U16, tANI_U32*) =
{ ProcDnldRsp,
    ProcGetReq,
    ProcSetReq,
    ProcSetReqNoRsp
};

/**---------------------------------------------------------------------
 * cfgProcessMbMsg()
 *
 *FUNCTION:
 * CFG mailbox message processing function.
 *
 *LOGIC:
 *
 *ASSUMPTIONS:
 * None.
 *
 *NOTE:
 *
 * @param pMsg    Message pointer
 *
 * @return None.
 *
 */
void
cfgProcessMbMsg(tpAniSirGlobal pMac, tSirMbMsg *pMsg)
{
    tANI_U16    index;
    tANI_U16    len;
    tANI_U32   *pParam;

    // Use type[7:0] as index to function table
    index = CFG_GET_FUNC_INDX(pMsg->type);

    if (index >= (sizeof(gCfgFunc) / sizeof(gCfgFunc[0])))
    {
        vos_mem_free(pMsg);
        return;
    }
    len    = pMsg->msgLen - WNI_CFG_MB_HDR_LEN;
    pParam = ((tANI_U32*)pMsg) + 1;

    // Call processing function
    gCfgFunc[index](pMac, len, pParam);

    // Free up buffer
    vos_mem_free(pMsg);

} /*** end cfgProcessMbMsg() ***/

/**---------------------------------------------------------------------
 * ProcDnldRsp()
 *
 * FUNCTION:
 * This function processes CFG_DNLD_RSP message from host.
 *
 * LOGIC:
 *
 * ASSUMPTIONS:
 *
 * NOTE:
 *
 * @param length:  message length
 * @param pParam:  parameter list pointer
 *
 * @return None
 *
 */
static void
ProcDnldRsp(tpAniSirGlobal pMac, tANI_U16 length, tANI_U32 *pParam)
{
    tANI_S32    i;

    tANI_U32    expLen, retVal, bufStart, bufEnd;
    tANI_U32    *pSrc, *pDst, *pDstEnd;
    tANI_U32    strSize, j;
    tANI_U8     pStr[CFG_MAX_STR_LEN];
    tpCfgBinHdr pHdr;
    tANI_U32    logLevel;
    tSirMsgQ    mmhMsg;

    // First Dword must contain the AP or STA magic dword
    PELOGW(cfgLog(pMac, LOGW, FL("CFG size %d bytes MAGIC dword is 0x%x"),
           length, sirReadU32N((tANI_U8*)pParam) );)

    // if the string is not correct, return failure
        if (*pParam == CFG_STA_MAGIC_DWORD) {}




    else
    {
        PELOGE(cfgLog(pMac, LOGE, FL("Invalid magic dword 0x%x"),sirReadU32N((tANI_U8*)pParam) );)
        retVal = WNI_CFG_INVALID_LEN;
        goto end;
    }

    pParam++;
    length -= 4;

    // Verify message length
    {
        pMac->cfg.gCfgMaxIBufSize = CFG_STA_IBUF_MAX_SIZE;
        pMac->cfg.gCfgMaxSBufSize = CFG_STA_SBUF_MAX_SIZE;
    }

    // Parse the Cfg header
    pHdr = (tpCfgBinHdr) pParam;
    pParam += (sizeof(tCfgBinHdr) >> 2);
    PELOGW(cfgLog(pMac, LOGW, FL("CFG hdr totParams %d intParams %d strBufSize %d/%d"),
           pHdr->controlSize, pHdr->iBufSize, pHdr->sBufSize, pMac->cfg.gCfgMaxSBufSize);)

    expLen = ((CFG_PARAM_MAX_NUM + 3 * pMac->cfg.gCfgMaxIBufSize) << 2) +
             pHdr->sBufSize + sizeof(tCfgBinHdr);

    if (length != expLen)
    {
        PELOGE(cfgLog(pMac, LOGE, FL("<CFG> DNLD_RSP invalid length %d (exp %d)"),
               length, expLen);)
        retVal = WNI_CFG_INVALID_LEN;
        goto end;
    }


    if (pHdr->controlSize != CFG_PARAM_MAX_NUM)
    {
        PELOGE(cfgLog(pMac, LOGE, FL("<CFG> Total parameter count mismatch"));)
        retVal = WNI_CFG_INVALID_LEN;
        goto end;
    }

    if (pHdr->iBufSize != pMac->cfg.gCfgMaxIBufSize)
    {
        PELOGE(cfgLog(pMac, LOGE, FL("<CFG> Integer parameter count mismatch"));)
        retVal = WNI_CFG_INVALID_LEN;
        goto end;
    }

    // Copy control array
    pDst = (tANI_U32*)pMac->cfg.gCfgEntry;
    pDstEnd = pDst + CFG_PARAM_MAX_NUM;
    pSrc = pParam;
    while (pDst < pDstEnd)
    {
        *pDst++ = *pSrc++;
    }
    // Copy default values
    pDst = pMac->cfg.gCfgIBuf;
    pDstEnd = pDst + pMac->cfg.gCfgMaxIBufSize;
    while (pDst < pDstEnd)
    {
        *pDst++ = *pSrc++;
    }

    // Copy min values
    pDst = pMac->cfg.gCfgIBufMin;
    pDstEnd = pDst + pMac->cfg.gCfgMaxIBufSize;
    while (pDst < pDstEnd)
    {
        *pDst++ = *pSrc++;
    }

    // Copy max values
    pDst = pMac->cfg.gCfgIBufMax;
    pDstEnd = pDst + pMac->cfg.gCfgMaxIBufSize;
    while (pDst < pDstEnd)
    {
        *pDst++ = *pSrc++;
    }

    for (i=0; i<pMac->cfg.gCfgMaxIBufSize; i++)
        if (pMac->cfg.gCfgIBuf[i] < pMac->cfg.gCfgIBufMin[i] ||
            pMac->cfg.gCfgIBuf[i] > pMac->cfg.gCfgIBufMax[i])
        {
            PELOGE(cfgLog(pMac, LOGE, FL("cfg id %d Invalid def value %d "
                            "min %d max %d"),
                   i, pMac->cfg.gCfgIBuf[i], pMac->cfg.gCfgIBufMin[i],
                   pMac->cfg.gCfgIBufMax[i]);)
        }

    // Calculate max string buffer lengths for all string parameters
    bufEnd = pMac->cfg.gCfgMaxSBufSize;
    for (i = CFG_PARAM_MAX_NUM - 1; i >= 0; i--)
    {
        if ((pMac->cfg.gCfgEntry[i].control & CFG_CTL_INT) != 0)
            continue;

        if ((pMac->cfg.gCfgEntry[i].control & CFG_CTL_VALID) == 0)
            continue;

        bufStart = pMac->cfg.gCfgEntry[i].control & CFG_BUF_INDX_MASK;
        pMac->cfg.gCfgSBuf[bufStart] = (tANI_U8)(bufEnd - bufStart - 2);

       PELOG1(cfgLog(pMac, LOG1, FL("id %d max %d bufStart %d bufEnd %d"),
               i, pMac->cfg.gCfgSBuf[bufStart], bufStart, bufEnd);)

        bufEnd = bufStart;
    }

    // Initialize string defaults
    strSize = pHdr->sBufSize;
    while (strSize)
    {
        tANI_U32 paramId, paramLen, paramLenCeil4;

        if (strSize < 4)
        {
            PELOGE(cfgLog(pMac, LOGE, FL("Error parsing str defaults, rem %d bytes"), strSize);)
            retVal = WNI_CFG_INVALID_LEN;
            goto end;
        }
        paramId = *pSrc >> 16;
        paramLen = *pSrc & 0xff;
        pSrc++;
        strSize -= 4;

        paramLenCeil4 = ((paramLen + 3) >> 2);
        if (strSize < paramLenCeil4 << 2)
        {
            PELOGE(cfgLog(pMac, LOGE, FL("Error parsing str defaults, rem %d bytes"), strSize);)
            PELOGE(cfgLog(pMac, LOGE, FL("param id %d len %d bytes"), paramId, paramLen);)
            retVal = WNI_CFG_INVALID_LEN;
            goto end;
        }
        for (j=0; j < paramLenCeil4; j++)
        {
            pStr[4*j] = (tANI_U8) (*pSrc >> 24) & 0xff;
            pStr[4*j+1] = (tANI_U8) (*pSrc >> 16) & 0xff;
            pStr[4*j+2] = (tANI_U8) (*pSrc >> 8) & 0xff;
            pStr[4*j+3] = (tANI_U8) (*pSrc) & 0xff;

            pSrc++;
            strSize -= 4;
        }

        PELOG1(cfgLog(pMac, LOG1, FL("set str id %d len %d"), paramId, paramLen);)

        if (cfgSetStr(pMac, (tANI_U16) paramId, pStr, paramLen) != eSIR_SUCCESS)
        {
            PELOGE(cfgLog(pMac, LOGE, FL("Error setting str default param %d len %d"), paramId, paramLen);)
            retVal = WNI_CFG_INVALID_LEN;
            goto end;
        }
    }

    // Set the default log level based on config
    wlan_cfgGetInt(pMac, WNI_CFG_LOG_LEVEL, &logLevel);
    for (i = 0; i < LOG_ENTRY_NUM; i++)
        pMac->utils.gLogEvtLevel[i] = pMac->utils.gLogDbgLevel[i] = logLevel;

    // Set status to READY
    pMac->cfg.gCfgStatus = CFG_SUCCESS;
    retVal = WNI_CFG_SUCCESS;
    PELOG1(cfgLog(pMac, LOG1, "<CFG> Completed successfully");)

    end:

    if ( retVal != WNI_CFG_SUCCESS )
        pMac->cfg.gCfgStatus = CFG_FAILURE;

    // Send response message to host
    pMac->cfg.gParamList[WNI_CFG_DNLD_CNF_RES] = retVal;
    cfgSendHostMsg(pMac, WNI_CFG_DNLD_CNF, WNI_CFG_DNLD_CNF_LEN,
                   WNI_CFG_DNLD_CNF_NUM, pMac->cfg.gParamList, 0, 0);

    // Notify WDA that the config has downloaded
    mmhMsg.type = SIR_CFG_DOWNLOAD_COMPLETE_IND;
    mmhMsg.bodyptr = NULL;
    mmhMsg.bodyval = 0;

    MTRACE(macTraceMsgTx(pMac, NO_SESSION, mmhMsg.type));
    if (wdaPostCtrlMsg(pMac, &mmhMsg) != eSIR_SUCCESS)
    {
        PELOGE(cfgLog(pMac, LOGE, FL("WDAPostMsgApi failed!"));)
    }

} /*** end procDnldRsp() ***/


/**---------------------------------------------------------------------
 * ProcGetReq()
 *
 * FUNCTION:
 * This function processes CFG_GET_REQ message from host.
 *
 * LOGIC:
 *
 * ASSUMPTIONS:
 *
 * NOTE:
 * For every parameter ID specified on the list, CFG will send a separate
 * CFG_GET_RSP back to host.
 *
 * @param length:  message length
 * @param pParam:  parameter list pointer
 *
 * @return None
 *
 */
static void
ProcGetReq(tpAniSirGlobal pMac, tANI_U16 length, tANI_U32 *pParam)
{
    tANI_U16    cfgId, i;
    tANI_U32    value, valueLen, result;
    tANI_U32    *pValue;

    PELOG1(cfgLog(pMac, LOG1, FL("Rcvd cfg get request %d bytes"), length);)
    for (i=0; i<length/4; i++)
        PELOG2(cfgLog(pMac, LOG2, FL("[%2d] 0x%08x"), i, pParam[i]);)

    if (!pMac->cfg.gCfgStatus)
    {
        cfgId = (tANI_U16)sirReadU32N((tANI_U8*)pParam);
        PELOGE(cfgLog(pMac, LOGE, FL("CFG not ready, param %d"), cfgId);)
        pMac->cfg.gParamList[WNI_CFG_GET_RSP_RES]  = WNI_CFG_NOT_READY;
        pMac->cfg.gParamList[WNI_CFG_GET_RSP_PID]  = cfgId;
        pMac->cfg.gParamList[WNI_CFG_GET_RSP_PLEN] = 0;
        cfgSendHostMsg(pMac, WNI_CFG_GET_RSP, WNI_CFG_GET_RSP_PARTIAL_LEN,
                       WNI_CFG_GET_RSP_NUM, pMac->cfg.gParamList, 0, 0);
    }
    else
    {
        // Process all parameter ID's on the list
        while (length >= sizeof(tANI_U32))
        {
            cfgId = (tANI_U16)*pParam++;
            pValue   = 0;
            valueLen = 0;

            PELOG1(cfgLog(pMac, LOG1, FL("Cfg get param %d"), cfgId);)

            // Check for valid parameter ID, etc...
            if (CheckParam(pMac, cfgId, CFG_CTL_RE, WNI_CFG_WO_PARAM, &result))
            {
                if ((pMac->cfg.gCfgEntry[cfgId].control & CFG_CTL_INT) != 0)
                {
                    // Get integer parameter
                    result = (wlan_cfgGetInt(pMac, cfgId, &value) == eSIR_SUCCESS ?
                              WNI_CFG_SUCCESS : WNI_CFG_OTHER_ERROR);
                    pValue   = &value;
                    valueLen = sizeof(tANI_U32);
                }
                else
                {
                    // Get string parameter
                    valueLen = sizeof(pMac->cfg.gSBuffer);
                    result = (wlan_cfgGetStr(pMac, cfgId, pMac->cfg.gSBuffer, &valueLen)
                              == eSIR_SUCCESS ?
                              WNI_CFG_SUCCESS : WNI_CFG_OTHER_ERROR);
                    pValue = (tANI_U32*)pMac->cfg.gSBuffer;
                }
            }
            else
            {
                PELOGE(cfgLog(pMac, LOGE, FL("Check param failed, param %d"), cfgId);)
                result = WNI_CFG_INVALID_LEN;
            }

            // Send response message to host
            pMac->cfg.gParamList[WNI_CFG_GET_RSP_RES]  = result;
            pMac->cfg.gParamList[WNI_CFG_GET_RSP_PID]  = cfgId;
            pMac->cfg.gParamList[WNI_CFG_GET_RSP_PLEN] = valueLen;

            // We need to round up buffer length to word-increment
            valueLen = (((valueLen + 3) >> 2) << 2);
            cfgSendHostMsg(pMac, WNI_CFG_GET_RSP,
                           WNI_CFG_GET_RSP_PARTIAL_LEN + valueLen,
                           WNI_CFG_GET_RSP_NUM, pMac->cfg.gParamList, valueLen, pValue);

            // Decrement length
            length -= sizeof(tANI_U32);
        }
    }

} /*** end procGetReq() ***/



/**---------------------------------------------------------------------
 * ProcSetReqInternal()
 *
 * FUNCTION:
 * This function processes CFG_SET_REQ message from host.
 *
 * LOGIC:
 *
 * ASSUMPTIONS:
 * - The message content is coded in TLV format.
 * - For string parameter, the length field is byte accurate.  However,
 *   the next TLV set will begin on the next word boundary.
 *
 * NOTE:
 * - For every parameter ID specified on the list, CFG will send a separate
 * CFG_SET_RSP back to host.
 *
 * @param length:  message length
 * @param pParam:  parameter list pointer
 * @param fRsp: whether to send response to host. TRUE means sending.
 * @return None
 *
 */
static void
ProcSetReqInternal(tpAniSirGlobal pMac, tANI_U16 length, tANI_U32 *pParam, tANI_BOOLEAN fRsp)
{
    tANI_U16    cfgId, valueLen, valueLenRoundedUp4;
    tANI_U32    value, result;

    PELOG1(cfgLog(pMac, LOG1, FL("Rcvd cfg set request %d bytes"), length);)
    //for (i=0; i<length/4; i++)
      //  PELOG2(cfgLog(pMac, LOG2, FL("[%2d] 0x%08x"), i, pParam[i]);)

    if (!pMac->cfg.gCfgStatus)
    {
        cfgId = (tANI_U16)sirReadU32N((tANI_U8*)pParam);
        PELOG1(cfgLog(pMac, LOGW, FL("CFG not ready, param %d"), cfgId);)
        pMac->cfg.gParamList[WNI_CFG_SET_CNF_RES] = WNI_CFG_NOT_READY;
        pMac->cfg.gParamList[WNI_CFG_SET_CNF_PID] = cfgId;
        if( fRsp )
        {
           cfgSendHostMsg(pMac, WNI_CFG_SET_CNF, WNI_CFG_SET_CNF_LEN,
                          WNI_CFG_SET_CNF_NUM, pMac->cfg.gParamList, 0, 0);
        }
    }
    else
    {
        // Process all TLVs in buffer
        while (length >= (sizeof(tANI_U32) * 2))
        {
            cfgId    = (tANI_U16) *pParam++;
            valueLen = (tANI_U16) *pParam++;
            length -= (sizeof(tANI_U32) * 2);
            // value length rounded up to a 4 byte multiple
            valueLenRoundedUp4 = (((valueLen + 3) >> 2) << 2);

            // Check for valid request before proceeding
            if (CheckParam(pMac, cfgId, CFG_CTL_WE, WNI_CFG_RO_PARAM, &result))
            {
                PELOG1(cfgLog(pMac, LOGW, (char *) gCfgParamName[cfgId]);)
                // Process integer parameter
                if ((pMac->cfg.gCfgEntry[cfgId].control & CFG_CTL_INT) != 0)
                {
                    // Set VALUE
                    if (valueLen != sizeof(tANI_U32))
                    {
                        PELOGE(cfgLog(pMac, LOGE, FL("Invalid value length %d in set param %d (tot %d)"),
                               valueLen, cfgId, length);)
                        result = WNI_CFG_INVALID_LEN;
                    }
                    else
                    {
                        value = *pParam;
                        PELOG1(cfgLog(pMac, LOGW, FL("Cfg set int %d len %d(%d) val %d"),
                               cfgId, valueLen, valueLenRoundedUp4, value);)
                        result = (cfgSetInt(pMac, cfgId, value) == eSIR_SUCCESS ?
                                  WNI_CFG_SUCCESS : WNI_CFG_OTHER_ERROR);
                        if (result == WNI_CFG_SUCCESS)
                        {
                            if (cfgNeedRestart(pMac, cfgId))
                            {
                                result = WNI_CFG_NEED_RESTART ;
                            }
                            else
                                if (cfgNeedReload(pMac, cfgId))
                                {
                                   result = WNI_CFG_NEED_RELOAD ;
                                }
                        }
                    }
                }
                // Process string parameter
                else
                {
                    if (valueLenRoundedUp4 > length)
                    {
                        PELOGE(cfgLog(pMac, LOGE, FL("Invalid string length %d"
                               "in set param %d (tot %d)"), valueLen,
                                                       cfgId, length);)
                        result = WNI_CFG_INVALID_LEN;
                    }
                    else
                    {
                        GetStrValue((tANI_U8*)pParam, pMac->cfg.gSBuffer, valueLen);
                        PELOG1(cfgLog(pMac, LOGW, FL("Cfg set str %d len %d(%d) bytes"),
                               cfgId, valueLen, valueLenRoundedUp4);)
                        result = (cfgSetStr(pMac, cfgId, pMac->cfg.gSBuffer, valueLen) == eSIR_SUCCESS ?
                                  WNI_CFG_SUCCESS : WNI_CFG_OTHER_ERROR);
                        if (result == WNI_CFG_SUCCESS)
                        {
                            if (cfgNeedRestart(pMac, cfgId))
                            {
                                result = WNI_CFG_NEED_RESTART ;
                            }
                            else
                                if (cfgNeedReload(pMac, cfgId))
                                {
                                   result = WNI_CFG_NEED_RELOAD ;
                                }
                        }
                    }
                }
            }
            else
            {
                PELOGE(cfgLog(pMac, LOGE, FL("Check param failed, param %d"), cfgId);)
                result = WNI_CFG_INVALID_LEN;
            }

            // Send confirm message to host
            pMac->cfg.gParamList[WNI_CFG_SET_CNF_RES] = result;
            pMac->cfg.gParamList[WNI_CFG_SET_CNF_PID] = cfgId;
            if( fRsp )
            {
                cfgSendHostMsg(pMac, WNI_CFG_SET_CNF, WNI_CFG_SET_CNF_LEN,
                               WNI_CFG_SET_CNF_NUM, pMac->cfg.gParamList, 0, 0);
            }
            else
            {
                PELOGW(cfgLog( pMac, LOG2, "  CFGID %d no rsp", cfgId);)
            }

            if (valueLenRoundedUp4 > length)
                length = 0;
            else
            {
                length -= valueLenRoundedUp4;
                pParam += (valueLenRoundedUp4 >> 2);
            }
        }
    }
}



static void
ProcSetReq(tpAniSirGlobal pMac, tANI_U16 length, tANI_U32 *pParam)
{
    ProcSetReqInternal( pMac, length, pParam, eANI_BOOLEAN_TRUE );
}

static void
ProcSetReqNoRsp(tpAniSirGlobal pMac, tANI_U16 length, tANI_U32 *pParam)
{
    ProcSetReqInternal( pMac, length, pParam, eANI_BOOLEAN_FALSE );
}



/**---------------------------------------------------------------------
 * CheckParam()
 *
 * FUNCTION:
 * This function is called to perform various check on a parameter.
 *
 * LOGIC:
 * -  If cfgId is out of bound or parameter is not valid, result
 *    WNI_CFG_INVALID_PID is returned at address specified in pResult.
 *
 * -  If specified 'flag' is not set in the parameter control entry,
 *    'failedResult' is returned at address specified in pResult.
 *
 * ASSUMPTIONS:
 * Since this function is used internally, 'pResult' is always valid.
 *
 * NOTE:
 *
 * @param None
 *
 * @return true:   Parameter is valid and matches checked condition \n
 * @return false:  Parameter either is not valid or does not match
 *                 checked condition.
 *
 */
static tANI_U8
CheckParam(tpAniSirGlobal pMac, tANI_U16 cfgId, tANI_U32 flag, tANI_U32 failedResult, tANI_U32 *pResult)
{
    // Check if parameter ID is out of bound
    if (cfgId >= CFG_PARAM_MAX_NUM)
    {
        PELOGE(cfgLog(pMac, LOGE, FL("Invalid param id %d"), cfgId);)
        *pResult = WNI_CFG_INVALID_PID;
    }
    else
    {
        // Check if parameter is valid
        if ((pMac->cfg.gCfgEntry[cfgId].control & CFG_CTL_VALID) == 0)
        {
            PELOGE(cfgLog(pMac, LOGE, FL("Param id %d not valid"), cfgId);)
            *pResult = WNI_CFG_INVALID_PID;
        }
        else
        {
            // Check control field against flag
            if ((pMac->cfg.gCfgEntry[cfgId].control & flag) == 0)
            {
                PELOGE(cfgLog(pMac, LOGE, FL("Param id %d wrong permissions %x"),
                       cfgId, pMac->cfg.gCfgEntry[cfgId].control);)
                *pResult = failedResult;
            }
            else
                return(true);
        }
    }
    return(false);

} /*** cfgParamCheck() ***/


/**---------------------------------------------------------------------
 * GetStrValue()
 *
 * FUNCTION:
 * This function copies a string value from the specified buffer.
 *
 * LOGIC:
 *
 * ASSUMPTIONS:
 *
 * NOTE:
 *
 * @param pBuf:    input data buffer
 * @param pValue:  address where data is returned
 * @param length:  number of bytes to copy
 *
 * @return None
 *
 */
static void
GetStrValue(tANI_U8 *pBuf, tANI_U8 *pValue, tANI_U32 length)
{
    tANI_U8     *pEnd;

    pEnd = pValue + length;
    while (pValue < pEnd)
        *pValue++ = *pBuf++;
} /*** end GetStrValue() ***/


/**---------------------------------------------------------------------
 * processCfgDownloadReq()
 *
 * FUNCTION: This function reads the cfgStatic array and
 * populates the cfg data structure.
 *
 * LOGIC:
 *
 * ASSUMPTIONS:
 *
 * NOTE:
 *
 * @param pMac: Pointer to Mac Structure
 *
 * @return None
 *
 */

void
processCfgDownloadReq(tpAniSirGlobal pMac)
{
    tANI_S32    i;
    tANI_U32    index;
    tANI_U8     *pDstTest, *pSrcTest;
    tANI_U8     len;
    tAniSirCfgStaticString *pStrCfg;
    tANI_U32    bufStart, bufEnd;
    tANI_U32    logLevel, retVal;
    tANI_U32 iCount = 0;
    tANI_U32 sCount = 0;


    for (i=0; i<CFG_PARAM_MAX_NUM ;i++)
    {
        if ((cfgStatic[i].control & CFG_CTL_VALID) != 0)
        {
            if (!(cfgStatic[i].control & CFG_CTL_INT))
            {
                pStrCfg = (tAniSirCfgStaticString *)cfgStatic[i].pStrData;
                if (pStrCfg == NULL)
                {
                    PELOGE(cfgLog(pMac, LOGE, FL("pStrCfg is NULL for CfigID : %d"),
                           i);)
                    continue;
                }
                index = sCount & CFG_BUF_INDX_MASK;
                sCount += pStrCfg->maxLen + 1 + 1;
            }
            else
            {
                index = iCount & CFG_BUF_INDX_MASK;
                iCount++;
            }
        }
        else
        {
            index = 0;
        }
        pMac->cfg.gCfgEntry[i].control = cfgStatic[i].control | index;
    }

    /*Fill the SBUF wih maxLength*/
     bufEnd = pMac->cfg.gCfgMaxSBufSize;
    for (i = CFG_PARAM_MAX_NUM - 1; i >= 0; i--)
    {
        if ((pMac->cfg.gCfgEntry[i].control & CFG_CTL_INT) != 0)
            continue;

        if ((pMac->cfg.gCfgEntry[i].control & CFG_CTL_VALID) == 0)
            continue;

        bufStart = pMac->cfg.gCfgEntry[i].control & CFG_BUF_INDX_MASK;
        pMac->cfg.gCfgSBuf[bufStart] = (tANI_U8)(bufEnd - bufStart - 2);

        PELOG1(cfgLog(pMac, LOG1, FL("id %d max %d bufStart %d bufEnd %d"),
               i, pMac->cfg.gCfgSBuf[bufStart], bufStart, bufEnd);)
        bufEnd = bufStart;
    }

    for(i=0; i<CFG_PARAM_MAX_NUM ;i++)
    {
        index = pMac->cfg.gCfgEntry[i].control & CFG_BUF_INDX_MASK;

        if ((pMac->cfg.gCfgEntry[i].control & CFG_CTL_INT) != 0)
        {
            pMac->cfg.gCfgIBufMin[index] = cfgStatic[i].cfgIMin;
            pMac->cfg.gCfgIBufMax[index] = cfgStatic[i].cfgIMax;
            pMac->cfg.gCfgIBuf[index]    = cfgStatic[i].cfgIVal;
        }
        else
        {
            tANI_U8 maxSavedLen;
            if ((pMac->cfg.gCfgEntry[i].control & CFG_CTL_VALID) == 0)
                continue;
            if (index >= CFG_STA_SBUF_MAX_SIZE)
                continue;

            pDstTest = &pMac->cfg.gCfgSBuf[index];
            pStrCfg = (tAniSirCfgStaticString *)cfgStatic[i].pStrData;
            pSrcTest = pStrCfg->data;
            if ((pDstTest == NULL) || (pStrCfg == NULL) || (pSrcTest == NULL))
                continue;
            maxSavedLen = *pDstTest;
            len = pStrCfg->length;
            if (len > maxSavedLen)
                continue;
            *pDstTest++ = pStrCfg->maxLen;
            *pDstTest++ = len;
            while(len)
            {
                *pDstTest++ = *pSrcTest++;
                len--;
            }
        }
    }

    // Set the default log level based on config
    wlan_cfgGetInt(pMac, WNI_CFG_LOG_LEVEL, &logLevel);
    for (i = 0; i < LOG_ENTRY_NUM; i++)
        pMac->utils.gLogEvtLevel[i] = pMac->utils.gLogDbgLevel[i] = logLevel;

    // Set status to READY
    pMac->cfg.gCfgStatus = CFG_SUCCESS;
    retVal = WNI_CFG_SUCCESS;
    PELOG1(cfgLog(pMac, LOG1, "<CFG> Completed successfully");)


    pMac->cfg.gParamList[WNI_CFG_DNLD_CNF_RES] = retVal;

} /*** end ProcessDownloadReq() ***/




