description("Test URL segmentation");

cases = [ 
  // [URL, [SCHEME, HOST, PORT, PATH, QUERY, REF]]
  ["http://user:pass@foo:21/bar;par?b#c",    ["http:","foo","21","/bar;par","?b","#c"]],
  ["http:foo.com",                           ["http:","foo.com","","/","",""]],
  ["\\t   :foo.com   \\n",                   [":","","","","",""]],
  [" foo.com  ",                             [":","","","","",""]],
  ["a:\\t foo.com",                          ["a:","",""," foo.com","",""]],
  ["http://f:21/ b ? d # e ",                ["http:","f","21","/%20b%20","?%20d%20","# e"]],
  ["http://f:/c",                            ["http:","f","","/c","",""]],
  ["http://f:0/c",                           ["http:","f","0","/c","",""]],
  ["http://f:00000000000000/c",              ["http:","f","0","/c","",""]],
  ["http://f:00000000000000000000080/c",     ["http:","f","0","/c","",""]],
  ["http://f:b/c",                           [":","","","","",""]],
  ["http://f: /c",                           [":","","","","",""]],
  ["http://f:\\n/c",                         [":","","","","",""]],
  ["http://f:fifty-two/c",                   [":","","","","",""]],
  ["http://f:999999/c",                      [":","","0","","",""]],
  ["http://f: 21 / b ? d # e ",              [":","","","","",""]],
  ["",                                       ["data:","","","text/plain,baseURL","",""]],
  ["  \\t",                                  ["data:","","","text/plain,baseURL","",""]],
  [":foo.com/",                              [":","","","","",""]],
  [":foo.com\\\\",                           [":","","","","",""]],
  [":",                                      [":","","","","",""]],
  [":a",                                     [":","","","","",""]],
  [":/",                                     [":","","","","",""]],
  [":\\\\",                                  [":","","","","",""]],
  [":#",                                     [":","","","","",""]],
  ["#",                                      [":","","","","",""]],
  ["#/",                                     [":","","","","",""]],
  ["#\\\\",                                  [":","","","","",""]],
  ["#;?",                                    [":","","","","",""]],
  ["?",                                      [":","","","","",""]],
  ["/",                                      [":","","","","",""]],
  [":23",                                    [":","","","","",""]],
  ["/:23",                                   ["data:","","","/:23","",""]],
  ["//",                                     [":","","","","",""]],
  ["::",                                     [":","","","","",""]],
  ["::23",                                   [":","","","","",""]],
  ["foo://",                                 ["foo:","","","//","",""]],
  ["http://a:b@c:29/d",                      ["http:","c","29","/d","",""]],
  ["http::@c:29",                            ["http:","c","29","/","",""]],
  ["http://&a:foo(b]c@d:2/",                 ["http:","d","2","/","",""]],
  ["http://::@c@d:2",                        ["http:","d","2","/","",""]],
  ["http://foo.com:b@d/",                    ["http:","d","","/","",""]],
  ["http://foo.com/\\\\@",                   ["http:","foo.com","","//@","",""]],
  ["http:\\\\\\\\foo.com\\\\",               ["http:","foo.com","","/","",""]],
  ["http:\\\\\\\\a\\\\b:c\\\\d@foo.com\\\\", ["http:","a","","/b:c/d@foo.com/","",""]],
  ["foo:/",                                  ["foo:","","","/","",""]],
  ["foo:/bar.com/",                          ["foo:","","","/bar.com/","",""]],
  ["foo://///////",                          ["foo:","","","/////////","",""]],
  ["foo://///////bar.com/",                  ["foo:","","","/////////bar.com/","",""]],
  ["foo:////://///",                         ["foo:","","","////://///","",""]],
  ["c:/foo",                                 ["c:","","","/foo","",""]],
  ["//foo/bar",                              [":","","","","",""]],
  ["http://foo/path;a??e#f#g",               ["http:","foo","","/path;a","??e","#f#g"]],
  ["http://foo/abcd?efgh?ijkl",              ["http:","foo","","/abcd","?efgh?ijkl",""]],
  ["http://foo/abcd#foo?bar",                ["http:","foo","","/abcd","","#foo?bar"]],
  ["[61:24:74]:98",                          ["data:","","","text/[61:24:74]:98","",""]],
  ["http://[61:27]:98",                      [":","","0","","",""]],
  ["http:[61:27]/:foo",                      [":","","","","",""]],
  ["http://[1::2]:3:4",                      [":","","","","",""]],
  ["http://2001::1",                         [":","","","","",""]],
  ["http://[2001::1",                        [":","","","","",""]],
  ["http://2001::1]",                        [":","","","","",""]],
  ["http://2001::1]:80",                     [":","","","","",""]],
  ["http://[2001::1]",                       ["http:","[2001::1]","","/","",""]],
  ["http://[2001::1]:80",                    ["http:","[2001::1]","","/","",""]],
  ["http://[[::]]",                          [":","","","","",""]],
];

var originalBaseURL = canonicalize(".");
setBaseURL("data:text/plain,baseURL");

for (var i = 0; i < cases.length; ++i) {
  shouldBe("segments('" + cases[i][0] + "')",
           "'" + JSON.stringify(cases[i][1]) + "'");
}

setBaseURL(originalBaseURL);

var successfullyParsed = true;
