# Copyright (C) 2009 The Android Open Source Project
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

LOCAL_PATH := $(call my-dir)

#
# mkerrcodes
#
include $(CLEAR_VARS)

LOCAL_MODULE := mkerrcodes

LOCAL_MODULE_TAGS := optional

LOCAL_SRC_FILES := \
    mkerrcodes.c \
    $(empty)

LOCAL_GENERATED_SOURCES := \
    $(empty)

include $(BUILD_HOST_EXECUTABLE)

#all-libgpg-error-targets: $(LOCAL_MODULE)
#clean-all-libgpg-error-targets: clean-$(LOCAL_MODULE)
include $(CLEAR_VARS)

#
# gpg-error-config
#

# BUILD_HOST_PREBUILT will take care CLEAR_VARS, LOCAL_MODULE, etc.
LOCAL_PREBUILT_EXECUTABLES := \
    gpg-error-config \
    $(empty)
include $(BUILD_HOST_PREBUILT)

#all-libgpg-error-targets: $(LOCAL_MODULE)
#clean-all-libgpg-error-targets: clean-$(LOCAL_MODULE)

#
# libgpg-error target/host common
#
#define libgpg-error-common
#include $$(CLEAR_VARS)
include $(CLEAR_VARS)

#LOCAL_MODULE := libgpg-error$$(if $(2),-host,-target)
LOCAL_MODULE := libgpg-error
#LOCAL_MODULE_STEM := libgpg-error
LOCAL_MODULE_TAGS := optional
LOCAL_SRC_FILES :=  \
    init.c \
    strsource.c \
    strerror.c \
    code-to-errno.c \
    code-from-errno.c

LOCAL_C_INCLUDES := \
    $(LOCAL_PATH)/.. \
    $(LOCAL_PATH) \
    $(LOCAL_PATH)/src

LOCAL_CFLAGS := \
    -DHAVE_CONFIG_H

LOCAL_COPY_HEADERS := \
    gpg-error.h

LOCAL_PRELINK_MODULE := false

#include $$(BUILD$$(if $(2),_HOST,_TARGET)_SHARED_LIBRARY)
include $(BUILD_SHARED_LIBRARY)

#all-libgpg-error-targets: $$(LOCAL_MODULE)
#clean-all-libgpg-error-targets: clean-$$(LOCAL_MODULE)
#endef

#
# libgpg-error (target)
#
$(eval $(call libgpg-error-common, \
    -DLOCALEDIR=\"/system/usr/share/locale\"))

#
# libgpg-error (host)
#
include $(CLEAR_VARS)
$(eval $(call libgpg-error-common, \
    -DLOCALEDIR=\"/usr/share/locale\", \
    HOST))
