#include <linux/batterydata-lib.h>

static struct single_row_lut fcc_temp = {
	.x		= {-20,0,25,40,60},
	.y		= {1980,2014,2012,2014,2017},
	.cols	= 5
};

static struct single_row_lut fcc_sf = {
	.x		= {0},
	.y		= {100},
	.cols	= 1
};

static struct sf_lut rbatt_sf = {
	.rows		= 30,
	.cols		= 5,
	.row_entries		= {-20,0,25,40,60},
	.percent	= {100,95,90,85,80,75,70,65,60,55,50,45,40,35,30,25,20,16,13,11,10,9,8,7,6,5,4,3,2,1},
	.sf		= {
				{1043,334,100,67,57},
				{1043,334,100,67,57},
				{1003,337,102,69,58},
				{963,336,104,70,59},
				{927,336,107,71,59},
				{899,330,111,73,61},
				{887,325,117,77,63},
				{889,316,124,83,66},
				{904,308,114,85,69},
				{926,303,101,74,63},
				{957,307,96,68,59},
				{995,319,98,69,59},
				{1040,342,99,71,62},
				{1092,372,101,72,64},
				{1153,410,103,71,63},
				{1227,459,108,70,59},
				{1423,530,112,68,59},
				{1854,612,115,69,59},
				{2442,701,116,69,59},
				{3041,776,122,71,61},
				{3396,819,126,73,62},
				{4019,860,132,75,64},
				{4820,904,141,79,65},
				{5659,938,148,81,65},
				{7311,951,148,80,62},
				{9915,1031,143,75,61},
				{15464,1221,146,77,64},
				{29539,1742,161,82,68},
				{65460,3094,195,92,78},
				{147278,7649,594,112,388}
	}
};

static struct pc_temp_ocv_lut pc_temp_ocv = {
	.rows		= 31,
	.cols		= 5,
	.temp		= {-20,0,25,40,60},
	.percent	= {100,95,90,85,80,75,70,65,60,55,50,45,40,35,30,25,20,16,13,11,10,9,8,7,6,5,4,3,2,1,0},
	.ocv		= {
				{4316,4314,4304,4298,4296},
				{4202,4228,4234,4234,4236},
				{4122,4164,4178,4178,4180},
				{4052,4108,4124,4124,4127},
				{3989,4056,4074,4074,4076},
				{3935,4005,4028,4028,4030},
				{3891,3954,3986,3986,3987},
				{3859,3908,3948,3949,3950},
				{3836,3868,3901,3908,3910},
				{3816,3834,3859,3864,3867},
				{3798,3808,3829,3834,3835},
				{3781,3792,3808,3812,3814},
				{3764,3780,3791,3796,3796},
				{3746,3766,3778,3780,3781},
				{3728,3750,3766,3767,3762},
				{3710,3730,3754,3750,3738},
				{3687,3708,3730,3727,3714},
				{3664,3692,3703,3702,3690},
				{3642,3680,3683,3682,3672},
				{3622,3670,3676,3676,3667},
				{3612,3664,3673,3675,3666},
				{3599,3659,3670,3674,3664},
				{3583,3650,3666,3671,3662},
				{3567,3642,3662,3668,3656},
				{3546,3628,3650,3656,3634},
				{3522,3606,3617,3621,3593},
				{3491,3572,3564,3568,3535},
				{3449,3520,3492,3500,3458},
				{3386,3442,3394,3408,3346},
				{3278,3316,3238,3246,3174},
				{3000,3000,3000,3000,3000}
	}
};

struct bms_battery_data LGE_BL41A1H_2100mAh_TOCAD_data = {
	.fcc				= 2100,
	.fcc_temp_lut			= &fcc_temp,
	.fcc_sf_lut				= &fcc_sf,
	.pc_temp_ocv_lut		= &pc_temp_ocv,
	.rbatt_sf_lut			= &rbatt_sf,
	.default_rbatt_mohm	= 182
};
