#include <linux/batterydata-lib.h>

static struct single_row_lut fcc_temp = {
	.x		= {-20, 0, 25, 40, 60},
	.y		= {2471, 2477, 2461, 2443, 2414},
	.cols	= 5
};

static struct single_row_lut fcc_sf = {
	.x		= {0},
	.y		= {100},
	.cols	= 1
};

static struct sf_lut rbatt_sf = {
	.rows		= 30,
	.cols		= 5,
	.row_entries		= {-20, 0, 25, 40, 60},
	.percent	= {100, 95, 90, 85, 80, 75, 70, 65, 60, 55, 50, 45, 40, 35, 30, 25, 20, 16, 13, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1},
	.sf		= {
				{1007, 225, 100, 87, 86},
				{999, 233, 103, 89, 87},
				{1000, 232, 102, 89, 87},
				{997, 241, 106, 91, 89},
				{1010, 250, 112, 94, 91},
				{956, 272, 118, 98, 93},
				{970, 251, 126, 104, 95},
				{987, 232, 133, 112, 102},
				{1013, 228, 113, 100, 95},
				{1055, 230, 105, 91, 89},
				{1108, 235, 106, 93, 91},
				{1170, 241, 109, 96, 93},
				{1241, 250, 114, 98, 94},
				{1323, 266, 115, 95, 91},
				{1418, 281, 110, 93, 91},
				{1538, 295, 106, 91, 90},
				{1915, 344, 114, 95, 91},
				{2804, 419, 133, 106, 98},
				{4012, 496, 154, 122, 114},
				{5114, 558, 165, 129, 122},
				{5785, 579, 171, 133, 127},
				{6546, 597, 179, 138, 131},
				{7036, 564, 189, 145, 136},
				{7900, 585, 200, 154, 142},
				{9518, 637, 218, 164, 149},
				{11770, 699, 237, 175, 156},
				{15088, 805, 260, 188, 166},
				{20192, 983, 292, 209, 183},
				{27545, 1429, 359, 246, 213},
				{36603, 2474, 489, 340, 295},
	}
};

static struct pc_temp_ocv_lut pc_temp_ocv = {
	.rows		= 31,
	.cols		= 5,
	.temp		= {-20, 0, 25, 40, 60},
	.percent	= {100, 95, 90, 85, 80, 75, 70, 65, 60, 55, 50, 45, 40, 35, 30, 25, 20, 16, 13, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0},
	.ocv		= {
				{4334, 4333, 4327, 4322, 4313},
				{4233, 4257, 4259, 4257, 4250},
				{4166, 4198, 4202, 4201, 4195},
				{4109, 4144, 4149, 4148, 4143},
				{4058, 4094, 4098, 4098, 4093},
				{3974, 4044, 4051, 4051, 4046},
				{3927, 3983, 4005, 4007, 4004},
				{3884, 3933, 3962, 3965, 3963},
				{3850, 3893, 3909, 3913, 3913},
				{3826, 3860, 3870, 3873, 3872},
				{3807, 3832, 3842, 3844, 3844},
				{3790, 3808, 3819, 3821, 3821},
				{3773, 3789, 3799, 3799, 3796},
				{3754, 3772, 3778, 3774, 3765},
				{3732, 3748, 3749, 3743, 3731},
				{3701, 3716, 3711, 3706, 3695},
				{3640, 3694, 3686, 3678, 3666},
				{3559, 3658, 3664, 3661, 3652},
				{3483, 3610, 3625, 3623, 3607},
				{3437, 3569, 3583, 3579, 3569},
				{3413, 3543, 3559, 3555, 3543},
				{3387, 3515, 3530, 3528, 3517},
				{3361, 3483, 3499, 3498, 3490},
				{3334, 3451, 3468, 3468, 3461},
				{3306, 3420, 3438, 3438, 3432},
				{3277, 3387, 3407, 3406, 3399},
				{3248, 3351, 3369, 3369, 3361},
				{3221, 3306, 3321, 3320, 3312},
				{3187, 3246, 3256, 3255, 3245},
				{3122, 3162, 3161, 3158, 3147},
				{3000, 3000, 3000, 3000, 3000}
	}
};

struct bms_battery_data LGE_BL_54SH_2540mAh_LG_Chem_data = {
	.fcc				= 2540,
	.fcc_temp_lut			= &fcc_temp,
	.fcc_sf_lut				= &fcc_sf,
	.pc_temp_ocv_lut		= &pc_temp_ocv,
	.rbatt_sf_lut			= &rbatt_sf,
	.default_rbatt_mohm	= 148
};
