#include <linux/batterydata-lib.h>

static struct single_row_lut fcc_temp = {
	.x		= {-20, 0, 25, 40, 60},
	.y		= {1809, 1810, 1816, 1819, 1817},
	.cols	= 5
};

static struct single_row_lut fcc_sf = {
	.x		= {0},
	.y		= {100},
	.cols	= 1
};

static struct sf_lut rbatt_sf = {
	.rows		= 30,
	.cols		= 5,
	.row_entries		= {-20, 0, 25, 40, 60},
	.percent	= {100, 95, 90, 85, 80, 75, 70, 65, 60, 55, 50, 45, 40, 35, 30, 25, 20, 16, 13, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1},
	.sf		= {
				{1247, 356, 100, 74, 67},
				{1212, 358, 101, 76, 67},
				{1216, 358, 101, 76, 67},
				{1171, 357, 104, 77, 68},
				{1138, 356, 107, 79, 70},
				{1118, 349, 112, 82, 72},
				{1114, 339, 119, 86, 74},
				{1126, 330, 127, 92, 78},
				{1152, 325, 120, 96, 82},
				{1188, 323, 106, 85, 74},
				{1234, 325, 100, 76, 69},
				{1291, 329, 100, 77, 69},
				{1357, 341, 102, 80, 73},
				{1430, 358, 104, 82, 75},
				{1531, 383, 107, 82, 74},
				{1766, 417, 108, 79, 69},
				{2280, 471, 110, 77, 69},
				{2896, 539, 111, 77, 69},
				{3738, 625, 108, 76, 69},
				{4526, 696, 112, 79, 71},
				{5090, 740, 116, 80, 72},
				{5654, 784, 120, 83, 74},
				{6513, 833, 127, 87, 76},
				{7544, 885, 134, 89, 78},
				{8556, 897, 136, 87, 72},
				{10458, 953, 130, 82, 72},
				{14161, 1090, 128, 84, 76},
				{20774, 1428, 136, 91, 85},
				{34692, 2368, 156, 104, 95},
				{68470, 5195, 220, 145, 296}
	}
};


static struct pc_temp_ocv_lut pc_temp_ocv = {
	.rows		= 31,
	.cols		= 5,
	.temp		= {-20, 0, 25, 40, 60},
	.percent	= {100, 95, 90, 85, 80, 75, 70, 65, 60, 55, 50, 45, 40, 35, 30, 25, 20, 16, 13, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0},
	.ocv		= {
				{4323, 4322, 4317, 4310, 4303},
				{4195, 4235, 4245, 4244, 4242},
				{4108, 4172, 4187, 4188, 4186},
				{4032, 4116, 4134, 4134, 4132},
				{3968, 4063, 4083, 4083, 4081},
				{3914, 4011, 4035, 4036, 4034},
				{3873, 3961, 3992, 3993, 3991},
				{3845, 3916, 3953, 3954, 3952},
				{3824, 3877, 3909, 3915, 3914},
				{3807, 3844, 3866, 3871, 3871},
				{3791, 3817, 3835, 3837, 3837},
				{3774, 3795, 3812, 3815, 3815},
				{3757, 3779, 3795, 3798, 3797},
				{3738, 3764, 3781, 3783, 3781},
				{3719, 3748, 3768, 3768, 3762},
				{3696, 3729, 3755, 3751, 3738},
				{3670, 3709, 3733, 3727, 3714},
				{3645, 3694, 3707, 3703, 3689},
				{3618, 3682, 3688, 3683, 3672},
				{3598, 3672, 3680, 3676, 3666},
				{3585, 3665, 3678, 3675, 3665},
				{3573, 3659, 3676, 3674, 3663},
				{3558, 3649, 3673, 3672, 3659},
				{3541, 3637, 3670, 3668, 3655},
				{3522, 3619, 3660, 3656, 3632},
				{3498, 3593, 3629, 3619, 3588},
				{3469, 3556, 3579, 3565, 3530},
				{3428, 3503, 3511, 3495, 3456},
				{3366, 3422, 3417, 3398, 3348},
				{3258, 3287, 3263, 3233, 3180},
				{3000, 3000, 3000, 3000, 3000}
	}
};


struct bms_battery_data LGE_L70_TOCAD_1900mAh_data = {
	.fcc				= 1900,
	.fcc_temp_lut			= &fcc_temp,
	.fcc_sf_lut				= &fcc_sf,
	.pc_temp_ocv_lut		= &pc_temp_ocv,
	.rbatt_sf_lut			= &rbatt_sf,
	.default_rbatt_mohm	= 163
};
