#include <linux/batterydata-lib.h>

static struct single_row_lut fcc_temp = {
	.x		= {-20, 0, 25, 40, 60},
	.y		= {2023, 2029, 2031, 2030, 2026},
	.cols	= 5
};

static struct single_row_lut fcc_sf = {
	.x		= {0},
	.y		= {100},
	.cols	= 1
};

static struct sf_lut rbatt_sf = {
	.rows		= 30,
	.cols		= 5,
	.row_entries		= {-20, 0, 25, 40, 60},
	.percent	= {100, 95, 90, 85, 80, 75, 70, 65, 60, 55, 50, 45, 40, 35, 30, 25, 20, 16, 13, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1},
	.sf		= {
				{1280, 334, 100, 75, 68},
				{1234, 335, 100, 77, 69},
				{1236, 335, 100, 77, 69},
				{1192, 337, 103, 78, 70},
				{1150, 338, 106, 80, 72},
				{1127, 335, 111, 83, 74},
				{1118, 324, 120, 88, 76},
				{1119, 316, 131, 94, 81},
				{1133, 311, 130, 105, 88},
				{1156, 309, 103, 81, 72},
				{1180, 312, 100, 77, 70},
				{1212, 319, 102, 79, 72},
				{1254, 334, 104, 83, 75},
				{1312, 357, 108, 86, 79},
				{1391, 380, 113, 83, 72},
				{1495, 400, 115, 81, 71},
				{1839, 421, 118, 83, 72},
				{2326, 455, 118, 82, 72},
				{2875, 490, 120, 83, 74},
				{3300, 503, 126, 88, 76},
				{3411, 490, 127, 90, 77},
				{3467, 481, 134, 92, 78},
				{3971, 495, 143, 95, 77},
				{4681, 508, 150, 96, 81},
				{5655, 520, 151, 104, 87},
				{7006, 545, 154, 111, 93},
				{9028, 588, 154, 119, 100},
				{12202, 663, 161, 125, 106},
				{17223, 819, 182, 136, 117},
				{25932, 1457, 241, 177, 176},
	}
};

static struct pc_temp_ocv_lut pc_temp_ocv = {
	.rows		= 31,
	.cols		= 5,
	.temp		= {-20, 0, 25, 40, 60},
	.percent	= {100, 95, 90, 85, 80, 75, 70, 65, 60, 55, 50, 45, 40, 35, 30, 25, 20, 16, 13, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0},
	.ocv		= {
				{4328, 4328, 4323, 4317, 4309},
				{4204, 4243, 4252, 4250, 4246},
				{4122, 4182, 4193, 4193, 4189},
				{4051, 4126, 4138, 4138, 4134},
				{3983, 4072, 4086, 4085, 4082},
				{3925, 4019, 4037, 4037, 4033},
				{3876, 3966, 3992, 3992, 3989},
				{3835, 3918, 3952, 3952, 3949},
				{3804, 3878, 3907, 3912, 3910},
				{3776, 3843, 3856, 3858, 3858},
				{3747, 3814, 3826, 3829, 3829},
				{3718, 3791, 3805, 3807, 3807},
				{3689, 3775, 3787, 3790, 3789},
				{3661, 3762, 3774, 3775, 3774},
				{3634, 3746, 3764, 3761, 3750},
				{3606, 3724, 3749, 3744, 3730},
				{3573, 3693, 3723, 3720, 3706},
				{3538, 3667, 3690, 3687, 3674},
				{3508, 3643, 3674, 3674, 3664},
				{3481, 3620, 3664, 3669, 3660},
				{3467, 3608, 3658, 3665, 3656},
				{3451, 3593, 3651, 3659, 3650},
				{3433, 3574, 3641, 3648, 3636},
				{3412, 3546, 3622, 3625, 3607},
				{3388, 3507, 3585, 3590, 3568},
				{3359, 3461, 3535, 3543, 3520},
				{3323, 3407, 3471, 3485, 3461},
				{3280, 3341, 3395, 3411, 3387},
				{3221, 3259, 3307, 3320, 3292},
				{3135, 3156, 3192, 3193, 3155},
				{3000, 3000, 3000, 3000, 3000}
	}
};

struct bms_battery_data LGE_Tocad_2040mAh_data = {
	.fcc				= 2040,
	.fcc_temp_lut			= &fcc_temp,
	.fcc_sf_lut				= &fcc_sf,
	.pc_temp_ocv_lut		= &pc_temp_ocv,
	.rbatt_sf_lut			= &rbatt_sf,
	.default_rbatt_mohm	= 143
};
