/* Copyright (c) 2011-2013, The Linux Foundation. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 and
 * only version 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */

#include <linux/batterydata-lib.h>

static struct single_row_lut fcc_temp = {
	.x		= {-20, 0, 25, 40, 60},
	.y		= {4014, 4051, 4055, 4053, 4032},
	.cols	= 5
};

static struct single_row_lut fcc_sf = {
	.x		= {0},
	.y		= {100},
	.cols	= 1
};

static struct sf_lut rbatt_sf = {
	.rows		= 30,
	.cols		= 5,
	.row_entries		= {-20, 0, 25, 40, 60},
	.percent	= {100, 95, 90, 85, 80, 75, 70, 65, 60, 55, 50, 45, 40, 35, 30, 25, 20, 16, 13, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1},
	.sf		= {
				{1171, 252, 100, 86, 82},
				{1156, 252, 100, 86, 82},
				{1140, 256, 100, 86, 82},
				{1121, 263, 103, 88, 83},
				{1091, 271, 106, 90, 84},
				{1073, 283, 109, 92, 86},
				{1076, 281, 115, 95, 86},
				{1082, 275, 122, 100, 90},
				{1097, 265, 122, 103, 92},
				{1124, 263, 105, 91, 84},
				{1163, 267, 103, 87, 83},
				{1213, 275, 104, 90, 84},
				{1273, 286, 106, 91, 86},
				{1348, 302, 108, 93, 88},
				{1441, 322, 110, 91, 85},
				{1602, 344, 110, 90, 84},
				{1829, 373, 112, 91, 83},
				{2073, 400, 113, 91, 84},
				{2386, 429, 111, 90, 84},
				{2559, 443, 115, 92, 86},
				{2605, 453, 118, 94, 86},
				{2846, 473, 121, 95, 87},
				{3161, 496, 125, 98, 89},
				{3547, 526, 128, 99, 89},
				{4063, 564, 128, 99, 87},
				{4755, 605, 124, 95, 86},
				{5757, 658, 126, 97, 88},
				{7354, 754, 131, 100, 93},
				{10393, 930, 146, 113, 104},
				{18310, 1953, 372, 379, 230}
	}
};


static struct pc_temp_ocv_lut pc_temp_ocv = {
	.rows		= 31,
	.cols		= 5,
	.temp		= {-20, 0, 25, 40, 60},
	.percent	= {100, 95, 90, 85, 80, 75, 70, 65, 60, 55, 50, 45, 40, 35, 30, 25, 20, 16, 13, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0},
	.ocv		= {
				{4323, 4321, 4317, 4312, 4305},
				{4227, 4248, 4251, 4249, 4244},
				{4156, 4189, 4195, 4193, 4189},
				{4094, 4135, 4142, 4140, 4136},
				{4030, 4085, 4091, 4089, 4086},
				{3970, 4035, 4044, 4042, 4038},
				{3923, 3981, 3998, 3998, 3995},
				{3884, 3935, 3960, 3960, 3956},
				{3850, 3891, 3914, 3917, 3915},
				{3826, 3857, 3867, 3868, 3867},
				{3807, 3829, 3838, 3838, 3838},
				{3789, 3807, 3815, 3816, 3816},
				{3772, 3789, 3797, 3798, 3797},
				{3754, 3774, 3782, 3783, 3781},
				{3735, 3761, 3770, 3766, 3759},
				{3715, 3747, 3755, 3748, 3735},
				{3692, 3728, 3733, 3726, 3712},
				{3671, 3707, 3704, 3697, 3682},
				{3651, 3690, 3686, 3679, 3668},
				{3635, 3681, 3683, 3676, 3665},
				{3627, 3676, 3682, 3675, 3664},
				{3616, 3670, 3680, 3674, 3662},
				{3603, 3663, 3677, 3671, 3659},
				{3586, 3653, 3672, 3665, 3650},
				{3566, 3637, 3657, 3648, 3625},
				{3538, 3611, 3623, 3611, 3582},
				{3498, 3567, 3570, 3557, 3527},
				{3442, 3504, 3500, 3488, 3455},
				{3360, 3415, 3406, 3394, 3356},
				{3236, 3280, 3264, 3249, 3211},
				{3000, 3000, 3000, 3000, 3000}
	}
};


struct bms_battery_data LGE_BL_T12_4000mAh_LG_Chem_data = {
	.fcc				= 4000,
	.fcc_temp_lut			= &fcc_temp,
	.fcc_sf_lut				= &fcc_sf,
	.pc_temp_ocv_lut		= &pc_temp_ocv,
	.rbatt_sf_lut			= &rbatt_sf,
	.default_rbatt_mohm	= 123,
	.flat_ocv_threshold_uv	= 3800000,
};
