/*
***************************************************************************
** SkFontHost_android_hy_debug.cpp
***************************************************************************
**
** 2012.07.17 Android JB
**
** Mobile Communication R&D Center, Hanyang
** Sangmin, Lee (TMSword) ( Mobile Communication R&D Center / Senior Researcher )
**
** This code is a program that changes the font.
**
***************************************************************************
*/
//                                                        
#ifdef CAPP_FONTS
#include "SkTypes.h"
#define xxINFORMATION_ACTIVATE
#define HYLOG_TAG "HyLog"
#include <android/log.h>

static const size_t hyBufferSize = 2048;

void
HyDebugif( const char * file, int line, const char * func, const char * format, ... )
{
#ifdef INFORMATION_ACTIVATE
    va_list args;
    va_start(args, format);
    char buffer[hyBufferSize+1];
    vsnprintf(buffer, hyBufferSize, format, args );
    __android_log_print(ANDROID_LOG_INFO, HYLOG_TAG, "I: %s (%d : %s() : %s)", buffer, line, func, file );
    va_end(args);
#else
    return;
#endif
}

void
HyDebugef( const char * file, int line, const char * func, const char * format, ... )
{
    va_list args;
    va_start(args, format);
    char buffer[hyBufferSize+1];
    vsnprintf(buffer, hyBufferSize, format, args );
    __android_log_print(ANDROID_LOG_ERROR, HYLOG_TAG, "E: %s (%d : %s() : %s)", buffer, line, func, file );
    va_end(args);
}

void
HyLogf( const char * format, ... )
{
    va_list args;
    va_start(args, format);
    char buffer[hyBufferSize+1];
    vsnprintf(buffer, hyBufferSize, format, args );
    __android_log_print(ANDROID_LOG_DEBUG, HYLOG_TAG, "I : %s", buffer );
    va_end(args);
}
#endif
// CAPP_FONTS_HYFONTS_END