/*
                                                                           
                                                     
                                                                           
  
                                                       
  
                                           
                                                                                 
  
                                                
  
                                                                           
*/
//                                                              
#if defined( CAPP_FONTS_JP )
// Fallbacks
#define MTLmr3m "/system/etc/fallback_fonts-ja-MTLmr3m.xml"
#define FANMIN4_NH "/system/etc/fallback_fonts-ja-FANMIN4_NH.xml"
#define VENDOR_FONTS_FILE "/vendor/etc/fallback_fonts.xml"

typedef struct _fallback_pair
{
    const char * webFaceName;
    const char * fallback;

} fallback_pair;

static const fallback_pair gFallbacksPair[] =
{
    { "roboto", MTLmr3m },
    { "FANDIARY_NH", MTLmr3m },
    { "FANSUNDAY_NH", MTLmr3m },
    { "FANCURVE_NH", MTLmr3m },
    { "FANCLEAR_NH", FANMIN4_NH },
    { NULL, NULL }
};

static const char *
getFallbacksXml( const char * webFaceName ) {
    uint32_t len = 0;
    if( !webFaceName || ( len = strlen( webFaceName ) ) <= 0 )
        goto END0;

    for( uint32_t n = 0 ; ; n++ )
    {
        if( gFallbacksPair[n].webFaceName == NULL )
            break;

        if( !strncmp( gFallbacksPair[n].webFaceName, webFaceName, len ) )
            return gFallbacksPair[n].fallback;
    }

END0:
    return MTLmr3m;
}

static void
getJapanFallbackFontFamilies( const char * webFaceName, SkTDArray<FontFamily*> &fallbackFonts )
{
    SkTDArray<FontFamily*> vendorFonts;
    int currentOrder = -1;

    parseConfigFile( getFallbacksXml( webFaceName ), fallbackFonts );
    parseConfigFile( VENDOR_FONTS_FILE, vendorFonts );

    for( int i = 0 ; i < vendorFonts.count() ; ++i )
    {
        FontFamily* family = vendorFonts[i];
        int order = family->order;
        if( order < 0 )
        {
            if( currentOrder < 0 )
            {
                *fallbackFonts.append() = family;
            }
            else
            {
                *fallbackFonts.insert( currentOrder++ ) = family;
            }
        }
        else
        {
            *fallbackFonts.insert( order ) = family;
            currentOrder = order + 1;
        }
    }
}

static void
reloadJapanFallbackFontsLocked( const char * webFaceName )
{
    SkGraphics::PurgeFontCache();

    SkTDArray<FontFamily*> fallbackFamilies;
    getJapanFallbackFontFamilies( webFaceName, fallbackFamilies );

    gFallbackFonts.reset();

    for (int i = 0; i < fallbackFamilies.count(); ++i) {
        FontFamily *family = fallbackFamilies[i];

        for (int j = 0; j < family->fFileNames.count(); ++j) {
            const char* filename = family->fFileNames[j];
            if (filename) {
                if (!haveSystemFont(filename)) {
                    SkDebugf("---- skipping fallback font %s because it was not "
                            "previously loaded as a system font", filename);
                    continue;
                }
                // ensure the fallback font exists before adding it to the list
                bool isFixedWidth;
                SkString name;
                SkTypeface::Style style;
                if (!getNameAndStyle(filename, &name, &style,
                                        &isFixedWidth, false)) {
                    continue;
                }

                SkFontID uniqueID = findUniqueIDLocked(filename);
                SkASSERT(uniqueID != 0);
                if (findFallbackFontIndex(uniqueID) >= 0) {
                    SkDebugf("---- system font and fallback font files specify a duplicate "
                            "font %s, skipping the second occurrence", filename);
                    continue;
                }

                SkDEBUGF(("---- reload %s as fallback[%d] fontID %d\n",
                          filename, gFallbackFonts.count(), uniqueID));

                *gFallbackFonts.append() = uniqueID;
                break;  // The fallback set contains only the first font of each family
            }
        }
    }

    fallbackFamilies.deleteAll();
}
#endif
// CAPP_FONTS_HYFONTS_JP_END
