
//#include "StdAfx.h"
#include "../inc/INC_INCLUDES.h"

extern PLL_MODE			m_ucPLL_Mode;

INC_UINT32 g_uiKOREnsembleFullFreq[MAX_KOREABAND_FULL_CHANNEL] = 
{
	175280,177008,178736,
	181280,183008,184736,
	187280,189008,190736,
	193280,195008,196736,
	199280,201008,202736,
	205280,207008,208736,
	211280,213008,214736
};

static INC_UINT32 g_uiKOREnsembleNormalFreq[MAX_KOREABAND_NORMAL_CHANNEL] = 
{
	181280,183008,184736,
	205280,207008,208736
};

static INC_UINT32 g_uiBandIIIEnsemblVal[MAX_BAND_III_CHANNEL] = 
{
	174928,176640,178352,180064,181936,
	183648,185360,187072,188928,190640,
	192352,194064,195936,197648,199360,
	201072,202928,204640,206352,208064,
	209936,211648,213360,215072,210096,
	216928,218640,220352,222064,217088,
	223936,225648,227360,229072,224096,
	230784,232496,234208,235776,237488,
	239200,
};


static INC_UINT32 g_uiLBandEnsemblVal[MAX_L_BAND_CHANNEL] = 
{
	1452960,1454672,1456384,1458096,1459808,
	1461520,1463232,1464944,1466656,1468368,
	1470080,1471792,1473504,1475216,1476928,
	1478640,1480352,1482064,1483776,1485488,
	1487200,1488912,1490624
};

static INC_UINT32 g_uiChinaEnsemblVal[MAX_CHINA_CHANNEL] = 
{
	168160,169872,171584,173296,175008,
	176720,178432,180144,181856,184160,
	185872,187584,189296,191008,192720,
	194432,196144,197856,200160,201872,
	203584,205296,207008,208720,210432,
	212144,213856,216432,218144,219856,
	221568,
};

static INC_UINT32 g_uiRoamingEnsemblVal[MAX_ROAMING_CHANNEL] = 
{
	217280,219008,220736,223280,225008,
	226736,229280,231008,232736,235280,
	237008, 238736
};

// default : No LNA version
static INC_UINT8 g_acT3900KorI2CValue_19200[MAX_KOREABAND_FULL_CHANNEL][RF500_REG_CTRL] = 
{
	{	//19200KHz 7AK.dat (175.280Mhz)
		0x7F, 0x9F, 0xF1, 0xF8, 0x02, 0x41, 0xFC, 0x00, 0x00, 0xC0, 0x00, 0x0C, 0xC3, 0x00, 0xC0, 0x40, 
		0x59, 0xC0, 0x03, 0xE8, 0x0C, 0xC0, 0x88, 0x33, 0x08, 0xF0, 0xF0, 0xD0, 0x02, 0x00, 0x12, 0x41, 
		0x4D, 0x0C, 0xE8, 0x03, 0xE8, 0xC1, 0x88, 0xEC, 0xE0, 0x10, 0x40, 0xFC, 0x00, 0x00, 0x00, 0x00, 
		0xFF, 0x01, 0x00, 0x70, 0x4C, 0xF0, 0x8C, 0xF0, 0x80, 0xC0, 0xB0, 0x70, 0x70, 0x80, 0x10, 0x00, 
		0xEE, 0xE0, 0x33, 0x44, 0x48, 0x44, 0x6E, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x0B, 0x2B, 
		0x00, 0x80, 0x60, 0x00, 0x00, 0x00, 0x94, 0x44, 0x00, 0x17, 0x17, 0x18, 0x18, 0x0E, 0x04, 0x00, 
		0x00, 0x00, 0xFB, 0xB0, 0x68, 0x20, 0x00, 0x08, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0xE0, 0x00, 0x10, 0x00, 
		0x0F, 0x0C, 0x00, 0xF3, 0x00, 0x00, 0x80, 0x00, 0x78, 0x00, 0x07, 0x80, 0x00, 0x60, 0x00, 0x00, 
		0xF8, 0x00, 0x04, 0x00, 0x02, 0x00, 0x01, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x80, 0x10, 0xC0, 0x10, 0x00, 0x08, 0x1C, 0xC0, 0x22, 0x96, 0xA5, 0xE0, 0xF0, 0xBF, 0xC0, 0x80, 
		0x03, 0x00, 0x27, 0x10, 0x00, 0x03, 0xE8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x01, 0x00, 0xE0, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//19200KHz 7BK.dat (177.008Mhz)
		0x7F, 0x9F, 0xF1, 0xF8, 0x02, 0x41, 0xFC, 0x00, 0x00, 0xC0, 0x00, 0x0C, 0xC3, 0x00, 0xC0, 0x40, 
		0x59, 0xC0, 0x03, 0xE8, 0x0C, 0xC0, 0x88, 0x33, 0x08, 0xF0, 0xF0, 0xD0, 0x02, 0x00, 0x12, 0x44, 
		0x4D, 0x09, 0x11, 0x03, 0xE8, 0xC1, 0x88, 0xEC, 0xE0, 0x10, 0x40, 0xFC, 0x00, 0x00, 0x00, 0x00, 
		0xFF, 0x01, 0x00, 0x70, 0x4C, 0xF0, 0x8C, 0xF0, 0x80, 0xC0, 0xB0, 0x70, 0x70, 0x80, 0x10, 0x00, 
		0xEE, 0xE0, 0x33, 0x44, 0x48, 0x44, 0x6E, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x0B, 0x2B, 
		0x00, 0x80, 0x60, 0x00, 0x00, 0x00, 0x94, 0x44, 0x00, 0x17, 0x17, 0x18, 0x18, 0x0E, 0x04, 0x00, 
		0x00, 0x00, 0xFB, 0xB0, 0x68, 0x20, 0x00, 0x08, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0xE0, 0x00, 0x10, 0x00, 
		0x0F, 0x0C, 0x00, 0xF3, 0x00, 0x00, 0x80, 0x00, 0x78, 0x00, 0x07, 0x80, 0x00, 0x60, 0x00, 0x00, 
		0xF8, 0x00, 0x04, 0x00, 0x02, 0x00, 0x01, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x80, 0x10, 0xC0, 0x10, 0x00, 0x08, 0x1C, 0xC0, 0x22, 0x96, 0xA5, 0xE0, 0xF0, 0xFF, 0xC0, 0x80, 
		0x03, 0x00, 0x27, 0x10, 0x00, 0x03, 0xE8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x01, 0x00, 0xE0, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//19200KHz 7CK.dat (178.736Mhz)
		0x7F, 0x9F, 0xF1, 0xF8, 0x02, 0x41, 0xFC, 0x00, 0x00, 0xC0, 0x00, 0x0C, 0xC3, 0x00, 0xC0, 0x40, 
		0x59, 0xC0, 0x03, 0xE8, 0x0C, 0xC0, 0x88, 0x33, 0x08, 0xF0, 0xF0, 0xD0, 0x02, 0x00, 0x12, 0x47, 
		0x4D, 0x05, 0x3A, 0x03, 0xE8, 0xC1, 0x88, 0xEC, 0xE0, 0x10, 0x40, 0xFC, 0x00, 0x00, 0x00, 0x00, 
		0xFF, 0x01, 0x00, 0x70, 0x4C, 0xF0, 0x8C, 0xF0, 0x80, 0xC0, 0xB0, 0x80, 0x60, 0x80, 0x10, 0x00, 
		0xCC, 0xC0, 0x33, 0x44, 0x48, 0x44, 0x6E, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x0B, 0x2B, 
		0x00, 0x80, 0x60, 0x00, 0x00, 0x00, 0x94, 0x44, 0x00, 0x17, 0x17, 0x18, 0x18, 0x0E, 0x04, 0x00, 
		0x00, 0x00, 0xFB, 0xB0, 0x68, 0x20, 0x00, 0x08, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0xE0, 0x00, 0x10, 0x00, 
		0x0F, 0x0C, 0x00, 0xF3, 0x00, 0x00, 0x80, 0x00, 0x78, 0x00, 0x07, 0x80, 0x00, 0x60, 0x00, 0x00, 
		0xF8, 0x00, 0x04, 0x00, 0x02, 0x00, 0x01, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x80, 0x10, 0xC0, 0x10, 0x00, 0x08, 0x1C, 0xC0, 0x22, 0x96, 0xA5, 0xE0, 0xF0, 0xBF, 0xC0, 0x80, 
		0x03, 0x00, 0x27, 0x10, 0x00, 0x03, 0xE8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x01, 0x00, 0xE0, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//19200KHz 8AK.dat (181.280Mhz)
		0x7F, 0x9F, 0xF1, 0xF8, 0x02, 0x41, 0xFC, 0x00, 0x00, 0xC0, 0x00, 0x0C, 0xC3, 0x00, 0xC0, 0x40, 
		0x59, 0xC0, 0x03, 0xE8, 0x0C, 0xC0, 0x88, 0x33, 0x08, 0xF0, 0xF0, 0xD0, 0x02, 0x00, 0x12, 0x4B, 
		0x4D, 0x0C, 0xE8, 0x03, 0xE8, 0xC1, 0x88, 0xEC, 0xE0, 0x10, 0x40, 0xFC, 0x00, 0x00, 0x00, 0x00, 
		0xFF, 0x01, 0x00, 0x70, 0x4C, 0xF0, 0x8C, 0xF0, 0x80, 0xC0, 0xB0, 0x60, 0x60, 0x80, 0x10, 0x00, 
		0xCC, 0xC0, 0x33, 0x44, 0x48, 0x44, 0x6E, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x0B, 0x2B, 
		0x00, 0x80, 0x60, 0x00, 0x00, 0x00, 0x94, 0x44, 0x00, 0x17, 0x17, 0x18, 0x18, 0x0E, 0x04, 0x00, 
		0x00, 0x00, 0xFB, 0xB0, 0x68, 0x20, 0x00, 0x08, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0xE0, 0x00, 0x10, 0x00, 
		0x0F, 0x0C, 0x00, 0xF3, 0x00, 0x00, 0x80, 0x00, 0x78, 0x00, 0x07, 0x80, 0x00, 0x60, 0x00, 0x00, 
		0xF8, 0x00, 0x04, 0x00, 0x02, 0x00, 0x01, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x80, 0x10, 0xC0, 0x10, 0x00, 0x08, 0x1C, 0xC0, 0x22, 0x96, 0xA5, 0xE0, 0xF0, 0xBF, 0xC0, 0x80, 
		0x03, 0x00, 0x27, 0x10, 0x00, 0x03, 0xE8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x01, 0x00, 0xE0, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//19200KHz 8BK.dat (183.008Mhz)
		0x7F, 0x9F, 0xF1, 0xF8, 0x02, 0x41, 0xFC, 0x00, 0x00, 0xC0, 0x00, 0x0C, 0xC3, 0x00, 0xC0, 0x40, 
		0x59, 0xC0, 0x03, 0xE8, 0x0C, 0xC0, 0x88, 0x33, 0x08, 0xF0, 0xF0, 0xD0, 0x02, 0x00, 0x12, 0x4E, 
		0x4D, 0x09, 0x11, 0x03, 0xE8, 0xC1, 0x88, 0xEC, 0xE0, 0x10, 0x40, 0xFC, 0x00, 0x00, 0x00, 0x00, 
		0xFF, 0x01, 0x00, 0x70, 0x4C, 0xF0, 0x8C, 0xF0, 0x80, 0xC0, 0xB0, 0x60, 0x60, 0x80, 0x10, 0x00, 
		0xBB, 0xB0, 0x33, 0x44, 0x48, 0x44, 0x6E, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x0B, 0x2B, 
		0x00, 0x80, 0x60, 0x00, 0x00, 0x00, 0x94, 0x44, 0x00, 0x17, 0x17, 0x18, 0x18, 0x0E, 0x04, 0x00, 
		0x00, 0x00, 0xFB, 0xB0, 0x68, 0x20, 0x00, 0x08, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0xE0, 0x00, 0x10, 0x00, 
		0x0F, 0x0C, 0x00, 0xF3, 0x00, 0x00, 0x80, 0x00, 0x78, 0x00, 0x07, 0x80, 0x00, 0x60, 0x00, 0x00, 
		0xF8, 0x00, 0x04, 0x00, 0x02, 0x00, 0x01, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x80, 0x10, 0xC0, 0x10, 0x00, 0x08, 0x1C, 0xC0, 0x22, 0x96, 0xA5, 0xE0, 0xF0, 0xBF, 0xC0, 0x80, 
		0x03, 0x00, 0x27, 0x10, 0x00, 0x03, 0xE8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x01, 0x00, 0xE0, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//19200KHz 8CK.dat (184.736Mhz)
		0x7F, 0x9F, 0xF1, 0xF8, 0x02, 0x41, 0xFC, 0x00, 0x00, 0xC0, 0x00, 0x0C, 0xC3, 0x00, 0xC0, 0x40, 
		0x59, 0xC0, 0x03, 0xE8, 0x0C, 0xC0, 0x88, 0x33, 0x08, 0xF0, 0xF0, 0xD0, 0x02, 0x00, 0x13, 0x41, 
		0x4D, 0x05, 0x3A, 0x03, 0xE8, 0xC1, 0x88, 0xEC, 0xE0, 0x10, 0x40, 0xFC, 0x00, 0x00, 0x00, 0x00, 
		0xFF, 0x01, 0x00, 0x70, 0x4C, 0xF0, 0x8C, 0xF0, 0x80, 0xC0, 0xB0, 0x60, 0x60, 0x80, 0x10, 0x00, 
		0xAA, 0xA0, 0x33, 0x44, 0x48, 0x44, 0x6E, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x0B, 0x2B, 
		0x00, 0x80, 0x60, 0x00, 0x00, 0x00, 0x94, 0x44, 0x00, 0x17, 0x17, 0x18, 0x18, 0x0E, 0x04, 0x00, 
		0x00, 0x00, 0xFB, 0xB0, 0x68, 0x20, 0x00, 0x08, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0xE0, 0x00, 0x10, 0x00, 
		0x0F, 0x0C, 0x00, 0xF3, 0x00, 0x00, 0x80, 0x00, 0x78, 0x00, 0x07, 0x80, 0x00, 0x60, 0x00, 0x00, 
		0xF8, 0x00, 0x04, 0x00, 0x02, 0x00, 0x01, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x80, 0x10, 0xC0, 0x10, 0x00, 0x08, 0x1C, 0xC0, 0x22, 0x96, 0xA5, 0xE0, 0xF0, 0xBF, 0xC0, 0x80, 
		0x03, 0x00, 0x27, 0x10, 0x00, 0x03, 0xE8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x01, 0x00, 0xE0, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//19200KHz 9AK.dat (187.280Mhz)
		0x7F, 0x9F, 0xF1, 0xF8, 0x02, 0x41, 0xFC, 0x00, 0x00, 0xC0, 0x00, 0x0C, 0xC3, 0x00, 0xC0, 0x40, 
		0x59, 0xC0, 0x03, 0xE8, 0x0C, 0xC0, 0x88, 0x33, 0x08, 0xF0, 0xF0, 0xD0, 0x02, 0x00, 0x13, 0x45, 
		0x4D, 0x0C, 0xE8, 0x03, 0xE8, 0xC1, 0x88, 0xEC, 0xE0, 0x10, 0x40, 0xFC, 0x00, 0x00, 0x00, 0x00, 
		0xFF, 0x01, 0x00, 0x70, 0x4C, 0xF0, 0x8C, 0xF0, 0x80, 0xC0, 0xB0, 0x60, 0x60, 0x80, 0x10, 0x00, 
		0xAA, 0xA0, 0x33, 0x44, 0x48, 0x44, 0x6E, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x0B, 0x2B, 
		0x00, 0x80, 0x60, 0x00, 0x00, 0x00, 0x94, 0x44, 0x00, 0x17, 0x17, 0x18, 0x18, 0x0E, 0x04, 0x00, 
		0x00, 0x00, 0xFB, 0xB0, 0x68, 0x20, 0x00, 0x08, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0xE0, 0x00, 0x10, 0x00, 
		0x0F, 0x0C, 0x00, 0xF3, 0x00, 0x00, 0x80, 0x00, 0x78, 0x00, 0x07, 0x80, 0x00, 0x60, 0x00, 0x00, 
		0xF8, 0x00, 0x04, 0x00, 0x02, 0x00, 0x01, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x80, 0x10, 0xC0, 0x10, 0x00, 0x08, 0x1C, 0xC0, 0x22, 0x96, 0xA5, 0xE0, 0xF0, 0xBF, 0xC0, 0x80, 
		0x03, 0x00, 0x27, 0x10, 0x00, 0x03, 0xE8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x01, 0x00, 0xE0, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//19200KHz 9BK.dat (189.008Mhz)
		0x7F, 0x9F, 0xF1, 0xF8, 0x02, 0x41, 0xFC, 0x00, 0x00, 0xC0, 0x00, 0x0C, 0xC3, 0x00, 0xC0, 0x40, 
		0x59, 0xC0, 0x03, 0xE8, 0x0C, 0xC0, 0x88, 0x33, 0x08, 0xF0, 0xF0, 0xD0, 0x02, 0x00, 0x13, 0x48, 
		0x4D, 0x09, 0x11, 0x03, 0xE8, 0xC1, 0x88, 0xEC, 0xE0, 0x10, 0x40, 0xFC, 0x00, 0x00, 0x00, 0x00, 
		0xFF, 0x01, 0x00, 0x70, 0x4C, 0xF0, 0x8C, 0xF0, 0x80, 0xC0, 0xB0, 0x50, 0x50, 0x80, 0x10, 0x00, 
		0x99, 0x90, 0x33, 0x44, 0x48, 0x44, 0x6E, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x0B, 0x2B, 
		0x00, 0x80, 0x60, 0x00, 0x00, 0x00, 0x94, 0x44, 0x00, 0x17, 0x17, 0x18, 0x18, 0x0E, 0x04, 0x00, 
		0x00, 0x00, 0xFB, 0xB0, 0x68, 0x20, 0x00, 0x08, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0xE0, 0x00, 0x10, 0x00, 
		0x0F, 0x0C, 0x00, 0xF3, 0x00, 0x00, 0x80, 0x00, 0x78, 0x00, 0x07, 0x80, 0x00, 0x60, 0x00, 0x00, 
		0xF8, 0x00, 0x04, 0x00, 0x02, 0x00, 0x01, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x80, 0x10, 0xC0, 0x10, 0x00, 0x08, 0x1C, 0xC0, 0x22, 0x96, 0xA5, 0xE0, 0xF0, 0xBF, 0xC0, 0x80, 
		0x03, 0x00, 0x27, 0x10, 0x00, 0x03, 0xE8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x01, 0x00, 0xE0, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//19200KHz 9CK.dat (190.736Mhz)
		0x7F, 0x9F, 0xF1, 0xF8, 0x02, 0x41, 0xFC, 0x00, 0x00, 0xC0, 0x00, 0x0C, 0xC3, 0x00, 0xC0, 0x40, 
		0x59, 0xC0, 0x03, 0xE8, 0x0C, 0xC0, 0x88, 0x33, 0x08, 0xF0, 0xF0, 0xD0, 0x02, 0x00, 0x13, 0x4B, 
		0x4D, 0x05, 0x3A, 0x03, 0xE8, 0xC1, 0x88, 0xEC, 0xE0, 0x10, 0x40, 0xFC, 0x00, 0x00, 0x00, 0x00, 
		0xFF, 0x01, 0x00, 0x70, 0x4C, 0xF0, 0x8C, 0xF0, 0x80, 0xC0, 0xB0, 0x50, 0x50, 0x80, 0x10, 0x00, 
		0x99, 0x90, 0x33, 0x44, 0x48, 0x44, 0x6E, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x0B, 0x2B, 
		0x00, 0x80, 0x60, 0x00, 0x00, 0x00, 0x94, 0x44, 0x00, 0x17, 0x17, 0x18, 0x18, 0x0E, 0x04, 0x00, 
		0x00, 0x00, 0xFB, 0xB0, 0x68, 0x20, 0x00, 0x08, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0xE0, 0x00, 0x10, 0x00, 
		0x0F, 0x0C, 0x00, 0xF3, 0x00, 0x00, 0x80, 0x00, 0x78, 0x00, 0x07, 0x80, 0x00, 0x60, 0x00, 0x00, 
		0xF8, 0x00, 0x04, 0x00, 0x02, 0x00, 0x01, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x80, 0x10, 0xC0, 0x10, 0x00, 0x08, 0x1C, 0xC0, 0x22, 0x96, 0xA5, 0xE0, 0xF0, 0xBF, 0xC0, 0x80, 
		0x03, 0x00, 0x27, 0x10, 0x00, 0x03, 0xE8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x01, 0x00, 0xE0, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//19200KHz 10AK.dat (193.280Mhz)
		0x7F, 0x9F, 0xF1, 0xF8, 0x02, 0x41, 0xFC, 0x00, 0x00, 0xC0, 0x00, 0x0C, 0xC3, 0x00, 0xC0, 0x40, 
		0x59, 0xC0, 0x03, 0xE8, 0x0C, 0xC0, 0x88, 0x33, 0x08, 0xF0, 0xF0, 0xD0, 0x02, 0x00, 0x13, 0x4F, 
		0x4D, 0x0C, 0xE8, 0x03, 0xE8, 0xC1, 0x88, 0xEC, 0xE0, 0x10, 0x40, 0xFC, 0x00, 0x00, 0x00, 0x00, 
		0xFF, 0x01, 0x00, 0x70, 0x4C, 0xF0, 0x8C, 0xF0, 0x80, 0xC0, 0xB0, 0x50, 0x50, 0x80, 0x10, 0x00, 
		0x99, 0x90, 0x33, 0x44, 0x48, 0x44, 0x6E, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x0B, 0x2B, 
		0x00, 0x80, 0x60, 0x00, 0x00, 0x00, 0x94, 0x44, 0x00, 0x17, 0x17, 0x18, 0x18, 0x0E, 0x04, 0x00, 
		0x00, 0x00, 0xFB, 0xB0, 0x68, 0x20, 0x00, 0x08, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0xE0, 0x00, 0x10, 0x00, 
		0x0F, 0x0C, 0x00, 0xF3, 0x00, 0x00, 0x80, 0x00, 0x78, 0x00, 0x07, 0x80, 0x00, 0x60, 0x00, 0x00, 
		0xF8, 0x00, 0x04, 0x00, 0x02, 0x00, 0x01, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x80, 0x10, 0xC0, 0x10, 0x00, 0x08, 0x1C, 0xC0, 0x22, 0x96, 0xA5, 0xE0, 0xF0, 0xBF, 0xC0, 0x80, 
		0x03, 0x00, 0x27, 0x10, 0x00, 0x03, 0xE8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x01, 0x00, 0xE0, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//19200KHz 10BK.dat (195.008Mhz)
		0x7F, 0x9F, 0xF1, 0xF8, 0x02, 0x41, 0xFC, 0x00, 0x00, 0xC0, 0x00, 0x0C, 0xC3, 0x00, 0xC0, 0x40, 
		0x59, 0xC0, 0x03, 0xE8, 0x0C, 0xC0, 0x88, 0x33, 0x08, 0xF0, 0xF0, 0xD0, 0x02, 0x00, 0x14, 0x42, 
		0x4D, 0x09, 0x12, 0x03, 0xE8, 0xC3, 0x8A, 0x08, 0xE0, 0x10, 0x40, 0xFC, 0x00, 0x00, 0x00, 0x00, 
		0xFF, 0x01, 0x00, 0x70, 0x4C, 0xF0, 0x8C, 0xF0, 0x80, 0xC0, 0xB0, 0x40, 0x40, 0x80, 0x10, 0x00, 
		0x88, 0x80, 0x33, 0x44, 0x48, 0x44, 0x6E, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x0B, 0x2B, 
		0x00, 0x80, 0x60, 0x00, 0x00, 0x00, 0x94, 0x44, 0x00, 0x17, 0x17, 0x18, 0x18, 0x0E, 0x04, 0x00, 
		0x00, 0x00, 0xFB, 0xB0, 0x68, 0x20, 0x00, 0x08, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0xE0, 0x00, 0x10, 0x00, 
		0x0F, 0x0C, 0x00, 0xF3, 0x00, 0x00, 0x80, 0x00, 0x78, 0x00, 0x07, 0x80, 0x00, 0x60, 0x00, 0x00, 
		0xF8, 0x00, 0x04, 0x00, 0x02, 0x00, 0x01, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x80, 0x10, 0xC0, 0x10, 0x00, 0x08, 0x1C, 0xC0, 0x22, 0x96, 0xA5, 0xE0, 0xF0, 0xFF, 0xC0, 0x50, 
		0x03, 0x00, 0x27, 0x10, 0x00, 0x03, 0xE8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x01, 0x00, 0xE0, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//19200KHz 10CK.dat (196.736Mhz)
		0x7F, 0x9F, 0xF1, 0xF8, 0x02, 0x41, 0xFC, 0x00, 0x00, 0xC0, 0x00, 0x0C, 0xC3, 0x00, 0xC0, 0x40, 
		0x59, 0xC0, 0x03, 0xE8, 0x0C, 0xC0, 0x88, 0x33, 0x08, 0xF0, 0xF0, 0xD0, 0x02, 0x00, 0x14, 0x45, 
		0x4D, 0x05, 0x3A, 0x03, 0xE8, 0xC1, 0x88, 0xEC, 0xE0, 0x10, 0x40, 0xFC, 0x00, 0x00, 0x00, 0x00, 
		0xFF, 0x01, 0x00, 0x70, 0x4C, 0xF0, 0x8C, 0xF0, 0x80, 0xC0, 0xB0, 0x40, 0x40, 0x80, 0x10, 0x00, 
		0x88, 0x80, 0x33, 0x44, 0x48, 0x44, 0x6E, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x0B, 0x2B, 
		0x00, 0x80, 0x60, 0x00, 0x00, 0x00, 0x94, 0x44, 0x00, 0x17, 0x17, 0x18, 0x18, 0x0E, 0x04, 0x00, 
		0x00, 0x00, 0xFB, 0xB0, 0x68, 0x20, 0x00, 0x08, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0xE0, 0x00, 0x10, 0x00, 
		0x0F, 0x0C, 0x00, 0xF3, 0x00, 0x00, 0x80, 0x00, 0x78, 0x00, 0x07, 0x80, 0x00, 0x60, 0x00, 0x00, 
		0xF8, 0x00, 0x04, 0x00, 0x02, 0x00, 0x01, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x80, 0x10, 0xC0, 0x10, 0x00, 0x08, 0x1C, 0xC0, 0x22, 0x96, 0xA5, 0xE0, 0xF0, 0xFF, 0xC0, 0x50, 
		0x03, 0x00, 0x27, 0x10, 0x00, 0x03, 0xE8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x01, 0x00, 0xE0, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//19200KHz 11AK.dat (199.280Mhz)
		0x7F, 0x9F, 0xF1, 0xF8, 0x02, 0x41, 0xFC, 0x00, 0x00, 0xC0, 0x00, 0x0C, 0xC3, 0x00, 0xC0, 0x40, 
		0x59, 0xC0, 0x03, 0xE8, 0x0C, 0xC0, 0x88, 0x33, 0x08, 0xF0, 0xF0, 0xD0, 0x02, 0x00, 0x14, 0x49, 
		0x4D, 0x0C, 0xE8, 0x03, 0xE8, 0xC1, 0x88, 0xEC, 0xE0, 0x10, 0x40, 0xFC, 0x00, 0x00, 0x00, 0x00, 
		0xFF, 0x01, 0x00, 0x70, 0x4C, 0xF0, 0x8C, 0xF0, 0x80, 0xC0, 0xB0, 0x40, 0x40, 0x80, 0x10, 0x00, 
		0x88, 0x80, 0x33, 0x44, 0x48, 0x44, 0x6E, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x0B, 0x2B, 
		0x00, 0x80, 0x60, 0x00, 0x00, 0x00, 0x94, 0x44, 0x00, 0x17, 0x17, 0x18, 0x18, 0x0E, 0x04, 0x00, 
		0x00, 0x00, 0xFB, 0xB0, 0x68, 0x20, 0x00, 0x08, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0xE0, 0x00, 0x10, 0x00, 
		0x0F, 0x0C, 0x00, 0xF3, 0x00, 0x00, 0x80, 0x00, 0x78, 0x00, 0x07, 0x80, 0x00, 0x60, 0x00, 0x00, 
		0xF8, 0x00, 0x04, 0x00, 0x02, 0x00, 0x01, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x80, 0x10, 0xC0, 0x10, 0x00, 0x08, 0x1C, 0xC0, 0x22, 0x96, 0xA5, 0xE0, 0xF0, 0xBF, 0xC0, 0x80, 
		0x03, 0x00, 0x27, 0x10, 0x00, 0x03, 0xE8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x01, 0x00, 0xE0, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//19200KHz 11BK.dat (201.008Mhz)
		0x7F, 0x9F, 0xF1, 0xF8, 0x02, 0x41, 0xFC, 0x00, 0x00, 0xC0, 0x00, 0x0C, 0xC3, 0x00, 0xC0, 0x40, 
		0x59, 0xC0, 0x03, 0xE8, 0x0C, 0xC0, 0x88, 0x33, 0x08, 0xF0, 0xF0, 0xD0, 0x02, 0x00, 0x14, 0x4C, 
		0x4D, 0x09, 0x11, 0x03, 0xE8, 0xC1, 0x88, 0xEC, 0xE0, 0x10, 0x40, 0xFC, 0x00, 0x00, 0x00, 0x00, 
		0xFF, 0x01, 0x00, 0x70, 0x4C, 0xF0, 0x8C, 0xF0, 0x80, 0xC0, 0xB0, 0x40, 0x40, 0x80, 0x10, 0x00, 
		0x77, 0x70, 0x33, 0x44, 0x48, 0x44, 0x6E, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x0B, 0x2B, 
		0x00, 0x80, 0x60, 0x00, 0x00, 0x00, 0x94, 0x44, 0x00, 0x17, 0x17, 0x18, 0x18, 0x0E, 0x04, 0x00, 
		0x00, 0x00, 0xFB, 0xB0, 0x68, 0x20, 0x00, 0x08, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0xE0, 0x00, 0x10, 0x00, 
		0x0F, 0x0C, 0x00, 0xF3, 0x00, 0x00, 0x80, 0x00, 0x78, 0x00, 0x07, 0x80, 0x00, 0x60, 0x00, 0x00, 
		0xF8, 0x00, 0x04, 0x00, 0x02, 0x00, 0x01, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x80, 0x10, 0xC0, 0x10, 0x00, 0x08, 0x1C, 0xC0, 0x22, 0x96, 0xA5, 0xE0, 0xF0, 0xBF, 0xC0, 0x80, 
		0x03, 0x00, 0x27, 0x10, 0x00, 0x03, 0xE8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x01, 0x00, 0xE0, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//19200KHz 11CK.dat (202.736Mhz)
		0x7F, 0x9F, 0xF1, 0xF8, 0x02, 0x41, 0xFC, 0x00, 0x00, 0xC0, 0x00, 0x0C, 0xC3, 0x00, 0xC0, 0x40, 
		0x59, 0xC0, 0x03, 0xE8, 0x0C, 0xC0, 0x88, 0x33, 0x08, 0xF0, 0xF0, 0xD0, 0x02, 0x00, 0x14, 0x4F, 
		0x4D, 0x05, 0x3A, 0x03, 0xE8, 0xC1, 0x88, 0xEC, 0xE0, 0x10, 0x40, 0xFC, 0x00, 0x00, 0x00, 0x00, 
		0xFF, 0x01, 0x00, 0x70, 0x4C, 0xF0, 0x8C, 0xF0, 0x80, 0xC0, 0xB0, 0x40, 0x40, 0x80, 0x10, 0x00, 
		0x66, 0x60, 0x33, 0x44, 0x48, 0x44, 0x6E, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x0B, 0x2B, 
		0x00, 0x80, 0x60, 0x00, 0x00, 0x00, 0x94, 0x44, 0x00, 0x17, 0x17, 0x18, 0x18, 0x0E, 0x04, 0x00, 
		0x00, 0x00, 0xFB, 0xB0, 0x68, 0x20, 0x00, 0x08, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0xE0, 0x00, 0x10, 0x00, 
		0x0F, 0x0C, 0x00, 0xF3, 0x00, 0x00, 0x80, 0x00, 0x78, 0x00, 0x07, 0x80, 0x00, 0x60, 0x00, 0x00, 
		0xF8, 0x00, 0x04, 0x00, 0x02, 0x00, 0x01, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x80, 0x10, 0xC0, 0x10, 0x00, 0x08, 0x1C, 0xC0, 0x22, 0x96, 0xA5, 0xE0, 0xF0, 0xBF, 0xC0, 0x80, 
		0x03, 0x00, 0x27, 0x10, 0x00, 0x03, 0xE8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x01, 0x00, 0xE0, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//19200KHz 12AK.dat (205.280Mhz)
		0x7F, 0x9F, 0xF1, 0xF8, 0x02, 0x41, 0xFC, 0x00, 0x00, 0xC0, 0x00, 0x0C, 0xC3, 0x00, 0xC0, 0x40, 
		0x59, 0xC0, 0x03, 0xE8, 0x0C, 0xC0, 0x88, 0x33, 0x08, 0xF0, 0xF0, 0xD0, 0x02, 0x00, 0x15, 0x43, 
		0x4D, 0x0C, 0xE8, 0x03, 0xE8, 0xC1, 0x88, 0xEC, 0xE0, 0x10, 0x40, 0xFC, 0x00, 0x00, 0x00, 0x00, 
		0xFF, 0x01, 0x00, 0x70, 0x4C, 0xF0, 0x8C, 0xF0, 0x80, 0xC0, 0xB0, 0x40, 0x40, 0x80, 0x10, 0x00, 
		0x66, 0x60, 0x33, 0x44, 0x48, 0x44, 0x6E, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x0B, 0x2B, 
		0x00, 0x80, 0x60, 0x00, 0x00, 0x00, 0x94, 0x44, 0x00, 0x17, 0x17, 0x18, 0x18, 0x0E, 0x04, 0x00, 
		0x00, 0x00, 0xFB, 0xB0, 0x68, 0x20, 0x00, 0x08, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0xE0, 0x00, 0x10, 0x00, 
		0x0F, 0x0C, 0x00, 0xF3, 0x00, 0x00, 0x80, 0x00, 0x78, 0x00, 0x07, 0x80, 0x00, 0x60, 0x00, 0x00, 
		0xF8, 0x00, 0x04, 0x00, 0x02, 0x00, 0x01, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x80, 0x10, 0xC0, 0x10, 0x00, 0x08, 0x1C, 0xC0, 0x22, 0x96, 0xA5, 0xE0, 0xF0, 0xBF, 0xC0, 0x80, 
		0x03, 0x00, 0x27, 0x10, 0x00, 0x03, 0xE8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x01, 0x00, 0xE0, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//19200KHz 12BK.dat (207.008Mhz)
		0x7F, 0x9F, 0xF1, 0xF8, 0x02, 0x41, 0xFC, 0x00, 0x00, 0xC0, 0x00, 0x0C, 0xC3, 0x00, 0xC0, 0x40, 
		0x59, 0xC0, 0x07, 0xD0, 0x0C, 0xC0, 0x88, 0x33, 0x08, 0xF0, 0xF0, 0xD0, 0x02, 0x00, 0x15, 0x46, 
		0x4D, 0x09, 0x11, 0x03, 0xE8, 0xC1, 0x88, 0xEC, 0xE0, 0x10, 0x40, 0xFC, 0x00, 0x00, 0x00, 0x00, 
		0xFF, 0x01, 0x00, 0x70, 0x4C, 0xF0, 0x8C, 0xF0, 0x80, 0xC0, 0xB0, 0x20, 0x20, 0x80, 0x10, 0x00, 
		0x66, 0x60, 0x33, 0x44, 0x48, 0x44, 0x6E, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x0B, 0x2B, 
		0x00, 0x80, 0x60, 0x00, 0x00, 0x00, 0x94, 0x44, 0x00, 0x17, 0x17, 0x18, 0x18, 0x0E, 0x04, 0x00, 
		0x00, 0x00, 0xFB, 0xB0, 0x68, 0x20, 0x00, 0x08, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0xE0, 0x00, 0x10, 0x00, 
		0x0F, 0x0C, 0x00, 0xF3, 0x00, 0x00, 0x80, 0x00, 0x78, 0x00, 0x07, 0x80, 0x00, 0x60, 0x00, 0x00, 
		0xF8, 0x00, 0x04, 0x00, 0x02, 0x00, 0x01, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x80, 0x10, 0xC0, 0x10, 0x00, 0x08, 0x1C, 0xC0, 0x22, 0x96, 0xA5, 0xE0, 0xF0, 0xBF, 0xC0, 0x80, 
		0x03, 0x00, 0x27, 0x10, 0x00, 0x03, 0xE8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x01, 0x00, 0xE0, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//19200KHz 12CK.dat (208.736Mhz)
		0x7F, 0x9F, 0xF1, 0xF8, 0x02, 0x41, 0xFC, 0x00, 0x00, 0xC0, 0x00, 0x0C, 0xC3, 0x00, 0xC0, 0x40, 
		0x59, 0xC0, 0x03, 0xE8, 0x0C, 0xC0, 0x88, 0x33, 0x08, 0xF0, 0xF0, 0xD0, 0x02, 0x00, 0x15, 0x49, 
		0x4D, 0x05, 0x3A, 0x03, 0xE8, 0xC1, 0x88, 0xEC, 0xE0, 0x10, 0x40, 0xFC, 0x00, 0x00, 0x00, 0x00, 
		0xFF, 0x01, 0x00, 0x70, 0x4C, 0xF0, 0x8C, 0xF0, 0x80, 0xC0, 0xB0, 0x20, 0x20, 0x80, 0x10, 0x00, 
		0x66, 0x60, 0x33, 0x44, 0x48, 0x44, 0x6E, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x0B, 0x2B, 
		0x00, 0x80, 0x60, 0x00, 0x00, 0x00, 0x94, 0x44, 0x00, 0x17, 0x17, 0x18, 0x18, 0x0E, 0x04, 0x00, 
		0x00, 0x00, 0xFB, 0xB0, 0x68, 0x20, 0x00, 0x08, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0xE0, 0x00, 0x10, 0x00, 
		0x0F, 0x0C, 0x00, 0xF3, 0x00, 0x00, 0x80, 0x00, 0x78, 0x00, 0x07, 0x80, 0x00, 0x60, 0x00, 0x00, 
		0xF8, 0x00, 0x04, 0x00, 0x02, 0x00, 0x01, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x80, 0x10, 0xC0, 0x10, 0x00, 0x08, 0x1C, 0xC0, 0x22, 0x96, 0xA5, 0xE0, 0xF0, 0xBF, 0xC0, 0x80, 
		0x03, 0x00, 0x27, 0x10, 0x00, 0x03, 0xE8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x01, 0x00, 0xE0, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//19200KHz 13AK.dat (211.280Mhz)
		0x7F, 0x9F, 0xF1, 0xF8, 0x02, 0x41, 0xFC, 0x00, 0x00, 0xC0, 0x00, 0x0C, 0xC3, 0x00, 0xC0, 0x40, 
		0x59, 0xC0, 0x03, 0xE8, 0x4C, 0xC0, 0x88, 0x33, 0x08, 0xF0, 0xF0, 0xD0, 0x02, 0x00, 0x15, 0x4D, 
		0x4D, 0x0C, 0xE8, 0x03, 0xE8, 0xC1, 0x88, 0xEC, 0xE0, 0x10, 0x40, 0xFC, 0x00, 0x00, 0x00, 0x00, 
		0xFF, 0x01, 0x00, 0x70, 0x4C, 0xF0, 0x8C, 0xF0, 0x80, 0xC0, 0xB0, 0x20, 0x20, 0x80, 0x10, 0x00, 
		0x66, 0x60, 0x33, 0x44, 0x48, 0x44, 0x6E, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x0B, 0x2B, 
		0x00, 0x80, 0x60, 0x00, 0x00, 0x00, 0x94, 0x44, 0x00, 0x17, 0x17, 0x18, 0x18, 0x0E, 0x04, 0x00, 
		0x00, 0x00, 0xFB, 0xB0, 0x68, 0x20, 0x00, 0x08, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0xE0, 0x00, 0x10, 0x00, 
		0x0F, 0x0C, 0x00, 0xF3, 0x00, 0x00, 0x80, 0x00, 0x78, 0x00, 0x07, 0x80, 0x00, 0x60, 0x00, 0x00, 
		0xF8, 0x00, 0x04, 0x00, 0x02, 0x00, 0x01, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x80, 0x10, 0xC0, 0x10, 0x00, 0x08, 0x1C, 0xC0, 0x22, 0x96, 0xA5, 0xE0, 0xF0, 0xBF, 0xC0, 0x80, 
		0x03, 0x00, 0x27, 0x10, 0x00, 0x03, 0xE8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x01, 0x00, 0xE0, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//19200KHz 13BK.dat (213.008Mhz)
		0x7F, 0x9F, 0xF1, 0xF8, 0x02, 0x41, 0xFC, 0x00, 0x00, 0xC0, 0x00, 0x0C, 0xC3, 0x00, 0xC0, 0x40, 
		0x59, 0xC0, 0x03, 0xE8, 0x0C, 0xC0, 0x88, 0x33, 0x08, 0xF0, 0xF0, 0xD0, 0x02, 0x00, 0x16, 0x40, 
		0x4D, 0x09, 0x11, 0x03, 0xE8, 0xC1, 0x88, 0xEC, 0xE0, 0x10, 0x40, 0xFC, 0x00, 0x00, 0x00, 0x00, 
		0xFF, 0x01, 0x00, 0x70, 0x4C, 0xF0, 0x8C, 0xF0, 0x80, 0xC0, 0xB0, 0x20, 0x20, 0x80, 0x10, 0x00, 
		0x66, 0x60, 0x33, 0x44, 0x48, 0x44, 0x6E, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x0B, 0x2B, 
		0x00, 0x80, 0x60, 0x00, 0x00, 0x00, 0x94, 0x44, 0x00, 0x17, 0x17, 0x18, 0x18, 0x0E, 0x04, 0x00, 
		0x00, 0x00, 0xFB, 0xB0, 0x68, 0x20, 0x00, 0x08, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0xE0, 0x00, 0x10, 0x00, 
		0x0F, 0x0C, 0x00, 0xF3, 0x00, 0x00, 0x80, 0x00, 0x78, 0x00, 0x07, 0x80, 0x00, 0x60, 0x00, 0x00, 
		0xF8, 0x00, 0x04, 0x00, 0x02, 0x00, 0x01, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x80, 0x10, 0xC0, 0x10, 0x00, 0x08, 0x1C, 0xC0, 0x22, 0x96, 0xA5, 0xE0, 0xF0, 0xBF, 0xC0, 0x80, 
		0x03, 0x00, 0x27, 0x10, 0x00, 0x03, 0xE8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x01, 0x00, 0xE0, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//19200KHz 13CK.dat (214.736Mhz)
		0x7F, 0x9F, 0xF1, 0xF8, 0x02, 0x41, 0xFC, 0x00, 0x00, 0xC0, 0x00, 0x0C, 0xC3, 0x00, 0xC0, 0x40, 
		0x59, 0xC0, 0x03, 0xE8, 0x0C, 0xC0, 0x88, 0x33, 0x08, 0xF0, 0xF0, 0xD0, 0x02, 0x00, 0x16, 0x43, 
		0x4D, 0x05, 0x3A, 0x03, 0xE8, 0xC1, 0x88, 0xEC, 0xE0, 0x10, 0x40, 0xFC, 0x00, 0x00, 0x00, 0x00, 
		0xFF, 0x01, 0x00, 0x70, 0x4C, 0xF0, 0x8C, 0xF0, 0x80, 0xC0, 0xB0, 0x20, 0x20, 0x80, 0x10, 0x00, 
		0x66, 0x60, 0x33, 0x44, 0x48, 0x44, 0x6E, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x0B, 0x2B, 
		0x00, 0x80, 0x60, 0x00, 0x00, 0x00, 0x94, 0x44, 0x00, 0x17, 0x17, 0x18, 0x18, 0x0E, 0x04, 0x00, 
		0x00, 0x00, 0xFB, 0xB0, 0x68, 0x20, 0x00, 0x08, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0xE0, 0x00, 0x10, 0x00, 
		0x0F, 0x0C, 0x00, 0xF3, 0x00, 0x00, 0x80, 0x00, 0x78, 0x00, 0x07, 0x80, 0x00, 0x60, 0x00, 0x00, 
		0xF8, 0x00, 0x04, 0x00, 0x02, 0x00, 0x01, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x80, 0x10, 0xC0, 0x10, 0x00, 0x08, 0x1C, 0xC0, 0x22, 0x96, 0xA5, 0xE0, 0xF0, 0xBF, 0xC0, 0x80, 
		0x03, 0x00, 0x27, 0x10, 0x00, 0x03, 0xE8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x01, 0x00, 0xE0, 0x00, 0x00, 0x00, 0x00, 
	},
};// end of default : No LNA version

static INC_UINT8 g_acT3900KorI2CValue_24576[MAX_KOREABAND_FULL_CHANNEL][RF500_REG_CTRL] = 
{
	{	//24576KHz 7AK.dat (175.280Mhz)
		0x55, 0x9F, 0xF1, 0xF8, 0x02, 0x41, 0xFC, 0x00, 0x00, 0xC0, 0x00, 0x0C, 0xC3, 0x00, 0xC0, 0x40, 
		0x73, 0x80, 0x03, 0xE8, 0x0C, 0xC0, 0x88, 0x33, 0x08, 0xF0, 0xF0, 0xD0, 0x03, 0x00, 0x15, 0x43, 
		0x4D, 0x04, 0xA0, 0x03, 0xE8, 0xC1, 0x88, 0x08, 0xE0, 0x10, 0x40, 0xFC, 0x00, 0x00, 0x00, 0x00, 
		0x0F, 0x01, 0x00, 0x70, 0x4C, 0xF0, 0x8C, 0xF0, 0x80, 0xC0, 0xC0, 0x70, 0x70, 0x80, 0x10, 0x00, 
		0xEE, 0xE0, 0x33, 0x44, 0x48, 0x33, 0x6E, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x0B, 0x2B, 
		0x00, 0x80, 0x60, 0x00, 0x00, 0x00, 0x94, 0x44, 0x00, 0x15, 0x0F, 0x18, 0x18, 0x0E, 0x04, 0x00, 
		0x00, 0x00, 0xFB, 0xB0, 0x68, 0x20, 0x00, 0x08, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0xE0, 0x00, 0x10, 0x00, 
		0x0F, 0x0C, 0x00, 0xF3, 0x00, 0x00, 0x80, 0x00, 0x78, 0x00, 0x07, 0x80, 0x00, 0x60, 0x00, 0x00, 
		0xF8, 0x00, 0x04, 0x00, 0x02, 0x00, 0x01, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x80, 0x10, 0xC0, 0x10, 0x00, 0x08, 0x1C, 0xC0, 0x22, 0x96, 0xA5, 0xE0, 0xF0, 0xBF, 0xC0, 0x80, 
		0x03, 0x00, 0x05, 0xDC, 0x00, 0x05, 0xDC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x01, 0x00, 0xE0, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//24576KHz 7BK.dat (177.008Mhz)
		0x55, 0x9F, 0xF1, 0xF8, 0x02, 0x41, 0xFC, 0x00, 0x00, 0xC0, 0x00, 0x0C, 0xC3, 0x00, 0xC0, 0x40, 
		0x73, 0x80, 0x03, 0xE8, 0x0C, 0xC0, 0x88, 0x33, 0x08, 0xF0, 0xF0, 0xD0, 0x03, 0x00, 0x15, 0x46, 
		0x4D, 0x10, 0xA0, 0x03, 0xE8, 0xC1, 0x88, 0x08, 0xE0, 0x10, 0x40, 0xFC, 0x00, 0x00, 0x00, 0x00, 
		0x0F, 0x01, 0x00, 0x70, 0x4C, 0xF0, 0x8C, 0xF0, 0x80, 0xC0, 0xC0, 0x70, 0x70, 0x80, 0x10, 0x00, 
		0xEE, 0xE0, 0x33, 0x44, 0x48, 0x33, 0x6E, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x0B, 0x2B, 
		0x00, 0x80, 0x60, 0x00, 0x00, 0x00, 0x94, 0x44, 0x00, 0x15, 0x0F, 0x18, 0x18, 0x0E, 0x04, 0x00, 
		0x00, 0x00, 0xFB, 0xB0, 0x68, 0x20, 0x00, 0x08, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0xE0, 0x00, 0x10, 0x00, 
		0x0F, 0x0C, 0x00, 0xF3, 0x00, 0x00, 0x80, 0x00, 0x78, 0x00, 0x07, 0x80, 0x00, 0x60, 0x00, 0x00, 
		0xF8, 0x00, 0x04, 0x00, 0x02, 0x00, 0x01, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x80, 0x10, 0xC0, 0x10, 0x00, 0x08, 0x1C, 0xC0, 0x22, 0x96, 0xA5, 0xE0, 0xF0, 0xFF, 0xC0, 0x80, 
		0x03, 0x00, 0x05, 0xDC, 0x00, 0x05, 0xDC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x01, 0x00, 0xE0, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//24576KHz 7CK.dat (178.736Mhz)
		0x55, 0x9F, 0xF1, 0xF8, 0x02, 0x41, 0xFC, 0x00, 0x00, 0xC0, 0x00, 0x0C, 0xC3, 0x00, 0xC0, 0x40, 
		0x73, 0x80, 0x03, 0xE8, 0x0C, 0xC0, 0x88, 0x33, 0x08, 0xF0, 0xF0, 0xD0, 0x03, 0x00, 0x15, 0x49, 
		0x4D, 0x1C, 0x9F, 0x03, 0xE8, 0xC1, 0x88, 0x08, 0xE0, 0x10, 0x40, 0xFC, 0x00, 0x00, 0x00, 0x00, 
		0x0F, 0x01, 0x00, 0x70, 0x4C, 0xF0, 0x8C, 0xF0, 0x80, 0xC0, 0xC0, 0x80, 0x60, 0x80, 0x10, 0x00, 
		0xCC, 0xC0, 0x33, 0x44, 0x48, 0x33, 0x6E, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x0B, 0x2B, 
		0x00, 0x80, 0x60, 0x00, 0x00, 0x00, 0x94, 0x44, 0x00, 0x15, 0x0F, 0x18, 0x18, 0x0E, 0x04, 0x00, 
		0x00, 0x00, 0xFB, 0xB0, 0x68, 0x20, 0x00, 0x08, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0xE0, 0x00, 0x10, 0x00, 
		0x0F, 0x0C, 0x00, 0xF3, 0x00, 0x00, 0x80, 0x00, 0x78, 0x00, 0x07, 0x80, 0x00, 0x60, 0x00, 0x00, 
		0xF8, 0x00, 0x04, 0x00, 0x02, 0x00, 0x01, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x80, 0x10, 0xC0, 0x10, 0x00, 0x08, 0x1C, 0xC0, 0x22, 0x96, 0xA5, 0xE0, 0xF0, 0xBF, 0xC0, 0x80, 
		0x03, 0x00, 0x05, 0xDC, 0x00, 0x05, 0xDC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x01, 0x00, 0xE0, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//24576KHz 8AK.dat (181.280Mhz)
		0x55, 0x9F, 0xF1, 0xF8, 0x02, 0x41, 0xFC, 0x00, 0x00, 0xC0, 0x00, 0x0C, 0xC3, 0x00, 0xC0, 0x40, 
		0x73, 0x80, 0x03, 0xE8, 0x0C, 0xC0, 0x88, 0x33, 0x08, 0xF0, 0xF0, 0xD0, 0x03, 0x00, 0x15, 0x4E, 
		0x4D, 0x1B, 0xA0, 0x03, 0xE8, 0xC1, 0x88, 0x08, 0xE0, 0x10, 0x40, 0xFC, 0x00, 0x00, 0x00, 0x00, 
		0x0F, 0x01, 0x00, 0x70, 0x4C, 0xF0, 0x8C, 0xF0, 0x80, 0xC0, 0xC0, 0x60, 0x60, 0x80, 0x10, 0x00, 
		0xCC, 0xC0, 0x33, 0x44, 0x48, 0x33, 0x6E, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x0B, 0x2B, 
		0x00, 0x80, 0x60, 0x00, 0x00, 0x00, 0x94, 0x44, 0x00, 0x15, 0x0F, 0x18, 0x18, 0x0E, 0x04, 0x00, 
		0x00, 0x00, 0xFB, 0xB0, 0x68, 0x20, 0x00, 0x08, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0xE0, 0x00, 0x10, 0x00, 
		0x0F, 0x0C, 0x00, 0xF3, 0x00, 0x00, 0x80, 0x00, 0x78, 0x00, 0x07, 0x80, 0x00, 0x60, 0x00, 0x00, 
		0xF8, 0x00, 0x04, 0x00, 0x02, 0x00, 0x01, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x80, 0x10, 0xC0, 0x10, 0x00, 0x08, 0x1C, 0xC0, 0x22, 0x96, 0xA5, 0xE0, 0xF0, 0xBF, 0xC0, 0x80, 
		0x03, 0x00, 0x05, 0xDC, 0x00, 0x05, 0xDC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x01, 0x00, 0xE0, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//24576KHz 8BK.dat (183.008Mhz)
		0x55, 0x9F, 0xF1, 0xF8, 0x02, 0x41, 0xFC, 0x00, 0x00, 0xC0, 0x00, 0x0C, 0xC3, 0x00, 0xC0, 0x40, 
		0x73, 0x80, 0x03, 0xE8, 0x0C, 0xC0, 0x88, 0x33, 0x08, 0xF0, 0xF0, 0xD0, 0x03, 0x00, 0x16, 0x42, 
		0x4D, 0x07, 0xA0, 0x03, 0xE8, 0xC1, 0x88, 0x08, 0xE0, 0x10, 0x40, 0xFC, 0x00, 0x00, 0x00, 0x00, 
		0x0F, 0x01, 0x00, 0x70, 0x4C, 0xF0, 0x8C, 0xF0, 0x80, 0xC0, 0xC0, 0x60, 0x60, 0x80, 0x10, 0x00, 
		0xBB, 0xB0, 0x33, 0x44, 0x48, 0x33, 0x6E, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x0B, 0x2B, 
		0x00, 0x80, 0x60, 0x00, 0x00, 0x00, 0x94, 0x44, 0x00, 0x15, 0x0F, 0x18, 0x18, 0x0E, 0x04, 0x00, 
		0x00, 0x00, 0xFB, 0xB0, 0x68, 0x20, 0x00, 0x08, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0xE0, 0x00, 0x10, 0x00, 
		0x0F, 0x0C, 0x00, 0xF3, 0x00, 0x00, 0x80, 0x00, 0x78, 0x00, 0x07, 0x80, 0x00, 0x60, 0x00, 0x00, 
		0xF8, 0x00, 0x04, 0x00, 0x02, 0x00, 0x01, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x80, 0x10, 0xC0, 0x10, 0x00, 0x08, 0x1C, 0xC0, 0x22, 0x96, 0xA5, 0xE0, 0xF0, 0xBF, 0xC0, 0x80, 
		0x03, 0x00, 0x05, 0xDC, 0x00, 0x05, 0xDC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x01, 0x00, 0xE0, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//24576KHz 8CK.dat (184.736Mhz)
		0x55, 0x9F, 0xF1, 0xF8, 0x02, 0x41, 0xFC, 0x00, 0x00, 0xC0, 0x00, 0x0C, 0xC3, 0x00, 0xC0, 0x40, 
		0x73, 0x80, 0x03, 0xE8, 0x0C, 0xC0, 0x88, 0x33, 0x08, 0xF0, 0xF0, 0xD0, 0x03, 0x00, 0x16, 0x45, 
		0x4D, 0x13, 0xA0, 0x03, 0xE8, 0xC1, 0x88, 0x08, 0xE0, 0x10, 0x40, 0xFC, 0x00, 0x00, 0x00, 0x00, 
		0x0F, 0x01, 0x00, 0x70, 0x4C, 0xF0, 0x8C, 0xF0, 0x80, 0xC0, 0xC0, 0x60, 0x60, 0x80, 0x10, 0x00, 
		0xAA, 0xA0, 0x33, 0x44, 0x48, 0x33, 0x6E, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x0B, 0x2B, 
		0x00, 0x80, 0x60, 0x00, 0x00, 0x00, 0x94, 0x44, 0x00, 0x15, 0x0F, 0x18, 0x18, 0x0E, 0x04, 0x00, 
		0x00, 0x00, 0xFB, 0xB0, 0x68, 0x20, 0x00, 0x08, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0xE0, 0x00, 0x10, 0x00, 
		0x0F, 0x0C, 0x00, 0xF3, 0x00, 0x00, 0x80, 0x00, 0x78, 0x00, 0x07, 0x80, 0x00, 0x60, 0x00, 0x00, 
		0xF8, 0x00, 0x04, 0x00, 0x02, 0x00, 0x01, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x80, 0x10, 0xC0, 0x10, 0x00, 0x08, 0x1C, 0xC0, 0x22, 0x96, 0xA5, 0xE0, 0xF0, 0xBF, 0xC0, 0x80, 
		0x03, 0x00, 0x05, 0xDC, 0x00, 0x05, 0xDC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x01, 0x00, 0xE0, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//24576KHz 9AK.dat (187.280Mhz)
		0x55, 0x9F, 0xF1, 0xF8, 0x02, 0x41, 0xFC, 0x00, 0x00, 0xC0, 0x00, 0x0C, 0xC3, 0x00, 0xC0, 0x40, 
		0x73, 0x80, 0x03, 0xE8, 0x0C, 0xC0, 0x88, 0x33, 0x08, 0xF0, 0xF0, 0xD0, 0x03, 0x00, 0x16, 0x4A, 
		0x4D, 0x12, 0xA0, 0x03, 0xE8, 0xC1, 0x88, 0x08, 0xE0, 0x10, 0x40, 0xFC, 0x00, 0x00, 0x00, 0x00, 
		0x0F, 0x01, 0x00, 0x70, 0x4C, 0xF0, 0x8C, 0xF0, 0x80, 0xC0, 0xC0, 0x60, 0x60, 0x80, 0x10, 0x00, 
		0xAA, 0xA0, 0x33, 0x44, 0x48, 0x33, 0x6E, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x0B, 0x2B, 
		0x00, 0x80, 0x60, 0x00, 0x00, 0x00, 0x94, 0x44, 0x00, 0x15, 0x0F, 0x18, 0x18, 0x0E, 0x04, 0x00, 
		0x00, 0x00, 0xFB, 0xB0, 0x68, 0x20, 0x00, 0x08, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0xE0, 0x00, 0x10, 0x00, 
		0x0F, 0x0C, 0x00, 0xF3, 0x00, 0x00, 0x80, 0x00, 0x78, 0x00, 0x07, 0x80, 0x00, 0x60, 0x00, 0x00, 
		0xF8, 0x00, 0x04, 0x00, 0x02, 0x00, 0x01, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x80, 0x10, 0xC0, 0x10, 0x00, 0x08, 0x1C, 0xC0, 0x22, 0x96, 0xA5, 0xE0, 0xF0, 0xBF, 0xC0, 0x80, 
		0x03, 0x00, 0x05, 0xDC, 0x00, 0x05, 0xDC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x01, 0x00, 0xE0, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//24576KHz 9BK.dat (189.008Mhz)
		0x55, 0x9F, 0xF1, 0xF8, 0x02, 0x41, 0xFC, 0x00, 0x00, 0xC0, 0x00, 0x0C, 0xC3, 0x00, 0xC0, 0x40, 
		0x73, 0x80, 0x03, 0xE8, 0x0C, 0xC0, 0x88, 0x33, 0x08, 0xF0, 0xF0, 0xD0, 0x02, 0x00, 0x0F, 0x43, 
		0x4D, 0x1F, 0x15, 0x03, 0xE8, 0xC1, 0x88, 0x08, 0xE0, 0x10, 0x40, 0xFC, 0x00, 0x00, 0x00, 0x00, 
		0x0F, 0x01, 0x00, 0x70, 0x4C, 0xF0, 0x8C, 0xF0, 0x80, 0xC0, 0xC0, 0x50, 0x50, 0x80, 0x10, 0x00, 
		0x99, 0x90, 0x33, 0x44, 0x48, 0x33, 0x6E, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x0B, 0x2B, 
		0x00, 0x80, 0x60, 0x00, 0x00, 0x00, 0x94, 0x44, 0x00, 0x15, 0x0F, 0x18, 0x18, 0x0E, 0x04, 0x00, 
		0x00, 0x00, 0xFB, 0xB0, 0x68, 0x20, 0x00, 0x08, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0xE0, 0x00, 0x10, 0x00, 
		0x0F, 0x0C, 0x00, 0xF3, 0x00, 0x00, 0x80, 0x00, 0x78, 0x00, 0x07, 0x80, 0x00, 0x60, 0x00, 0x00, 
		0xF8, 0x00, 0x04, 0x00, 0x02, 0x00, 0x01, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x80, 0x10, 0xC0, 0x10, 0x00, 0x08, 0x1C, 0xC0, 0x22, 0x96, 0xA5, 0xE0, 0xF0, 0xBF, 0xC0, 0x80, 
		0x03, 0x00, 0x05, 0xDC, 0x00, 0x05, 0xDC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x01, 0x00, 0xE0, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//24576KHz 9CK.dat (190.736Mhz)
		0x55, 0x9F, 0xF1, 0xF8, 0x02, 0x41, 0xFC, 0x00, 0x00, 0xC0, 0x00, 0x0C, 0xC3, 0x00, 0xC0, 0x40, 
		0x73, 0x80, 0x03, 0xE8, 0x0C, 0xC0, 0x88, 0x33, 0x08, 0xF0, 0xF0, 0xD0, 0x03, 0x00, 0x17, 0x41, 
		0x4D, 0x0A, 0xA0, 0x03, 0xE8, 0xC1, 0x88, 0x08, 0xE0, 0x10, 0x40, 0xFC, 0x00, 0x00, 0x00, 0x00, 
		0x0F, 0x01, 0x00, 0x70, 0x4C, 0xF0, 0x8C, 0xF0, 0x80, 0xC0, 0xC0, 0x50, 0x50, 0x80, 0x10, 0x00, 
		0x99, 0x90, 0x33, 0x44, 0x48, 0x33, 0x6E, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x0B, 0x2B, 
		0x00, 0x80, 0x60, 0x00, 0x00, 0x00, 0x94, 0x44, 0x00, 0x15, 0x0F, 0x18, 0x18, 0x0E, 0x04, 0x00, 
		0x00, 0x00, 0xFB, 0xB0, 0x68, 0x20, 0x00, 0x08, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0xE0, 0x00, 0x10, 0x00, 
		0x0F, 0x0C, 0x00, 0xF3, 0x00, 0x00, 0x80, 0x00, 0x78, 0x00, 0x07, 0x80, 0x00, 0x60, 0x00, 0x00, 
		0xF8, 0x00, 0x04, 0x00, 0x02, 0x00, 0x01, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x80, 0x10, 0xC0, 0x10, 0x00, 0x08, 0x1C, 0xC0, 0x22, 0x96, 0xA5, 0xE0, 0xF0, 0xBF, 0xC0, 0x80, 
		0x03, 0x00, 0x05, 0xDC, 0x00, 0x05, 0xDC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x01, 0x00, 0xE0, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//24576KHz 10AK.dat (193.280Mhz)
		0x55, 0x9F, 0xF1, 0xF8, 0x02, 0x41, 0xFC, 0x00, 0x00, 0xC0, 0x00, 0x0C, 0xC3, 0x00, 0xC0, 0x40, 
		0x73, 0x80, 0x03, 0xE8, 0x0C, 0xC0, 0x88, 0x33, 0x08, 0xF0, 0xF0, 0xD0, 0x03, 0x00, 0x17, 0x46, 
		0x4D, 0x09, 0xA0, 0x03, 0xE8, 0xC1, 0x88, 0x08, 0xE0, 0x10, 0x40, 0xFC, 0x00, 0x00, 0x00, 0x00, 
		0x0F, 0x01, 0x00, 0x70, 0x4C, 0xF0, 0x8C, 0xF0, 0x80, 0xC0, 0xC0, 0x50, 0x50, 0x80, 0x10, 0x00, 
		0x99, 0x90, 0x33, 0x44, 0x48, 0x33, 0x6E, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x0B, 0x2B, 
		0x00, 0x80, 0x60, 0x00, 0x00, 0x00, 0x94, 0x44, 0x00, 0x15, 0x0F, 0x18, 0x18, 0x0E, 0x04, 0x00, 
		0x00, 0x00, 0xFB, 0xB0, 0x68, 0x20, 0x00, 0x08, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0xE0, 0x00, 0x10, 0x00, 
		0x0F, 0x0C, 0x00, 0xF3, 0x00, 0x00, 0x80, 0x00, 0x78, 0x00, 0x07, 0x80, 0x00, 0x60, 0x00, 0x00, 
		0xF8, 0x00, 0x04, 0x00, 0x02, 0x00, 0x01, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x80, 0x10, 0xC0, 0x10, 0x00, 0x08, 0x1C, 0xC0, 0x22, 0x96, 0xA5, 0xE0, 0xF0, 0xBF, 0xC0, 0x80, 
		0x03, 0x00, 0x05, 0xDC, 0x00, 0x05, 0xDC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x01, 0x00, 0xE0, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//24576KHz 10BK.dat (195.008Mhz)
		0x55, 0x9F, 0xF1, 0xF8, 0x02, 0x41, 0xFC, 0x00, 0x00, 0xC0, 0x00, 0x0C, 0xC3, 0x00, 0xC0, 0x40, 
		0x73, 0x80, 0x03, 0xE8, 0x0C, 0xC0, 0x88, 0x33, 0x08, 0xF0, 0xF0, 0xD0, 0x03, 0x00, 0x17, 0x49, 
		0x4D, 0x15, 0xA0, 0x03, 0xE8, 0xC1, 0x88, 0x08, 0xE0, 0x10, 0x40, 0xFC, 0x00, 0x00, 0x00, 0x00, 
		0x0F, 0x01, 0x00, 0x70, 0x4C, 0xF0, 0x8C, 0xF0, 0x80, 0xC0, 0xC0, 0x40, 0x40, 0x80, 0x10, 0x00, 
		0x88, 0x80, 0x33, 0x44, 0x48, 0x33, 0x6E, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x0B, 0x2B, 
		0x00, 0x80, 0x60, 0x00, 0x00, 0x00, 0x94, 0x44, 0x00, 0x15, 0x0F, 0x18, 0x18, 0x0E, 0x04, 0x00, 
		0x00, 0x00, 0xFB, 0xB0, 0x68, 0x20, 0x00, 0x08, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0xE0, 0x00, 0x10, 0x00, 
		0x0F, 0x0C, 0x00, 0xF3, 0x00, 0x00, 0x80, 0x00, 0x78, 0x00, 0x07, 0x80, 0x00, 0x60, 0x00, 0x00, 
		0xF8, 0x00, 0x04, 0x00, 0x02, 0x00, 0x01, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x80, 0x10, 0xC0, 0x10, 0x00, 0x08, 0x1C, 0xC0, 0x22, 0x96, 0xA5, 0xE0, 0xF0, 0xFF, 0xC0, 0x50, 
		0x03, 0x00, 0x05, 0xDC, 0x00, 0x05, 0xDC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x01, 0x00, 0xE0, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//24576KHz 10CK.dat (196.736Mhz)
		0x55, 0x9F, 0xF1, 0xF8, 0x02, 0x41, 0xFC, 0x00, 0x00, 0xC0, 0x00, 0x0C, 0xC3, 0x00, 0xC0, 0x40, 
		0x73, 0x80, 0x03, 0xE8, 0x0C, 0xC0, 0x88, 0x33, 0x08, 0xF0, 0xF0, 0xD0, 0x04, 0x00, 0x1F, 0x4C, 
		0x4D, 0x02, 0x2A, 0x03, 0xE8, 0xC1, 0x88, 0x08, 0xE0, 0x10, 0x40, 0xFC, 0x00, 0x00, 0x00, 0x00, 
		0x0F, 0x01, 0x00, 0x70, 0x4C, 0xF0, 0x8C, 0xF0, 0x80, 0xC0, 0xC0, 0x40, 0x40, 0x80, 0x10, 0x00, 
		0x88, 0x80, 0x33, 0x44, 0x48, 0x33, 0x6E, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x0B, 0x2B, 
		0x00, 0x80, 0x60, 0x00, 0x00, 0x00, 0x94, 0x44, 0x00, 0x15, 0x0F, 0x18, 0x18, 0x0E, 0x04, 0x00, 
		0x00, 0x00, 0xFB, 0xB0, 0x68, 0x20, 0x00, 0x08, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0xE0, 0x00, 0x10, 0x00, 
		0x0F, 0x0C, 0x00, 0xF3, 0x00, 0x00, 0x80, 0x00, 0x78, 0x00, 0x07, 0x80, 0x00, 0x60, 0x00, 0x00, 
		0xF8, 0x00, 0x04, 0x00, 0x02, 0x00, 0x01, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x80, 0x10, 0xC0, 0x10, 0x00, 0x08, 0x1C, 0xC0, 0x22, 0x96, 0xA5, 0xE0, 0xF0, 0xFF, 0xC0, 0x50, 
		0x03, 0x00, 0x05, 0xDC, 0x00, 0x05, 0xDC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x01, 0x00, 0xE0, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//24576KHz 11AK.dat (199.280Mhz)
		0x55, 0x9F, 0xF1, 0xF8, 0x02, 0x41, 0xFC, 0x00, 0x00, 0xC0, 0x00, 0x0C, 0xC3, 0x00, 0xC0, 0x40, 
		0x73, 0x80, 0x03, 0xE8, 0x0C, 0xC0, 0x88, 0x33, 0x08, 0xF0, 0xF0, 0xD0, 0x03, 0x00, 0x18, 0x42, 
		0x4D, 0x00, 0xA0, 0x03, 0xE8, 0xC1, 0x88, 0x08, 0xE0, 0x10, 0x40, 0xFC, 0x00, 0x00, 0x00, 0x00, 
		0x0F, 0x01, 0x00, 0x70, 0x4C, 0xF0, 0x8C, 0xF0, 0x80, 0xC0, 0xC0, 0x40, 0x40, 0x80, 0x10, 0x00, 
		0x88, 0x80, 0x33, 0x44, 0x48, 0x33, 0x6E, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x0B, 0x2B, 
		0x00, 0x80, 0x60, 0x00, 0x00, 0x00, 0x94, 0x44, 0x00, 0x15, 0x0F, 0x18, 0x18, 0x0E, 0x04, 0x00, 
		0x00, 0x00, 0xFB, 0xB0, 0x68, 0x20, 0x00, 0x08, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0xE0, 0x00, 0x10, 0x00, 
		0x0F, 0x0C, 0x00, 0xF3, 0x00, 0x00, 0x80, 0x00, 0x78, 0x00, 0x07, 0x80, 0x00, 0x60, 0x00, 0x00, 
		0xF8, 0x00, 0x04, 0x00, 0x02, 0x00, 0x01, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x80, 0x10, 0xC0, 0x10, 0x00, 0x08, 0x1C, 0xC0, 0x22, 0x96, 0xA5, 0xE0, 0xF0, 0xBF, 0xC0, 0x80, 
		0x03, 0x00, 0x05, 0xDC, 0x00, 0x05, 0xDC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x01, 0x00, 0xE0, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//24576KHz 11BK.dat (201.008Mhz)
		0x55, 0x9F, 0xF1, 0xF8, 0x02, 0x41, 0xFC, 0x00, 0x00, 0xC0, 0x00, 0x0C, 0xC3, 0x00, 0xC0, 0x40, 
		0x73, 0x80, 0x03, 0xE8, 0x0C, 0xC0, 0x88, 0x33, 0x08, 0xF0, 0xF0, 0xD0, 0x03, 0x00, 0x18, 0x45, 
		0x4D, 0x0C, 0xA0, 0x03, 0xE8, 0xC1, 0x88, 0x08, 0xE0, 0x10, 0x40, 0xFC, 0x00, 0x00, 0x00, 0x00, 
		0x0F, 0x01, 0x00, 0x70, 0x4C, 0xF0, 0x8C, 0xF0, 0x80, 0xC0, 0xC0, 0x40, 0x40, 0x80, 0x10, 0x00, 
		0x77, 0x70, 0x33, 0x44, 0x48, 0x33, 0x6E, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x0B, 0x2B, 
		0x00, 0x80, 0x60, 0x00, 0x00, 0x00, 0x94, 0x44, 0x00, 0x15, 0x0F, 0x18, 0x18, 0x0E, 0x04, 0x00, 
		0x00, 0x00, 0xFB, 0xB0, 0x68, 0x20, 0x00, 0x08, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0xE0, 0x00, 0x10, 0x00, 
		0x0F, 0x0C, 0x00, 0xF3, 0x00, 0x00, 0x80, 0x00, 0x78, 0x00, 0x07, 0x80, 0x00, 0x60, 0x00, 0x00, 
		0xF8, 0x00, 0x04, 0x00, 0x02, 0x00, 0x01, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x80, 0x10, 0xC0, 0x10, 0x00, 0x08, 0x1C, 0xC0, 0x22, 0x96, 0xA5, 0xE0, 0xF0, 0xBF, 0xC0, 0x80, 
		0x03, 0x00, 0x05, 0xDC, 0x00, 0x05, 0xDC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x01, 0x00, 0xE0, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//24576KHz 11CK.dat (202.736Mhz)
		0x55, 0x9F, 0xF1, 0xF8, 0x02, 0x41, 0xFC, 0x00, 0x00, 0xC0, 0x00, 0x0C, 0xC3, 0x00, 0xC0, 0x40, 
		0x73, 0x80, 0x03, 0xE8, 0x0C, 0xC0, 0x88, 0x33, 0x08, 0xF0, 0xF0, 0xD0, 0x03, 0x00, 0x18, 0x48, 
		0x4D, 0x18, 0xA0, 0x03, 0xE8, 0xC1, 0x88, 0x08, 0xE0, 0x10, 0x40, 0xFC, 0x00, 0x00, 0x00, 0x00, 
		0x0F, 0x01, 0x00, 0x70, 0x4C, 0xF0, 0x8C, 0xF0, 0x80, 0xC0, 0xC0, 0x40, 0x40, 0x80, 0x10, 0x00, 
		0x66, 0x60, 0x33, 0x44, 0x48, 0x33, 0x6E, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x0B, 0x2B, 
		0x00, 0x80, 0x60, 0x00, 0x00, 0x00, 0x94, 0x44, 0x00, 0x15, 0x0F, 0x18, 0x18, 0x0E, 0x04, 0x00, 
		0x00, 0x00, 0xFB, 0xB0, 0x68, 0x20, 0x00, 0x08, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0xE0, 0x00, 0x10, 0x00, 
		0x0F, 0x0C, 0x00, 0xF3, 0x00, 0x00, 0x80, 0x00, 0x78, 0x00, 0x07, 0x80, 0x00, 0x60, 0x00, 0x00, 
		0xF8, 0x00, 0x04, 0x00, 0x02, 0x00, 0x01, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x80, 0x10, 0xC0, 0x10, 0x00, 0x08, 0x1C, 0xC0, 0x22, 0x96, 0xA5, 0xE0, 0xF0, 0xBF, 0xC0, 0x80, 
		0x03, 0x00, 0x05, 0xDC, 0x00, 0x05, 0xDC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x01, 0x00, 0xE0, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//24576KHz 12AK.dat (205.280Mhz)
		0x55, 0x9F, 0xF1, 0xF8, 0x02, 0x41, 0xFC, 0x00, 0x00, 0xC0, 0x00, 0x0C, 0xC3, 0x00, 0xC0, 0x40, 
		0x73, 0x80, 0x03, 0xE8, 0x0C, 0xC0, 0x88, 0x33, 0x08, 0xF0, 0xF0, 0xD0, 0x02, 0x00, 0x10, 0x49, 
		0x4D, 0x05, 0x15, 0x03, 0xE8, 0xC1, 0x88, 0x08, 0xE0, 0x10, 0x40, 0xFC, 0x00, 0x00, 0x00, 0x00, 
		0x0F, 0x01, 0x00, 0x70, 0x4C, 0xF0, 0x8C, 0xF0, 0x80, 0xC0, 0xC0, 0x40, 0x40, 0x80, 0x10, 0x00, 
		0x66, 0x60, 0x33, 0x44, 0x48, 0x33, 0x6E, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x0B, 0x2B, 
		0x00, 0x80, 0x60, 0x00, 0x00, 0x00, 0x94, 0x44, 0x00, 0x15, 0x0F, 0x18, 0x18, 0x0E, 0x04, 0x00, 
		0x00, 0x00, 0xFB, 0xB0, 0x68, 0x20, 0x00, 0x08, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0xE0, 0x00, 0x10, 0x00, 
		0x0F, 0x0C, 0x00, 0xF3, 0x00, 0x00, 0x80, 0x00, 0x78, 0x00, 0x07, 0x80, 0x00, 0x60, 0x00, 0x00, 
		0xF8, 0x00, 0x04, 0x00, 0x02, 0x00, 0x01, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x80, 0x10, 0xC0, 0x10, 0x00, 0x08, 0x1C, 0xC0, 0x22, 0x96, 0xA5, 0xE0, 0xF0, 0xBF, 0xC0, 0x80, 
		0x03, 0x00, 0x05, 0xDC, 0x00, 0x05, 0xDC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x01, 0x00, 0xE0, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//24576KHz 12BK.dat (207.008Mhz)
		0x55, 0x9F, 0xF1, 0xF8, 0x02, 0x41, 0xFC, 0x00, 0x00, 0xC0, 0x00, 0x0C, 0xC3, 0x00, 0xC0, 0x40, 
		0x73, 0x80, 0x03, 0xE8, 0x0C, 0xC0, 0x88, 0x33, 0x08, 0xF0, 0xF0, 0xD0, 0x03, 0x00, 0x19, 0x41, 
		0x4D, 0x03, 0xA0, 0x03, 0xE8, 0xC1, 0x88, 0x08, 0xE0, 0x10, 0x40, 0xFC, 0x00, 0x00, 0x00, 0x00, 
		0x0F, 0x01, 0x00, 0x70, 0x4C, 0xF0, 0x8C, 0xF0, 0x80, 0xC0, 0xC0, 0x20, 0x20, 0x80, 0x10, 0x00, 
		0x66, 0x60, 0x33, 0x44, 0x48, 0x33, 0x6E, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x0B, 0x2B, 
		0x00, 0x80, 0x60, 0x00, 0x00, 0x00, 0x94, 0x44, 0x00, 0x15, 0x0F, 0x18, 0x18, 0x0E, 0x04, 0x00, 
		0x00, 0x00, 0xFB, 0xB0, 0x68, 0x20, 0x00, 0x08, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0xE0, 0x00, 0x10, 0x00, 
		0x0F, 0x0C, 0x00, 0xF3, 0x00, 0x00, 0x80, 0x00, 0x78, 0x00, 0x07, 0x80, 0x00, 0x60, 0x00, 0x00, 
		0xF8, 0x00, 0x04, 0x00, 0x02, 0x00, 0x01, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x80, 0x10, 0xC0, 0x10, 0x00, 0x08, 0x1C, 0xC0, 0x22, 0x96, 0xA5, 0xE0, 0xF0, 0xBF, 0xC0, 0x80, 
		0x03, 0x00, 0x05, 0xDC, 0x00, 0x05, 0xDC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x01, 0x00, 0xE0, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//24576KHz 12CK.dat (208.736Mhz)
		0x55, 0x9F, 0xF1, 0xF8, 0x02, 0x41, 0xFC, 0x00, 0x00, 0xC0, 0x00, 0x0C, 0xC3, 0x00, 0xC0, 0x40, 
		0x73, 0x80, 0x03, 0xE8, 0x0C, 0xC0, 0x88, 0x33, 0x08, 0xF0, 0xF0, 0xD0, 0x03, 0x00, 0x19, 0x44, 
		0x4D, 0x0F, 0xA0, 0x03, 0xE8, 0xC1, 0x88, 0x08, 0xE0, 0x10, 0x40, 0xFC, 0x00, 0x00, 0x00, 0x00, 
		0x0F, 0x01, 0x00, 0x70, 0x4C, 0xF0, 0x8C, 0xF0, 0x80, 0xC0, 0xC0, 0x20, 0x20, 0x80, 0x10, 0x00, 
		0x66, 0x60, 0x33, 0x44, 0x48, 0x33, 0x6E, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x0B, 0x2B, 
		0x00, 0x80, 0x60, 0x00, 0x00, 0x00, 0x94, 0x44, 0x00, 0x15, 0x0F, 0x18, 0x18, 0x0E, 0x04, 0x00, 
		0x00, 0x00, 0xFB, 0xB0, 0x68, 0x20, 0x00, 0x08, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0xE0, 0x00, 0x10, 0x00, 
		0x0F, 0x0C, 0x00, 0xF3, 0x00, 0x00, 0x80, 0x00, 0x78, 0x00, 0x07, 0x80, 0x00, 0x60, 0x00, 0x00, 
		0xF8, 0x00, 0x04, 0x00, 0x02, 0x00, 0x01, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x80, 0x10, 0xC0, 0x10, 0x00, 0x08, 0x1C, 0xC0, 0x22, 0x96, 0xA5, 0xE0, 0xF0, 0xBF, 0xC0, 0x80, 
		0x03, 0x00, 0x05, 0xDC, 0x00, 0x05, 0xDC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x01, 0x00, 0xE0, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//24576KHz 13AK.dat (211.280Mhz)
		0x55, 0x9F, 0xF1, 0xF8, 0x02, 0x41, 0xFC, 0x00, 0x00, 0xC0, 0x00, 0x0C, 0xC3, 0x00, 0xC0, 0x40, 
		0x73, 0x80, 0x03, 0xE8, 0x4C, 0xC0, 0x88, 0x33, 0x08, 0xF0, 0xF0, 0xD0, 0x03, 0x00, 0x19, 0x49, 
		0x4D, 0x0E, 0xA0, 0x03, 0xE8, 0xC1, 0x88, 0x08, 0xE0, 0x10, 0x40, 0xFC, 0x00, 0x00, 0x00, 0x00, 
		0x0F, 0x01, 0x00, 0x70, 0x4C, 0xF0, 0x8C, 0xF0, 0x80, 0xC0, 0xC0, 0x20, 0x20, 0x80, 0x10, 0x00, 
		0x66, 0x60, 0x33, 0x44, 0x48, 0x33, 0x6E, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x0B, 0x2B, 
		0x00, 0x80, 0x60, 0x00, 0x00, 0x00, 0x94, 0x44, 0x00, 0x15, 0x0F, 0x18, 0x18, 0x0E, 0x04, 0x00, 
		0x00, 0x00, 0xFB, 0xB0, 0x68, 0x20, 0x00, 0x08, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0xE0, 0x00, 0x10, 0x00, 
		0x0F, 0x0C, 0x00, 0xF3, 0x00, 0x00, 0x80, 0x00, 0x78, 0x00, 0x07, 0x80, 0x00, 0x60, 0x00, 0x00, 
		0xF8, 0x00, 0x04, 0x00, 0x02, 0x00, 0x01, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x80, 0x10, 0xC0, 0x10, 0x00, 0x08, 0x1C, 0xC0, 0x22, 0x96, 0xA5, 0xE0, 0xF0, 0xBF, 0xC0, 0x80, 
		0x03, 0x00, 0x05, 0xDC, 0x00, 0x05, 0xDC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x01, 0x00, 0xE0, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//24576KHz 13BK.dat (213.008Mhz)
		0x55, 0x9F, 0xF1, 0xF8, 0x02, 0x41, 0xFC, 0x00, 0x00, 0xC0, 0x00, 0x0C, 0xC3, 0x00, 0xC0, 0x40, 
		0x73, 0x80, 0x03, 0xE8, 0x0C, 0xC0, 0x88, 0x33, 0x08, 0xF0, 0xF0, 0xD0, 0x02, 0x00, 0x11, 0x43, 
		0x4D, 0x07, 0x15, 0x03, 0xE8, 0xC1, 0x88, 0x08, 0xE0, 0x10, 0x40, 0xFC, 0x00, 0x00, 0x00, 0x00, 
		0x0F, 0x01, 0x00, 0x70, 0x4C, 0xF0, 0x8C, 0xF0, 0x80, 0xC0, 0xC0, 0x20, 0x20, 0x80, 0x10, 0x00, 
		0x66, 0x60, 0x33, 0x44, 0x48, 0x33, 0x6E, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x0B, 0x2B, 
		0x00, 0x80, 0x60, 0x00, 0x00, 0x00, 0x94, 0x44, 0x00, 0x15, 0x0F, 0x18, 0x18, 0x0E, 0x04, 0x00, 
		0x00, 0x00, 0xFB, 0xB0, 0x68, 0x20, 0x00, 0x08, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0xE0, 0x00, 0x10, 0x00, 
		0x0F, 0x0C, 0x00, 0xF3, 0x00, 0x00, 0x80, 0x00, 0x78, 0x00, 0x07, 0x80, 0x00, 0x60, 0x00, 0x00, 
		0xF8, 0x00, 0x04, 0x00, 0x02, 0x00, 0x01, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x80, 0x10, 0xC0, 0x10, 0x00, 0x08, 0x1C, 0xC0, 0x22, 0x96, 0xA5, 0xE0, 0xF0, 0xBF, 0xC0, 0x80, 
		0x03, 0x00, 0x05, 0xDC, 0x00, 0x05, 0xDC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x01, 0x00, 0xE0, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//24576KHz 13CK.dat (214.736Mhz)
		0x55, 0x9F, 0xF1, 0xF8, 0x02, 0x41, 0xFC, 0x00, 0x00, 0xC0, 0x00, 0x0C, 0xC3, 0x00, 0xC0, 0x40, 
		0x73, 0x80, 0x03, 0xE8, 0x0C, 0xC0, 0x88, 0x33, 0x08, 0xF0, 0xF0, 0xD0, 0x03, 0x00, 0x1A, 0x40, 
		0x4D, 0x06, 0xA0, 0x03, 0xE8, 0xC1, 0x88, 0x08, 0xE0, 0x10, 0x40, 0xFC, 0x00, 0x00, 0x00, 0x00, 
		0x0F, 0x01, 0x00, 0x70, 0x4C, 0xF0, 0x8C, 0xF0, 0x80, 0xC0, 0xC0, 0x20, 0x20, 0x80, 0x10, 0x00, 
		0x66, 0x60, 0x33, 0x44, 0x48, 0x33, 0x6E, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x0B, 0x2B, 
		0x00, 0x80, 0x60, 0x00, 0x00, 0x00, 0x94, 0x44, 0x00, 0x15, 0x0F, 0x18, 0x18, 0x0E, 0x04, 0x00, 
		0x00, 0x00, 0xFB, 0xB0, 0x68, 0x20, 0x00, 0x08, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0xE0, 0x00, 0x10, 0x00, 
		0x0F, 0x0C, 0x00, 0xF3, 0x00, 0x00, 0x80, 0x00, 0x78, 0x00, 0x07, 0x80, 0x00, 0x60, 0x00, 0x00, 
		0xF8, 0x00, 0x04, 0x00, 0x02, 0x00, 0x01, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x80, 0x10, 0xC0, 0x10, 0x00, 0x08, 0x1C, 0xC0, 0x22, 0x96, 0xA5, 0xE0, 0xF0, 0xBF, 0xC0, 0x80, 
		0x03, 0x00, 0x05, 0xDC, 0x00, 0x05, 0xDC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x01, 0x00, 0xE0, 0x00, 0x00, 0x00, 0x00, 
	},


};


static INC_UINT8 g_acT3900KorI2CValue_27000[MAX_KOREABAND_FULL_CHANNEL][RF500_REG_CTRL] = 
{
	{	//27000KHz 7AK.dat (175.280Mhz)
		0x00, 0x1F, 0xF1, 0xF8, 0x02, 0x41, 0xFC, 0x00, 0x00, 0xC0, 0x00, 0x0C, 0xC3, 0x00, 0xC0, 0x40, 
		0x72, 0xC0, 0x03, 0xE8, 0x0C, 0xC0, 0x88, 0x33, 0x08, 0xF0, 0xF0, 0xD0, 0x03, 0x00, 0x15, 0x43, 
		0x4D, 0x04, 0xA0, 0x01, 0xF4, 0xC1, 0x88, 0xEC, 0xE0, 0x10, 0x40, 0xFC, 0x00, 0x00, 0x00, 0x00, 
		0xFF, 0x01, 0x00, 0x70, 0x4C, 0xF0, 0x8C, 0xF0, 0x80, 0xC0, 0xB0, 0x70, 0x70, 0x80, 0x10, 0x00, 
		0xEE, 0xE0, 0x33, 0x44, 0x48, 0x44, 0x6E, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x0B, 0x2B, 
		0x00, 0x80, 0x60, 0x00, 0x00, 0x00, 0x94, 0x44, 0x00, 0x17, 0x17, 0x18, 0x18, 0x0E, 0x04, 0x00, 
		0x00, 0x00, 0xFB, 0xB0, 0x68, 0x20, 0x00, 0x08, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0xE0, 0x00, 0x10, 0x00, 
		0x0F, 0x0C, 0x00, 0xF3, 0x00, 0x00, 0x80, 0x00, 0x78, 0x00, 0x07, 0x80, 0x00, 0x60, 0x00, 0x00, 
		0xF8, 0x00, 0x04, 0x00, 0x02, 0x00, 0x01, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x80, 0x10, 0xC0, 0x10, 0x00, 0x08, 0x1C, 0xC0, 0x22, 0x96, 0xA5, 0xE0, 0xF0, 0xBF, 0xC0, 0x80, 
		0x03, 0x00, 0x27, 0x10, 0x00, 0x03, 0xE8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x01, 0x00, 0xE0, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//27000KHz 7BK.dat (177.008Mhz)
		0x00, 0x1F, 0xF1, 0xF8, 0x02, 0x41, 0xFC, 0x00, 0x00, 0xC0, 0x00, 0x0C, 0xC3, 0x00, 0xC0, 0x40, 
		0x72, 0xC0, 0x03, 0xE8, 0x0C, 0xC0, 0x88, 0x33, 0x08, 0xF0, 0xF0, 0xD0, 0x03, 0x00, 0x15, 0x46, 
		0x4D, 0x10, 0xA0, 0x01, 0xF4, 0xC1, 0x88, 0xEC, 0xE0, 0x10, 0x40, 0xFC, 0x00, 0x00, 0x00, 0x00, 
		0xFF, 0x01, 0x00, 0x70, 0x4C, 0xF0, 0x8C, 0xF0, 0x80, 0xC0, 0xB0, 0x70, 0x70, 0x80, 0x10, 0x00, 
		0xEE, 0xE0, 0x33, 0x44, 0x48, 0x44, 0x6E, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x0B, 0x2B, 
		0x00, 0x80, 0x60, 0x00, 0x00, 0x00, 0x94, 0x44, 0x00, 0x17, 0x17, 0x18, 0x18, 0x0E, 0x04, 0x00, 
		0x00, 0x00, 0xFB, 0xB0, 0x68, 0x20, 0x00, 0x08, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0xE0, 0x00, 0x10, 0x00, 
		0x0F, 0x0C, 0x00, 0xF3, 0x00, 0x00, 0x80, 0x00, 0x78, 0x00, 0x07, 0x80, 0x00, 0x60, 0x00, 0x00, 
		0xF8, 0x00, 0x04, 0x00, 0x02, 0x00, 0x01, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x80, 0x10, 0xC0, 0x10, 0x00, 0x08, 0x1C, 0xC0, 0x22, 0x96, 0xA5, 0xE0, 0xF0, 0xFF, 0xC0, 0x80, 
		0x03, 0x00, 0x27, 0x10, 0x00, 0x03, 0xE8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x01, 0x00, 0xE0, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//27000KHz 7CK.dat (178.736Mhz)
		0x00, 0x1F, 0xF1, 0xF8, 0x02, 0x41, 0xFC, 0x00, 0x00, 0xC0, 0x00, 0x0C, 0xC3, 0x00, 0xC0, 0x40, 
		0x72, 0xC0, 0x03, 0xE8, 0x0C, 0xC0, 0x88, 0x33, 0x08, 0xF0, 0xF0, 0xD0, 0x03, 0x00, 0x15, 0x49, 
		0x4D, 0x1C, 0x9F, 0x01, 0xF4, 0xC1, 0x88, 0xEC, 0xE0, 0x10, 0x40, 0xFC, 0x00, 0x00, 0x00, 0x00, 
		0xFF, 0x01, 0x00, 0x70, 0x4C, 0xF0, 0x8C, 0xF0, 0x80, 0xC0, 0xB0, 0x80, 0x60, 0x80, 0x10, 0x00, 
		0xCC, 0xC0, 0x33, 0x44, 0x48, 0x44, 0x6E, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x0B, 0x2B, 
		0x00, 0x80, 0x60, 0x00, 0x00, 0x00, 0x94, 0x44, 0x00, 0x17, 0x17, 0x18, 0x18, 0x0E, 0x04, 0x00, 
		0x00, 0x00, 0xFB, 0xB0, 0x68, 0x20, 0x00, 0x08, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0xE0, 0x00, 0x10, 0x00, 
		0x0F, 0x0C, 0x00, 0xF3, 0x00, 0x00, 0x80, 0x00, 0x78, 0x00, 0x07, 0x80, 0x00, 0x60, 0x00, 0x00, 
		0xF8, 0x00, 0x04, 0x00, 0x02, 0x00, 0x01, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x80, 0x10, 0xC0, 0x10, 0x00, 0x08, 0x1C, 0xC0, 0x22, 0x96, 0xA5, 0xE0, 0xF0, 0xBF, 0xC0, 0x80, 
		0x03, 0x00, 0x27, 0x10, 0x00, 0x03, 0xE8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x01, 0x00, 0xE0, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//27000KHz 8AK.dat (181.280Mhz)
		0x00, 0x1F, 0xF1, 0xF8, 0x02, 0x41, 0xFC, 0x00, 0x00, 0xC0, 0x00, 0x0C, 0xC3, 0x00, 0xC0, 0x40, 
		0x72, 0xC0, 0x03, 0xE8, 0x0C, 0xC0, 0x88, 0x33, 0x08, 0xF0, 0xF0, 0xD0, 0x03, 0x00, 0x15, 0x4E, 
		0x4D, 0x1B, 0xA0, 0x01, 0xF4, 0xC1, 0x88, 0xEC, 0xE0, 0x10, 0x40, 0xFC, 0x00, 0x00, 0x00, 0x00, 
		0xFF, 0x01, 0x00, 0x70, 0x4C, 0xF0, 0x8C, 0xF0, 0x80, 0xC0, 0xB0, 0x60, 0x60, 0x80, 0x10, 0x00, 
		0xCC, 0xC0, 0x33, 0x44, 0x48, 0x44, 0x6E, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x0B, 0x2B, 
		0x00, 0x80, 0x60, 0x00, 0x00, 0x00, 0x94, 0x44, 0x00, 0x17, 0x17, 0x18, 0x18, 0x0E, 0x04, 0x00, 
		0x00, 0x00, 0xFB, 0xB0, 0x68, 0x20, 0x00, 0x08, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0xE0, 0x00, 0x10, 0x00, 
		0x0F, 0x0C, 0x00, 0xF3, 0x00, 0x00, 0x80, 0x00, 0x78, 0x00, 0x07, 0x80, 0x00, 0x60, 0x00, 0x00, 
		0xF8, 0x00, 0x04, 0x00, 0x02, 0x00, 0x01, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x80, 0x10, 0xC0, 0x10, 0x00, 0x08, 0x1C, 0xC0, 0x22, 0x96, 0xA5, 0xE0, 0xF0, 0xBF, 0xC0, 0x80, 
		0x03, 0x00, 0x27, 0x10, 0x00, 0x03, 0xE8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x01, 0x00, 0xE0, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//27000KHz 8BK.dat (183.008Mhz)
		0x00, 0x1F, 0xF1, 0xF8, 0x02, 0x41, 0xFC, 0x00, 0x00, 0xC0, 0x00, 0x0C, 0xC3, 0x00, 0xC0, 0x40, 
		0x72, 0xC0, 0x03, 0xE8, 0x0C, 0xC0, 0x88, 0x33, 0x08, 0xF0, 0xF0, 0xD0, 0x03, 0x00, 0x16, 0x42, 
		0x4D, 0x07, 0xA0, 0x01, 0xF4, 0xC1, 0x88, 0xEC, 0xE0, 0x10, 0x40, 0xFC, 0x00, 0x00, 0x00, 0x00, 
		0xFF, 0x01, 0x00, 0x70, 0x4C, 0xF0, 0x8C, 0xF0, 0x80, 0xC0, 0xB0, 0x60, 0x60, 0x80, 0x10, 0x00, 
		0xBB, 0xB0, 0x33, 0x44, 0x48, 0x44, 0x6E, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x0B, 0x2B, 
		0x00, 0x80, 0x60, 0x00, 0x00, 0x00, 0x94, 0x44, 0x00, 0x17, 0x17, 0x18, 0x18, 0x0E, 0x04, 0x00, 
		0x00, 0x00, 0xFB, 0xB0, 0x68, 0x20, 0x00, 0x08, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0xE0, 0x00, 0x10, 0x00, 
		0x0F, 0x0C, 0x00, 0xF3, 0x00, 0x00, 0x80, 0x00, 0x78, 0x00, 0x07, 0x80, 0x00, 0x60, 0x00, 0x00, 
		0xF8, 0x00, 0x04, 0x00, 0x02, 0x00, 0x01, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x80, 0x10, 0xC0, 0x10, 0x00, 0x08, 0x1C, 0xC0, 0x22, 0x96, 0xA5, 0xE0, 0xF0, 0xBF, 0xC0, 0x80, 
		0x03, 0x00, 0x27, 0x10, 0x00, 0x03, 0xE8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x01, 0x00, 0xE0, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//27000KHz 8CK.dat (184.736Mhz)
		0x00, 0x1F, 0xF1, 0xF8, 0x02, 0x41, 0xFC, 0x00, 0x00, 0xC0, 0x00, 0x0C, 0xC3, 0x00, 0xC0, 0x40, 
		0x72, 0xC0, 0x03, 0xE8, 0x0C, 0xC0, 0x88, 0x33, 0x08, 0xF0, 0xF0, 0xD0, 0x03, 0x00, 0x16, 0x45, 
		0x4D, 0x13, 0xA0, 0x01, 0xF4, 0xC1, 0x88, 0xEC, 0xE0, 0x10, 0x40, 0xFC, 0x00, 0x00, 0x00, 0x00, 
		0xFF, 0x01, 0x00, 0x70, 0x4C, 0xF0, 0x8C, 0xF0, 0x80, 0xC0, 0xB0, 0x60, 0x60, 0x80, 0x10, 0x00, 
		0xAA, 0xA0, 0x33, 0x44, 0x48, 0x44, 0x6E, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x0B, 0x2B, 
		0x00, 0x80, 0x60, 0x00, 0x00, 0x00, 0x94, 0x44, 0x00, 0x17, 0x17, 0x18, 0x18, 0x0E, 0x04, 0x00, 
		0x00, 0x00, 0xFB, 0xB0, 0x68, 0x20, 0x00, 0x08, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0xE0, 0x00, 0x10, 0x00, 
		0x0F, 0x0C, 0x00, 0xF3, 0x00, 0x00, 0x80, 0x00, 0x78, 0x00, 0x07, 0x80, 0x00, 0x60, 0x00, 0x00, 
		0xF8, 0x00, 0x04, 0x00, 0x02, 0x00, 0x01, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x80, 0x10, 0xC0, 0x10, 0x00, 0x08, 0x1C, 0xC0, 0x22, 0x96, 0xA5, 0xE0, 0xF0, 0xBF, 0xC0, 0x80, 
		0x03, 0x00, 0x27, 0x10, 0x00, 0x03, 0xE8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x01, 0x00, 0xE0, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//27000KHz 9AK.dat (187.280Mhz)
		0x00, 0x1F, 0xF1, 0xF8, 0x02, 0x41, 0xFC, 0x00, 0x00, 0xC0, 0x00, 0x0C, 0xC3, 0x00, 0xC0, 0x40, 
		0x72, 0xC0, 0x03, 0xE8, 0x0C, 0xC0, 0x88, 0x33, 0x08, 0xF0, 0xF0, 0xD0, 0x03, 0x00, 0x16, 0x4A, 
		0x4D, 0x12, 0xA0, 0x01, 0xF4, 0xC1, 0x88, 0xEC, 0xE0, 0x10, 0x40, 0xFC, 0x00, 0x00, 0x00, 0x00, 
		0xFF, 0x01, 0x00, 0x70, 0x4C, 0xF0, 0x8C, 0xF0, 0x80, 0xC0, 0xB0, 0x60, 0x60, 0x80, 0x10, 0x00, 
		0xAA, 0xA0, 0x33, 0x44, 0x48, 0x44, 0x6E, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x0B, 0x2B, 
		0x00, 0x80, 0x60, 0x00, 0x00, 0x00, 0x94, 0x44, 0x00, 0x17, 0x17, 0x18, 0x18, 0x0E, 0x04, 0x00, 
		0x00, 0x00, 0xFB, 0xB0, 0x68, 0x20, 0x00, 0x08, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0xE0, 0x00, 0x10, 0x00, 
		0x0F, 0x0C, 0x00, 0xF3, 0x00, 0x00, 0x80, 0x00, 0x78, 0x00, 0x07, 0x80, 0x00, 0x60, 0x00, 0x00, 
		0xF8, 0x00, 0x04, 0x00, 0x02, 0x00, 0x01, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x80, 0x10, 0xC0, 0x10, 0x00, 0x08, 0x1C, 0xC0, 0x22, 0x96, 0xA5, 0xE0, 0xF0, 0xBF, 0xC0, 0x80, 
		0x03, 0x00, 0x27, 0x10, 0x00, 0x03, 0xE8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x01, 0x00, 0xE0, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//27000KHz 9BK.dat (189.008Mhz)
		0x00, 0x1F, 0xF1, 0xF8, 0x02, 0x41, 0xFC, 0x00, 0x00, 0xC0, 0x00, 0x0C, 0xC3, 0x00, 0xC0, 0x40, 
		0x72, 0xC0, 0x03, 0xE8, 0x0C, 0xC0, 0x88, 0x33, 0x08, 0xF0, 0xF0, 0xD0, 0x03, 0x00, 0x16, 0x4D, 
		0x4D, 0x1E, 0xA0, 0x01, 0xF4, 0xC1, 0x88, 0xEC, 0xE0, 0x10, 0x40, 0xFC, 0x00, 0x00, 0x00, 0x00, 
		0xFF, 0x01, 0x00, 0x70, 0x4C, 0xF0, 0x8C, 0xF0, 0x80, 0xC0, 0xB0, 0x50, 0x50, 0x80, 0x10, 0x00, 
		0x99, 0x90, 0x33, 0x44, 0x48, 0x44, 0x6E, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x0B, 0x2B, 
		0x00, 0x80, 0x60, 0x00, 0x00, 0x00, 0x94, 0x44, 0x00, 0x17, 0x17, 0x18, 0x18, 0x0E, 0x04, 0x00, 
		0x00, 0x00, 0xFB, 0xB0, 0x68, 0x20, 0x00, 0x08, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0xE0, 0x00, 0x10, 0x00, 
		0x0F, 0x0C, 0x00, 0xF3, 0x00, 0x00, 0x80, 0x00, 0x78, 0x00, 0x07, 0x80, 0x00, 0x60, 0x00, 0x00, 
		0xF8, 0x00, 0x04, 0x00, 0x02, 0x00, 0x01, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x80, 0x10, 0xC0, 0x10, 0x00, 0x08, 0x1C, 0xC0, 0x22, 0x96, 0xA5, 0xE0, 0xF0, 0xBF, 0xC0, 0x80, 
		0x03, 0x00, 0x27, 0x10, 0x00, 0x03, 0xE8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x01, 0x00, 0xE0, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//27000KHz 9CK.dat (190.736Mhz)
		0x00, 0x1F, 0xF1, 0xF8, 0x02, 0x41, 0xFC, 0x00, 0x00, 0xC0, 0x00, 0x0C, 0xC3, 0x00, 0xC0, 0x40, 
		0x72, 0xC0, 0x03, 0xE8, 0x0C, 0xC0, 0x88, 0x33, 0x08, 0xF0, 0xF0, 0xD0, 0x03, 0x00, 0x17, 0x41, 
		0x4D, 0x0A, 0xA0, 0x01, 0xF4, 0xC1, 0x88, 0xEC, 0xE0, 0x10, 0x40, 0xFC, 0x00, 0x00, 0x00, 0x00, 
		0xFF, 0x01, 0x00, 0x70, 0x4C, 0xF0, 0x8C, 0xF0, 0x80, 0xC0, 0xB0, 0x50, 0x50, 0x80, 0x10, 0x00, 
		0x99, 0x90, 0x33, 0x44, 0x48, 0x44, 0x6E, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x0B, 0x2B, 
		0x00, 0x80, 0x60, 0x00, 0x00, 0x00, 0x94, 0x44, 0x00, 0x17, 0x17, 0x18, 0x18, 0x0E, 0x04, 0x00, 
		0x00, 0x00, 0xFB, 0xB0, 0x68, 0x20, 0x00, 0x08, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0xE0, 0x00, 0x10, 0x00, 
		0x0F, 0x0C, 0x00, 0xF3, 0x00, 0x00, 0x80, 0x00, 0x78, 0x00, 0x07, 0x80, 0x00, 0x60, 0x00, 0x00, 
		0xF8, 0x00, 0x04, 0x00, 0x02, 0x00, 0x01, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x80, 0x10, 0xC0, 0x10, 0x00, 0x08, 0x1C, 0xC0, 0x22, 0x96, 0xA5, 0xE0, 0xF0, 0xBF, 0xC0, 0x80, 
		0x03, 0x00, 0x27, 0x10, 0x00, 0x03, 0xE8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x01, 0x00, 0xE0, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//27000KHz 10AK.dat (193.280Mhz)
		0x00, 0x1F, 0xF1, 0xF8, 0x02, 0x41, 0xFC, 0x00, 0x00, 0xC0, 0x00, 0x0C, 0xC3, 0x00, 0xC0, 0x40, 
		0x72, 0xC0, 0x03, 0xE8, 0x0C, 0xC0, 0x88, 0x33, 0x08, 0xF0, 0xF0, 0xD0, 0x03, 0x00, 0x17, 0x46, 
		0x4D, 0x09, 0xA0, 0x01, 0xF4, 0xC1, 0x88, 0xEC, 0xE0, 0x10, 0x40, 0xFC, 0x00, 0x00, 0x00, 0x00, 
		0xFF, 0x01, 0x00, 0x70, 0x4C, 0xF0, 0x8C, 0xF0, 0x80, 0xC0, 0xB0, 0x50, 0x50, 0x80, 0x10, 0x00, 
		0x99, 0x90, 0x33, 0x44, 0x48, 0x44, 0x6E, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x0B, 0x2B, 
		0x00, 0x80, 0x60, 0x00, 0x00, 0x00, 0x94, 0x44, 0x00, 0x17, 0x17, 0x18, 0x18, 0x0E, 0x04, 0x00, 
		0x00, 0x00, 0xFB, 0xB0, 0x68, 0x20, 0x00, 0x08, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0xE0, 0x00, 0x10, 0x00, 
		0x0F, 0x0C, 0x00, 0xF3, 0x00, 0x00, 0x80, 0x00, 0x78, 0x00, 0x07, 0x80, 0x00, 0x60, 0x00, 0x00, 
		0xF8, 0x00, 0x04, 0x00, 0x02, 0x00, 0x01, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x80, 0x10, 0xC0, 0x10, 0x00, 0x08, 0x1C, 0xC0, 0x22, 0x96, 0xA5, 0xE0, 0xF0, 0xBF, 0xC0, 0x80, 
		0x03, 0x00, 0x27, 0x10, 0x00, 0x03, 0xE8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x01, 0x00, 0xE0, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//27000KHz 10BK.dat (195.008Mhz)
		0x00, 0x1F, 0xF1, 0xF8, 0x02, 0x41, 0xFC, 0x00, 0x00, 0xC0, 0x00, 0x0C, 0xC3, 0x00, 0xC0, 0x40, 
		0x72, 0xC0, 0x03, 0xE8, 0x0C, 0xC0, 0x88, 0x33, 0x08, 0xF0, 0xF0, 0xD0, 0x03, 0x00, 0x17, 0x49, 
		0x4D, 0x15, 0xA0, 0x01, 0xF4, 0xC1, 0x88, 0xEC, 0xE0, 0x10, 0x40, 0xFC, 0x00, 0x00, 0x00, 0x00, 
		0xFF, 0x01, 0x00, 0x70, 0x4C, 0xF0, 0x8C, 0xF0, 0x80, 0xC0, 0xB0, 0x40, 0x40, 0x80, 0x10, 0x00, 
		0x88, 0x80, 0x33, 0x44, 0x48, 0x44, 0x6E, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x0B, 0x2B, 
		0x00, 0x80, 0x60, 0x00, 0x00, 0x00, 0x94, 0x44, 0x00, 0x17, 0x17, 0x18, 0x18, 0x0E, 0x04, 0x00, 
		0x00, 0x00, 0xFB, 0xB0, 0x68, 0x20, 0x00, 0x08, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0xE0, 0x00, 0x10, 0x00, 
		0x0F, 0x0C, 0x00, 0xF3, 0x00, 0x00, 0x80, 0x00, 0x78, 0x00, 0x07, 0x80, 0x00, 0x60, 0x00, 0x00, 
		0xF8, 0x00, 0x04, 0x00, 0x02, 0x00, 0x01, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x80, 0x10, 0xC0, 0x10, 0x00, 0x08, 0x1C, 0xC0, 0x22, 0x96, 0xA5, 0xE0, 0xF0, 0xFF, 0xC0, 0x50, 
		0x03, 0x00, 0x27, 0x10, 0x00, 0x03, 0xE8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x01, 0x00, 0xE0, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//27000KHz 10CK.dat (196.736Mhz)
		0x00, 0x1F, 0xF1, 0xF8, 0x02, 0x41, 0xFC, 0x00, 0x00, 0xC0, 0x00, 0x0C, 0xC3, 0x00, 0xC0, 0x40, 
		0x72, 0xC0, 0x03, 0xE8, 0x0C, 0xC0, 0x88, 0x33, 0x08, 0xF0, 0xF0, 0xD0, 0x03, 0x00, 0x17, 0x4D, 
		0x4D, 0x01, 0xA0, 0x01, 0xF4, 0xC1, 0x88, 0xEC, 0xE0, 0x10, 0x40, 0xFC, 0x00, 0x00, 0x00, 0x00, 
		0xFF, 0x01, 0x00, 0x70, 0x4C, 0xF0, 0x8C, 0xF0, 0x80, 0xC0, 0xB0, 0x40, 0x40, 0x80, 0x10, 0x00, 
		0x88, 0x80, 0x33, 0x44, 0x48, 0x44, 0x6E, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x0B, 0x2B, 
		0x00, 0x80, 0x60, 0x00, 0x00, 0x00, 0x94, 0x44, 0x00, 0x17, 0x17, 0x18, 0x18, 0x0E, 0x04, 0x00, 
		0x00, 0x00, 0xFB, 0xB0, 0x68, 0x20, 0x00, 0x08, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0xE0, 0x00, 0x10, 0x00, 
		0x0F, 0x0C, 0x00, 0xF3, 0x00, 0x00, 0x80, 0x00, 0x78, 0x00, 0x07, 0x80, 0x00, 0x60, 0x00, 0x00, 
		0xF8, 0x00, 0x04, 0x00, 0x02, 0x00, 0x01, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x80, 0x10, 0xC0, 0x10, 0x00, 0x08, 0x1C, 0xC0, 0x22, 0x96, 0xA5, 0xE0, 0xF0, 0xFF, 0xC0, 0x50, 
		0x03, 0x00, 0x27, 0x10, 0x00, 0x03, 0xE8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x01, 0x00, 0xE0, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//27000KHz 11AK.dat (199.280Mhz)
		0x00, 0x1F, 0xF1, 0xF8, 0x02, 0x41, 0xFC, 0x00, 0x00, 0xC0, 0x00, 0x0C, 0xC3, 0x00, 0xC0, 0x40, 
		0x72, 0xC0, 0x03, 0xE8, 0x0C, 0xC0, 0x88, 0x33, 0x08, 0xF0, 0xF0, 0xD0, 0x03, 0x00, 0x18, 0x42, 
		0x4D, 0x00, 0xA0, 0x01, 0xF4, 0xC1, 0x88, 0xEC, 0xE0, 0x10, 0x40, 0xFC, 0x00, 0x00, 0x00, 0x00, 
		0xFF, 0x01, 0x00, 0x70, 0x4C, 0xF0, 0x8C, 0xF0, 0x80, 0xC0, 0xB0, 0x40, 0x40, 0x80, 0x10, 0x00, 
		0x88, 0x80, 0x33, 0x44, 0x48, 0x44, 0x6E, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x0B, 0x2B, 
		0x00, 0x80, 0x60, 0x00, 0x00, 0x00, 0x94, 0x44, 0x00, 0x17, 0x17, 0x18, 0x18, 0x0E, 0x04, 0x00, 
		0x00, 0x00, 0xFB, 0xB0, 0x68, 0x20, 0x00, 0x08, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0xE0, 0x00, 0x10, 0x00, 
		0x0F, 0x0C, 0x00, 0xF3, 0x00, 0x00, 0x80, 0x00, 0x78, 0x00, 0x07, 0x80, 0x00, 0x60, 0x00, 0x00, 
		0xF8, 0x00, 0x04, 0x00, 0x02, 0x00, 0x01, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x80, 0x10, 0xC0, 0x10, 0x00, 0x08, 0x1C, 0xC0, 0x22, 0x96, 0xA5, 0xE0, 0xF0, 0xBF, 0xC0, 0x80, 
		0x03, 0x00, 0x27, 0x10, 0x00, 0x03, 0xE8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x01, 0x00, 0xE0, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//27000KHz 11BK.dat (201.008Mhz)
		0x00, 0x1F, 0xF1, 0xF8, 0x02, 0x41, 0xFC, 0x00, 0x00, 0xC0, 0x00, 0x0C, 0xC3, 0x00, 0xC0, 0x40, 
		0x72, 0xC0, 0x03, 0xE8, 0x0C, 0xC0, 0x88, 0x33, 0x08, 0xF0, 0xF0, 0xD0, 0x03, 0x00, 0x18, 0x45, 
		0x4D, 0x0C, 0xA0, 0x01, 0xF4, 0xC1, 0x88, 0xEC, 0xE0, 0x10, 0x40, 0xFC, 0x00, 0x00, 0x00, 0x00, 
		0xFF, 0x01, 0x00, 0x70, 0x4C, 0xF0, 0x8C, 0xF0, 0x80, 0xC0, 0xB0, 0x40, 0x40, 0x80, 0x10, 0x00, 
		0x77, 0x70, 0x33, 0x44, 0x48, 0x44, 0x6E, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x0B, 0x2B, 
		0x00, 0x80, 0x60, 0x00, 0x00, 0x00, 0x94, 0x44, 0x00, 0x17, 0x17, 0x18, 0x18, 0x0E, 0x04, 0x00, 
		0x00, 0x00, 0xFB, 0xB0, 0x68, 0x20, 0x00, 0x08, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0xE0, 0x00, 0x10, 0x00, 
		0x0F, 0x0C, 0x00, 0xF3, 0x00, 0x00, 0x80, 0x00, 0x78, 0x00, 0x07, 0x80, 0x00, 0x60, 0x00, 0x00, 
		0xF8, 0x00, 0x04, 0x00, 0x02, 0x00, 0x01, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x80, 0x10, 0xC0, 0x10, 0x00, 0x08, 0x1C, 0xC0, 0x22, 0x96, 0xA5, 0xE0, 0xF0, 0xBF, 0xC0, 0x80, 
		0x03, 0x00, 0x27, 0x10, 0x00, 0x03, 0xE8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x01, 0x00, 0xE0, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//27000KHz 11CK.dat (202.736Mhz)
		0x00, 0x1F, 0xF1, 0xF8, 0x02, 0x41, 0xFC, 0x00, 0x00, 0xC0, 0x00, 0x0C, 0xC3, 0x00, 0xC0, 0x40, 
		0x72, 0xC0, 0x03, 0xE8, 0x0C, 0xC0, 0x88, 0x33, 0x08, 0xF0, 0xF0, 0xD0, 0x03, 0x00, 0x18, 0x48, 
		0x4D, 0x18, 0xA0, 0x01, 0xF4, 0xC1, 0x88, 0xEC, 0xE0, 0x10, 0x40, 0xFC, 0x00, 0x00, 0x00, 0x00, 
		0xFF, 0x01, 0x00, 0x70, 0x4C, 0xF0, 0x8C, 0xF0, 0x80, 0xC0, 0xB0, 0x40, 0x40, 0x80, 0x10, 0x00, 
		0x66, 0x60, 0x33, 0x44, 0x48, 0x44, 0x6E, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x0B, 0x2B, 
		0x00, 0x80, 0x60, 0x00, 0x00, 0x00, 0x94, 0x44, 0x00, 0x17, 0x17, 0x18, 0x18, 0x0E, 0x04, 0x00, 
		0x00, 0x00, 0xFB, 0xB0, 0x68, 0x20, 0x00, 0x08, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0xE0, 0x00, 0x10, 0x00, 
		0x0F, 0x0C, 0x00, 0xF3, 0x00, 0x00, 0x80, 0x00, 0x78, 0x00, 0x07, 0x80, 0x00, 0x60, 0x00, 0x00, 
		0xF8, 0x00, 0x04, 0x00, 0x02, 0x00, 0x01, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x80, 0x10, 0xC0, 0x10, 0x00, 0x08, 0x1C, 0xC0, 0x22, 0x96, 0xA5, 0xE0, 0xF0, 0xBF, 0xC0, 0x80, 
		0x03, 0x00, 0x27, 0x10, 0x00, 0x03, 0xE8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x01, 0x00, 0xE0, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//27000KHz 12AK.dat (205.280Mhz)
		0x00, 0x1F, 0xF1, 0xF8, 0x02, 0x41, 0xFC, 0x00, 0x00, 0xC0, 0x00, 0x0C, 0xC3, 0x00, 0xC0, 0x40, 
		0x72, 0xC0, 0x03, 0xE8, 0x0C, 0xC0, 0x88, 0x33, 0x08, 0xF0, 0xF0, 0xD0, 0x03, 0x00, 0x18, 0x4D, 
		0x4D, 0x17, 0xA0, 0x01, 0xF4, 0xC1, 0x88, 0xEC, 0xE0, 0x10, 0x40, 0xFC, 0x00, 0x00, 0x00, 0x00, 
		0xFF, 0x01, 0x00, 0x70, 0x4C, 0xF0, 0x8C, 0xF0, 0x80, 0xC0, 0xB0, 0x40, 0x40, 0x80, 0x10, 0x00, 
		0x66, 0x60, 0x33, 0x44, 0x48, 0x44, 0x6E, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x0B, 0x2B, 
		0x00, 0x80, 0x60, 0x00, 0x00, 0x00, 0x94, 0x44, 0x00, 0x17, 0x17, 0x18, 0x18, 0x0E, 0x04, 0x00, 
		0x00, 0x00, 0xFB, 0xB0, 0x68, 0x20, 0x00, 0x08, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0xE0, 0x00, 0x10, 0x00, 
		0x0F, 0x0C, 0x00, 0xF3, 0x00, 0x00, 0x80, 0x00, 0x78, 0x00, 0x07, 0x80, 0x00, 0x60, 0x00, 0x00, 
		0xF8, 0x00, 0x04, 0x00, 0x02, 0x00, 0x01, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x80, 0x10, 0xC0, 0x10, 0x00, 0x08, 0x1C, 0xC0, 0x22, 0x96, 0xA5, 0xE0, 0xF0, 0xBF, 0xC0, 0x80, 
		0x03, 0x00, 0x27, 0x10, 0x00, 0x03, 0xE8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x01, 0x00, 0xE0, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//27000KHz 12BK.dat (207.008Mhz)
		0x00, 0x1F, 0xF1, 0xF8, 0x02, 0x41, 0xFC, 0x00, 0x00, 0xC0, 0x00, 0x0C, 0xC3, 0x00, 0xC0, 0x40, 
		0x72, 0xC0, 0x07, 0xD0, 0x0C, 0xC0, 0x88, 0x33, 0x08, 0xF0, 0xF0, 0xD0, 0x03, 0x00, 0x19, 0x41, 
		0x4D, 0x03, 0xA0, 0x01, 0xF4, 0xC1, 0x88, 0xEC, 0xE0, 0x10, 0x40, 0xFC, 0x00, 0x00, 0x00, 0x00, 
		0xFF, 0x01, 0x00, 0x70, 0x4C, 0xF0, 0x8C, 0xF0, 0x80, 0xC0, 0xB0, 0x20, 0x20, 0x80, 0x10, 0x00, 
		0x66, 0x60, 0x33, 0x44, 0x48, 0x44, 0x6E, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x0B, 0x2B, 
		0x00, 0x80, 0x60, 0x00, 0x00, 0x00, 0x94, 0x44, 0x00, 0x17, 0x17, 0x18, 0x18, 0x0E, 0x04, 0x00, 
		0x00, 0x00, 0xFB, 0xB0, 0x68, 0x20, 0x00, 0x08, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0xE0, 0x00, 0x10, 0x00, 
		0x0F, 0x0C, 0x00, 0xF3, 0x00, 0x00, 0x80, 0x00, 0x78, 0x00, 0x07, 0x80, 0x00, 0x60, 0x00, 0x00, 
		0xF8, 0x00, 0x04, 0x00, 0x02, 0x00, 0x01, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x80, 0x10, 0xC0, 0x10, 0x00, 0x08, 0x1C, 0xC0, 0x22, 0x96, 0xA5, 0xE0, 0xF0, 0xBF, 0xC0, 0x80, 
		0x03, 0x00, 0x27, 0x10, 0x00, 0x03, 0xE8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x01, 0x00, 0xE0, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//27000KHz 12CK.dat (208.736Mhz)
		0x00, 0x1F, 0xF1, 0xF8, 0x02, 0x41, 0xFC, 0x00, 0x00, 0xC0, 0x00, 0x0C, 0xC3, 0x00, 0xC0, 0x40, 
		0x72, 0xC0, 0x03, 0xE8, 0x0C, 0xC0, 0x88, 0x33, 0x08, 0xF0, 0xF0, 0xD0, 0x03, 0x00, 0x19, 0x44, 
		0x4D, 0x0F, 0xA0, 0x01, 0xF4, 0xC1, 0x88, 0xEC, 0xE0, 0x10, 0x40, 0xFC, 0x00, 0x00, 0x00, 0x00, 
		0xFF, 0x01, 0x00, 0x70, 0x4C, 0xF0, 0x8C, 0xF0, 0x80, 0xC0, 0xB0, 0x20, 0x20, 0x80, 0x10, 0x00, 
		0x66, 0x60, 0x33, 0x44, 0x48, 0x44, 0x6E, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x0B, 0x2B, 
		0x00, 0x80, 0x60, 0x00, 0x00, 0x00, 0x94, 0x44, 0x00, 0x17, 0x17, 0x18, 0x18, 0x0E, 0x04, 0x00, 
		0x00, 0x00, 0xFB, 0xB0, 0x68, 0x20, 0x00, 0x08, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0xE0, 0x00, 0x10, 0x00, 
		0x0F, 0x0C, 0x00, 0xF3, 0x00, 0x00, 0x80, 0x00, 0x78, 0x00, 0x07, 0x80, 0x00, 0x60, 0x00, 0x00, 
		0xF8, 0x00, 0x04, 0x00, 0x02, 0x00, 0x01, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x80, 0x10, 0xC0, 0x10, 0x00, 0x08, 0x1C, 0xC0, 0x22, 0x96, 0xA5, 0xE0, 0xF0, 0xBF, 0xC0, 0x80, 
		0x03, 0x00, 0x27, 0x10, 0x00, 0x03, 0xE8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x01, 0x00, 0xE0, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//27000KHz 13AK.dat (211.280Mhz)
		0x00, 0x1F, 0xF1, 0xF8, 0x02, 0x41, 0xFC, 0x00, 0x00, 0xC0, 0x00, 0x0C, 0xC3, 0x00, 0xC0, 0x40, 
		0x72, 0xC0, 0x03, 0xE8, 0x4C, 0xC0, 0x88, 0x33, 0x08, 0xF0, 0xF0, 0xD0, 0x03, 0x00, 0x19, 0x49, 
		0x4D, 0x0E, 0xA0, 0x01, 0xF4, 0xC1, 0x88, 0xEC, 0xE0, 0x10, 0x40, 0xFC, 0x00, 0x00, 0x00, 0x00, 
		0xFF, 0x01, 0x00, 0x70, 0x4C, 0xF0, 0x8C, 0xF0, 0x80, 0xC0, 0xB0, 0x20, 0x20, 0x80, 0x10, 0x00, 
		0x66, 0x60, 0x33, 0x44, 0x48, 0x44, 0x6E, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x0B, 0x2B, 
		0x00, 0x80, 0x60, 0x00, 0x00, 0x00, 0x94, 0x44, 0x00, 0x17, 0x17, 0x18, 0x18, 0x0E, 0x04, 0x00, 
		0x00, 0x00, 0xFB, 0xB0, 0x68, 0x20, 0x00, 0x08, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0xE0, 0x00, 0x10, 0x00, 
		0x0F, 0x0C, 0x00, 0xF3, 0x00, 0x00, 0x80, 0x00, 0x78, 0x00, 0x07, 0x80, 0x00, 0x60, 0x00, 0x00, 
		0xF8, 0x00, 0x04, 0x00, 0x02, 0x00, 0x01, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x80, 0x10, 0xC0, 0x10, 0x00, 0x08, 0x1C, 0xC0, 0x22, 0x96, 0xA5, 0xE0, 0xF0, 0xBF, 0xC0, 0x80, 
		0x03, 0x00, 0x27, 0x10, 0x00, 0x03, 0xE8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x01, 0x00, 0xE0, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//27000KHz 13BK.dat (213.008Mhz)
		0x00, 0x1F, 0xF1, 0xF8, 0x02, 0x41, 0xFC, 0x00, 0x00, 0xC0, 0x00, 0x0C, 0xC3, 0x00, 0xC0, 0x40, 
		0x72, 0xC0, 0x03, 0xE8, 0x0C, 0xC0, 0x88, 0x33, 0x08, 0xF0, 0xF0, 0xD0, 0x03, 0x00, 0x19, 0x4C, 
		0x4D, 0x1A, 0xA0, 0x01, 0xF4, 0xC1, 0x88, 0xEC, 0xE0, 0x10, 0x40, 0xFC, 0x00, 0x00, 0x00, 0x00, 
		0xFF, 0x01, 0x00, 0x70, 0x4C, 0xF0, 0x8C, 0xF0, 0x80, 0xC0, 0xB0, 0x20, 0x20, 0x80, 0x10, 0x00, 
		0x66, 0x60, 0x33, 0x44, 0x48, 0x44, 0x6E, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x0B, 0x2B, 
		0x00, 0x80, 0x60, 0x00, 0x00, 0x00, 0x94, 0x44, 0x00, 0x17, 0x17, 0x18, 0x18, 0x0E, 0x04, 0x00, 
		0x00, 0x00, 0xFB, 0xB0, 0x68, 0x20, 0x00, 0x08, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0xE0, 0x00, 0x10, 0x00, 
		0x0F, 0x0C, 0x00, 0xF3, 0x00, 0x00, 0x80, 0x00, 0x78, 0x00, 0x07, 0x80, 0x00, 0x60, 0x00, 0x00, 
		0xF8, 0x00, 0x04, 0x00, 0x02, 0x00, 0x01, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x80, 0x10, 0xC0, 0x10, 0x00, 0x08, 0x1C, 0xC0, 0x22, 0x96, 0xA5, 0xE0, 0xF0, 0xBF, 0xC0, 0x80, 
		0x03, 0x00, 0x27, 0x10, 0x00, 0x03, 0xE8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x01, 0x00, 0xE0, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//27000KHz 13CK.dat (214.736Mhz)
		0x00, 0x1F, 0xF1, 0xF8, 0x02, 0x41, 0xFC, 0x00, 0x00, 0xC0, 0x00, 0x0C, 0xC3, 0x00, 0xC0, 0x40, 
		0x72, 0xC0, 0x03, 0xE8, 0x0C, 0xC0, 0x88, 0x33, 0x08, 0xF0, 0xF0, 0xD0, 0x03, 0x00, 0x1A, 0x40, 
		0x4D, 0x06, 0xA0, 0x01, 0xF4, 0xC1, 0x88, 0xEC, 0xE0, 0x10, 0x40, 0xFC, 0x00, 0x00, 0x00, 0x00, 
		0xFF, 0x01, 0x00, 0x70, 0x4C, 0xF0, 0x8C, 0xF0, 0x80, 0xC0, 0xB0, 0x20, 0x20, 0x80, 0x10, 0x00, 
		0x66, 0x60, 0x33, 0x44, 0x48, 0x44, 0x6E, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x0B, 0x2B, 
		0x00, 0x80, 0x60, 0x00, 0x00, 0x00, 0x94, 0x44, 0x00, 0x17, 0x17, 0x18, 0x18, 0x0E, 0x04, 0x00, 
		0x00, 0x00, 0xFB, 0xB0, 0x68, 0x20, 0x00, 0x08, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0xE0, 0x00, 0x10, 0x00, 
		0x0F, 0x0C, 0x00, 0xF3, 0x00, 0x00, 0x80, 0x00, 0x78, 0x00, 0x07, 0x80, 0x00, 0x60, 0x00, 0x00, 
		0xF8, 0x00, 0x04, 0x00, 0x02, 0x00, 0x01, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x80, 0x10, 0xC0, 0x10, 0x00, 0x08, 0x1C, 0xC0, 0x22, 0x96, 0xA5, 0xE0, 0xF0, 0xBF, 0xC0, 0x80, 
		0x03, 0x00, 0x27, 0x10, 0x00, 0x03, 0xE8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x01, 0x00, 0xE0, 0x00, 0x00, 0x00, 0x00, 
	},
};



INC_UINT32 INC_GET_KOREABAND_FULL_TABLE(INC_UINT16 uiIndex)
{
	if(uiIndex >= MAX_KOREABAND_FULL_CHANNEL) return 0xFFFF;
	return g_uiKOREnsembleFullFreq[uiIndex];
}

INC_UINT32 INC_GET_KOREABAND_NORMAL_TABLE(INC_UINT16 uiIndex)
{
	if(uiIndex >= MAX_KOREABAND_NORMAL_CHANNEL) return 0xFFFF;
	return g_uiKOREnsembleNormalFreq[uiIndex];
}

INC_UINT16 INC_FIND_LBAND_FREQ(INC_UINT32 ulFreq)
{
	INC_UINT16 uiLoop;
	for(uiLoop = 0 ; uiLoop < MAX_L_BAND_CHANNEL; uiLoop++){
		if(g_uiLBandEnsemblVal[uiLoop] == ulFreq)
			return uiLoop;
	}
	return 0xFFFF;
}

INC_UINT16 INC_FIND_CHINA_FREQ(INC_UINT32 ulFreq)
{
	INC_UINT16 uiLoop;
	for(uiLoop = 0 ; uiLoop < MAX_CHINA_CHANNEL; uiLoop++){
		if(g_uiChinaEnsemblVal[uiLoop] == ulFreq)
			return uiLoop;
	}
	return 0xFFFF;
}

INC_UINT16 INC_FIND_ROAMING_FREQ(INC_UINT32 ulFreq)
{
	INC_UINT16 uiLoop;
	for(uiLoop = 0 ; uiLoop < MAX_ROAMING_CHANNEL; uiLoop++){
		if(g_uiRoamingEnsemblVal[uiLoop] == ulFreq)
			return uiLoop;
	}
	return 0xFFFF;
}

INC_UINT16 INC_FIND_BANDIII_FREQ(INC_UINT32 ulFreq)
{
	INC_UINT16 uiLoop;
	for(uiLoop = 0 ; uiLoop < MAX_BAND_III_CHANNEL; uiLoop++){
		if(g_uiBandIIIEnsemblVal[uiLoop] == ulFreq)
			return uiLoop;
	}
	return 0xFFFF;
}

INC_UINT8 INC_IS_KOR_FREQ(INC_UINT32 ulFreq)
{
	INC_UINT16 uiLoop;
	for(uiLoop = 0 ; uiLoop < MAX_KOREABAND_NORMAL_CHANNEL; uiLoop++){
		if(g_uiKOREnsembleNormalFreq[uiLoop] == ulFreq)
			return INC_SUCCESS;
	}	
	return INC_ERROR;
}

INC_UINT16 INC_FIND_KOR_FREQ(INC_UINT32 ulFreq)
{
	INC_UINT16 uiLoop;
	for(uiLoop = 0 ; uiLoop < MAX_KOREABAND_FULL_CHANNEL; uiLoop++){
		if(g_uiKOREnsembleFullFreq[uiLoop] == ulFreq)
			return uiLoop;
	}
	return 0xFFFF;
}

INC_UINT8 INC_RF500_I2C_WRITE(INC_UINT8 ucI2CID, INC_UINT8 *pucData, INC_UINT32 uLength)
{
	INC_INT16 nLoop;
	for(nLoop = 0 ;nLoop < (INC_INT16)uLength; nLoop++){
		INC_CMD_WRITE(ucI2CID, APB_RF_BASE+nLoop, (INC_UINT16)pucData[nLoop]);
	}
	return INC_SUCCESS;
}

INC_UINT8 INC_RF500_START(INC_UINT8 ucI2CID, INC_UINT32 ulRFChannel, ENSEMBLE_BAND ucBand)
{
	INC_UINT16 uiPos;
	INC_UINT8* pDataBuff = INC_NULL;

	if(ucBand == KOREA_BAND_ENABLE){
		uiPos = INC_FIND_KOR_FREQ(ulRFChannel);
		if(uiPos == 0xFFFF) return INC_ERROR;

		switch(m_ucPLL_Mode){
		case INPUT_CLOCK_19200KHZ : pDataBuff = g_acT3900KorI2CValue_19200[uiPos]; break;
		case INPUT_CLOCK_24576KHZ : pDataBuff = g_acT3900KorI2CValue_24576[uiPos]; break;
		case INPUT_CLOCK_27000KHZ : pDataBuff = g_acT3900KorI2CValue_27000[uiPos]; break;
		case INPUT_CLOCK_12000KHZ : //pDataBuff = g_acT3900KorI2CValue_12000[uiPos]; break;
		default : 
			INC_MSG_PRINTF(1, "INC_RF500_START() error: [KBAND] unknown PLL(%d) \r\n", m_ucPLL_Mode); 
			return INC_ERROR;
		}
	}
	else if(ucBand == BANDIII_ENABLE){
		uiPos = INC_FIND_BANDIII_FREQ(ulRFChannel);
		if(uiPos == 0xFFFF) return INC_ERROR;

		switch(m_ucPLL_Mode){
		case INPUT_CLOCK_12000KHZ : //pDataBuff = g_acT3900BandIIII2CValue_12000[uiPos]; break;
		case INPUT_CLOCK_19200KHZ : //pDataBuff = g_acT3900BandIIII2CValue_19200[uiPos]; break;
		case INPUT_CLOCK_24576KHZ : //pDataBuff = g_acT3900BandIIII2CValue_24576[uiPos]; break;
		case INPUT_CLOCK_27000KHZ : //pDataBuff = g_acT3900BandIIII2CValue_27000[uiPos]; break;
		default : 
			INC_MSG_PRINTF(1, " INC_RF500_START() error: [BandIII] unknown PLL(%d) \r\n", m_ucPLL_Mode); 
			return INC_ERROR;
		}
	}
	else if(ucBand == ROAMING_ENABLE){
		uiPos = INC_FIND_ROAMING_FREQ(ulRFChannel);
		if(uiPos == 0xFFFF) return INC_ERROR;

		switch(m_ucPLL_Mode){
		case INPUT_CLOCK_12000KHZ : //pDataBuff = g_acT3900RoamingI2CValue_12000[uiPos]; break;
		case INPUT_CLOCK_19200KHZ : //pDataBuff = g_acT3900RoamingI2CValue_19200[uiPos]; break;
		case INPUT_CLOCK_24576KHZ : //pDataBuff = g_acT3900RoamingI2CValue_24576[uiPos]; break;
		case INPUT_CLOCK_27000KHZ : //pDataBuff = g_acT3900RoamingI2CValue_27000[uiPos]; break;
		default : 
			INC_MSG_PRINTF(1, " INC_RF500_START() error: [Roaming] unknown PLL(%d) \r\n", m_ucPLL_Mode); 
			return INC_ERROR;
		}
	}
	else if(ucBand == EXTERNAL_ENABLE) 
		return INC_SUCCESS;
	else {
		INC_MSG_PRINTF(1, " INC_RF500_START() error: unknown Band(%d)  \r\n", ucBand);
		return INC_ERROR;
	}

	if(pDataBuff == INC_NULL) return INC_ERROR;
	if(INC_RF500_I2C_WRITE(ucI2CID, pDataBuff, RF500_REG_CTRL) == INC_ERROR)
		return INC_ERROR;

	return INC_SUCCESS;
}


