/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.net.URL;
import java.util.Map;
import org.apache.batik.bridge.AbstractSVGFilterPrimitiveElementBridge;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.BridgeException;
import org.apache.batik.bridge.DocumentLoader;
import org.apache.batik.bridge.SVGUtilities;
import org.apache.batik.bridge.URIResolver;
import org.apache.batik.dom.svg.SVGOMDocument;
import org.apache.batik.dom.util.XLinkSupport;
import org.apache.batik.ext.awt.image.PadMode;
import org.apache.batik.ext.awt.image.renderable.AffineRable8Bit;
import org.apache.batik.ext.awt.image.renderable.Filter;
import org.apache.batik.ext.awt.image.renderable.PadRable8Bit;
import org.apache.batik.ext.awt.image.spi.ImageTagRegistry;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.util.ParsedURL;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.svg.SVGDocument;

public class SVGFeImageElementBridge
extends AbstractSVGFilterPrimitiveElementBridge {
    public String getLocalName() {
        return "feImage";
    }

    public Filter createFilter(BridgeContext ctx, Element filterElement, Element filteredElement, GraphicsNode filteredNode, Filter inputFilter, Rectangle2D filterRegion, Map filterMap) {
        String uriStr = XLinkSupport.getXLinkHref(filterElement);
        if (uriStr.length() == 0) {
            throw new BridgeException(filterElement, "attribute.missing", new Object[]{"xlink:href"});
        }
        Rectangle2D defaultRegion = filterRegion;
        Rectangle2D primitiveRegion = SVGUtilities.convertFilterPrimitiveRegion(filterElement, filteredElement, filteredNode, defaultRegion, filterRegion, ctx);
        Filter filter = null;
        SVGDocument svgDoc = (SVGDocument)filterElement.getOwnerDocument();
        URL baseURL = ((SVGOMDocument)svgDoc).getURLObject();
        ParsedURL purl = baseURL != null ? new ParsedURL(baseURL.toString(), uriStr) : new ParsedURL(uriStr);
        DocumentLoader loader = ctx.getDocumentLoader();
        URIResolver resolver = new URIResolver(svgDoc, loader);
        boolean toBBoxNeeded = false;
        try {
            Element refElement = null;
            Node n = resolver.getNode(purl.toString(), filterElement);
            if (n.getNodeType() == 9) {
                refElement = ((SVGDocument)n).getRootElement();
            } else if (n.getNodeType() == 1) {
                refElement = (Element)n;
                toBBoxNeeded = true;
            } else {
                throw new BridgeException(filterElement, "uri.image.invalid", new Object[]{uriStr});
            }
            filter = SVGFeImageElementBridge.createSVGFeImage(ctx, primitiveRegion, refElement, toBBoxNeeded, filterElement, filteredNode);
        }
        catch (BridgeException ex) {
            throw ex;
        }
        catch (SecurityException ex) {
            throw new BridgeException(filterElement, "uri.unsecure", new Object[]{uriStr});
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (filter == null) {
            filter = SVGFeImageElementBridge.createRasterFeImage(ctx, primitiveRegion, purl);
        }
        if (filter == null) {
            throw new BridgeException(filterElement, "uri.image.invalid", new Object[]{"xlink:href", uriStr});
        }
        AbstractSVGFilterPrimitiveElementBridge.handleColorInterpolationFilters(filter, filterElement);
        filter = new PadRable8Bit(filter, primitiveRegion, PadMode.ZERO_PAD);
        AbstractSVGFilterPrimitiveElementBridge.updateFilterMap(filterElement, filter, filterMap);
        return filter;
    }

    protected static Filter createSVGFeImage(BridgeContext ctx, Rectangle2D primitiveRegion, Element refElement, boolean toBBoxNeeded, Element filterElement, GraphicsNode filteredNode) {
        GraphicsNode node = ctx.getGVTBuilder().build(ctx, refElement);
        Filter filter = node.getGraphicsNodeRable(true);
        AffineTransform at = new AffineTransform();
        if (toBBoxNeeded) {
            Element filterDefElement = (Element)filterElement.getParentNode();
            String s = SVGUtilities.getChainableAttributeNS(filterDefElement, null, "primitiveUnits", ctx);
            short coordSystemType = s.length() == 0 ? (short)1 : SVGUtilities.parseCoordinateSystem(filterDefElement, "primitiveUnits", s);
            if (coordSystemType == 2) {
                at = SVGUtilities.toObjectBBox(at, filteredNode);
            }
            Rectangle2D bounds = filteredNode.getGeometryBounds();
            at.preConcatenate(AffineTransform.getTranslateInstance(primitiveRegion.getX() - bounds.getX(), primitiveRegion.getY() - bounds.getY()));
        } else {
            at.translate(primitiveRegion.getX(), primitiveRegion.getY());
        }
        return new AffineRable8Bit(filter, at);
    }

    protected static Filter createRasterFeImage(BridgeContext ctx, Rectangle2D primitiveRegion, ParsedURL purl) {
        Filter filter = ImageTagRegistry.getRegistry().readURL(purl);
        Rectangle2D bounds = filter.getBounds2D();
        AffineTransform scale = new AffineTransform();
        scale.translate(primitiveRegion.getX(), primitiveRegion.getY());
        scale.scale(primitiveRegion.getWidth() / (bounds.getWidth() - 1.0), primitiveRegion.getHeight() / (bounds.getHeight() - 1.0));
        scale.translate(-bounds.getX(), -bounds.getY());
        return new AffineRable8Bit(filter, scale);
    }
}

