/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.digester;

import org.apache.commons.digester.Digester;
import org.apache.commons.digester.ObjectCreationFactory;
import org.apache.commons.digester.Rule;
import org.xml.sax.Attributes;

public class FactoryCreateRule
extends Rule {
    protected String attributeName = null;
    protected String className = null;
    protected ObjectCreationFactory creationFactory = null;

    public FactoryCreateRule(Digester digester, String className) {
        this(className);
    }

    public FactoryCreateRule(Digester digester, Class clazz) {
        this(clazz);
    }

    public FactoryCreateRule(Digester digester, String className, String attributeName) {
        this(className, attributeName);
    }

    public FactoryCreateRule(Digester digester, Class clazz, String attributeName) {
        this(clazz, attributeName);
    }

    public FactoryCreateRule(Digester digester, ObjectCreationFactory creationFactory) {
        this(creationFactory);
    }

    public FactoryCreateRule(String className) {
        this(className, null);
    }

    public FactoryCreateRule(Class clazz) {
        this(clazz, null);
    }

    public FactoryCreateRule(String className, String attributeName) {
        this.className = className;
        this.attributeName = attributeName;
    }

    public FactoryCreateRule(Class clazz, String attributeName) {
        this(clazz.getName(), attributeName);
    }

    public FactoryCreateRule(ObjectCreationFactory creationFactory) {
        this.creationFactory = creationFactory;
    }

    public void begin(Attributes attributes) throws Exception {
        Object instance = this.getFactory(attributes).createObject(attributes);
        if (this.digester.log.isDebugEnabled()) {
            this.digester.log.debug("[FactoryCreateRule]{" + this.digester.match + "} New " + instance.getClass().getName());
        }
        this.digester.push(instance);
    }

    public void end() throws Exception {
        Object top = this.digester.pop();
        if (this.digester.log.isDebugEnabled()) {
            this.digester.log.debug("[FactoryCreateRule]{" + this.digester.match + "} Pop " + top.getClass().getName());
        }
    }

    public void finish() throws Exception {
        if (this.attributeName != null) {
            this.creationFactory = null;
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("FactoryCreateRule[");
        sb.append("className=");
        sb.append(this.className);
        sb.append(", attributeName=");
        sb.append(this.attributeName);
        if (this.creationFactory != null) {
            sb.append(", creationFactory=");
            sb.append(this.creationFactory);
        }
        sb.append("]");
        return sb.toString();
    }

    protected ObjectCreationFactory getFactory(Attributes attributes) throws Exception {
        if (this.creationFactory == null) {
            String value;
            String realClassName = this.className;
            if (this.attributeName != null && (value = attributes.getValue(this.attributeName)) != null) {
                realClassName = value;
            }
            if (this.digester.log.isDebugEnabled()) {
                this.digester.log.debug("[FactoryCreateRule]{" + this.digester.match + "} New factory " + realClassName);
            }
            Class<?> clazz = this.digester.getClassLoader().loadClass(realClassName);
            this.creationFactory = (ObjectCreationFactory)clazz.newInstance();
            this.creationFactory.setDigester(this.digester);
        }
        return this.creationFactory;
    }
}

