/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.expr;

import com.icl.saxon.Context;
import com.icl.saxon.Controller;
import com.icl.saxon.expr.BooleanValue;
import com.icl.saxon.expr.EmptyNodeSet;
import com.icl.saxon.expr.Expression;
import com.icl.saxon.expr.Function;
import com.icl.saxon.expr.NodeSetExtent;
import com.icl.saxon.expr.NumericValue;
import com.icl.saxon.expr.ObjectValue;
import com.icl.saxon.expr.SingletonNodeSet;
import com.icl.saxon.expr.StringValue;
import com.icl.saxon.expr.Value;
import com.icl.saxon.expr.XPathException;
import com.icl.saxon.om.NodeEnumeration;
import com.icl.saxon.om.NodeInfo;
import com.icl.saxon.sort.NodeOrderComparer;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Vector;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FunctionProxy
extends Function {
    private Class theClass;
    private Vector candidateMethods = new Vector();
    private XPathException theException = null;
    private String name;
    private Class resultClass = null;
    static /* synthetic */ Class class$com$icl$saxon$Context;
    static /* synthetic */ Class class$org$w3c$xsl$XSLTContext;
    static /* synthetic */ Class class$com$icl$saxon$expr$Value;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$com$icl$saxon$expr$StringValue;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$com$icl$saxon$expr$BooleanValue;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$com$icl$saxon$expr$NumericValue;
    static /* synthetic */ Class class$com$icl$saxon$expr$NodeSetValue;
    static /* synthetic */ Class class$com$icl$saxon$om$NodeEnumeration;
    static /* synthetic */ Class class$org$w3c$dom$NodeList;
    static /* synthetic */ Class class$org$w3c$dom$Node;

    public boolean setFunctionName(Class clazz, String string) {
        int n;
        boolean bl = false;
        this.name = string;
        int n2 = n = this.getNumberOfArguments();
        this.theClass = clazz;
        if (this.name.equals("new")) {
            int n3 = this.theClass.getModifiers();
            if (Modifier.isAbstract(n3)) {
                this.theException = new XPathException("Class " + this.theClass + " is abstract");
                return false;
            }
            if (Modifier.isInterface(n3)) {
                this.theException = new XPathException(this.theClass + " is an interface");
                return false;
            }
            if (Modifier.isPrivate(n3)) {
                this.theException = new XPathException("Class " + this.theClass + " is private");
                return false;
            }
            if (Modifier.isProtected(n3)) {
                this.theException = new XPathException("Class " + this.theClass + " is protected");
                return false;
            }
            this.resultClass = this.theClass;
            Constructor<?>[] constructorArray = this.theClass.getConstructors();
            int n4 = 0;
            while (n4 < constructorArray.length) {
                bl = true;
                Constructor<?> constructor = constructorArray[n4];
                if (constructor.getParameterTypes().length == n) {
                    bl = true;
                    this.candidateMethods.addElement(constructor);
                }
                ++n4;
            }
            if (bl) {
                return true;
            }
            this.theException = new XPathException("No constructor with " + n + (n == 1 ? " parameter" : " parameters") + " found in class " + this.theClass.getName());
            return false;
        }
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl2 = false;
        int n5 = 0;
        while (n5 < this.name.length()) {
            char c = this.name.charAt(n5);
            if (c == '-') {
                bl2 = true;
            } else {
                if (bl2) {
                    stringBuffer.append(Character.toUpperCase(c));
                } else {
                    stringBuffer.append(c);
                }
                bl2 = false;
            }
            ++n5;
        }
        this.name = stringBuffer.toString();
        if (this.name.equals("if")) {
            this.name = "IF";
        }
        Method[] methodArray = this.theClass.getMethods();
        boolean bl3 = true;
        int n6 = 0;
        while (n6 < methodArray.length) {
            Method method = methodArray[n6];
            if (method.getName().equals(this.name) && Modifier.isPublic(method.getModifiers())) {
                bl = true;
                if (bl3) {
                    if (this.resultClass == null) {
                        this.resultClass = method.getReturnType();
                    } else {
                        bl3 = method.getReturnType() == this.resultClass;
                    }
                }
                Class<?>[] classArray = method.getParameterTypes();
                boolean bl4 = Modifier.isStatic(method.getModifiers());
                int n7 = n2 = bl4 ? n : n - 1;
                if (n2 >= 0) {
                    if (classArray.length == n2 && (n2 == 0 || classArray[0] != (class$com$icl$saxon$Context == null ? FunctionProxy.class$("com.icl.saxon.Context") : class$com$icl$saxon$Context))) {
                        bl = true;
                        this.candidateMethods.addElement(method);
                    }
                    if (classArray.length == n2 + 1 && (classArray[0] == (class$com$icl$saxon$Context == null ? FunctionProxy.class$("com.icl.saxon.Context") : class$com$icl$saxon$Context) || classArray[0] == (class$org$w3c$xsl$XSLTContext == null ? FunctionProxy.class$("org.w3c.xsl.XSLTContext") : class$org$w3c$xsl$XSLTContext))) {
                        bl = true;
                        this.candidateMethods.addElement(method);
                    }
                }
            }
            ++n6;
        }
        if (!bl3) {
            this.resultClass = null;
        }
        if (bl) {
            return true;
        }
        this.theException = new XPathException("No method matching " + this.name + " with " + n2 + (n2 == 1 ? " parameter" : " parameters") + " found in class " + this.theClass.getName());
        return false;
    }

    public int getDataType() {
        if (this.resultClass == null || this.resultClass == (class$com$icl$saxon$expr$Value == null ? (class$com$icl$saxon$expr$Value = FunctionProxy.class$("com.icl.saxon.expr.Value")) : class$com$icl$saxon$expr$Value)) {
            return -1;
        }
        if (this.resultClass.toString().equals("void")) {
            return 4;
        }
        if (this.resultClass == (class$java$lang$String == null ? (class$java$lang$String = FunctionProxy.class$("java.lang.String")) : class$java$lang$String) || this.resultClass == (class$com$icl$saxon$expr$StringValue == null ? (class$com$icl$saxon$expr$StringValue = FunctionProxy.class$("com.icl.saxon.expr.StringValue")) : class$com$icl$saxon$expr$StringValue)) {
            return 3;
        }
        if (this.resultClass == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = FunctionProxy.class$("java.lang.Boolean")) : class$java$lang$Boolean) || this.resultClass == Boolean.TYPE || this.resultClass == (class$com$icl$saxon$expr$BooleanValue == null ? (class$com$icl$saxon$expr$BooleanValue = FunctionProxy.class$("com.icl.saxon.expr.BooleanValue")) : class$com$icl$saxon$expr$BooleanValue)) {
            return 1;
        }
        if (this.resultClass == (class$java$lang$Double == null ? (class$java$lang$Double = FunctionProxy.class$("java.lang.Double")) : class$java$lang$Double) || this.resultClass == Double.TYPE || this.resultClass == (class$java$lang$Float == null ? (class$java$lang$Float = FunctionProxy.class$("java.lang.Float")) : class$java$lang$Float) || this.resultClass == Float.TYPE || this.resultClass == (class$java$lang$Long == null ? (class$java$lang$Long = FunctionProxy.class$("java.lang.Long")) : class$java$lang$Long) || this.resultClass == Long.TYPE || this.resultClass == (class$java$lang$Integer == null ? (class$java$lang$Integer = FunctionProxy.class$("java.lang.Integer")) : class$java$lang$Integer) || this.resultClass == Integer.TYPE || this.resultClass == (class$java$lang$Short == null ? (class$java$lang$Short = FunctionProxy.class$("java.lang.Short")) : class$java$lang$Short) || this.resultClass == Short.TYPE || this.resultClass == (class$java$lang$Byte == null ? (class$java$lang$Byte = FunctionProxy.class$("java.lang.Byte")) : class$java$lang$Byte) || this.resultClass == Byte.TYPE || this.resultClass == (class$com$icl$saxon$expr$NumericValue == null ? (class$com$icl$saxon$expr$NumericValue = FunctionProxy.class$("com.icl.saxon.expr.NumericValue")) : class$com$icl$saxon$expr$NumericValue)) {
            return 2;
        }
        if ((class$com$icl$saxon$expr$NodeSetValue == null ? (class$com$icl$saxon$expr$NodeSetValue = FunctionProxy.class$("com.icl.saxon.expr.NodeSetValue")) : class$com$icl$saxon$expr$NodeSetValue).isAssignableFrom(this.resultClass) || (class$com$icl$saxon$om$NodeEnumeration == null ? (class$com$icl$saxon$om$NodeEnumeration = FunctionProxy.class$("com.icl.saxon.om.NodeEnumeration")) : class$com$icl$saxon$om$NodeEnumeration).isAssignableFrom(this.resultClass) || (class$org$w3c$dom$NodeList == null ? (class$org$w3c$dom$NodeList = FunctionProxy.class$("org.w3c.dom.NodeList")) : class$org$w3c$dom$NodeList).isAssignableFrom(this.resultClass) || (class$org$w3c$dom$Node == null ? (class$org$w3c$dom$Node = FunctionProxy.class$("org.w3c.dom.Node")) : class$org$w3c$dom$Node).isAssignableFrom(this.resultClass)) {
            return 4;
        }
        return 6;
    }

    public String getName() {
        return this.name;
    }

    public Expression simplify() throws XPathException {
        int n = 0;
        while (n < this.getNumberOfArguments()) {
            this.argument[n] = this.argument[n].simplify();
            ++n;
        }
        if (this.candidateMethods.size() > 1) {
            boolean bl = true;
            int n2 = 0;
            while (n2 < this.getNumberOfArguments()) {
                int n3 = this.argument[n2].getDataType();
                if (n3 == -1 || n3 == 6) {
                    bl = false;
                    break;
                }
                ++n2;
            }
            if (bl) {
                Value[] valueArray = new Value[this.getNumberOfArguments()];
                int n4 = 0;
                while (n4 < this.getNumberOfArguments()) {
                    switch (this.argument[n4].getDataType()) {
                        case 1: {
                            valueArray[n4] = new BooleanValue(true);
                            break;
                        }
                        case 2: {
                            valueArray[n4] = new NumericValue(1.0);
                            break;
                        }
                        case 3: {
                            valueArray[n4] = new StringValue("");
                            break;
                        }
                        case 4: {
                            valueArray[n4] = new EmptyNodeSet();
                        }
                    }
                    ++n4;
                }
                try {
                    Object object = this.getBestFit(valueArray);
                    this.candidateMethods = new Vector();
                    this.candidateMethods.addElement(object);
                }
                catch (XPathException xPathException) {
                    this.theException = xPathException;
                }
            }
        }
        return this;
    }

    public int getDependencies() {
        int n = 0;
        n = 56;
        int n2 = 0;
        while (n2 < this.getNumberOfArguments()) {
            n |= this.argument[n2].getDependencies();
            ++n2;
        }
        return n;
    }

    public Expression reduce(int n, Context context) throws XPathException {
        if ((n & 0x38) != 0) {
            return this.evaluate(context);
        }
        FunctionProxy functionProxy = new FunctionProxy();
        functionProxy.theClass = this.theClass;
        functionProxy.candidateMethods = this.candidateMethods;
        functionProxy.theException = this.theException;
        functionProxy.name = this.name;
        functionProxy.argument = new Expression[this.getNumberOfArguments()];
        int n2 = 0;
        while (n2 < this.getNumberOfArguments()) {
            functionProxy.addArgument(this.argument[n2].reduce(n, context));
            ++n2;
        }
        return functionProxy;
    }

    public Object getBestFit(Value[] valueArray) throws XPathException {
        if (this.candidateMethods.size() == 1) {
            return this.candidateMethods.elementAt(0);
        }
        int n = this.candidateMethods.size();
        boolean[] blArray = new boolean[n];
        int n2 = 0;
        while (n2 < n) {
            blArray[n2] = false;
            ++n2;
        }
        int n3 = 0;
        while (n3 < n - 1) {
            int[] nArray = this.getConversionPreferences(valueArray, this.candidateMethods.elementAt(n3));
            if (!blArray[n3]) {
                int n4 = n3 + 1;
                while (n4 < n) {
                    if (!blArray[n4]) {
                        int[] nArray2 = this.getConversionPreferences(valueArray, this.candidateMethods.elementAt(n4));
                        int n5 = 0;
                        while (n5 < nArray2.length) {
                            if (nArray[n5] > nArray2[n5]) {
                                blArray[n3] = true;
                            }
                            if (nArray[n5] < nArray2[n5]) {
                                blArray[n4] = true;
                            }
                            ++n5;
                        }
                    }
                    ++n4;
                }
            }
            ++n3;
        }
        int n6 = 0;
        Object var7_9 = null;
        int n7 = 0;
        while (n7 < n) {
            if (!blArray[n7]) {
                var7_9 = this.candidateMethods.elementAt(n7);
                ++n6;
            }
            ++n7;
        }
        if (n6 == 0) {
            throw new XPathException("There is no Java method that is a unique best match");
        }
        if (n6 > 1) {
            throw new XPathException("There are several Java methods that match equally well");
        }
        return var7_9;
    }

    public Value evaluate(Context context) throws XPathException {
        Object object = this.call(context);
        return FunctionProxy.convertJavaObjectToXPath(object, context.getController());
    }

    public String evaluateAsString(Context context) throws XPathException {
        if (this.resultClass == (class$java$lang$String == null ? (class$java$lang$String = FunctionProxy.class$("java.lang.String")) : class$java$lang$String)) {
            return (String)this.call(context);
        }
        if (this.resultClass == (class$com$icl$saxon$om$NodeEnumeration == null ? (class$com$icl$saxon$om$NodeEnumeration = FunctionProxy.class$("com.icl.saxon.om.NodeEnumeration")) : class$com$icl$saxon$om$NodeEnumeration)) {
            NodeEnumeration nodeEnumeration = this.enumerate(context, true);
            if (nodeEnumeration.hasMoreElements()) {
                return nodeEnumeration.nextElement().getStringValue();
            }
            return "";
        }
        return this.evaluate(context).asString();
    }

    public double evaluateAsNumber(Context context) throws XPathException {
        if (this.resultClass == Double.TYPE) {
            return (Double)this.call(context);
        }
        return this.evaluate(context).asNumber();
    }

    public boolean evaluateAsBoolean(Context context) throws XPathException {
        if (this.resultClass == Boolean.TYPE) {
            return (Boolean)this.call(context);
        }
        if (this.resultClass == (class$com$icl$saxon$om$NodeEnumeration == null ? (class$com$icl$saxon$om$NodeEnumeration = FunctionProxy.class$("com.icl.saxon.om.NodeEnumeration")) : class$com$icl$saxon$om$NodeEnumeration)) {
            NodeEnumeration nodeEnumeration = this.enumerate(context, false);
            return nodeEnumeration.hasMoreElements();
        }
        return this.evaluate(context).asBoolean();
    }

    public NodeEnumeration enumerate(Context context, boolean bl) throws XPathException {
        if (this.resultClass == (class$com$icl$saxon$om$NodeEnumeration == null ? (class$com$icl$saxon$om$NodeEnumeration = FunctionProxy.class$("com.icl.saxon.om.NodeEnumeration")) : class$com$icl$saxon$om$NodeEnumeration)) {
            NodeEnumeration nodeEnumeration = (NodeEnumeration)this.call(context);
            if (bl && !nodeEnumeration.isSorted()) {
                NodeSetExtent nodeSetExtent = new NodeSetExtent(nodeEnumeration, (NodeOrderComparer)context.getController());
                nodeSetExtent.sort();
                return nodeSetExtent.enumerate();
            }
            return nodeEnumeration;
        }
        return super.enumerate(context, bl);
    }

    private Object call(Context context) throws XPathException {
        Object[] objectArray;
        int n;
        Object object;
        boolean bl;
        if (this.theException != null) {
            throw this.theException;
        }
        context.setException(null);
        Value[] valueArray = new Value[this.getNumberOfArguments()];
        int n2 = 0;
        while (n2 < this.getNumberOfArguments()) {
            valueArray[n2] = this.argument[n2].evaluate(context);
            ++n2;
        }
        Object object2 = this.getBestFit(valueArray);
        if (object2 instanceof Constructor) {
            Constructor constructor = (Constructor)object2;
            Class[] classArray = constructor.getParameterTypes();
            Object[] objectArray2 = new Object[classArray.length];
            this.setupParams(valueArray, objectArray2, classArray, 0, 0);
            try {
                Object t = constructor.newInstance(objectArray2);
                if (context.getException() != null) {
                    throw context.getException();
                }
                return t;
            }
            catch (InstantiationException instantiationException) {
                throw new XPathException("Cannot instantiate class", instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new XPathException("Constructor access is illegal", illegalAccessException);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new XPathException("Argument is of wrong type", illegalArgumentException);
            }
            catch (InvocationTargetException invocationTargetException) {
                Throwable throwable = invocationTargetException.getTargetException();
                if (throwable instanceof XPathException) {
                    throw (XPathException)throwable;
                }
                if (context.getController().isTracing()) {
                    invocationTargetException.getTargetException().printStackTrace();
                }
                throw new XPathException("Exception in extension function " + invocationTargetException.getTargetException().toString());
            }
        }
        Method method = (Method)object2;
        boolean bl2 = Modifier.isStatic(method.getModifiers());
        Class[] classArray = method.getParameterTypes();
        boolean bl3 = classArray.length > 0 && (classArray[0] == (class$com$icl$saxon$Context == null ? (class$com$icl$saxon$Context = FunctionProxy.class$("com.icl.saxon.Context")) : class$com$icl$saxon$Context) || classArray[0] == (class$org$w3c$xsl$XSLTContext == null ? (class$org$w3c$xsl$XSLTContext = FunctionProxy.class$("org.w3c.xsl.XSLTContext")) : class$org$w3c$xsl$XSLTContext)) ? true : (bl = false);
        if (bl2) {
            object = null;
        } else {
            n = this.getNumberOfArguments();
            if (n == 0) {
                throw new XPathException("Must supply an argument for an instance-level extension function");
            }
            objectArray = this.argument[0].evaluate(context);
            if (objectArray instanceof ObjectValue) {
                object = ((ObjectValue)objectArray).getObject();
            } else if (this.theClass == (class$java$lang$String == null ? (class$java$lang$String = FunctionProxy.class$("java.lang.String")) : class$java$lang$String)) {
                object = objectArray.asString();
            } else if (this.theClass == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = FunctionProxy.class$("java.lang.Boolean")) : class$java$lang$Boolean)) {
                object = new Boolean(objectArray.asBoolean());
            } else if (this.theClass == (class$java$lang$Double == null ? (class$java$lang$Double = FunctionProxy.class$("java.lang.Double")) : class$java$lang$Double)) {
                object = new Double(objectArray.asNumber());
            } else {
                throw new XPathException("First argument is not an object instance");
            }
        }
        n = classArray.length - (bl ? 1 : 0) + (bl2 ? 0 : 1);
        this.checkArgumentCount(n, n);
        objectArray = new Object[classArray.length];
        if (bl) {
            objectArray[0] = context;
        }
        this.setupParams(valueArray, objectArray, classArray, bl ? 1 : 0, bl2 ? 0 : 1);
        try {
            Object object3 = method.invoke(object, objectArray);
            if (context.getException() != null) {
                throw context.getException();
            }
            if (method.getReturnType().toString().equals("void")) {
                return new EmptyNodeSet();
            }
            return object3;
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new XPathException("Method access is illegal", illegalAccessException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new XPathException("Argument is of wrong type", illegalArgumentException);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable instanceof XPathException) {
                throw (XPathException)throwable;
            }
            if (context.getController().isTracing()) {
                invocationTargetException.getTargetException().printStackTrace();
            }
            throw new XPathException("Exception in extension function " + invocationTargetException.getTargetException().toString());
        }
    }

    public static Value convertJavaObjectToXPath(Object object, Controller controller) throws XPathException {
        if (object == null) {
            return new ObjectValue(null);
        }
        if (object instanceof String) {
            return new StringValue((String)object);
        }
        if (object instanceof Boolean) {
            return new BooleanValue((Boolean)object);
        }
        if (object instanceof Double) {
            return new NumericValue((Double)object);
        }
        if (object instanceof Float) {
            return new NumericValue(((Float)object).floatValue());
        }
        if (object instanceof Short) {
            return new NumericValue(((Short)object).shortValue());
        }
        if (object instanceof Integer) {
            return new NumericValue(((Integer)object).intValue());
        }
        if (object instanceof Long) {
            return new NumericValue(((Long)object).longValue());
        }
        if (object instanceof Character) {
            return new NumericValue(((Character)object).charValue());
        }
        if (object instanceof Byte) {
            return new NumericValue(((Byte)object).byteValue());
        }
        if (object instanceof Value) {
            return (Value)object;
        }
        if (object instanceof NodeInfo) {
            return new SingletonNodeSet((NodeInfo)object);
        }
        if (object instanceof NodeEnumeration) {
            return new NodeSetExtent((NodeEnumeration)object, (NodeOrderComparer)controller);
        }
        if (object instanceof NodeList) {
            NodeList nodeList = (NodeList)object;
            NodeInfo[] nodeInfoArray = new NodeInfo[nodeList.getLength()];
            int n = 0;
            while (n < nodeList.getLength()) {
                if (!(nodeList.item(n) instanceof NodeInfo)) {
                    throw new XPathException("Supplied NodeList contains non-Saxon DOM Nodes");
                }
                nodeInfoArray[n] = (NodeInfo)((Object)nodeList.item(n));
                ++n;
            }
            return new NodeSetExtent(nodeInfoArray, (NodeOrderComparer)controller);
        }
        if (object instanceof Node) {
            throw new XPathException("Result is a non-Saxon DOM Node");
        }
        return new ObjectValue(object);
    }

    private int[] getConversionPreferences(Value[] valueArray, Object object) {
        int n;
        Class<?>[] classArray;
        int n2;
        if (object instanceof Constructor) {
            n2 = 0;
            classArray = ((Constructor)object).getParameterTypes();
        } else {
            n = Modifier.isStatic(((Method)object).getModifiers());
            n2 = n != 0 ? 0 : 1;
            classArray = ((Method)object).getParameterTypes();
        }
        n = this.getNumberOfArguments() - n2;
        int[] nArray = new int[n];
        int n3 = 0;
        if (classArray[0] == (class$com$icl$saxon$Context == null ? (class$com$icl$saxon$Context = FunctionProxy.class$("com.icl.saxon.Context")) : class$com$icl$saxon$Context) || classArray[0] == (class$org$w3c$xsl$XSLTContext == null ? (class$org$w3c$xsl$XSLTContext = FunctionProxy.class$("org.w3c.xsl.XSLTContext")) : class$org$w3c$xsl$XSLTContext)) {
            n3 = 1;
        }
        int n4 = 0;
        while (n4 < n) {
            nArray[n4] = valueArray[n4 + n2].conversionPreference(classArray[n4 + n3]);
            ++n4;
        }
        return nArray;
    }

    private void setupParams(Value[] valueArray, Object[] objectArray, Class[] classArray, int n, int n2) throws XPathException {
        int n3 = n;
        int n4 = n2;
        while (n4 < this.getNumberOfArguments()) {
            objectArray[n3] = valueArray[n4].convertToJava(classArray[n3]);
            ++n3;
            ++n4;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

