/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.expr;

import com.icl.saxon.Context;
import com.icl.saxon.InternalSaxonError;
import com.icl.saxon.expr.BooleanValue;
import com.icl.saxon.expr.NodeSetExtent;
import com.icl.saxon.expr.NumericValue;
import com.icl.saxon.expr.ObjectValue;
import com.icl.saxon.expr.SingletonNodeSet;
import com.icl.saxon.expr.StringValue;
import com.icl.saxon.expr.Value;
import com.icl.saxon.expr.XPathException;
import com.icl.saxon.om.NodeEnumeration;
import com.icl.saxon.om.NodeInfo;
import com.icl.saxon.sort.LocalOrderComparer;
import com.icl.saxon.sort.NodeOrderComparer;
import java.util.Hashtable;
import org.w3c.dom.NodeList;

public abstract class NodeSetValue
extends Value {
    private Hashtable stringValues = null;
    static /* synthetic */ Class class$com$icl$saxon$expr$NodeSetValue;
    static /* synthetic */ Class class$org$w3c$dom$NodeList;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$org$w3c$dom$Node;
    static /* synthetic */ Class class$org$w3c$dom$Element;
    static /* synthetic */ Class class$org$w3c$dom$Document;
    static /* synthetic */ Class class$org$w3c$dom$DocumentFragment;
    static /* synthetic */ Class class$org$w3c$dom$Attr;
    static /* synthetic */ Class class$org$w3c$dom$Comment;
    static /* synthetic */ Class class$org$w3c$dom$Text;
    static /* synthetic */ Class class$org$w3c$dom$CharacterData;
    static /* synthetic */ Class class$org$w3c$dom$ProcessingInstruction;
    static /* synthetic */ Class class$com$icl$saxon$om$NodeEnumeration;

    public int getDataType() {
        return 4;
    }

    public Value evaluate(Context context) throws XPathException {
        this.sort();
        return this;
    }

    public NodeSetValue evaluateAsNodeSet(Context context) throws XPathException {
        this.sort();
        return this;
    }

    public abstract NodeEnumeration enumerate() throws XPathException;

    public NodeEnumeration enumerate(Context context, boolean bl) throws XPathException {
        if (bl) {
            this.sort();
        }
        return this.enumerate();
    }

    public abstract void setSorted(boolean var1);

    public abstract boolean isSorted() throws XPathException;

    public abstract String asString() throws XPathException;

    public double asNumber() throws XPathException {
        return new StringValue(this.asString()).asNumber();
    }

    public abstract boolean asBoolean() throws XPathException;

    public abstract int getCount() throws XPathException;

    public abstract NodeSetValue sort() throws XPathException;

    public abstract NodeInfo getFirst() throws XPathException;

    private Hashtable getStringValues() throws XPathException {
        if (this.stringValues == null) {
            this.stringValues = new Hashtable();
            NodeEnumeration nodeEnumeration = this.enumerate();
            while (nodeEnumeration.hasMoreElements()) {
                this.stringValues.put(nodeEnumeration.nextElement().getStringValue(), "x");
            }
        }
        return this.stringValues;
    }

    public boolean equals(Value value) throws XPathException {
        if (value instanceof ObjectValue) {
            return false;
        }
        if (value instanceof SingletonNodeSet) {
            if (value.asBoolean()) {
                return this.equals(new StringValue(value.asString()));
            }
            return false;
        }
        if (value instanceof NodeSetValue) {
            Hashtable hashtable = this.getStringValues();
            NodeEnumeration nodeEnumeration = ((NodeSetValue)value).enumerate();
            while (nodeEnumeration.hasMoreElements()) {
                if (hashtable.get(nodeEnumeration.nextElement().getStringValue()) == null) continue;
                return true;
            }
            return false;
        }
        if (value instanceof NumericValue) {
            NodeEnumeration nodeEnumeration = this.enumerate();
            while (nodeEnumeration.hasMoreElements()) {
                NodeInfo nodeInfo = nodeEnumeration.nextElement();
                if (Value.stringToNumber(nodeInfo.getStringValue()) != value.asNumber()) continue;
                return true;
            }
            return false;
        }
        if (value instanceof StringValue) {
            if (this.stringValues == null) {
                NodeEnumeration nodeEnumeration = this.enumerate();
                while (nodeEnumeration.hasMoreElements()) {
                    NodeInfo nodeInfo = nodeEnumeration.nextElement();
                    if (!nodeInfo.getStringValue().equals(value.asString())) continue;
                    return true;
                }
                return false;
            }
            return this.stringValues.get(value.asString()) != null;
        }
        if (value instanceof BooleanValue) {
            return this.asBoolean() == value.asBoolean();
        }
        throw new InternalSaxonError("Unknown data type in a relational expression");
    }

    public boolean notEquals(Value value) throws XPathException {
        if (value instanceof ObjectValue) {
            return false;
        }
        if (value instanceof SingletonNodeSet) {
            if (value.asBoolean()) {
                return this.notEquals(new StringValue(value.asString()));
            }
            return false;
        }
        if (value instanceof NodeSetValue) {
            NodeEnumeration nodeEnumeration = this.enumerate();
            while (nodeEnumeration.hasMoreElements()) {
                String string = nodeEnumeration.nextElement().getStringValue();
                NodeEnumeration nodeEnumeration2 = ((NodeSetValue)value).enumerate();
                while (nodeEnumeration2.hasMoreElements()) {
                    String string2 = nodeEnumeration2.nextElement().getStringValue();
                    if (string.equals(string2)) continue;
                    return true;
                }
            }
            return false;
        }
        if (value instanceof NumericValue) {
            NodeEnumeration nodeEnumeration = this.enumerate();
            while (nodeEnumeration.hasMoreElements()) {
                NodeInfo nodeInfo = nodeEnumeration.nextElement();
                if (Value.stringToNumber(nodeInfo.getStringValue()) == value.asNumber()) continue;
                return true;
            }
            return false;
        }
        if (value instanceof StringValue) {
            NodeEnumeration nodeEnumeration = this.enumerate();
            while (nodeEnumeration.hasMoreElements()) {
                NodeInfo nodeInfo = nodeEnumeration.nextElement();
                if (nodeInfo.getStringValue().equals(value.asString())) continue;
                return true;
            }
            return false;
        }
        if (value instanceof BooleanValue) {
            return this.asBoolean() != value.asBoolean();
        }
        throw new InternalSaxonError("Unknown data type in a relational expression");
    }

    public boolean compare(int n, Value value) throws XPathException {
        if (value instanceof ObjectValue) {
            return false;
        }
        if (value instanceof SingletonNodeSet) {
            if (value.asBoolean()) {
                value = new StringValue(value.asString());
            } else {
                return false;
            }
        }
        if (n == 11) {
            return this.equals(value);
        }
        if (n == 34) {
            return this.notEquals(value);
        }
        if (value instanceof NodeSetValue) {
            double d;
            double d2 = Double.NEGATIVE_INFINITY;
            double d3 = Double.POSITIVE_INFINITY;
            boolean bl = true;
            NodeEnumeration nodeEnumeration = this.enumerate();
            while (nodeEnumeration.hasMoreElements()) {
                d = Value.stringToNumber(nodeEnumeration.nextElement().getStringValue());
                if (d < d3) {
                    d3 = d;
                }
                if (d > d2) {
                    d2 = d;
                }
                bl = false;
            }
            if (bl) {
                return false;
            }
            d = Double.NEGATIVE_INFINITY;
            double d4 = Double.POSITIVE_INFINITY;
            boolean bl2 = true;
            NodeEnumeration nodeEnumeration2 = ((NodeSetValue)value).enumerate();
            while (nodeEnumeration2.hasMoreElements()) {
                double d5 = Value.stringToNumber(nodeEnumeration2.nextElement().getStringValue());
                if (d5 < d4) {
                    d4 = d5;
                }
                if (d5 > d) {
                    d = d5;
                }
                bl2 = false;
            }
            if (bl2) {
                return false;
            }
            switch (n) {
                case 22: {
                    return d3 < d;
                }
                case 24: {
                    return d3 <= d;
                }
                case 21: {
                    return d2 > d4;
                }
                case 23: {
                    return d2 >= d4;
                }
            }
            return false;
        }
        if (value instanceof NumericValue || value instanceof StringValue) {
            NodeEnumeration nodeEnumeration = this.enumerate();
            while (nodeEnumeration.hasMoreElements()) {
                NodeInfo nodeInfo = nodeEnumeration.nextElement();
                if (!this.numericCompare(n, Value.stringToNumber(nodeInfo.getStringValue()), value.asNumber())) continue;
                return true;
            }
            return false;
        }
        if (value instanceof BooleanValue) {
            return this.numericCompare(n, new BooleanValue(this.asBoolean()).asNumber(), new BooleanValue(value.asBoolean()).asNumber());
        }
        throw new InternalSaxonError("Unknown data type in a relational expression");
    }

    public int conversionPreference(Class clazz) {
        if (clazz.isAssignableFrom(class$com$icl$saxon$expr$NodeSetValue == null ? (class$com$icl$saxon$expr$NodeSetValue = NodeSetValue.class$("com.icl.saxon.expr.NodeSetValue")) : class$com$icl$saxon$expr$NodeSetValue)) {
            return 0;
        }
        if (clazz == (class$org$w3c$dom$NodeList == null ? (class$org$w3c$dom$NodeList = NodeSetValue.class$("org.w3c.dom.NodeList")) : class$org$w3c$dom$NodeList)) {
            return 0;
        }
        if (clazz == Boolean.TYPE) {
            return 8;
        }
        if (clazz == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = NodeSetValue.class$("java.lang.Boolean")) : class$java$lang$Boolean)) {
            return 9;
        }
        if (clazz == Byte.TYPE) {
            return 6;
        }
        if (clazz == (class$java$lang$Byte == null ? (class$java$lang$Byte = NodeSetValue.class$("java.lang.Byte")) : class$java$lang$Byte)) {
            return 7;
        }
        if (clazz == Character.TYPE) {
            return 4;
        }
        if (clazz == (class$java$lang$Character == null ? (class$java$lang$Character = NodeSetValue.class$("java.lang.Character")) : class$java$lang$Character)) {
            return 5;
        }
        if (clazz == Double.TYPE) {
            return 6;
        }
        if (clazz == (class$java$lang$Double == null ? (class$java$lang$Double = NodeSetValue.class$("java.lang.Double")) : class$java$lang$Double)) {
            return 7;
        }
        if (clazz == Float.TYPE) {
            return 6;
        }
        if (clazz == (class$java$lang$Float == null ? (class$java$lang$Float = NodeSetValue.class$("java.lang.Float")) : class$java$lang$Float)) {
            return 7;
        }
        if (clazz == Integer.TYPE) {
            return 6;
        }
        if (clazz == (class$java$lang$Integer == null ? (class$java$lang$Integer = NodeSetValue.class$("java.lang.Integer")) : class$java$lang$Integer)) {
            return 7;
        }
        if (clazz == Long.TYPE) {
            return 6;
        }
        if (clazz == (class$java$lang$Long == null ? (class$java$lang$Long = NodeSetValue.class$("java.lang.Long")) : class$java$lang$Long)) {
            return 7;
        }
        if (clazz == Short.TYPE) {
            return 6;
        }
        if (clazz == (class$java$lang$Short == null ? (class$java$lang$Short = NodeSetValue.class$("java.lang.Short")) : class$java$lang$Short)) {
            return 7;
        }
        if (clazz == (class$java$lang$String == null ? (class$java$lang$String = NodeSetValue.class$("java.lang.String")) : class$java$lang$String)) {
            return 2;
        }
        if (clazz == (class$java$lang$Object == null ? (class$java$lang$Object = NodeSetValue.class$("java.lang.Object")) : class$java$lang$Object)) {
            return 3;
        }
        if (clazz == (class$org$w3c$dom$Node == null ? (class$org$w3c$dom$Node = NodeSetValue.class$("org.w3c.dom.Node")) : class$org$w3c$dom$Node)) {
            return 1;
        }
        if (clazz == (class$org$w3c$dom$Element == null ? (class$org$w3c$dom$Element = NodeSetValue.class$("org.w3c.dom.Element")) : class$org$w3c$dom$Element)) {
            return 1;
        }
        if (clazz == (class$org$w3c$dom$Document == null ? (class$org$w3c$dom$Document = NodeSetValue.class$("org.w3c.dom.Document")) : class$org$w3c$dom$Document)) {
            return 1;
        }
        if (clazz == (class$org$w3c$dom$DocumentFragment == null ? (class$org$w3c$dom$DocumentFragment = NodeSetValue.class$("org.w3c.dom.DocumentFragment")) : class$org$w3c$dom$DocumentFragment)) {
            return 1;
        }
        if (clazz == (class$org$w3c$dom$Attr == null ? (class$org$w3c$dom$Attr = NodeSetValue.class$("org.w3c.dom.Attr")) : class$org$w3c$dom$Attr)) {
            return 1;
        }
        if (clazz == (class$org$w3c$dom$Comment == null ? (class$org$w3c$dom$Comment = NodeSetValue.class$("org.w3c.dom.Comment")) : class$org$w3c$dom$Comment)) {
            return 1;
        }
        if (clazz == (class$org$w3c$dom$Text == null ? (class$org$w3c$dom$Text = NodeSetValue.class$("org.w3c.dom.Text")) : class$org$w3c$dom$Text)) {
            return 1;
        }
        if (clazz == (class$org$w3c$dom$CharacterData == null ? (class$org$w3c$dom$CharacterData = NodeSetValue.class$("org.w3c.dom.CharacterData")) : class$org$w3c$dom$CharacterData)) {
            return 1;
        }
        if (clazz == (class$org$w3c$dom$ProcessingInstruction == null ? (class$org$w3c$dom$ProcessingInstruction = NodeSetValue.class$("org.w3c.dom.ProcessingInstruction")) : class$org$w3c$dom$ProcessingInstruction)) {
            return 1;
        }
        return Integer.MAX_VALUE;
    }

    public Object convertToJava(Class clazz) throws XPathException {
        if (clazz.isAssignableFrom(this.getClass())) {
            return this;
        }
        if (clazz == (class$com$icl$saxon$om$NodeEnumeration == null ? (class$com$icl$saxon$om$NodeEnumeration = NodeSetValue.class$("com.icl.saxon.om.NodeEnumeration")) : class$com$icl$saxon$om$NodeEnumeration)) {
            return this.enumerate();
        }
        if (clazz == Boolean.TYPE) {
            return new Boolean(this.asBoolean());
        }
        if (clazz == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = NodeSetValue.class$("java.lang.Boolean")) : class$java$lang$Boolean)) {
            return new Boolean(this.asBoolean());
        }
        if (clazz == (class$java$lang$Object == null ? (class$java$lang$Object = NodeSetValue.class$("java.lang.Object")) : class$java$lang$Object) || clazz == (class$org$w3c$dom$NodeList == null ? (class$org$w3c$dom$NodeList = NodeSetValue.class$("org.w3c.dom.NodeList")) : class$org$w3c$dom$NodeList)) {
            if (this instanceof NodeList) {
                return this;
            }
            return new NodeSetExtent(this.enumerate(), (NodeOrderComparer)new LocalOrderComparer());
        }
        if (clazz == (class$org$w3c$dom$Node == null ? (class$org$w3c$dom$Node = NodeSetValue.class$("org.w3c.dom.Node")) : class$org$w3c$dom$Node)) {
            NodeInfo nodeInfo = this.getFirst();
            return nodeInfo;
        }
        if (clazz == (class$org$w3c$dom$Attr == null ? (class$org$w3c$dom$Attr = NodeSetValue.class$("org.w3c.dom.Attr")) : class$org$w3c$dom$Attr)) {
            NodeInfo nodeInfo = this.getFirst();
            if (nodeInfo == null) {
                return null;
            }
            if (nodeInfo.getNodeType() == 2) {
                return nodeInfo;
            }
            throw new XPathException("Node is of wrong type");
        }
        if (clazz == (class$org$w3c$dom$CharacterData == null ? (class$org$w3c$dom$CharacterData = NodeSetValue.class$("org.w3c.dom.CharacterData")) : class$org$w3c$dom$CharacterData) || clazz == (class$org$w3c$dom$Text == null ? (class$org$w3c$dom$Text = NodeSetValue.class$("org.w3c.dom.Text")) : class$org$w3c$dom$Text)) {
            NodeInfo nodeInfo = this.getFirst();
            if (nodeInfo == null) {
                return null;
            }
            if (nodeInfo.getNodeType() == 3) {
                return nodeInfo;
            }
            throw new XPathException("Node is of wrong type");
        }
        if (clazz == (class$org$w3c$dom$Comment == null ? (class$org$w3c$dom$Comment = NodeSetValue.class$("org.w3c.dom.Comment")) : class$org$w3c$dom$Comment)) {
            NodeInfo nodeInfo = this.getFirst();
            if (nodeInfo == null) {
                return null;
            }
            if (nodeInfo.getNodeType() == 8) {
                return nodeInfo;
            }
            throw new XPathException("Node is of wrong type");
        }
        if (clazz == (class$org$w3c$dom$Document == null ? (class$org$w3c$dom$Document = NodeSetValue.class$("org.w3c.dom.Document")) : class$org$w3c$dom$Document)) {
            NodeInfo nodeInfo = this.getFirst();
            if (nodeInfo == null) {
                return null;
            }
            if (nodeInfo.getNodeType() == 9) {
                return nodeInfo;
            }
            throw new XPathException("Node is of wrong type");
        }
        if (clazz == (class$org$w3c$dom$Element == null ? (class$org$w3c$dom$Element = NodeSetValue.class$("org.w3c.dom.Element")) : class$org$w3c$dom$Element)) {
            NodeInfo nodeInfo = this.getFirst();
            if (nodeInfo == null) {
                return null;
            }
            if (nodeInfo.getNodeType() == 1) {
                return nodeInfo;
            }
            throw new XPathException("Node is of wrong type");
        }
        if (clazz == (class$org$w3c$dom$ProcessingInstruction == null ? (class$org$w3c$dom$ProcessingInstruction = NodeSetValue.class$("org.w3c.dom.ProcessingInstruction")) : class$org$w3c$dom$ProcessingInstruction)) {
            NodeInfo nodeInfo = this.getFirst();
            if (nodeInfo == null) {
                return null;
            }
            if (nodeInfo.getNodeType() == 7) {
                return nodeInfo;
            }
            throw new XPathException("Node is of wrong type");
        }
        if (clazz == (class$java$lang$String == null ? (class$java$lang$String = NodeSetValue.class$("java.lang.String")) : class$java$lang$String)) {
            return this.asString();
        }
        if (clazz == Double.TYPE) {
            return new Double(this.asNumber());
        }
        if (clazz == (class$java$lang$Double == null ? (class$java$lang$Double = NodeSetValue.class$("java.lang.Double")) : class$java$lang$Double)) {
            return new Double(this.asNumber());
        }
        if (clazz == Float.TYPE) {
            return new Float(this.asNumber());
        }
        if (clazz == (class$java$lang$Float == null ? (class$java$lang$Float = NodeSetValue.class$("java.lang.Float")) : class$java$lang$Float)) {
            return new Float(this.asNumber());
        }
        if (clazz == Long.TYPE) {
            return new Long((long)this.asNumber());
        }
        if (clazz == (class$java$lang$Long == null ? (class$java$lang$Long = NodeSetValue.class$("java.lang.Long")) : class$java$lang$Long)) {
            return new Long((long)this.asNumber());
        }
        if (clazz == Integer.TYPE) {
            return new Integer((int)this.asNumber());
        }
        if (clazz == (class$java$lang$Integer == null ? (class$java$lang$Integer = NodeSetValue.class$("java.lang.Integer")) : class$java$lang$Integer)) {
            return new Integer((int)this.asNumber());
        }
        if (clazz == Short.TYPE) {
            return new Short((short)this.asNumber());
        }
        if (clazz == (class$java$lang$Short == null ? (class$java$lang$Short = NodeSetValue.class$("java.lang.Short")) : class$java$lang$Short)) {
            return new Short((short)this.asNumber());
        }
        if (clazz == Byte.TYPE) {
            return new Byte((byte)this.asNumber());
        }
        if (clazz == (class$java$lang$Byte == null ? (class$java$lang$Byte = NodeSetValue.class$("java.lang.Byte")) : class$java$lang$Byte)) {
            return new Byte((byte)this.asNumber());
        }
        if (clazz == Character.TYPE || clazz == (class$java$lang$Character == null ? (class$java$lang$Character = NodeSetValue.class$("java.lang.Character")) : class$java$lang$Character)) {
            String string = this.asString();
            if (string.length() == 1) {
                return new Character(string.charAt(0));
            }
            throw new XPathException("Cannot convert string to Java char unless length is 1");
        }
        throw new XPathException("Conversion of node-set to " + clazz.getName() + " is not supported");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

