/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.expr;

import com.icl.saxon.Context;
import com.icl.saxon.expr.Expression;
import com.icl.saxon.expr.FilterEnumerator;
import com.icl.saxon.expr.IsLastExpression;
import com.icl.saxon.expr.NumericValue;
import com.icl.saxon.expr.Value;
import com.icl.saxon.expr.XPathException;
import com.icl.saxon.functions.Last;
import com.icl.saxon.om.NodeEnumeration;
import com.icl.saxon.om.NodeInfo;
import com.icl.saxon.pattern.NodeTest;

public final class Step {
    private byte axis;
    private NodeTest test;
    private Expression[] filters = new Expression[3];
    private int numberOfFilters = 0;

    public Step(byte by, NodeTest nodeTest) {
        this.axis = by;
        this.test = nodeTest;
    }

    public Step addFilter(Expression expression) {
        if (this.numberOfFilters == this.filters.length) {
            Expression[] expressionArray = new Expression[this.numberOfFilters * 2];
            System.arraycopy(this.filters, 0, expressionArray, 0, this.numberOfFilters);
            this.filters = expressionArray;
        }
        this.filters[this.numberOfFilters++] = expression;
        return this;
    }

    public void setFilters(Expression[] expressionArray, int n) {
        this.filters = expressionArray;
        this.numberOfFilters = n;
    }

    public byte getAxis() {
        return this.axis;
    }

    public NodeTest getNodeTest() {
        return this.test;
    }

    public Expression[] getFilters() {
        return this.filters;
    }

    public int getNumberOfFilters() {
        return this.numberOfFilters;
    }

    public Step simplify() throws XPathException {
        int n = this.numberOfFilters - 1;
        while (n >= 0) {
            Expression expression;
            this.filters[n] = expression = this.filters[n].simplify();
            if (expression instanceof Value && !(expression instanceof NumericValue)) {
                if (((Value)expression).asBoolean()) {
                    if (n == this.numberOfFilters - 1) {
                        --this.numberOfFilters;
                    }
                } else {
                    return null;
                }
            }
            if (expression instanceof Last) {
                this.filters[1] = new IsLastExpression(true);
            }
            --n;
        }
        return this;
    }

    public NodeEnumeration enumerate(NodeInfo nodeInfo, Context context) throws XPathException {
        NodeEnumeration nodeEnumeration = nodeInfo.getEnumeration(this.axis, this.test);
        if (nodeEnumeration.hasMoreElements()) {
            int n = 0;
            while (n < this.numberOfFilters) {
                nodeEnumeration = new FilterEnumerator(nodeEnumeration, this.filters[n], context, false);
                ++n;
            }
        }
        return nodeEnumeration;
    }
}

