/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.style;

import com.icl.saxon.Binding;
import com.icl.saxon.Loader;
import com.icl.saxon.expr.ExpressionParser;
import com.icl.saxon.expr.Function;
import com.icl.saxon.expr.FunctionProxy;
import com.icl.saxon.expr.StaticContext;
import com.icl.saxon.expr.XPathException;
import com.icl.saxon.om.Name;
import com.icl.saxon.om.NamePool;
import com.icl.saxon.om.NamespaceException;
import com.icl.saxon.pattern.NameTest;
import com.icl.saxon.pattern.NamespaceTest;
import com.icl.saxon.style.StyleElement;
import com.icl.saxon.style.XSLKey;
import com.icl.saxon.style.XSLStyleSheet;
import javax.xml.transform.TransformerException;

public class ExpressionContext
implements StaticContext {
    private StyleElement element;
    private NamePool namePool;
    static /* synthetic */ Class class$com$icl$saxon$functions$Extensions;
    static /* synthetic */ Class class$com$icl$saxon$exslt$Common;
    static /* synthetic */ Class class$com$icl$saxon$exslt$Sets;
    static /* synthetic */ Class class$com$icl$saxon$exslt$Math;
    static /* synthetic */ Class class$com$icl$saxon$exslt$Date;

    public ExpressionContext(StyleElement styleElement) {
        this.element = styleElement;
        this.namePool = styleElement.getNamePool();
    }

    public StaticContext makeRuntimeContext(NamePool namePool) {
        ExpressionContext expressionContext = new ExpressionContext(this.element);
        expressionContext.namePool = namePool;
        return expressionContext;
    }

    public String getSystemId() {
        return this.element.getSystemId();
    }

    public int getLineNumber() {
        return this.element.getLineNumber();
    }

    public String getBaseURI() {
        return this.element.getBaseURI();
    }

    public String getURIForPrefix(String string) throws XPathException {
        try {
            short s = this.element.getURICodeForPrefix(string);
            return this.namePool.getURIFromURICode(s);
        }
        catch (NamespaceException namespaceException) {
            throw new XPathException(namespaceException.getMessage());
        }
    }

    public final int makeNameCode(String string, boolean bl) throws XPathException {
        String string2 = Name.getPrefix(string);
        try {
            if (string2.equals("")) {
                short s = 0;
                if (!Name.isNCName(string)) {
                    throw new XPathException("Name " + string + " contains invalid characters");
                }
                if (bl) {
                    s = this.element.getURICodeForPrefix(string2);
                }
                return this.namePool.allocate(string2, s, string);
            }
            String string3 = Name.getLocalName(string);
            short s = this.element.getURICodeForPrefix(string2);
            return this.namePool.allocate(string2, s, string3);
        }
        catch (NamespaceException namespaceException) {
            throw new XPathException("Namespace prefix " + string2 + " has not been declared");
        }
    }

    public int getFingerprint(String string, boolean bl) throws XPathException {
        String string2 = Name.getPrefix(string);
        if (string2.equals("")) {
            String string3 = "";
            if (bl) {
                string3 = this.getURIForPrefix(string2);
            }
            return this.namePool.getFingerprint(string3, string);
        }
        String string4 = Name.getLocalName(string);
        String string5 = this.getURIForPrefix(string2);
        return this.namePool.getFingerprint(string5, string4);
    }

    public NameTest makeNameTest(short s, String string, boolean bl) throws XPathException {
        int n = this.makeNameCode(string, bl);
        return new NameTest(s, n);
    }

    public NamespaceTest makeNamespaceTest(short s, String string) throws XPathException {
        try {
            short s2 = this.element.getURICodeForPrefix(string);
            return new NamespaceTest(this.namePool, s, s2);
        }
        catch (NamespaceException namespaceException) {
            throw new XPathException(namespaceException.getMessage());
        }
    }

    public Binding bindVariable(int n) throws XPathException {
        return this.element.bindVariable(n);
    }

    public boolean isExtensionNamespace(short s) throws XPathException {
        return this.element.isExtensionNamespace(s);
    }

    public boolean forwardsCompatibleModeIsEnabled() throws XPathException {
        return this.element.forwardsCompatibleModeIsEnabled();
    }

    public Function getStyleSheetFunction(int n) throws XPathException {
        return this.element.getStyleSheetFunction(n);
    }

    public Class getExternalJavaClass(String string) throws TransformerException {
        XSLStyleSheet xSLStyleSheet = this.element.getPrincipalStyleSheet();
        Class clazz = xSLStyleSheet.getExternalJavaClass(string);
        if (clazz != null) {
            return clazz;
        }
        if (string.equals("http://icl.com/saxon")) {
            return class$com$icl$saxon$functions$Extensions == null ? (class$com$icl$saxon$functions$Extensions = ExpressionContext.class$("com.icl.saxon.functions.Extensions")) : class$com$icl$saxon$functions$Extensions;
        }
        if (string.equals("http://exslt.org/common")) {
            return class$com$icl$saxon$exslt$Common == null ? (class$com$icl$saxon$exslt$Common = ExpressionContext.class$("com.icl.saxon.exslt.Common")) : class$com$icl$saxon$exslt$Common;
        }
        if (string.equals("http://exslt.org/sets")) {
            return class$com$icl$saxon$exslt$Sets == null ? (class$com$icl$saxon$exslt$Sets = ExpressionContext.class$("com.icl.saxon.exslt.Sets")) : class$com$icl$saxon$exslt$Sets;
        }
        if (string.equals("http://exslt.org/math")) {
            return class$com$icl$saxon$exslt$Math == null ? (class$com$icl$saxon$exslt$Math = ExpressionContext.class$("com.icl.saxon.exslt.Math")) : class$com$icl$saxon$exslt$Math;
        }
        if (string.equals("http://exslt.org/dates-and-times")) {
            return class$com$icl$saxon$exslt$Date == null ? (class$com$icl$saxon$exslt$Date = ExpressionContext.class$("com.icl.saxon.exslt.Date")) : class$com$icl$saxon$exslt$Date;
        }
        try {
            if (string.startsWith("java:")) {
                return Loader.getClass(string.substring(5));
            }
            int n = string.lastIndexOf(47);
            if (n < 0) {
                return Loader.getClass(string);
            }
            if (n == string.length() - 1) {
                return null;
            }
            return Loader.getClass(string.substring(n + 1));
        }
        catch (TransformerException transformerException) {
            return null;
        }
    }

    public boolean isElementAvailable(String string) throws XPathException {
        if (!Name.isQName(string)) {
            throw new XPathException("Invalid QName: " + string);
        }
        String string2 = Name.getPrefix(string);
        String string3 = Name.getLocalName(string);
        String string4 = this.getURIForPrefix(string2);
        return this.element.getPreparedStyleSheet().getStyleNodeFactory().isElementAvailable(string4, string3);
    }

    public boolean isFunctionAvailable(String string) throws XPathException {
        if (!Name.isQName(string)) {
            throw new XPathException("Invalid QName: " + string);
        }
        String string2 = Name.getPrefix(string);
        String string3 = this.getURIForPrefix(string2);
        try {
            Object object;
            if (string2.equals("")) {
                return ExpressionParser.makeSystemFunction(string) != null;
            }
            int n = this.getFingerprint(string, false);
            if (n >= 0 && (object = this.getStyleSheetFunction(n)) != null) {
                return true;
            }
            object = this.getExternalJavaClass(string3);
            if (object == null) {
                return false;
            }
            String string4 = Name.getLocalName(string);
            FunctionProxy functionProxy = new FunctionProxy();
            return functionProxy.setFunctionName((Class)object, string4);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean allowsKeyFunction() {
        return !(this.element instanceof XSLKey);
    }

    public String getVersion() {
        return this.element.getVersion();
    }

    public String toString() {
        return "Expression Context at " + this.element.toString();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

