package com.foo;

import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.*;
import org.aspectj.lang.annotation.Aspect;

@Aspect
public class TestAspect
{
    private TestDep    dep    = new TestDep();

    @Pointcut("execution(@com.foo.ProfiledMethod * *(..))")
    public void profiledMethodPointcut() {
    }

    @Around("execution(@com.foo.ProfiledMethod * *(..))")
    public Object profileMe(ProceedingJoinPoint thisJoinPoint) throws Throwable
    {
        // XXX: causes (BCException) malformed org.aspectj.weaver.EffectiveSignature attribute
//        return dep.invoke(thisJoinPoint);

        // XXX: causes NegativeArraySizeException
        return thisJoinPoint.proceed();
    }
}
