#include <openssl/aes.h>
#include <stdio.h>

unsigned char indata[AES_BLOCK_SIZE]={0};
unsigned char outdata[AES_BLOCK_SIZE]={0};

int encrypt(char *infile,char *outfile,char *key)
{
   FILE *infp, *outfp;
   int bytes_read,bytes_written;
   int total_bytes_read,total_bytes_written;

   /* data structure that contains the key itself */
   AES_KEY aes_key;
   /* set the encryption key */
   AES_set_encrypt_key((const unsigned char *)key, 128, &aes_key);

   if((infp = fopen(infile, "rb"))==NULL)
   {
          fprintf(stdout,"fail to open %s for reading\n",infile);
          return -1;
   }

   if((outfp = fopen(outfile,"wb"))==NULL)
   {
          fprintf(stdout,"fail to open %s for writing\n",outfile);
          return -1;
   }

   total_bytes_read=total_bytes_written=0;

   while((bytes_read=fread(indata,1,AES_BLOCK_SIZE,infp))>0)
   {
      total_bytes_read+=bytes_read;

      if(bytes_read < AES_BLOCK_SIZE)
      {
           bytes_written = fwrite(indata, 1, bytes_read, outfp);
           total_bytes_written+=bytes_written;
           break;
      }
      else
      {
           AES_ecb_encrypt(indata, outdata, &aes_key, AES_ENCRYPT);
           bytes_written = fwrite(outdata, 1, bytes_read, outfp);
           total_bytes_written+=bytes_written;
      }
   }

   fclose(infp);
   fclose(outfp);

   if(total_bytes_read==total_bytes_written)
        return 0;
   else
        return -1;
}


int decrypt(char *infile,char *outfile,char *key)
{
   FILE *infp, *outfp;
   int bytes_read,bytes_written;
   int total_bytes_read,total_bytes_written;

   /* data structure that contains the key itself */
   AES_KEY aes_key;
   /* set the encryption key */
   AES_set_decrypt_key((const unsigned char *)key, 128, &aes_key);

   if((infp = fopen(infile, "rb"))==NULL)
   {
          fprintf(stdout,"fail to open %s for reading\n",infile);
          return -1;
   }

   if((outfp = fopen(outfile,"wb"))==NULL)
   {
          fprintf(stdout,"fail to open %s for writing\n",outfile);
          return -1;
   }

   total_bytes_read=total_bytes_written=0;

   while((bytes_read=fread(indata,1,AES_BLOCK_SIZE,infp))>0)
   {
      total_bytes_read+=bytes_read;

      if(bytes_read < AES_BLOCK_SIZE)
      {
           bytes_written = fwrite(indata, 1, bytes_read, outfp);
           total_bytes_written+=bytes_written;
           break;
      }
      else
      {
           AES_ecb_encrypt(indata, outdata, &aes_key, AES_DECRYPT);
           bytes_written = fwrite(outdata, 1, bytes_read, outfp);
           total_bytes_written+=bytes_written;
      }
   }

   fclose(infp);
   fclose(outfp);

   if(total_bytes_read==total_bytes_written)
        return 0;
   else
        return -1;
}

#if defined(STAND_ALONE)
#define KEY_VALUE  "7648975389400340"

void main(int argc, const char *const *argv)
{
    if(argc<3)
    {
          printf("argc:%d\n",argc);
          exit(0);
    }
    printf("infile:%s outfile:%s\n",argv[1],argv[2]);

    if(encrypt(argv[1],argv[2],KEY_VALUE))
        printf("decrypt failure\n");
}
#endif
