/*
 * ------  Backup & Restore Daemon Patch history  ------
 *
 * Multiple account list patch (Ver 1.0) : 2012.09.26    byungjung.jang
 * Log path change patch(Ver 1.0) : 2012.09.26    byungjung.jang
 * File Permission issue patch (V 1.0) : 2012.09.26    byungjung.jang
 *
 */


#include <stdio.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <string.h>
#include <sys/mount.h>
#include <stdlib.h>
#include <errno.h>
#include <fcntl.h>
#include <sys/stat.h>
#include <signal.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <time.h>
#include <dirent.h>
#include <unistd.h>
#include <pthread.h>
#include <sys/wait.h>
#include <ctype.h>
// inho.kang add reboot lib.
#include <sys/reboot.h>
#include <linux/input.h>

#include "br_errno.h"
#include "list.h"

//#define REMOVE_WHOLE_DATA_DIR // please comment out this line later
//#define SPLIT_TEST            // please comment out this line later

#if defined(UI_IMAGE)
#define BACKUP_ICON 0
#define RESTORE_ICON 1
#define BACKUP_ICON_CS 2 //inho.kang@lge.com 2011.12.27 : add for a Backup Image of C/S Mode
extern "C" void ui_set_background(int icon);
extern "C" void ui_init();
#endif

#define DEC_BUILD

#define WORKING_DIR "/temp/"
#define HIDDEN_DIR  "/temp/hidden/"
#define MAX_PATH_LENGTH 1024

#define PORT 0x1234

#define CONFIG_FILE "/temp/configure" //inho.kang@lge.com : get configure from pc app

#define REMOVAL_KEYWORD      "REMOVAL:"
#define EXCLUDE_GZIP         "EX_GZIP:"
#define EXCLUDE_BACKUP       "EX_BACKUP:"
#define EXCLUDE_ENCRYPTION   "EX_ENCRYPTION:"
#define LIMIT                "LIMIT:"
#define ACCOUNT_INFO            "ACCOUNT_INFO:"

#define SPLIT_FILE_EXT         ".split"
#define LAST_SPLIT_FILE_EXT    ".splitlast"

#define BACKUP_INFO_FILENAME   "/temp/backup_info"
#define BRD_READY_FILENAME     "/temp/brd_ready"

#define BRD_INIT                "brd_init"
#define BRD_INIT_S                "brd_init_s" //inho.kang@lge.com add for C/S Backup
/* back notification from pc */
#define START_BACKUP            "/temp/start_backup"
/* inho.kang@lge.com 2001.10.11 : including internal sdcard data backup */
#define START_BACKUP_SDCARD_FULL "/temp/start_backup_sdcard_full"

#define BACKUP_COMPLETE_CONFIRM "/temp/end_backup"
#define RESTORE_COMPLETE_CONFIRM "/temp/end_restore" //inho.kang@lge.com add RESTORE CONFIRM 2011.10.11

/* restore notification from pc */
#define START_RESTORE "/temp/start_restore"

#define START_SHORT_BACKUP  "/temp/start_short_backup"
#define START_SHORT_RESTORE "/temp/start_short_restore"

/* filename for  */
#define COMPLETE_NOTI_FILE_EXT "_complete"
#define ENCRYPTION_FILE_EXT    ".enc"
#define GZIP_FILE_EXT          ".gz"
#define BACKUP_INFO_FILENAME   "/temp/backup_info"
#define BACKUP_LAST_FILENAME   "/temp/end_of_backup"
#define RESTORE_LAST_FILENAME  "/temp/end_of_restore"
#define ERROR_FILENAME         "/temp/error"
#define LAST_RESTORE_FILENAME  "/temp/last_restore_file"
#define WORKING_DIRECTORY      "/temp/"
#define DATA_DIRECTORY         "/data"
#define READY_FILENAME         "/temp/READY"
#define BACKUP_CANCEL_FILENAME "/temp/backup_cancel"
#define FILE_LISTUP_FILENAME   "filenames" /* please encrypt it */

#define SDCARD_FILE_NAME         "/data/media"

#define LOG_TMP        "/temp/br_daemon.log"
#define LOG_DATA    "/data/br_daemon.log"

#define GZIP_COMP_RATIO      6/10
#define MAX_CMD_LINE_LEN     8192
#define MAX_PATH_LEN         8192
#define MAX_FILE_LEN         8192

#define MAX_SPLIT_BUFFER    10000 /* 10 Kbytes. Please increase this value if file split operation takes too much time. */

#define MEMORY_MARGIN       104857600 /* 100M bytes */

#define KEY_LEN   16
#define SHORT_KEY_LEN 4 /* encryption key for service center */

#define FALSE 0
#define TRUE 1

#define MINIMUM_VALUE 1000000 /* 1M bytes */
#define MINIMUM_VALUE_CS_SDCARD 50000000 /* 50M byte */ // inho.kang temp 1107
////////////////////////////////////////////////////////////////////////////
// Please look for header file for below two definitions in android platform
// and replace it with below lines later
#define SHELL_ID 2000
#define ROOT_ID 0

int mode=-1;
#define INVALID_MODE -1
#define BACKUP_MODE  1
#define RESTORE_MODE 2
#define SHORT_RESTORE_MODE 3

#define LOG_MSG

#if defined(LOG_MSG)
FILE *log = NULL;
#define LOG(...)    fprintf(log, __VA_ARGS__); \
    fflush(log);
#else LOG(...)
#endif


char **removal_list;
int  removal_num=0;

char **ex_gzip_list;
int ex_gzip_num=0;

char **ex_backup_list;
int ex_backup_num=0;

char **except_list;

char *backup_item[] = {
        "/data/app",
        "/data/app-private",
        "/data/system",
        "/data/data"
};

long long file_limit=0;
long long total_transfer=0;

int ext_num=0; /* the number of backup file. It starts from 0 and represents the extension of backup files. */
char backup_filename[MAX_PATH_LENGTH];

int usableMemSize;

char key[KEY_LEN+1];        // encrypt/dectypt  Ǵ key
char hw_key[KEY_LEN+1];    // account


#define TIME_LOG
#if defined(TIME_LOG)
long encryption_time=0;
long decryption_time=0;
long compression_time=0;
long uncompression_time=0;
long tar_time=0;
long untar_time=0;
long split_time=0;
long merge_time=0;
long checkfile_time=0;
#endif

/*test start*/
char *dir_item[100];
long check_dir_time[100];
long check_real_time[100];
/*test end*/


List *backup_list;
List *restore_list;


int ready_file_num=0;

char *log_path;
pthread_mutex_t sync_mutex = PTHREAD_MUTEX_INITIALIZER;
pthread_cond_t  sync_cond  = PTHREAD_COND_INITIALIZER;

int CopyFile(FILE *fp_in,FILE *fp_out,int limit);
//int dirwalk(char *dir,char **list,int list_num); /* kalen.lee@lge.com 2011.11.21 replace int with long long */
long long dirwalk(char *dir,char **list,int list_num);
int checkMemFree();
void generate_key(char *key_in);
int split_file(char *filename,int info_only_flag,FILE *info, int limit,int gzip_flag,int no_encryption_flag);
void emulator(char *string);
int rm_directory(char *dir);


extern "C" int encrypt(char *infile,char *outfile,char *key);
extern "C" int decrypt(char *infile,char *outfile,char *key);
extern "C" char *getfirmware();
extern "C" char* propertyget(const char *name);
extern "C" int read_hw_key(char *keyout);


/*
 * Multiple account list patch (Ver 1.0) : new function
 *
 * backup mode : As before, just read "settings.txt"
 * restore mode : Read account ID from "ACCOUNT_INFO:xxx" in "/temp/start_restore"
 *
 * @mode : to distinguish backup and restore mode
 *
 */
void ready_key(int mode){

    FILE *fp;
    int exist_account = FALSE;
    char string[100];
    memset(hw_key, 0x00, sizeof(hw_key));

    // Backup mode - read "settings.txt" as before.
    if (mode == BACKUP_MODE) {
        LOG("[ready_key] backup_mode : read file - settings.txt\n");
        read_hw_key(hw_key);
    } //end of backup_mode
    else if (mode == RESTORE_MODE) {
        if ((fp = fopen(START_RESTORE, "rt")) == NULL) /* no directory and files for removal */
        {
            LOG("[ready_key] open fail : /temp/start_restore \n");
            return;
        }

        // Search for ACCOUNT_INFO: in "start_restore" file.
        while (fgets(string, sizeof(string), fp)) {
            if (strlen(string) > strlen(ACCOUNT_INFO) && !strncmp(string, ACCOUNT_INFO, strlen(ACCOUNT_INFO))) /* removal list */
            {
                int i;
                char *account;

                LOG("[ready_key] restore_mode : read file - start_restore\n");
                account = strdup(string + strlen(ACCOUNT_INFO));
                sprintf(hw_key, "%s", account);

                // Remove last character, if it is CR or LF.
                if (hw_key[strlen(hw_key) - 1] == 0x0D || hw_key[strlen(hw_key) - 1] == 0x0A)
                    hw_key[strlen(hw_key) - 1] = 0;

                // Save '0' to remaining digits.
                for (i = strlen(hw_key); i < KEY_LEN; i++)
                    hw_key[i] = '0';

                LOG("[ready_key] account : %s\n", hw_key);
                exist_account = TRUE;
                free(account);
                break;
            }
        } //end of while
        fclose(fp);

        // Restore mode - BUT, there is not "ACCOUNT_INFO:" in "start_restore" file.
        // Just read "settings.txt" as before.
        if (FALSE == exist_account){
            LOG("[ready_key] restore_mode : read file - settings.txt\n");
            read_hw_key(hw_key);
        }
    } //end of restore_mode

    generate_key(hw_key);/* call rand function with key */
}



void generate_brd_ready_file()
{
    FILE *fp;

    if((fp=fopen(BRD_READY_FILENAME,"w"))==NULL)
        return;
    fprintf(fp,"FIRMWARE_VERSION:%s\n",getfirmware());
    fprintf(fp,"TRANSFER:ADB\n");
    fclose(fp);

    //File Permission issue patch (V 1.0)
    if(chmod(BRD_READY_FILENAME, 0644)){
        LOG("[generate_brd_ready_file] permission change error\n");
    }

    LOG("[generate_brd_ready_file] generage_brd_ready_file\n");
}


/* generate file containing contents */
void generate_file(char *filename,char *contents,int len)
{
    FILE *fp;

    LOG("[generate_file] filename: %s, contents:len: %s, len: %d\n",filename, contents, len);
    if((fp=fopen(filename,"a"))==NULL)
        return;

    fwrite(contents,1,len,fp);
    fclose(fp);

    //File Permission issue patch (V 1.0)
    if(chmod(filename, 0644)){
        LOG("[generate_file] permission change error\n");
    }

    LOG("[generate_file] end of generate_file\n");
}

#define MAX_ARGS 20
char *getarg(char *string,char **next)
{
    int i=0;
    int start,end;
    char *retVal=NULL;

    start=0;
    end=-1;
    for(i=0;i<strlen(string) && (isspace(string[i])|| string[i]==' ') ;i++);
    if(i==strlen(string))
        return retVal;

    if(string[i]=='"')
    {
        start=i+1;
        i++;
        for(;i<strlen(string) && string[i]!='"';i++);
        end=i-1;
    }
    else
    {
        start=i;
        for(;i<strlen(string) && !isspace(string[i]);i++);
        end=i-1;
    }
    if(end-start+1>0)
        retVal=strndup(string+start,end-start+1);
    if(string[end+1]=='"')
        *next=string+end+2;
    else
        *next=string+end+1;
    printf("getarg:[%s]\n",retVal);
    return retVal;

}

int runcmd(char *cmd)
{
    char* argv[MAX_ARGS];
    pid_t child_pid;
    int child_status;

    int idx=0;
    char *next;
    char *arg,*ptr;

    ptr=cmd;
    while((arg=getarg(ptr,&next)))
    {
        argv[idx++]=arg;
        ptr=next;
    }
    argv[idx]=NULL;

    int i;
    for(i=0;i<idx;i++)
    {
        LOG("[runcmd] argv[%d]:%s\n",i,argv[i]);
        fflush(log);
    }

    child_pid = fork();

    if(child_pid==-1) /* fork failed */
        return -1;
    if(child_pid == 0) {
        /* This is done by the child process. */
        execv(argv[0], argv);

        /* If execv returns, it must have failed. */
        LOG("[runcmd] Unknown command\n");
        exit(-1);
    }
    else {
        /* This is run by the parent.  Wait for the child
        to terminate. */
        int child_status;
        pid_t tpid = waitpid( child_pid ,&child_status,0);
        if(WIFEXITED(child_status))
        {
            if(WEXITSTATUS(child_status)==0)/* success */
            {
                LOG("[runcmd] child return 0 \n");
                return 0;
            }
            else
            {
                LOG("[runcmd] child return non-zero \n");
                return -1;
            }
        }
        else
        {
            LOG("[runcmd] child died \n");
            return -1;
        }
    }
}

int system_call(char *cmd,int error_num)
{
    int ret = runcmd(cmd);
    if(ret!=0)
    {
        // humm. Should I generate error file here?
        char string[256];
        //sprintf(string,"(%s) return non zero value(%d)",cmd,ret);
        sprintf(string,"%d\n",error_num);
        generate_file(ERROR_FILENAME,string,strlen(string));
        /* please generate error file for tar,openssl,gzip */
        LOG("[system_call] (%s) return non zero value\n",cmd);
        exit(0); /* test code */
    }
    time_t curr_time;
    time(&curr_time);
    LOG("[system_call] system_call: %s time:%ld\n",cmd,curr_time);
    return 0;
}

int get_version_num(char *version)
{
    int i,fw_version=0;
    LOG("[system_call] get_version_num:%s\n",version);
    for(i=0;i<strlen(version);i++)
    {
        if(version[i]=='.') continue;
        if(isdigit(version[i]))
        {
            fw_version=(fw_version)*10+(version[i]-'0');
        }
    }
    LOG("[system_call] fw_version:%d\n",fw_version);
    return fw_version;
}

/*
 * Compare FW ver. between phone and backup data
 * If backup_data ver. > phone ver. , restore should NOT proceed.
 *
 * @version_in : Firmware ver. in backup_data
 */
int version_check(char *version_in)
{
    int fw_version=0,in_version=0;

    fw_version=get_version_num((char *)getfirmware());
    in_version=get_version_num(version_in);
    LOG("[version_check] fw_version:%d in_version:%d\n",fw_version,in_version);
    if(fw_version>0 && in_version>0 && fw_version>=in_version)
    {
        LOG("[version_check] version check ok \n");
        return 1;
    }
    LOG("[version_check] invalid version\n");
    return 0;
}


/*
 * FW version / ENC key / Backup data check
 *
 * @filename : /temp/start_restore or /temp/start_short_restore
 */
int check_version_restore_files(char *filename)
{
    FILE *fp;

    if((fp=fopen(filename,"rb"))==NULL)
    {
        LOG("[check_version_restore_files] get_last_restore_file return null\n");
        char string[256];
        sprintf(string,"%d\n",LAST_RESTORE_FILE_NOT_FOUND);
        //sprintf(string,"cannot open %s",filename);
        generate_file(ERROR_FILENAME,string,strlen(string));
        return -1;
    }
    restore_list = new List("restore_list");

    while(!feof(fp))
    {
        char buffer[255];
        memset(buffer,0x00,sizeof(buffer));
        fgets(buffer,sizeof(buffer),fp);
        if(buffer[strlen(buffer)-1]== 0x0A||    //0x0A - line feed
                buffer[strlen(buffer)-1]==0x0D)    //0x0D - carriage return
            buffer[strlen(buffer)-1]=0x00;
        if(strlen(buffer)==0 || buffer[0]==' ')
            continue;

        fprintf(stdout,"[check_version_restore_files] buffer:%s\n",buffer);

        LOG("[check_version_restore_files] buffer : %s \n", buffer);
        /* start_restore 1st line : FIRMWARE_VERSION: */
        if(!strncmp(buffer,"FIRMWARE_VERSION:",strlen("FIRMWARE_VERSION:")))
        {
            LOG("[check_version_restore_files] getfirmware:%s firmware version:%s\n",getfirmware(), buffer+strlen("FIRMWARE_VERSION:"));
            /* If backup data ver. > phone ver. = restore fail */
            if(!version_check(buffer+strlen("FIRMWARE_VERSION:")))
            {
                char string[32];
                sprintf(string,"%d\n",FIRMWARE_VERSION_MISMATCH);
                generate_file(ERROR_FILENAME,string,strlen(string));
                return -1;
            }
        }
        /* In Service app. */
        else if(!strncmp(buffer,"ENCRYPTION_KEY:",strlen("ENCRYPTION_KEY:")))
        {
        // comment out key log

            LOG("[check_version_restore_files] ENCRYPTION_KEY:%s\n",buffer+strlen("ENCRYPTION_KEY:"));

            memset(key,0x00,sizeof(key));
            int i; // fill up with '0'
            for(i=0;i<SHORT_KEY_LEN;i++)
                key[i]= buffer[strlen("ENCRYPTION_KEY:")+i];
            for(;i<KEY_LEN;i++)
                 key[i]='0';
          // comment out key log

            LOG("[check_version_restore_files] ENCRYPTION_KEY:%s\n",key);
        }
        //Multiple account list patch (Ver 1.0)
        else if(!strncmp(buffer, ACCOUNT_INFO, strlen(ACCOUNT_INFO)))
        {
            continue;
        }
        else
        {
            Node *node = new Node(buffer);
            restore_list->insert(node);
            LOG("[check_version_restore_files] filename:%s\n",buffer);
        }
    } /* end of while */
#if defined(LOG_MSG)
    restore_list->printList();
#endif
    return 0;
}

/* remove spaces at the end of string */
void del_space(char *string)
{
    int i=strlen(string)-1;
    for(;i>0;i--)
        if(!(isspace(string[i])|| string[i]=='\n')) break;

    if(i>0)
        string[i+1]='\0';
    LOG("[del_space] string:(%s)\n",string);
}


/*
 *  Analysis /temp/configure
 */
int readConfig()
{
    FILE *fp;
    int removal_idx=0,ex_gzip_idx=0,ex_backup_idx=0;
    int i, j, idx=0;
    char string[MAX_PATH_LENGTH];

    if((fp=fopen(CONFIG_FILE,"rt"))==NULL) /* no directory and files for removal */
    {
        LOG("[readConfig] cannot open %s\n",CONFIG_FILE);
        return -1;
    }
    /* sem : keyword num  */
    while(fgets(string, MAX_PATH_LENGTH, fp))
    {
        LOG("[readConfig] %s\n",string);
        if(strlen(string)>strlen(REMOVAL_KEYWORD) && !strncmp(string,REMOVAL_KEYWORD,strlen(REMOVAL_KEYWORD)))
            ++removal_num;
        else if(strlen(string)>strlen(EXCLUDE_GZIP) && !strncmp(string,EXCLUDE_GZIP,strlen(EXCLUDE_GZIP)))
            ++ex_gzip_num;
        else if(strlen(string)>strlen(EXCLUDE_BACKUP) && !strncmp(string,EXCLUDE_BACKUP,strlen(EXCLUDE_BACKUP)))
            ++ex_backup_num;
    }
    LOG("[readConfig] removal_num:%d ex_gzip_num:%d ex_backup_num:%d\n",removal_num,ex_gzip_num,ex_backup_num);
    if(fseek(fp,0,SEEK_SET))
    {
        return -1;
    }

    removal_list       = (char **)malloc(sizeof(char *)*removal_num);
    ex_gzip_list       = (char **)malloc(sizeof(char *)*ex_gzip_num);
    ex_backup_list     = (char **)malloc(sizeof(char *)*ex_backup_num);

    /* sem :  迭 Ű ߰ */
    while(fgets(string, MAX_PATH_LENGTH, fp))
    {
        if(strlen(string)>0 && string[0]=='#') /* comment */
            continue;
        if(strlen(string)>strlen(REMOVAL_KEYWORD) && !strncmp(string,REMOVAL_KEYWORD,strlen(REMOVAL_KEYWORD))) /* removal list */
        {
            removal_list[removal_idx] = strdup(string+strlen(REMOVAL_KEYWORD));
            del_space(removal_list[removal_idx]);
            removal_idx++;
            LOG("[readConfig] removal_list[%d]:%s\n",removal_idx-1,removal_list[removal_idx-1]);
        }
        else if(strlen(string)>strlen(EXCLUDE_GZIP) && !strncmp(string,EXCLUDE_GZIP,strlen(EXCLUDE_GZIP))) /* do not gzip list */
        {
            ex_gzip_list[ex_gzip_idx] = strdup(string+strlen(EXCLUDE_GZIP));
            del_space(ex_gzip_list[ex_gzip_idx]);
            ex_gzip_idx++;
            LOG("[readConfig] ex_gzip_list[%d]:%s\n",ex_gzip_idx-1,ex_gzip_list[ex_gzip_idx-1]);
        }
        else if(strlen(string)>strlen(EXCLUDE_BACKUP) && !strncmp(string,EXCLUDE_BACKUP,strlen(EXCLUDE_BACKUP))) /* do not backup list */
        {
            ex_backup_list[ex_backup_idx] = strdup(string+strlen(EXCLUDE_BACKUP));
            del_space(ex_backup_list[ex_backup_idx]);
            ex_backup_idx++;
            LOG("[readConfig] ex_backup_list[%d]:%s\n",ex_backup_idx-1,ex_backup_list[ex_backup_idx-1]);
        }
        else if(strlen(string)>strlen(LIMIT) && !strncmp(string,LIMIT,strlen(LIMIT))) /* limit backup file size */
        {
            file_limit= (long) atoi(string+strlen(LIMIT));
            if(file_limit<MINIMUM_VALUE)
                file_limit = MINIMUM_VALUE;
            LOG("[readConfig] file_limit:%ld \n",file_limit);
        }
    }

    except_list = (char **)malloc(sizeof(char *)*(removal_num+ex_gzip_num+ex_backup_num));

    for(i=0;i<removal_num;i++)
        except_list[idx++]= removal_list[i];

    for(j=0;j<ex_gzip_num;j++)
        except_list[idx++]= ex_gzip_list[j];

    for(j=0;j<ex_backup_num;j++)
        except_list[idx++]= ex_backup_list[j];

    for(i=0; i<idx; i++){
        LOG("[readConfig] except_list %d: %s \n", i+1, except_list[i]);
    }


    fclose(fp);
    return 0;
}

void read_st_info(FILE *fp,unsigned long *uid,unsigned long *gid,unsigned int* mode);
int create_directory(FILE *fp);


/*
 * split file = file info + directory info + file contents
 * file info = file_len + file name + uid + gid + mod
 * directory info = dir_len + directory name + uid + gid + mod
 *
 * @filename : split backup data name
 */
int MergeSplitFile(char* filename)
{
    static char last_merge_file[MAX_PATH_LENGTH];
    char merge_file[MAX_PATH_LENGTH];
    char buffer[MAX_PATH_LEN];
    FILE *fp_in,*fp_out;
    unsigned int len;

   /* read the head info */
    if((fp_in=fopen(filename,"rb"))==NULL)
    {
        LOG("[MergeSplitFile] open %s failure\n",filename);
        return -1;
    }
    /* read 4 bytes */
    fread(buffer,1,4,fp_in);
    buffer[4]='\0';
    /* kalen.lee@lge.com 2011.10.04 */
    char *endptr;
    len=strtoul(buffer,&endptr,10);        //Why should do this?

    if(len==ULONG_MAX)
    {
        LOG("[MergeSplitFile] invalid file len(%s)\n",buffer);
    }

    LOG("[MergeSplitFile] file name len:%s %d \n", buffer,len);
    memset(buffer,0x00,sizeof(buffer));
    if(fread(buffer,1,len,fp_in)<len)
    {
        LOG("[MergeSplitFile] fail to read file name\n");
        return -1;
    }
    strcpy(merge_file,buffer);

    /* kalen.lee@lge.com 2011.10.04 -begin */
    unsigned long uid,gid;
    unsigned int mode;

    read_st_info(fp_in,&uid,&gid,&mode);
    /* kalen.lee@lge.com 2011.10.04 -end */
    LOG("[MergeSplitFile] filename:%s uid:%u gid:%u mode:%u\n",filename,uid,gid,mode);
       /* truncate the existing file */
    if(strlen(last_merge_file)==0 ||(strlen(last_merge_file)>0 && strcmp(last_merge_file,merge_file))) /* new file : strcmp  ڰ  0 return */
    {
        /* kalen.lee@lge.com 2011.09.30-begin */
        if(create_directory(fp_in))
        {
            LOG("[MergeSplitFile] fail to create directory for split files\n");
            return -1;
        }
        /* kalen.lee@lge.com 2011.09.30-end */
        if((fp_out=fopen(merge_file,"w"))==NULL)
        {
            LOG("[MergeSplitFile] fail to open %s for w\n",merge_file);
            return -1;
        }
        LOG("[MergeSplitFile] merge_file:%s\n",merge_file);
        /* copy contents from in to out*/
        CopyFile(fp_in,fp_out,0);
        strcpy(last_merge_file,merge_file);
    }
    else
    {
        /* merge an exsiting file with new piece */
        if((fp_out=fopen(merge_file,"a"))==NULL)
        {
            LOG("[MergeSplitFile] fail to open %s for a\n",merge_file);
            return -1;
        }
        LOG("[MergeSplitFile] merge_file:%s\n",merge_file);
        CopyFile(fp_in,fp_out,0);
    }

    fclose(fp_in);
    fclose(fp_out);

    if(strstr(filename,LAST_SPLIT_FILE_EXT)) /* the last merged file */
    {
        if(chown(merge_file,uid,gid))
        {
            char string[16];
            sprintf(string,"%d\n",CHOWN_FAILURE);
            generate_file(ERROR_FILENAME,string,strlen(string));
        }
        /* kalen.lee@lge.com 2011.10.04 - begin */
        mode=mode&0777;
        if(chmod(merge_file,mode)) /* Humm. Why this doesn't work?  */
        {
            LOG("[MergeSplitFile] error:%s\n",strerror(errno));
            char string[16];
            sprintf(string,"%d\n",MERGE_CHMOD_FAILURE);
            generate_file(ERROR_FILENAME,string,strlen(string));
        }
        /* kalen.lee@lge.com 2011.10.04 - end */
    }

    return 0;
}

void append_exclude(char *command,char *fullname,char **removal_list,int removal_list_num)
{
    int i;
    char *begin;

    for(i=0;i<removal_list_num;i++)
    {
        fprintf(stdout,"[append_exclude] removal_list[i]:%s fullname:%s\n",removal_list[i],fullname);

        if((begin=strstr(removal_list[i],fullname))) /* fullname is part of list[i] */
        {
            if(!strncmp(fullname,removal_list[i],strlen(fullname)) && removal_list[i][strlen(fullname)]=='/')
            {
                strcat(command," --exclude=");
                strcat(command,removal_list[i]);
                LOG("[append_exclude] command:%s\n",command);
            }
        }
    }

    for(i=0;i<ex_backup_num;i++)
    {
        if((begin=strstr(ex_backup_list[i],fullname))) /* fullname is part of list[i] */
        {
            if(!strncmp(fullname,ex_backup_list[i],strlen(fullname)) && ex_backup_list[i][strlen(fullname)]=='/')
            {
                strcat(command," --exclude=");
                strcat(command,ex_backup_list[i]);
                LOG("[append_exclude] command:%s\n",command);
            }
        }
    }
}

/* return 1 if string exists in the list */
int check_except(char **list,int list_num,char *string)
{
    int i,retVal=0;
    for(i=0;i<list_num;i++)
    {
        if(!strcmp(string,list[i]))
        {
            retVal=1;
            break;
        }
    }
    return retVal;
}


/*
 * info_only_flag is
 * TRUE : write backup data name in /temp/backup_info
 * FALSE : TAR
 *
 */
void handle_info (int info_only_flag, FILE *info, int gzip_flag, int no_encryption_flag, char *fullname, char *command, int info_write)
{
#if defined(TIME_LOG)
    time_t time_before,time_after;
#endif

    LOG("[backup] backup_filename : %s \n",backup_filename);

    if(info_only_flag && info_write)/* write down file name */
    {
        if(gzip_flag && no_encryption_flag)
            fprintf(info,"%s%s\n",backup_filename+strlen(HIDDEN_DIR),GZIP_FILE_EXT);
        else if(gzip_flag && !no_encryption_flag)
            fprintf(info,"%s%s%s\n",backup_filename+strlen(HIDDEN_DIR),GZIP_FILE_EXT,ENCRYPTION_FILE_EXT);
        else if(!gzip_flag && !no_encryption_flag)
            fprintf(info,"%s%s\n",backup_filename+strlen(HIDDEN_DIR),ENCRYPTION_FILE_EXT);
        else
            fprintf(info,"%s\n",backup_filename+strlen(HIDDEN_DIR));
        LOG("[backup] write down %s in backup_info\n",backup_filename);
    }
    else if (!info_only_flag)    /* NOT info_onfly_flag */
    {
        sprintf(command,"/sbin/tar -uvf %s \"%s\"",backup_filename,fullname);
        append_exclude(command,fullname,removal_list,removal_num);
        LOG("[backup] command:%s\n",command);
#if defined(TIME_LOG)
        time(&time_before);
#endif
        system_call(command,TAR_FAILURE);
#if defined(TIME_LOG)
        time(&time_after);
        tar_time+=(time_after-time_before);
#endif
    }
}


/*
 * close current backup file
 * process : GZIP, ENC, generate READY
 */
void close_backup_file (int gzip_flag, int no_encryption_flag, char *backup_filename, char *command)
{

#if defined(TIME_LOG)
    time_t time_before,time_after;
#endif

    if(gzip_flag /* && strlen(backup_filename)>0*/)
    {
        sprintf(command,"/sbin/gzip_static %s",backup_filename);
        strcat(backup_filename,GZIP_FILE_EXT);
#if defined(TIME_LOG)
        time(&time_before);
#endif
        system_call(command,GZIP_FAILURE);
#if defined(TIME_LOG)
        time(&time_after);
        compression_time+=(time_after-time_before);
#endif
    }
    char outfilename[MAX_PATH_LENGTH],string[MAX_CMD_LINE_LEN];
    memset(outfilename,0x00,sizeof(outfilename));

    if(no_encryption_flag)
    {
        sprintf(outfilename,"%s%s",WORKING_DIR,backup_filename+strlen(HIDDEN_DIR));
        rename(backup_filename,outfilename);
        //sprintf(string,"mv %s %s",backup_filename,outfilename);
        //system_call(string,MV_FAILURE);
    }
    else
    {
        sprintf(outfilename,"%s%s%s",WORKING_DIR,backup_filename+strlen(HIDDEN_DIR),ENCRYPTION_FILE_EXT);
        //sprintf(string,"/sbin/openssl enc -aes-256-ecb -k %s -in %s -out %s",key,backup_filename,outfilename);
#if defined(TIME_LOG)
        time(&time_before);
#endif
        if(encrypt(backup_filename,outfilename,key))
        {
            char buffer[16];
            sprintf(buffer,"%d\n",ENC_FAILURE);
            generate_file(ERROR_FILENAME,buffer,strlen(buffer));
        }
        //File Permission issue patch (V 1.0)
        if(chmod(outfilename, 0644)){
            LOG("[close_backup_file] permission change error\n");
        }
        //system_call(string,ENC_FAILURE);
#if defined(TIME_LOG)
        time(&time_after);
        encryption_time+=(time_after-time_before);
#endif
        // remove "temp/hidden/backup_%d"
        remove(backup_filename);
        //sprintf(string,"rm %s",backup_filename);
        //system_call(string,RM_FAILURE);
    }

    strcat(outfilename,"\n");

    /* backup_filename : /temp/hidden/backup_%d.tar(.gz)(.enc) */
    /* outfilename : /temp/backup_%d.tar(.gz)(.enc) */
    /* generate "/temp/READY" containing "backup_%d.tar" */
    generate_file(READY_FILENAME,outfilename+strlen(WORKING_DIR),strlen(outfilename)-strlen(WORKING_DIR));
    memset(backup_filename,0x00,sizeof(backup_filename));

    pthread_mutex_lock(&sync_mutex);
    ready_file_num++;

    if(ready_file_num>1)
    {
        LOG("[backup] pthread_cond_wait enter\n");
        pthread_cond_wait(&sync_cond, &sync_mutex);
    }
    pthread_mutex_unlock(&sync_mutex);
    LOG("[backup] pthread_cond_wait exit\n");
}


/* Please make sure that it traverses the whole directory only one time.
 * compute total_transfer and list up backup file names if info_only_flag is 1,
 * generate backup files                                if info_only_flag is 0
 * info must be not null for info_only_flag with 1
 * This function doesn't back up files or directories in removal_list if removal_flag is true
 *
 * @ *name : backup target directory
 * @ info_only_flag : TRUE - just compute total_transfer and list up file names
 *                     FALSE - generate backup files
 * @ *info : file desc.(/temp/backup_info)
 * @ gzip_flag : decide whether or not to GZIP compression
 * @ **list : excluding item in backup
 * @ list_num : the number of **list
 * @ toplevel_flag : TRUE - target directory or file is top of the backup data
 * @ limit : limitations of each backup data
 * @ no_encryption_flag : decide whether or not to encrypt backup data
 *
 *
 */
int backup(char * name,int info_only_flag,FILE *info,int gzip_flag,char **list,int list_num, int toplevel_flag,int limit,int no_encryption_flag)
{
    struct stat file_info;
    char fullname[MAX_PATH_LEN];
    char command[MAX_CMD_LINE_LEN];
    //static int accumul=0;
    static long long accumul=0;    /* kalen.lee@lge.com 2011.11.21 replace int with long */

#if defined(TIME_LOG)
    time_t time_before,time_after;
#endif

    LOG("[backup] backup(%s)\n",name);
    if(toplevel_flag) /* reset accumul. */
        accumul=0;

    if(access(name,F_OK)) /* directory or file does't exist */
        return -1;
    if(lstat(name, &file_info) == -1)
        return -1;

    if((file_info.st_mode & S_IFMT)==S_IFDIR) /* directory */
    {
        DIR *dir_info=NULL;
        struct dirent *dp=NULL;

        if((dir_info = opendir(name))==NULL)
        {
            return -1;
        }
        while ((dp = readdir(dir_info)) != NULL)
        {
            if (strcmp(dp->d_name, ".") == 0
                    || strcmp(dp->d_name, "..") ==0)
                continue;    /* skip self and parent */

            sprintf(fullname, "%s/%s", name, dp->d_name);        //fullname = sub directory(or file) of name(/name/~)

            if(check_except(list,list_num,fullname))
                continue;

            long long dir_size = dirwalk(fullname,list,list_num); /* kalen.lee@lge.com 2011.11.21 */

        //Trash File(negative number size) return patch (Ver 1.0)
        if(dir_size < 0)
        {
            LOG("[backup] There are Problem files in the directory. pass it. \n")
            continue;
        }

            LOG("[backup] fullname:%s dir_size:%lld limit:%d accumul:%lld\n",fullname,dir_size,limit,accumul);
            if(dir_size > limit) /* split a directory or a file into pieces */
            {
                LOG("[backup] split a directory (%s)\n",fullname);
                /* topflag = FALSE */
                backup(fullname,info_only_flag,info,gzip_flag,list,list_num,FALSE,limit,no_encryption_flag);
            }
            else if(dir_size+accumul > limit)
            {
                LOG("[backup] generate new backup file\n");
                /* If not info & already backup file exits, then the backup file close and generate new backup file */
                if(!info_only_flag && strlen(backup_filename)>0){
                    close_backup_file(gzip_flag, no_encryption_flag, backup_filename, command);
                    accumul = 0;
                }
                /* generate new backup file */
                sprintf(backup_filename,"%sbackup_%d.tar",HIDDEN_DIR,ext_num++);

                LOG("[backup] handle_info 1\n");
                fflush(log);
                handle_info(info_only_flag, info, gzip_flag, no_encryption_flag, fullname, command, TRUE);
                accumul=dir_size;
            }
            /* dir_size + accumul <= limit */
            else
            {
                int info_write = FALSE;
                if(strlen(backup_filename)==0)
                {    /* no backup_filename exist */
                    info_write = TRUE;
                    sprintf(backup_filename,"%sbackup_%d.tar",HIDDEN_DIR,ext_num++);
                }
                LOG("[backup] handle_info 2\n");
                fflush(log);
                /* generate new backup file */
                handle_info(info_only_flag, info, gzip_flag, no_encryption_flag, fullname, command, info_write);
                accumul+=dir_size;
            }
            if(gzip_flag)
                total_transfer+=dir_size*GZIP_COMP_RATIO;
              else
                  total_transfer+=dir_size;
            LOG("[backup] go to next dir\n");
        }/* end of while( ) */
        closedir(dir_info);
    } /* end of if(file_info.st_mode & S_IFMT)==S_IFDIR)*/

    else  /* !directory */
    {
        LOG("[backup] file backup\n");
        if(check_except(list,list_num,name))
            return 0;

        struct stat stbuf;
        memset(&stbuf,0x00,sizeof(stbuf));
        if(lstat(name,&stbuf)==-1)
            return -1;
        if(stbuf.st_size>=0)
        {
            LOG("[backup] st_size:%lld limit:%d usableMemSize:%d\n",stbuf.st_size,limit,usableMemSize);
            if(stbuf.st_size > limit/*usableMemSize*/) /* kalen.lee@lge.com 2011.10.07 replace usableMemSize with limit */
            {
                /* close existing backup file if it exists.*/
                if(!info_only_flag && strlen(backup_filename)>0){
                    close_backup_file(gzip_flag, no_encryption_flag, backup_filename, command);
                    //accumul = 0;
                }

                LOG("[backup] call split_file\n");

                time(&time_before);
                /* kalen.lee@lge.com 2011.10.07 replace usableMemSize with limit */
                split_file(name,info_only_flag,info,/*usableMemSize*/limit,gzip_flag,no_encryption_flag); /* regular file. What can I do for non-regular files? */

                time(&time_after);
                split_time += (time_after - time_before);

                LOG("[backup] after split_file\n");
                accumul=0;
                memset(backup_filename,0x00,sizeof(backup_filename));
            }
            else if(stbuf.st_size+accumul>limit)
            {
                if(!info_only_flag && strlen(backup_filename)>0 )
                {
                    close_backup_file(gzip_flag, no_encryption_flag, backup_filename, command);
                    accumul = 0;
                }
                sprintf(backup_filename,"%sbackup_%d.tar",HIDDEN_DIR,ext_num++);
                accumul=stbuf.st_size;
                LOG("[backup] handle_info 3\n");
                handle_info(info_only_flag, info, gzip_flag, no_encryption_flag, fullname, command, TRUE);
            }
            /*  file_size + accumul < limit */
            else
            {
                int info_write = FALSE;
                if(strlen(backup_filename)==0) /* no backup_filename exist */
                {
                    info_write = TRUE;
                    sprintf(backup_filename,"%sbackup_%d.tar",HIDDEN_DIR,ext_num++);
                }
                LOG("[backup] handle_info 4\n");
                accumul+=stbuf.st_size;
                handle_info(info_only_flag, info, gzip_flag, no_encryption_flag, fullname, command, info_write);
            }

            if(gzip_flag)
                total_transfer+=stbuf.st_size*GZIP_COMP_RATIO;
            else
                total_transfer+=stbuf.st_size;
        }
        else /* stbuf.st_size<0. Can it be possible? */
        {
            /* [To-do] What should I do here? */
        }
    } /* end of !directory */

    if(toplevel_flag /* && accumul>0 kalen.lee@lge.com 2011.11.29. fix a bug for directory or file with size=0 */ )/* close the last file */
    {
        LOG("[backup] toplevel_flag check! \n");
        if(!info_only_flag && strlen(backup_filename)>0)
        {
            close_backup_file(gzip_flag, no_encryption_flag, backup_filename, command);
            accumul = 0;
        }
        memset(backup_filename,0x00,sizeof(backup_filename));
    }
    return 0;
}


/* Compute total size of *dir
 *
 * @*dir : target directory to compute total size
 * @**list : excluding directory
 * @list_num : the number of **list
 */
long long dirwalk(char *dir,char **list,int list_num) /* kalen.lee@lge.com 2011.11.21 replace int with long */
{
    char name[MAX_PATH_LEN];
    struct dirent *dp=NULL;
    struct stat stbuf;
    DIR *dfd=NULL;;
    long long dir_size=0; /* kalen.lee@lge.com 2011.11.21 replace int with long */

    if(lstat(dir,&stbuf)==-1)
    {
        LOG("[dirwalk] dirwalk: stat %s failure\n", dir);
        return -1;
    }

    if(stbuf.st_mode & S_IFREG) /* regular file, then computer the file size */
    {
        LOG("[dirwalk] dirwalk returns %lld\n",stbuf.st_size);
        return stbuf.st_size;
    }
    else if((stbuf.st_mode & S_IFMT)!=S_IFDIR)     /* none of regular file and directory */
    {
        return 0;
    }

    if ((dfd = opendir(dir)) == NULL) {            /* dir is directory, open it */
        char string[256];
        sprintf(string,"%d\n",OPEN_DIR_FAILURE);
        generate_file(ERROR_FILENAME,string,strlen(string));
        LOG("[dirwalk] dirwalk: can't open %s\n", dir);
        return -1;
    }
    while ((dp = readdir(dfd)) != NULL) {
        if (strcmp(dp->d_name, ".") == 0
                || strcmp(dp->d_name, "..") ==0)
            continue;
        sprintf(name, "%s/%s", dir, dp->d_name);        //name = sub directory of dir
        if(check_except(list,list_num,name))
            continue;

        if(lstat(name,&stbuf)==-1)
        {
            char string[80];
            LOG("[dirwalk] Can't know file info-0(%s) error(%s)!\n",name,strerror(errno));
            // kalen.lee@lge.com -begin
            // just skip it
            //sprintf(string,"%d\n",STAT_FAILURE);
            //generate_file(ERROR_FILENAME,string,strlen(string));
            // kalen.lee@lge.com -end
            //generate_file(ERROR_FILENAME,"can't know file info",strlen("can't know file info"));
            return -1;
        }
        if((stbuf.st_mode & S_IFMT)==S_IFDIR)
        {
            int ret;
            if((ret=dirwalk(name,list,list_num))==-1)    /* name = directory, Recursive */
            {
                LOG("[dirwalk] dirwalk(%s) error\n",name);
                //return -1; ignore invalid file
            }
            else
                dir_size+=ret;                            /* accumulate sub directories size */
        }
        else if(stbuf.st_mode & S_IFREG) /* regular file */
               dir_size+=stbuf.st_size;                    /* accumulate sub directories size */
       }
    closedir(dfd);

    return dir_size;
}


void read_st_info(FILE *fp,unsigned long *uid,unsigned long *gid,unsigned int* mode)
{
   char buffer[128];

   int sizeof_st_uid,sizeof_st_gid,sizeof_st_mode;
   struct stat stbuf;
   sizeof_st_uid = sizeof(stbuf.st_uid);  /* unsigned long. please refer to android/bionic/libc/include/sys/stat.h */
   sizeof_st_gid = sizeof(stbuf.st_gid);  /* unsigned long. please refer to android/bionic/libc/include/sys/stat.h */
   sizeof_st_mode = sizeof(stbuf.st_mode);/* unsigned int. please refer to android/bionic/libc/include/sys/stat.h */

   if(sizeof_st_uid==4)
   {
        fread(buffer,1,8,fp);
        buffer[8]='\0';
   }
   else if(sizeof_st_uid==8)
   {
        fread(buffer,1,16,fp);
        buffer[16]='\0';
   }
   else if(sizeof_st_uid==16)
   {
        fread(buffer,1,32,fp);
        buffer[32]='\0';
   }
   else if(sizeof_st_uid==32)
   {
        fread(buffer,1,64,fp);
        buffer[64]='\0';
   }
   else
        fprintf(stderr,"[read_st_info] Humm.please add code to handle unsigned long(%d bytes)\n",sizeof_st_uid);

   char *endptr;

   *uid=strtoul(buffer,&endptr,16);        //16->10  ȯ

   if(sizeof_st_gid==4)
   {
        fread(buffer,1,8,fp);
        buffer[8]='\0';
   }
   else if(sizeof_st_gid==8)
   {
        fread(buffer,1,16,fp);
        buffer[16]='\0';
   }
   else if(sizeof_st_gid==16)
   {
        fread(buffer,1,32,fp);
        buffer[32]='\0';
   }
   else if(sizeof_st_gid==32)
   {
        fread(buffer,1,64,fp);
        buffer[64]='\0';
   }
   else
        fprintf(stderr,"[read_st_info] Humm.please add code to handle unsigned long(%d bytes)\n",sizeof_st_gid);

   *gid=strtoul(buffer,&endptr,16);

   if(sizeof_st_mode==4)
   {
        fread(buffer,1,8,fp);
        buffer[8]='\0';
   }
   else if(sizeof_st_mode==8)
   {
        fread(buffer,1,16,fp);
        buffer[16]='\0';
   }
   else if(sizeof_st_mode==16)
   {
        fread(buffer,1,32,fp);
        buffer[32]='\0';
   }
   else if(sizeof_st_mode==32)
   {
        fread(buffer,1,64,fp);
        buffer[64]='\0';
   }
   else
        fprintf(stderr,"[read_st_info] Humm.please add code to handle unsigned long(%d bytes)\n",sizeof_st_mode);

   *mode=strtoul(buffer,&endptr,16);

     LOG("[read_st_info] uid:%u gid:%u mode:%u\n",*uid,*gid,*mode);
}


void save_st_info(struct stat *stbuf,FILE *fp_out)
{
     int sizeof_st_uid = sizeof(stbuf->st_uid);  /* unsigned long. please refer to android/bionic/libc/include/sys/stat.h */
     int sizeof_st_gid = sizeof(stbuf->st_gid);  /* unsigned long. please refer to android/bionic/libc/include/sys/stat.h */
     int sizeof_st_mode = sizeof(stbuf->st_mode);/* unsigned int. please refer to android/bionic/libc/include/sys/stat.h */

     /* write down uid,gid,mode */
     if(sizeof_st_uid==4)
               fprintf(fp_out,"%8x%8x",stbuf->st_uid,stbuf->st_gid);
     else if(sizeof_st_uid==8)
               fprintf(fp_out,"%16x%16x",stbuf->st_uid,stbuf->st_gid);
     else if(sizeof_st_uid==16)
               fprintf(fp_out,"%32x%32x",stbuf->st_uid,stbuf->st_gid);
     else if(sizeof_st_uid==32)
               fprintf(fp_out,"%64x%64x",stbuf->st_uid,stbuf->st_gid);
     else
               fprintf(stderr,"Humm.please add code to handle unsigned long(%d bytes)\n",sizeof_st_uid);
     if(sizeof_st_mode==4)
               fprintf(fp_out,"%8x",stbuf->st_mode);
     else if(sizeof_st_mode==8)
               fprintf(fp_out,"%16x",stbuf->st_mode);
     else if(sizeof_st_mode==16)
               fprintf(fp_out,"%32x",stbuf->st_mode);
     else if(sizeof_st_mode==32)
               fprintf(fp_out,"%64x",stbuf->st_mode);
     else
              fprintf(stderr,"[save_st_info] Humm. please add code to handle unsigned int(%d bytes)\n",sizeof_st_mode);
     LOG("[save_st_info] uid:%u gid:%u mode:%u\n",stbuf->st_uid,stbuf->st_gid,stbuf->st_mode);
}

/*
 * Create a directory by reference to directory information in split file
 *
 */
#define DIR_LEN_NUM 4
int create_directory(FILE *fp)
{
    char buffer[MAX_PATH_LEN];
    int read,len;
    unsigned long uid,gid;
    unsigned int mode;
    char *endptr;

    while(1)
    {
        /* split file  = file info + directory info : տ file  read, ̹ directory info read */
        if((read=fread((void *)buffer,1,DIR_LEN_NUM,fp))!=DIR_LEN_NUM)
            return -1;
        buffer[DIR_LEN_NUM]='\0';
        len=strtoul(buffer,&endptr,10);                                     //convert to a decimal integer
        if(len==0)
        {
            break;
        }
        memset(buffer,0x00,sizeof(buffer));
        if(fread(buffer,1,len,fp)<len)                                        //directory name read
           return -1;
        LOG("[create_directory] directory:%s len:%d\n",buffer,len);
        /* read uid,gid,mode*/
        read_st_info(fp,&uid,&gid,&mode);                                //directory uid, gid, mode read
        if(access(buffer,F_OK)) /* create it */
        {
            if(S_ISDIR(mode))                                                    //mode = directory
            {
                LOG("[create_directory] mkdir %s\n",buffer);
                if(mkdir(buffer,mode))
                {
                    char string[16];
                    sprintf(string,"%d\n",MERGE_DIR_CREATION_FAILURE);
                    generate_file(ERROR_FILENAME,string,strlen(string));
                    return -1;
                }
                if(chown(buffer,uid,gid))
                {
                    char string[16];
                    sprintf(string,"%d\n",MERGE_DIR_CREATION_FAILURE);
                    generate_file(ERROR_FILENAME,string,strlen(string));
                    return -1;
                }
            }
            else if(S_ISLNK(mode))                                            //mode = symbolic link
            {
                char linked[MAX_PATH_LEN];
                int link_len;
                memset(linked,0x00,sizeof(linked));
                if((read=fread((void *)linked,1,DIR_LEN_NUM,fp))!=DIR_LEN_NUM)
                    return -1;
                linked[DIR_LEN_NUM]='\0';
                link_len=strtoul(linked,&endptr,10);
                memset(linked,0x00,sizeof(linked));
                if(fread(linked,1,link_len,fp)<len)
                    return -1;
                LOG("[create_directory] create link %s at %s\n",buffer,linked);
                if(link(linked,buffer))
                {
                    char string[16];
                    sprintf(string,"%d\n",MERGE_DIR_CREATION_FAILURE);
                    generate_file(ERROR_FILENAME,string,strlen(string));
                    return -1;
                }
                if(chown(buffer,uid,gid))
                {
                    char string[16];
                    sprintf(string,"%d\n",MERGE_DIR_CREATION_FAILURE);
                    generate_file(ERROR_FILENAME,string,strlen(string));
                    return -1;
                }
            }/* end of if(S_ISLNK(mode))*/
        }/* if(access(buffer,F_OK)) create it */
    }

    return 0;
}


/* kalen.lee@lge.com 2011.10.04-begin */
/* How can I handle symbolic link? save symbolic link name */
int save_directory_info(char *filename,FILE *fp)
{
    char directory[MAX_PATH_LEN];
    memset(directory,0x00,sizeof(directory));
    struct stat stbuf;
    char *ptr=strstr(filename,"/");
    char *dir_end;

    while(ptr)
    {
      dir_end=strstr(ptr+1,"/");
      if(!dir_end) break;
      /* get directory name */
      strncat(directory,ptr,dir_end-ptr);
      LOG("[save_directory_info] directory:%s\n",directory);
      if(!lstat(directory,&stbuf)) /* success */
      {
         fprintf(fp,"%4u%s",strlen(directory),directory);
         save_st_info(&stbuf,fp);
         if(S_ISLNK(stbuf.st_mode)) /* symbolic link */
         {
            /* save link info */
            char out_buf[MAX_PATH_LEN];
            if(readlink(directory,out_buf,sizeof(out_buf)))
            {
               char string[16];
               sprintf(string,"%d\n",SYMLINK_SAVE_FAILURE);
               generate_file(ERROR_FILENAME,string,strlen(string));
            }
            fprintf(fp,"%4u%s",strlen(out_buf),out_buf);
         }
      }
      ptr=strstr(ptr+1,"/");/* Is it right? */
    }

    fprintf(fp,"%4u",0x00); /* save the last directory info flag */
    return 0; /* Humm. How can I handle error case? */
}



int split_file(char *filename,int info_only_flag,FILE *info, int limit,int gzip_flag,int no_encryption_flag)
{
    FILE *fp_out,*fp_in=NULL;
    //int written=0,read=0,tmp;
    char buffer[MAX_FILE_LEN+12]; /* 12 is enough? */
    //char split_filename[MAX_FILE_LEN];
    struct stat stbuf;
#if defined(TIME_LOG)
    time_t time_before,time_after;
#endif
    LOG("[split_file] split_file(filename:%s gzip_flag:%d)\n",filename,gzip_flag);

    if(lstat(filename,&stbuf)==-1)
        return -1;
    if(!(stbuf.st_mode & S_IFREG))        //S_IFREG : normal file
        return -1;

    long long total = stbuf.st_size;

    if(gzip_flag)
        total_transfer+=stbuf.st_size*GZIP_COMP_RATIO;
    else
        total_transfer+=stbuf.st_size;

    if(!info_only_flag && ((fp_in=fopen(filename,"rb"))==NULL))
    {
        LOG("[split_file] fail to open %s\n",filename);
        return -1;
    }
    LOG("[split_file] fp_in:%ld \n",fp_in);
    while(total>0)
    {
        if(total<limit)
            sprintf(backup_filename,"%sbackup_%d%s",HIDDEN_DIR,ext_num++,LAST_SPLIT_FILE_EXT);
        else
            sprintf(backup_filename,"%sbackup_%d%s",HIDDEN_DIR,ext_num++,SPLIT_FILE_EXT);
        LOG("[split_file] backup_filename:%s\n",backup_filename);
        if(info_only_flag)/* write down file name */
           {
            if(gzip_flag && no_encryption_flag)
                fprintf(info,"%s%s\n",backup_filename+strlen(HIDDEN_DIR),GZIP_FILE_EXT);
            else if(gzip_flag && !no_encryption_flag)
                fprintf(info,"%s%s%s\n",backup_filename+strlen(HIDDEN_DIR),GZIP_FILE_EXT,ENCRYPTION_FILE_EXT);
            else if(!gzip_flag && !no_encryption_flag)
                fprintf(info,"%s%s\n",backup_filename+strlen(HIDDEN_DIR),ENCRYPTION_FILE_EXT);
            else
                fprintf(info,"%s\n",backup_filename+strlen(HIDDEN_DIR));
           }
        else
        {
            if((fp_out=fopen(backup_filename,"wb"))==NULL)
            {
                LOG("[split_file] fail to open %s\n",backup_filename);
                return -1;
            }
            LOG("[split_file] fp_out:%ld\n",fp_out);
            /* record the length of file name(4bytes) and file name at the head of split file */
            /* add owner and group id for chown(const char *path, uid_t owner, gid_t group)*/
            memset(buffer,0x00,sizeof(buffer));
            /* kalen.lee@lge.com 2011.10.04 - begin */
            fprintf(fp_out,"%4u%s",strlen(filename),filename); /* write down filename */
            save_st_info(&stbuf,fp_out);
            /* kalen.lee@lge.com 2011.10.04 - end */

            /* kalen.lee@lge.com 2011.10.04-begin
               Save directory info */
            if(total==stbuf.st_size) /* first split piece */
                save_directory_info(filename,fp_out);
            /* kalen.lee@lge.com 2011.10.04-end */
            LOG("[split_file] buffer:%s\n",buffer);
            LOG("[split_file] call CopyFile fp_in:%d fp_out:%d limit:%d\n",fp_in,fp_out,limit);
            CopyFile(fp_in,fp_out,limit);
            LOG("[split_file] after CopyFile\n");
            fclose(fp_out);
            LOG("[split_file] close fp_out\n");
            if(gzip_flag)
            {
                char command[MAX_CMD_LINE_LEN];
                sprintf(command,"/sbin/gzip_static %s",backup_filename);
#if defined(TIME_LOG)
                time(&time_before);
#endif
                system_call(command,GZIP_FAILURE);
#if defined(TIME_LOG)
                time(&time_after);
                compression_time+=(time_after-time_before);
#endif
                strcat(backup_filename,GZIP_FILE_EXT);
            }

            char outfilename[MAX_PATH_LENGTH],string[MAX_CMD_LINE_LEN];
            memset(outfilename,0x00,sizeof(outfilename));
            if(no_encryption_flag)
            {
                sprintf(outfilename,"%s%s",WORKING_DIR,backup_filename+strlen(HIDDEN_DIR));
                rename(backup_filename,outfilename);
            }
            else
            {
                sprintf(outfilename,"%s%s%s",WORKING_DIR,backup_filename+strlen(HIDDEN_DIR),ENCRYPTION_FILE_EXT);
                //sprintf(string,"/sbin/openssl enc -aes-256-ecb -k %s -in %s -out %s",key,backup_filename,outfilename);
#if defined(TIME_LOG)
                time(&time_before);
#endif
                if(encrypt(backup_filename,outfilename,key))
                {
                    char buffer[16];
                    sprintf(buffer,"%d\n",ENC_FAILURE);
                    generate_file(ERROR_FILENAME,buffer,strlen(buffer));
                }
                //File Permission issue patch (V 1.0)
                if(chmod(outfilename, 0644)){
                    LOG("[split_file] permission change error\n");
                }
                //system_call(string,ENC_FAILURE);
#if defined(TIME_LOG)
                time(&time_after);
                encryption_time+=(time_after-time_before);
#endif
                //sprintf(string,"rm %s",backup_filename);
                //system_call(string,RM_FAILURE);
                remove(backup_filename);
                  //strcat(backup_filename,ENCRYPTION_FILE_EXT);
            }
            strcat(outfilename,"\n");
            generate_file(READY_FILENAME,outfilename+strlen(WORKING_DIR),strlen(outfilename)-strlen(WORKING_DIR));

            memset(backup_filename,0x00,sizeof(backup_filename));
            pthread_mutex_lock(&sync_mutex);
            ready_file_num++;
            if(ready_file_num>1)
            {
                LOG("[split_file] pthread_cond_wait enter\n");
                pthread_cond_wait(&sync_cond, &sync_mutex);
                LOG("[split_file] pthread_cond_wait exit\n");
            }
            pthread_mutex_unlock(&sync_mutex);
        }
        total-=limit;
    }

    if(!info_only_flag)
        fclose(fp_in);

    return 0;
}

#define LOG_TMP_FILE "/data/local/tmp/brd_daemon.log"
#define LOG_TMP_START_FILE "/data/local/tmp/brd_start.log"

//extern int read_hw_key(char *keyout);

int init_handler()
{
    char cmd[255];
    char *debuggable;
    char option[] = "iocharset=iso8859-1,shortname=mixed,utf8"; //inho.kang@lge.com 2011.11.19: change sd card mount option.

    //Log path change patch(Ver 1.0)
    debuggable = (char *) malloc(sizeof(char *) * 64);
    debuggable = propertyget("ro.debuggable");

    if (!strcmp(debuggable, "1"))    //debug mode
        log_path = LOG_DATA;
    else                            //user mode
        log_path = LOG_TMP;

    /* make /temp directory to use ramdisk */
    if(access(WORKING_DIR,F_OK))/* directory doesn't exist */
    {
       if(mkdir(WORKING_DIR, 0777))
       {
           return -1;
       }
       if(chown(WORKING_DIR,SHELL_ID, SHELL_ID))
       {
           return -1;
       }
    }
    if(access(HIDDEN_DIR,F_OK))
    {
        if(mkdir(HIDDEN_DIR,0700))
        {
            char buffer[80];
            sprintf(buffer,"%d\n",HIDDEN_DIR_CREATE_FAILURE);
            generate_file(ERROR_FILENAME,buffer,strlen(buffer));
            return -1;
        }
    }

#if defined(LOG_MSG)
    if((log=fopen(log_path, "a"))==NULL)
    {
        char buffer[80];
        sprintf(buffer,"%d\n",LOG_FILE_OPEN_FAILURE);
        generate_file(ERROR_FILENAME,buffer,strlen(buffer));
        return -1;
    }
    //File Permission issue patch (V 1.0)
    if(chmod(log_path, 0644)){
        LOG("[init_handler] permission change error\n");
    }

    LOG("\n[init_handler] BNR LOG START\n");
#endif


    /* remount root file system with rw mode to allocate ramdisk area to "/temp" directory */
    mount("rootfs","/","rootfs",MS_REMOUNT,NULL);

#if defined(SPLIT_TEST)
    usableMemSize = 1000000;
#else
    /* read available "/temp" size */
    usableMemSize = checkMemFree();
#endif

    LOG("[init_handler] usableMemSize:%ld\n",usableMemSize);

    generate_brd_ready_file();

    return 0;
}


int main()
{
    char     dir[MAX_CMD_LINE_LEN];
    int      sd;//, cc, fromlen, tolen,i;
    int      addrlen;
    struct   sockaddr_in sin;
    struct   sockaddr_in pin;

    fprintf(stderr,"[main] main start\n");

#if defined(LOG_MSG)
    if((log=fopen("/tmp/br_daemon.log", "a"))==NULL)
    {
        char buffer[80];
        sprintf(buffer,"%d\n",LOG_FILE_OPEN_FAILURE);
        generate_file(ERROR_FILENAME,buffer,strlen(buffer));
        return -1;
    }
#endif
    LOG("[main] main start\n");

    /* get an internet domain socket */
    if ((sd = socket(AF_INET, SOCK_DGRAM, 0)) == -1)
    {
        perror("socket");
        exit(-1);
    }
    fprintf(stderr,"[main] socket\n");
    /* complete the socket structure */
    memset(&sin, 0, sizeof(sin));
    sin.sin_family = AF_INET;
    sin.sin_addr.s_addr = INADDR_ANY;
    sin.sin_port = htons(PORT);

    /* bind the socket to the port number */
    if (bind(sd, (struct sockaddr *) &sin, sizeof(sin)) == -1)
    {
        perror("bind");
        exit(1);
    }
    fprintf(stderr,"[main] bind\n");
    addrlen = sizeof(pin);
    do{
      /* get a message from the client */
        memset(dir,0x00,sizeof(dir));
        if (recvfrom(sd, dir, sizeof(dir), 0,(const sockaddr *)&pin,&addrlen) == -1)
        {
            char buffer[80];
            sprintf(buffer,"%d\n",RECV_FAILURE);

            if(!access(WORKING_DIR,F_OK))/* directory exists */
                generate_file(ERROR_FILENAME,buffer,strlen(buffer));

            LOG("[main] recv error");
        }
        else
        {
            LOG("\n[main] server receive %s\n",dir);
            LOG( "usable memory check : %d \n", checkMemFree());
            emulator(dir);
        }
    }while(1);

    close(sd);

    return 0;
}


/* generate a file that list up filenames under /data
 * filenames : list up all file names of backup target in regular sequence
 *
 * @dir : backup_item[]
 * @*fp : file descriptor of /temp/hidden/filenames
 */
int ListupFiles(char *dir, FILE *fp)
{
    char name[MAX_PATH_LEN];
    struct dirent *dp=NULL;
    struct stat stbuf;
    DIR *dfd=NULL;

    LOG("[ListupFiles] %s\n",dir);

    if(lstat(dir,&stbuf)==-1)
    {

        LOG("[ListupFiles] lstat %s failure\n", dir);
        return -1;
    }

    if(!S_ISLNK(stbuf.st_mode) && S_ISDIR(stbuf.st_mode))        // dir = directory
    {
        fprintf(fp,"%s\n",dir);
        /* recursive calls */
        if ((dfd = opendir(dir)) == NULL)
        {
            char string[256];
            sprintf(string,"%d\n",OPEN_DIR_FAILURE);
            generate_file(ERROR_FILENAME,string,strlen(string));
            LOG("[ListupFiles] can't open %s\n", dir);
            return -1;
        }
        while ((dp = readdir(dfd)) != NULL)
        {
            if (strcmp(dp->d_name, ".") == 0
                    || strcmp(dp->d_name, "..") ==0)
                continue;
            sprintf(name, "%s/%s", dir, dp->d_name);
            if(check_except(removal_list,removal_num,name))
                continue;
            if(check_except(ex_backup_list,ex_backup_num,name))
                continue;
            if(lstat(name,&stbuf)==-1)
            {
                LOG("[ListupFiles] lstat %s failure\n", dir);
                return -1;
            }
            if(!S_ISLNK(stbuf.st_mode) && S_ISDIR(stbuf.st_mode))
            {
                ListupFiles(name,fp);
            }
            else
            {
                fprintf(fp,"%s\n",name);
                fflush(fp);
            }
        }
        closedir(dfd);
    }
    else /* Can it happen? No */
    {
        fprintf(fp,"%s\n",name);
        fflush(fp);
    }
    return 0;
}


/*
 * @ *info : file descriptor (/temp/backup_info)
 */
int MakeFileNames(FILE *info)
{
    FILE *fp;
    char filename[128];
    sprintf(filename,"%s%s",HIDDEN_DIR,FILE_LISTUP_FILENAME);            // filename = /temp/hidden/filenames
    int i;
/*filenames   */
    if((fp=fopen(filename,"w"))==NULL)
    {
        /* generate error file */
        char string[16];
        sprintf(string,"%d\n",GENERATE_FILES_FAIURE);
        generate_file(ERROR_FILENAME,string,strlen(string));
        return -1;
    }
    /* inho.kang@lge.com 2012.01.03 : change Listup file coverage */
    for(i=0; i<sizeof(backup_item)/sizeof(char*); i++)
        ListupFiles(backup_item[i], fp);

    fclose(fp);
    fprintf(info,"%s.enc\n",FILE_LISTUP_FILENAME);

    return 0;
}


void AppendBackupInfo()
{
   FILE *fp;

   if((fp=fopen(BACKUP_INFO_FILENAME,"a"))==NULL)
         return;
   /* generate a list of files under /data */

   fprintf(fp,"TOTALSIZE:%lld\n",total_transfer); /* hard coded value(2Mbytes per sec). Please calculate this value on pc side for accuracy */
   LOG("[AppendBackupInfo] total_transfer:%lld \n",total_transfer);
   fclose(fp);
}

void *backup_routine(void *data)
{

    int i,j,idx=0,gzip_flag = TRUE;

    /* reset ext_num */
    ext_num=0;
    memset(backup_filename,0x00,sizeof(backup_filename)); /* kalen.lee@lge.com 2011.11.29 */

    for(j=0; j<sizeof(backup_item)/sizeof(char*); j++){
        for(i=0; i<ex_gzip_num; i++){
            if(!strcmp(backup_item[j], ex_gzip_list[i])){
                gzip_flag = FALSE;
                continue;
            }
        }

        LOG( "[backup_routine] %s : %s \n", gzip_flag ? "GZIP" : "EX_GZIP", backup_item[j]);

        if(gzip_flag == TRUE)
            backup(backup_item[j],FALSE,NULL,gzip_flag,except_list,idx,TRUE,file_limit,FALSE);
        else
            backup(backup_item[j],FALSE,NULL,gzip_flag,removal_list,removal_num,TRUE,file_limit,FALSE);

        gzip_flag = TRUE;
    }

    free(except_list);
    //generate_file(BACKUP_LAST_FILENAME,BACKUP_LAST_FILENAME,strlen(BACKUP_LAST_FILENAME));
    return NULL;
}


// inho.kang@lge.com : add sdcard full backup_routine Function 2011.10.11 - begin
void *backup_routine_sdcard(void *data)
{
    int i,j,idx=0;

    /* reset ext_num */
    ext_num=0;
    memset(backup_filename,0x00,sizeof(backup_filename)); /* kalen.lee@lge.com 2011.11.29 */

    except_list = (char **)malloc(sizeof(char *)*(removal_num+ex_gzip_num+ex_backup_num));

    for(i=0;i<removal_num;i++)
    {
           except_list[idx++]= removal_list[i];
    }
    for(j=0;j<ex_gzip_num;j++)
    {
           except_list[idx++]= ex_gzip_list[j];
    }

    for(j=0;j<ex_backup_num;j++)
         except_list[idx++]= ex_backup_list[j];

    for(j=0;j<ex_gzip_num;j++) /* directories without gzip compression */
    {
           backup(ex_gzip_list[j],FALSE,NULL,FALSE,removal_list,removal_num,TRUE,file_limit,FALSE);
    }

    backup("/data",FALSE,NULL,TRUE,except_list,idx,TRUE,file_limit,FALSE); /* top level */

    // inho.kang@lge.com - 2011.09.27 begin: add internal sdcard except External SD card
    /* inho.kang@lge.com : no encryption flag set FASLE 2011.11.10 */
    backup("/mnt/sdcard",FALSE,NULL,TRUE,except_list,idx,TRUE,file_limit,FALSE);
    // inho.kang@lge.com -2011.06.27 end

    free(except_list);
    return NULL;
}
//inho.kang@lge.com -end


//inho.kang 2011.10.28 : add CS backup_routine -begin
void *backup_routine_sdcard_CS(void *data)
{
    // inho.kang@lge.com - 2011.09.27 begin: add internal sdcard except External SD card.
    // Let's assume that External SD card is not mounted.

    /* reset ext_num */
    ext_num = 0;
    memset(backup_filename,0x00,sizeof(backup_filename)); /* kalen.lee@lge.com 2011.11.29 */
    backup(SDCARD_FILE_NAME, FALSE, NULL, TRUE, NULL, 0, TRUE, file_limit, FALSE); //gzip flag set TRUE
    return NULL;
}
//inho.kang@lge.com -end


void backup_info()
{
    int i, j, idx=0, gzip_flag=TRUE;
    LOG("[backup_info] (removal_num:%d ex_gzip_num:%d)\n",removal_num,ex_gzip_num);

    FILE *fp;

    if((fp=fopen(BACKUP_INFO_FILENAME,"a"))==NULL)
    {
        LOG("[backup_info] fail to open %s\n",BACKUP_INFO_FILENAME);
        return;
    }

    MakeFileNames(fp);

    for(j=0; j<sizeof(backup_item)/sizeof(char*); j++){
        for(i=0; i<ex_gzip_num; i++){
            if(!strcmp(backup_item[j], ex_gzip_list[i])){
                gzip_flag = FALSE;
                continue;
            }
        }

        LOG( "[backup_info] %s : %s \n", gzip_flag ? "GZIP" : "EX_GZIP", backup_item[j]);

        if(gzip_flag == TRUE)
            backup(backup_item[j],TRUE,fp,gzip_flag,except_list,idx,TRUE,file_limit,FALSE);
        else
            backup(backup_item[j],TRUE,fp,gzip_flag,removal_list,removal_num,TRUE,file_limit,FALSE);

        gzip_flag = TRUE;
    }

    fclose(fp);

    //File Permission issue patch (V 1.0)
    if(chmod(BACKUP_INFO_FILENAME, 0644)){
        LOG("[backup_info] permission change error\n");
    }
}


// inho.kang@lge.com : add sdcard full backup_info Function 2011.10.11 - begin
void backup_info_sdcard()
{
    int i,j,idx=0;
     LOG("[backup_info_sdcard] (removal_num:%d ex_gzip_num:%d)\n",removal_num,ex_gzip_num);
     except_list = (char **)malloc(sizeof(char *)*(removal_num+ex_gzip_num));

    for(i=0;i<removal_num;i++)
    {
       except_list[idx++]= removal_list[i];
       LOG("[backup_info_sdcard] except_list[%d]:%s \n",idx-1,except_list[idx-1]);
    }
    for(j=0;j<ex_gzip_num;j++)
    {
           except_list[idx++]= ex_gzip_list[j];
           LOG("[backup_info_sdcard] except_list[%d]:%s \n",idx-1,except_list[idx-1]);
    }
    for(i=0;i<idx;i++)
      LOG("[backup_info_sdcard] except_list[%d]:%s\n",i,except_list[i]);
    LOG("[backup_info_sdcard] call backup\n");
    FILE *fp;

    if((fp=fopen(BACKUP_INFO_FILENAME,"a"))==NULL)
    {
         LOG("[backup_info_sdcard] fail to open %s\n",BACKUP_INFO_FILENAME);
         return;
    }

    MakeFileNames(fp);

    for(j=0;j<ex_gzip_num;j++) /* directories without gzip compression */
    {
           backup(ex_gzip_list[j],TRUE,fp,FALSE,removal_list,removal_num,TRUE,file_limit,FALSE);
    }

    backup("/data",TRUE,fp,TRUE,except_list,idx,TRUE,file_limit,FALSE); /* top level */

    /* inho.kang@lge.com :no encryption flag set FASLE 2011.11.10 */
    backup("/mnt/sdcard",TRUE,fp,TRUE,removal_list,removal_num,TRUE,file_limit,FALSE);    //inho.kang add gzip flag set true 4th param

    fclose(fp);
    free(except_list);
}
//inho.kang@lge.com -end


/*
 * remove added files after backup.
 * Please do not remove files of ex_backup list.
 *
 * @fp  : /temp/hidden/filenames
 * @dir : /data/data, /data/app,,,
 * dir  directory/file , filenames  ׸ remove.
 */
int check_filenames(FILE *fp/* file pointer of files */,char *dir)
{
    char name[MAX_PATH_LEN];
    struct dirent *dp=NULL;
    struct stat stbuf;
    DIR *dfd=NULL;
    fpos_t dir_pos;

    LOG("[check_filenames] check_filenames(%s)\n", dir);

    if(fgetpos(fp,&dir_pos))
    { /* save file pointer */
        LOG("[check_filenames] fgetpos failure(%s)\n", dir);
        return -1;
    }

    fprintf(stderr,"[check_filenames] %s\n",dir);

    if(lstat(dir,&stbuf)==-1)
    {
        LOG("[check_filenames] lstat %s failure\n", dir);
        return -1;
    }
    /* S_ISLINK : symbolic link, S_ISDIR : directory*/
    if(!S_ISLNK(stbuf.st_mode) && S_ISDIR(stbuf.st_mode))
     {
        /* recursive calls */
        if ((dfd = opendir(dir)) == NULL)
        {
            char string[256];
            sprintf(string,"%d\n",OPEN_DIR_FAILURE);
            generate_file(ERROR_FILENAME,string,strlen(string));
            LOG("[check_filenames] can't open %s\n", dir);
            return -1;
        }

        while ((dp = readdir(dfd)) != NULL)
        {
            if (strcmp(dp->d_name, ".") == 0
                    || strcmp(dp->d_name, "..") ==0)
                continue;
            sprintf(name, "%s/%s", dir, dp->d_name);
            if(check_except(ex_backup_list,ex_backup_num,name))
                continue;
            fprintf(stderr,"[check_filenames] name:%s\n",name);
            if(lstat(name,&stbuf)==-1)
            {
                LOG("[check_filenames] lstat %s failure\n", dir);
                return -1;
            }

            char buffer[MAX_PATH_LEN];

            /* move file pointer to the corresponding directory */
            if(fsetpos(fp,&dir_pos))
            {
                LOG("[check_filenames] fail in fsetpos\n");
            }
            /* name = directory ϶*/
            if(!S_ISLNK(stbuf.st_mode) && S_ISDIR(stbuf.st_mode))
            {
                do{
                    fgets(buffer,sizeof(buffer),fp);
                    if(buffer[strlen(buffer)-1]==0x0D || buffer[strlen(buffer)-1]==0x0A)
                        buffer[strlen(buffer)-1]='\0';
                    if(!strcmp(name,buffer))
                        break;
                }while(!feof(fp));     //fp filenames Ѱ  fp ű⼭  stop.

                /* name filenames ִ directory  check_filenames() ѹ  , ƴϸ remove */
                if(!strcmp(name,buffer))
                {
                    check_filenames(fp,name);
                } else {
                    LOG("[check_filenames] rm_directory(%s) buffer:%s\n",name,buffer);
                    rm_directory(name);
                    rmdir(name);
                }
            /* name = file ϶, check_filenames()   . */
            } else {
                do{
                    fgets(buffer,sizeof(buffer),fp);
                    if(buffer[strlen(buffer)-1]==0x0D || buffer[strlen(buffer)-1]==0x0A)
                        buffer[strlen(buffer)-1]='\0';
                    if(!strcmp(name,buffer)) /* humm. Please check carriage return */
                        break;
                }while(!feof(fp));

                if(strcmp(buffer,name))
                {
                    remove(name);
                    LOG("[check_filenames] remove(%s) buffer:%s\n",name,buffer);
                }
            }/* file */
        }/* end of while */
        closedir(dfd);
    }
    return 0;
}


void handle_filenames()
{
    time_t time_before,time_after;
     FILE *fp;
     char filename[128];
     int i;

     sprintf(filename,"%s%s",HIDDEN_DIR,FILE_LISTUP_FILENAME);    // filename = /temp/hidden/filenames
     if((fp=fopen(filename,"r"))==NULL)
     {
             char buffer[16];
             sprintf(buffer,"%d\n",FILES_OPEN_FAILURE);
             generate_file(ERROR_FILENAME,buffer,strlen(buffer));
             return;
     }

     /* inho.kang@lge.com 2012.01.03 : change check_filenames coverage */
     time(&time_before);

     for(i=0; i<sizeof(backup_item)/sizeof(char*); i++)
         check_filenames(fp,backup_item[i]);

     time(&time_after);
     checkfile_time += (time_after-time_before);
}


/*
  *  :  string = /temp/filenames.enc
  *
  *
  */
void restore_handler(char *string)
{
    time_t time_before,time_after;
    /* take restore actions here */
    char cmd[255],out_string[255];
    memset(cmd,0x00,255);
    memset(out_string,0x00,255);

    sprintf(out_string,"%s%s",HIDDEN_DIR,string+strlen(WORKING_DIR));    //    out_string = /temp/hidden/filenames.enc or backup_d.tar.gz.enc

    /* DEC - remove ".enc" */
    if(strlen(out_string)>strlen(ENCRYPTION_FILE_EXT) &&
            !strncmp(out_string+strlen(out_string)-strlen(ENCRYPTION_FILE_EXT),ENCRYPTION_FILE_EXT,strlen(ENCRYPTION_FILE_EXT)))
    {
        sprintf(out_string,"%s%s",HIDDEN_DIR,string+strlen(WORKING_DIR));    //duplication... WHY??
        out_string[strlen(out_string)-strlen(ENCRYPTION_FILE_EXT)]='\0';        //out_string = /temp/hidden/filenames or backup_d.tar.gz
        //sprintf(cmd,"/sbin/openssl enc -d -aes-256-ecb -k %s -in %s -out %s",key,string,out_string);
#if defined(TIME_LOG)
        time(&time_before);
#endif

        /* string : input filename, out_string : output filename, key = encryption key in phone */
        if(decrypt(string,out_string,key))
            return;
#if defined(TIME_LOG)
        time(&time_after);
        decryption_time+=(time_after-time_before);
        time_before=time_after;
#endif

    } else {
        rename(string,out_string);
        LOG("[restore_handler] rename %s into %s\n",string,out_string);
    }

    /* UNZIP - remove ".gz" */
    if(strlen(out_string)>strlen(GZIP_FILE_EXT) &&
            !strncmp(out_string+strlen(out_string)-strlen(GZIP_FILE_EXT),GZIP_FILE_EXT,strlen(GZIP_FILE_EXT)))
    {
        memset(cmd,0x00,255);
        sprintf(cmd,"/sbin/gzip_static -d %s",out_string);
#if defined(TIME_LOG)
        time(&time_before);
#endif
        system_call(cmd,UNZIP_FAILURE);
#if defined(TIME_LOG)
        time(&time_after);
        uncompression_time+=(time_after-time_before);
        time_before=time_after;
#endif
        /* filename  ".gz"  */
        out_string[strlen(out_string)-strlen(GZIP_FILE_EXT)]='\0';
    }

    memset(cmd,0x00,255);
    /* --overwrite  overwrite existing files when extracting
    --overwrite-dir  overwrite meatadata of existing directories when extracting (default)
    */
    sprintf(cmd,"/sbin/tar --overwrite --overwrite-dir -xf %s -C /",out_string);

    /* out_sting = filenames */
    if(!strcmp(out_string+strlen(HIDDEN_DIR),FILE_LISTUP_FILENAME)) /* remove added files */
    {
        handle_filenames();
    }
    /* out_sting = *.split/splitlast  */
    else if(strstr(out_string,SPLIT_FILE_EXT))  /* if a tar file is a splitted file */
    {
        LOG("[restore_handler] split file(%s)\n",out_string);
        /* split file exists in /temp/hidden directory */
        time(&time_before);

        if(MergeSplitFile(out_string)<0)
        {
            char buffer[80];
            sprintf(buffer,"%d\n",MERGE_SPLIT_FAILURE);
            generate_file(ERROR_FILENAME,buffer,strlen(buffer));
        }
        time(&time_after);
        merge_time += (time_after-time_before);

    /* out_string == *.tar  */
    } else {
#if defined(TIME_LOG)
        time(&time_before);
#endif
        system_call(cmd,UNTAR_FAILURE);
#if defined(TIME_LOG)
        time(&time_after);
        untar_time+=(time_after-time_before);
        time_before=time_after;
#endif
    }
#if defined(DEC_BUILD)
    remove(string);
#endif
    remove(out_string);

#if !defined(RESTORE_PARALLEL)
    char comp_filename[255];
    memset(comp_filename,0x00,255);
    sprintf(comp_filename,"%s_complete",string);
    generate_file(comp_filename,comp_filename,strlen(comp_filename));
#endif
    restore_list->del(string+strlen(WORKING_DIR));

    /* the last step of restore */
    if(restore_list->isEmpty())
    {
        if(mode==RESTORE_MODE)
        {
            /* remove directories */
            int i;
            for(i=0;i<removal_num;i++)
            {
                LOG("[restore_handler] rm_dir:%s \n",removal_list[i]);
                rm_directory(removal_list[i]);
            }
            /* kalen.lee@lge.com - 2011.09.29 begin */
            /* execute clearlock */
            system_call("/sbin/clearlock",CLEARLOCK_FAILURE);
            /* kalen.lee@lge.com - 2011.09.29 end */
        }
        sync(); // kalen.2011.04.27 make sure that restored files are saved at flash

        LOG("[restore_handler] call sync\n");
        generate_file(RESTORE_LAST_FILENAME,RESTORE_LAST_FILENAME,strlen(RESTORE_LAST_FILENAME));
        LOG("[restore_handler] generate %s\n",RESTORE_LAST_FILENAME);
#if defined(TIME_LOG)
        LOG("[restore_handler] untar_time:%ld uncompression_time:%ld decryption_time:%ld merge_time:%ld checkfile_time:%ld\n",untar_time,uncompression_time,decryption_time,merge_time,checkfile_time);
        sync();
        //sleep(5);        //inho.kang - waiting for PC
        //reboot(RB_AUTOBOOT);       //inho.kang - reboot
#endif
        mode=INVALID_MODE;
    }
}


void listup_backup_files()
{
    FILE *fp;

    if((fp=fopen(BACKUP_INFO_FILENAME,"r"))==NULL)
    {
        char string[256];
        sprintf(string,"%d\n",LISTUP_BACKUP_FILES_FAILURE);
        generate_file(ERROR_FILENAME,string,strlen(string));
        return;
    }

    backup_list = new List("backup_list");        //ʱȭ, name = backup_list
    char buffer[MAX_PATH_LENGTH];
    memset(buffer,0x00,sizeof(buffer));
    while(fgets(buffer,sizeof(buffer),fp))
    {
        if(!strncmp(buffer,"backup_",strlen("backup_"))
                ||!strncmp(buffer,FILE_LISTUP_FILENAME,strlen(FILE_LISTUP_FILENAME)))
        {
            if(buffer[strlen(buffer)-1]==0x0A || buffer[strlen(buffer)-1]==0x0D)
                buffer[strlen(buffer)-1]='\0';
            Node *node = new Node(buffer);
            backup_list->insert(node);
        }
        memset(buffer,0x00,sizeof(buffer));
    }
    fclose(fp);
#if defined(LOG_MSG)
    backup_list->printList();
#endif
}


/* Please change below definitions when short backup changes */
#define CONTACT_FLAG   0x01
#define CALENDAR_FLAG  0x02
#define RICH_NOTE_FLAG 0x04
#define SDCARD_FLAG    0x08 //inho.kang@lge.com : add sdcard flag 2011.11.11

#define SHORT_BACKUP_FILENAME "backup_short.tar"

#define CONTACT_FILE_NAME        "/data/data/com.android.providers.contacts/databases"
#define CALENDAR_FILE_NAME       "/data/data/com.android.providers.calendar/databases"
#define RICH_NOTE_FILE_NAME      "/data/data/com.lge.app.richnote/databases"
//inho.kang@lge.com : add accounts db file 2011.12.08 -being
#define ACCOUNT_DB_FILE_NAME     "/data/system/accounts.db"
#define ACCOUNT_WAL_FILE_NAME     "/data/system/accounts.db-wal"
#define ACCOUNT_SHM_FILE_NAME    "/data/system/accounts.db-shm"
#define SYNC_INFO_FILE_NAME      "/data/system/sync"
//inho.kang@lge.com -end

void short_backup_handler(char *string_in)
{
   mode=BACKUP_MODE;
#if defined(UI_IMAGE)
   ui_set_background(BACKUP_ICON);
#endif
   char filename[MAX_PATH_LENGTH],outfilename[MAX_PATH_LENGTH];
   memset(filename,0x00,sizeof(filename));
   memset(outfilename,0x00,sizeof(outfilename));
    /* read ENCRYPTION_KEY and BACKUP_FIELD */
   FILE *fp;
   if((fp=fopen(string_in,"r"))==NULL)
   {
       // humm. generate error file
      char string[16];
      sprintf(string,"%d\n",SHORT_BACKUP_OPEN_FAILURE);
      generate_file(ERROR_FILENAME,string,strlen(string));
      LOG("[short_backup_handler] fail to open (%s)\n",string_in);
   }
   int backup_flag=0;
   char buffer[MAX_PATH_LENGTH];
   memset(buffer,0x00,sizeof(buffer));
   while(fgets(buffer,sizeof(buffer),fp))
   {
          LOG("[short_backup_handler] buffer : %s \n ",buffer);
          if(buffer[strlen(buffer)-1]==0x0A || buffer[strlen(buffer)-1]==0x0D)
                 buffer[strlen(buffer)-1]='\0';
          if(!strncmp(buffer,"ENCRYPTION_KEY:",strlen("ENCRYPTION_KEY:")))
          {
                int i;
                for(i=0;i<SHORT_KEY_LEN;i++)
                  key[i]=buffer[strlen("ENCRYPTION_KEY:")+i];
                for(;i<KEY_LEN;i++)
                  key[i]='0';
                  LOG("[short_backup_handler] key:%s\n",key);
          }
          else if(!strncmp(buffer,"BACKUP_FIELD:",strlen("BACKUP_FIELD:")))
          {
              backup_flag=atoi(buffer+strlen("BACKUP_FIELD:"));
              LOG("[short_backup_handler] backup_flag:%d\n",backup_flag);
          }
          memset(buffer,0x00,sizeof(buffer));
   }
   fclose(fp);

   int backup_exist=0;
   char command_line[MAX_CMD_LINE_LEN];
   memset(command_line,0x00,sizeof(command_line));

   if(backup_flag!=0)
   {
       sprintf(command_line,"/sbin/tar cvf %s%s",HIDDEN_DIR,SHORT_BACKUP_FILENAME);
   //inho.kang@lge.com : add accounts db file 2011.12.08 -being
   if((backup_flag & CONTACT_FLAG) || (backup_flag & CALENDAR_FLAG))
   {
    /* BNR : file not found error fix issued by E0 */
    int i;
    char *account_files[] = {ACCOUNT_DB_FILE_NAME,
                    ACCOUNT_WAL_FILE_NAME,
                    ACCOUNT_SHM_FILE_NAME,
                    SYNC_INFO_FILE_NAME};

    for(i=0; i<sizeof(account_files)/sizeof(char*); i++){
        if(!access(account_files[i],F_OK)){
            strcat(command_line," ");
            strcat(command_line,account_files[i]);
            backup_exist=1;
        } else {
         LOG("[short_backup_handler] account file \(%s\) doesn't exist\n",account_files[i]);
        }
    }
   }
   /* inho.kang -end */
   if(backup_flag & CONTACT_FLAG)
   {
      if(!access(CONTACT_FILE_NAME,F_OK))
      {
        strcat(command_line," ");
        strcat(command_line,CONTACT_FILE_NAME);
        backup_exist=1;
      }
      else
      {
         LOG("[short_backup_handler] contact file doesn't exist\n");
      }
   }
   if(backup_flag & CALENDAR_FLAG)
   {
      if(!access(CALENDAR_FILE_NAME,F_OK))
      {
        strcat(command_line," ");
        strcat(command_line,CALENDAR_FILE_NAME);
        backup_exist=1;
      }
      else
      {
         LOG("[short_backup_handler] calendar file doesn't exist\n");
      }
   }
   if(backup_flag & RICH_NOTE_FLAG)
   {
      if(!access(RICH_NOTE_FILE_NAME,F_OK))
      {
        strcat(command_line," ");
        strcat(command_line,RICH_NOTE_FILE_NAME);
        backup_exist=1;
      }
      else
      {
         LOG("[short_backup_handler] rich note file doesn't exist\n");
      }
       }
      if(backup_exist)
      {
         system_call(command_line,TAR_FAILURE);
         sprintf(filename,"%s%s",HIDDEN_DIR,SHORT_BACKUP_FILENAME);
         sprintf(outfilename,"%s%s.enc",WORKING_DIR,SHORT_BACKUP_FILENAME);
         encrypt(filename,outfilename,key);
         //File Permission issue patch (V 1.0)
         if(chmod(outfilename, 0644)){
             LOG("[short_backup_handler] permission change error\n");
         }
      }
   }

   if(backup_flag & SDCARD_FLAG)
   {
      if(!access(SDCARD_FILE_NAME,F_OK))
      {
        backup_exist=1;
      }
      else
      {
         LOG("internal sdcard doesn't exist\n");
      }
   }
   if(!backup_exist)
   {
          char string[16];
          sprintf(string,"%d\n",NO_BACKUP_FILE);
          generate_file(ERROR_FILENAME,string,strlen(string));
          LOG("[short_backup_handler] backup file doesn't exist\n");
          return;
   }

   /* generate backup_info file */
   if((fp=fopen(BACKUP_INFO_FILENAME,"w"))==NULL)
    {
          LOG("[short_backup_handler] fail to open %s\n",BACKUP_INFO_FILENAME);
          return;
    }
   //File Permission issue patch (V 1.0)
   if(chmod(BACKUP_INFO_FILENAME, 0644)){
       LOG("[emulator] permission change error\n");
   }

    struct stat stbuf;
    memset(&stbuf,0x00,sizeof(struct stat));

    if(backup_flag & ~SDCARD_FLAG)
    {
          LOG("[short_backup_handler] Test : here 1\n");

        if(lstat(outfilename,&stbuf)!=-1) /* success */
        {
          LOG("[short_backup_handler] Test : here 2\n");
           fprintf(fp,"%s\n",outfilename+strlen(WORKING_DIR));
        }
    }

    if(backup_flag & SDCARD_FLAG) /* save internal SD card */
    {
          LOG("[short_backup_handler] Test : here 3 - backup info \n");
         file_limit = MINIMUM_VALUE_CS_SDCARD; // inho.kang 1107 : set file_limit temp
         /* we assume that backup all of /mnt/sdcard and /mnt/sdcard/_External is not mounted. Therefore removal_list is null.*/
         backup(SDCARD_FILE_NAME,TRUE,fp,TRUE,NULL,0,TRUE,file_limit,FALSE);  //bacup info
    }

    fprintf(fp,"TOTALSIZE:%lld\n",stbuf.st_size+total_transfer);
    LOG("[short_backup_handler] TOTALSIZE:%lld\n",stbuf.st_size+total_transfer);
    fclose(fp);
    listup_backup_files();
   /* write down backup_info and outfilename in READY file.*/
     memset(command_line,0x00,sizeof(command_line));
     sprintf(command_line,"%s\n",BACKUP_INFO_FILENAME+strlen(WORKING_DIR));
     generate_file(READY_FILENAME,command_line,strlen(command_line));
     if(strlen(outfilename)>0)        // 4Ͱ  0x00
     {
        sprintf(command_line,"%s\n",outfilename+strlen(WORKING_DIR));
        generate_file(READY_FILENAME,command_line,strlen(command_line));
     }
     if(backup_flag & SDCARD_FLAG) /* save internal SD card */
     {

      pthread_t tid;
          if (pthread_create(&tid, NULL, backup_routine_sdcard_CS, (void *)NULL) <0)
          {
                 LOG("[short_backup_handler] pthread_create returns error\n");
          }
     }
}


/*
 * String list :
 * BRD_INIT_S                     "brd_init_s"
 * BRD_INIT                     "brd_init"
 * CONFIG_FILE                     "/temp/configure"
 * BACKUP_CANCEL_FILENAME        "/temp/backup_cancel"
 * START_BACKUP_SDCARD_FULL     "/temp/start_backup_sdcard_full"
 * START_BACKUP                 "/temp/start_backup"
 * START_SHORT_BACKUP             "/temp/start_short_backup"
 * START_RESTORE                 "/temp/start_restore"
 * START_SHORT_RESTORE             "/temp/start_short_restore"
 * RESTORE_COMPLETE_CONFIRM     "/temp/end_restore"
 * COMPLETE_NOTI_FILE_EXT         "_complete"
 * BACKUP_COMPLETE_CONFIRM         "/temp/end_backup"
 * WORKING_DIR                     "/temp/"
 */
void emulator(char *string_in)
{
    //static char prev_file[128];
    char string[256];
    time_t time_before,time_after;

    /* cut off file size */
    time_t curr_time;
    time(&curr_time);
    LOG("[emulator] string_in:%s time:%ld\n",string_in,curr_time);
    memset(string,0x00,256);

      char *tmp=strstr(string_in,",");
    if(tmp)
     {
        /* remove the file size field if it exists. */
        strncpy(string,string_in,tmp-string_in);
        LOG("[emulator] len:%d string:%s\n",tmp-string_in+1,string);
        string[(tmp-string_in)+1] ='\0';
    }
    else
        strcpy(string,string_in);

    LOG("[emulator] %s\n",string);
    sync();
    // inho.kang@lge.com:Add for C/S Backup(we can show Backup UI before triggering)  -begin
    if(!strncmp(string,BRD_INIT_S,strlen(BRD_INIT_S)))
    {
        if(mode==INVALID_MODE)
            init_handler();

/* change UI secnario : code replace from brd to recovery */
/* UI_IMAGE define cancel in makefile */
#if defined(UI_IMAGE)
         ui_set_background(BACKUP_ICON_CS); //inho.kang@lge.com 2011.12.27 : change icon for C/S Mode
         LOG("[emulator] (BRD_INIT_S)ui_set_background(BACKUP_ICON)\n");
         LOG("[emulator] string : %s\n",string);
#endif

    }
     // inho.kang@lge.com -end
    else if(!strncmp(string,BRD_INIT,strlen(BRD_INIT)))
    {
        if(mode==INVALID_MODE)
            init_handler();
    }
     //inho.kang@lge.com:get configure from pc app  -begin
    else if(!strncmp(string,CONFIG_FILE,strlen(CONFIG_FILE)))
    {
        LOG("[emulator] that is configure \n");
        readConfig();
    }
    //inho.kang -end

    //inho.kang@lge.com:when backup cancel file comes from PC, reboot -begin
    /* Disused scenario */
    else if(!strncmp(string,BACKUP_CANCEL_FILENAME,strlen(BACKUP_CANCEL_FILENAME)))
    {
        LOG("[emulator] Backup Cancel\n");
        LOG("=========================================\n\n\n");
        sync();
        reboot(RB_AUTOBOOT);
    }
     //inho.kang -end

    else if(mode<0)
    {
        //inho.kang@lge.com : add Backup routine including internal SD Card. 2011.10.11 -begin
        if(!strncmp(string,START_BACKUP_SDCARD_FULL,strlen(START_BACKUP_SDCARD_FULL)))
        {
            mode=BACKUP_MODE;
#if defined(UI_IMAGE)
            ui_set_background(BACKUP_ICON);
            LOG("[emulator] ui_set_background(BACKUP_ICON)\n");
#endif
            /* generate backup_info file */
            char filename[128];
            /* list up data files */
            backup_info_sdcard();
            AppendBackupInfo();
            sprintf(filename,"%s\n",BACKUP_INFO_FILENAME+strlen(WORKING_DIR));
            generate_file(READY_FILENAME,filename,strlen(filename));
            /* encrypt */
            char encfilename[128];
            sprintf(encfilename,"%s%s.enc",WORKING_DIR,FILE_LISTUP_FILENAME);
            sprintf(filename,"%s%s",HIDDEN_DIR,FILE_LISTUP_FILENAME);
            if(encrypt(filename,encfilename,key))
            {
                char buffer[16];
                sprintf(buffer,"%d\n",ENC_FAILURE);
                generate_file(ERROR_FILENAME,buffer,strlen(buffer));
                return;
            }
            //File Permission issue patch (V 1.0)
            if(chmod(encfilename, 0644)){
                LOG("[emulator] permission change error\n");
            }

            remove(filename);  //please add this code for removing files under hidden
            sprintf(filename,"%s\n",encfilename+strlen(WORKING_DIR));
            generate_file(READY_FILENAME,filename,strlen(filename));
            LOG("[emulator] add %s into READY\n",filename);
            listup_backup_files();
            pthread_t tid;

            if (pthread_create(&tid, NULL, backup_routine_sdcard, (void *)NULL) <0)
            {
                LOG("[emulator] pthread_create returns error\n");
            }

        }
        //inho.kang@lge.com -end

        else if(!strncmp(string,START_BACKUP,strlen(START_BACKUP)))
        {
            mode = BACKUP_MODE;

            //Multiple account list patch (Ver 1.0)
            ready_key(mode);

            if(!strncmp(hw_key,"0000000000",strlen("0000000000")))
            {
                LOG("[emulator] hw_key is %s\n",hw_key);
                LOG("[emulator] You don't have Googie ID. -> forcing reboot\n");
                LOG("=========================================\n\n\n");
                sync();
                reboot(RB_AUTOBOOT);
            }

#if defined(UI_IMAGE)
            ui_set_background(BACKUP_ICON);
            LOG("[emulator] ui_set_background(BACKUP_ICON)\n");
#endif
            /* generate backup_info file */
            char filename[128];
            /* list up data files */
            backup_info();
            AppendBackupInfo();
            sprintf(filename,"%s\n",BACKUP_INFO_FILENAME+strlen(WORKING_DIR));
            generate_file(READY_FILENAME,filename,strlen(filename));
            /* encrypt */
            char encfilename[128];
            sprintf(encfilename,"%s%s.enc",WORKING_DIR,FILE_LISTUP_FILENAME);
            sprintf(filename,"%s%s",HIDDEN_DIR,FILE_LISTUP_FILENAME);
            if(encrypt(filename,encfilename,key))
            {
                char buffer[16];
                sprintf(buffer,"%d\n",ENC_FAILURE);
                generate_file(ERROR_FILENAME,buffer,strlen(buffer));
                return;
            }
            //File Permission issue patch (V 1.0)
            if(chmod(encfilename, 0644)){
                LOG("[emulator] permission change error\n");
            }

            remove(filename);  //please add this code for removing files under hidden
            sprintf(filename,"%s\n",encfilename+strlen(WORKING_DIR));
            generate_file(READY_FILENAME,filename,strlen(filename));
            LOG("[emulator] add %s into READY\n",filename);
            listup_backup_files();
            pthread_t tid;

            if (pthread_create(&tid, NULL, backup_routine, (void *)NULL) <0)
            {
                LOG("[emulator] pthread_create returns error\n");
            }
        }

        else if(!strncmp(string,START_SHORT_BACKUP,strlen(START_SHORT_BACKUP)))
        {
            /* read ENCRYPTION_KEY and BACKUP_FIELD */
            short_backup_handler(string);
        }
        else if(!strncmp(string,START_RESTORE,strlen(START_RESTORE)))
        {
            mode=RESTORE_MODE;

            //Multiple account list patch (Ver 1.0)
            ready_key(mode);
#if defined(UI_IMAGE)
            ui_set_background(RESTORE_ICON);
            LOG("[emulator] ui_set_background(RESTORE_ICON)\n");
#endif
            if(check_version_restore_files(string))
            {
                mode=INVALID_MODE;
                return;
            }
             /* wait restore files */
#if defined(REMOVE_WHOLE_DATA_DIR)
            rm_directory(DATA_DIRECTORY);  // rm /data for testing. Please comment out this line later
#endif
            return;
        }
        else if(!strncmp(string,START_SHORT_RESTORE,strlen(START_SHORT_RESTORE)))
        {
            mode=SHORT_RESTORE_MODE;
#if defined(UI_IMAGE)
            ui_set_background(RESTORE_ICON);
            LOG("[emulator] ui_set_background(RESTORE_ICON)\n");
#endif
            //rm_directory("/mnt/sdcard");//inho.kang@lge.com : remove internal sd card data.
            if(check_version_restore_files(string))
            {
                mode=INVALID_MODE;
                return;
            }
        }
        // inho.kang@lge.com 2011.10.11 : reboot when restore is complete. - begin
        else if(!strncmp(string,RESTORE_COMPLETE_CONFIRM,strlen(RESTORE_COMPLETE_CONFIRM)))
        {
            LOG("[emulator] Restore complete\n");
            LOG("=========================================\n\n\n");
            sync();
            reboot(RB_AUTOBOOT);
        }
     // inho.kang@lge.com -end

        LOG("[emulator] invalid state(%d,%s)\n",mode,string);
    }
    else if(strlen(string)>strlen(COMPLETE_NOTI_FILE_EXT) &&
            !strncmp(string+strlen(string)-strlen(COMPLETE_NOTI_FILE_EXT),COMPLETE_NOTI_FILE_EXT,strlen(COMPLETE_NOTI_FILE_EXT)))
    {
        if(mode==BACKUP_MODE)
        {
            //char cmd[255];
            char filename[255];
            //memset(cmd,0x00,sizeof(cmd));
            /* remove previsou file */
            strcpy(filename,string);                                                                        //filename = /temp/string.enc_complete
            filename[strlen(string)-strlen(COMPLETE_NOTI_FILE_EXT)]='\0';            //filename = /temp/string.enc
            remove(string);                                                                                    //remove /temp/string.enc(_complete) both.
            remove(filename);
/* generate next file */
            LOG("[emulator] pthread_cond_signal enter\n");
            pthread_mutex_lock(&sync_mutex);
            --ready_file_num;
            pthread_cond_signal(&sync_cond);
            pthread_mutex_unlock(&sync_mutex);
            LOG("[emulator] pthread_cond_signal exit\n");
            LOG("[emulator] filename:[%s] [%s]\n",filename,filename+strlen(WORKING_DIR));
            backup_list->del(filename+strlen(WORKING_DIR));
#if defined(LOG_MSG)
            backup_list->printList();
#endif
            if(backup_list->isEmpty())
            {
                generate_file(BACKUP_LAST_FILENAME,BACKUP_LAST_FILENAME,strlen(BACKUP_LAST_FILENAME));
                //sleep(5);        // inho.kang - for waiting PC
                //reboot(RB_AUTOBOOT);    // inho.kang - reboot
            }
         } else {
             char buffer[80];
             sprintf(buffer,"%d\n",INVALID_MODE_FAILURE);
             /* invalid mode */
             generate_file(ERROR_FILENAME,buffer,strlen(buffer));
             //generate_file(ERROR_FILENAME,"invalid mode",strlen("invalid_mode"));
         }
    }
    else if(!strncmp(string,BACKUP_COMPLETE_CONFIRM,strlen(BACKUP_COMPLETE_CONFIRM)))
    {
        LOG("[emulator] Backup Complete\n");
        LOG("=========================================\n\n\n");
        sync();
        reboot(RB_AUTOBOOT); // inho.kang@lge.com 2011.10.11 : reboot when backup is complete.
    }
    /*
    // inho.kang@lge.com 2011.10.11 : reboot when restore is complete. - begin
    else if(!strncmp(string,RESTORE_COMPLETE_CONFIRM,strlen(RESTORE_COMPLETE_CONFIRM)))
    {
        reboot(RB_AUTOBOOT);
    }
    // inho.kang@lge.com -end
    */
    /* restore files : /temp/backup_0.tar.gz.enc */
    else if(!strncmp(string,WORKING_DIR,strlen(WORKING_DIR)) && (mode==RESTORE_MODE || mode==SHORT_RESTORE_MODE))
    {
        LOG("[emulator] restore a file:%s\n",string);

#if defined(RESTORE_PARALLEL)
        char comp_filename[255];
        memset(comp_filename,0x00,255);
        sprintf(comp_filename,"%s_complete",string);
        generate_file(comp_filename,comp_filename,strlen(comp_filename));
#endif
          restore_handler(string);
    } else {
        /* do nothing. normal adb push */
        LOG("[emulator] normal adb push %s\n",string);
    }

LOG("endendend\n");

}


/* limit must be multiples of MAX_SPLIT_BUFFER.
   If limit is zero,copy fp_in to fp_out till end of fp_in */
int CopyFile(FILE *fp_in,FILE *fp_out,int limit)
{
    int written=0,read=0,tmp;
    unsigned char buffer[MAX_SPLIT_BUFFER];

    LOG("[CopyFile] CopyFile enters (fp_in:%d fp_out:%d limit:%d)\n",fp_in,fp_out,limit);

    while(!feof(fp_in) && (written < limit || limit==0))
    {
      //memset(buffer,0x00,sizeof(buffer)); whiy this line causes trouble?

        if((read=fread((void *)buffer,1,MAX_SPLIT_BUFFER,fp_in))<0)
        {
            LOG("[CopyFile] fail to read in CopyFile\n");
            return -1;
        }
        if((tmp=fwrite((const void *)buffer,1,read,fp_out))<0)
        {
            LOG("[CopyFile] fail to write in CopyFile\n");
            return -1;
        }
        if(tmp>0)
            written+=tmp;
    }
    LOG("[CopyFile] CopyFile exits written:%d \n",written);
    return written;
}


void generate_key(char *key_in)
{
    int i;
    unsigned int seed=0;

    for(i=0;i<KEY_LEN;i++)
    {
        seed+=key_in[i];
    }
    srand(seed);

    for(i=0;i<KEY_LEN;i++)
    {
        key[i] = (rand() % 10)+'0';
    }

    for(i=0;i<KEY_LEN;i++)
    {
        key[i] = (rand() %10)+'0';
    }
    key[i+1]='\0';

    LOG("[generate_key] key_in: %s\n", key_in);
    LOG("[generate_key] key_out: %s\n", key);
}


int  checkMemFree()
{
    const char *digits = "0123456789";
    unsigned len;
    int  memfree_size = 0;
    FILE *fmeminfo;
      char buf[80], *colon, *num;

    fmeminfo = fopen("/proc/meminfo", "r");

    if(fmeminfo == NULL)
    {
        char string[80];

        printf("meminfo File Open Error!\n");

        sprintf(string,"%d\n",RECV_FAILURE);
        generate_file(ERROR_FILENAME,string,strlen(string));

        //generate_file(ERROR_FILENAME,"meminfo open error",strlen("meminfo open error"));
           return 0;
      }

      while(fgets(buf, 80, fmeminfo) != NULL)
      {
        colon = strchr(buf, ':');

            if(colon != NULL)
            {
                  *colon++ = '\0';
                  len = strcspn(colon, digits);
                  num = colon + len;

                  if(isdigit(*num))
                  {
                    len = strspn(num, digits);
                    *(num+len) = '\0';

                    if(strcmp(buf, "MemFree") == 0)
                    {
                        memfree_size = atoi(num);
                        break;
                    }

                  }
            }
      }

      fclose(fmeminfo);

    return (memfree_size*1024-MEMORY_MARGIN)/3; /* serialize:2 parallelize:3 */
}

int rm_directory(char *dir)
{
    char name[MAX_CMD_LINE_LEN];
    struct dirent *dp=NULL;
    struct stat stbuf;
    DIR *dfd=NULL;;
    int dir_size=0;
    LOG("[rm_directory] %s\n",dir);
    if ((dfd = opendir(dir)) == NULL) {
        return -1;
    }
    while ((dp = readdir(dfd)) != NULL) {
        if (strcmp(dp->d_name, ".") == 0
                || strcmp(dp->d_name, "..") ==0 )
            continue;    /* skip self and parent */
        sprintf(name, "%s/%s", dir, dp->d_name);

        if(lstat(name,&stbuf)==-1)
        {
            return -1;
        }
        if((stbuf.st_mode & S_IFMT)==S_IFDIR)
        {
            int ret;
            rm_directory(name);
            rmdir(name);
        }
        else
        {
            remove(name);
            LOG("[rm_directory] remove %s\n",name);
        }
    }
    closedir(dfd);

    return 0;
}


/*
 * D1L / App 200ea / backup size 768M / limit 50M
 * tar_time:75 compression_time:147 encryption_time:176
 * untar_time:11 uncompression_time:14 decryption_time:39
 *
 * lmit 100M
 * tar_time:107 compression_time:144 encryption_time:198
 * untar_time:52 uncompression_time:15 decryption_time:36
 *
 * limit 50M
 * tar_time:83 compression_time:148 encryption_time:192
 *
 * limit 20M
 * tar_time:37 compression_time:142 encryption_time:153 spilt_time:17 checkfile_time:0
 * untar_time:13 uncompression_time:15 decryption_time:37 merge_time:2 checkfile_time:1
 *
 * limit 10M
 * tar_time:27 compression_time:147 encryption_time:190 spilt_time:121 checkfile_tme:0
 *
 * limit 20M / App 100ea / Backup Size 321M
 * tar_time:22 compression_time:64 encryption_time:61 spilt_time:0 checkfile_time:0
 * untar_time:5 uncompression_time:5 decryption_time:10 merge_time:0 checkfile_time:0
 *
 *
 *
 * [TIME] dir  ð üũ
 * Q1 : resotore, ð  ׷ Դ°ǰ... Ҽ  © ׷...gzip ɸ...
 *
 * restore : backup_tar.enc(20M)  7.6 / 6.4
 *
 *
 * EX_GZIP Code Error
 * tar_time:22 compression_time:64 encryption_time:61 spilt_time:0 checkfile_time:0
 * tar_time:11 compression_time:10 encryption_time:29 spilt_time:0 checkfile_time:0
 *
 * tar_time:14 compression_time:10 encryption_time:26 spilt_time:0 checkfile_time:0
 *
 *
 *
 *
 *
 */
