/* -*- Mode: C; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* ***** BEGIN LICENSE BLOCK *****
* Version: MPL 1.1/GPL 2.0/LGPL 2.1
*
* The contents of this file are subject to the Mozilla Public License Version
* 1.1 (the "License"); you may not use this file except in compliance with
* the License. You may obtain a copy of the License at
* http://www.mozilla.org/MPL/
*
* Software distributed under the License is distributed on an "AS IS" basis,
* WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
* for the specific language governing rights and limitations under the
* License.
*
* The Original Code is mozilla.org code.
*
* The Initial Developer of the Original Code is
* Netscape Communications Corporation.
* Portions created by the Initial Developer are Copyright (C) 1998
* the Initial Developer. All Rights Reserved.
*
* Contributor(s):
*
* Alternatively, the contents of this file may be used under the terms of
* either the GNU General Public License Version 2 or later (the "GPL"), or
* the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
* in which case the provisions of the GPL or the LGPL are applicable instead
* of those above. If you wish to allow use of your version of this file only
* under the terms of either the GPL or the LGPL, and not to allow others to
* use your version of this file under the terms of the MPL, indicate your
* decision by deleting the provisions above and replace them with the notice
* and other provisions required by the GPL or the LGPL. If you do not delete
* the provisions above, a recipient may use your version of this file under
* the terms of any one of the MPL, the GPL or the LGPL.
*
* ***** END LICENSE BLOCK ***** */

#ifndef __PAL_C_CODINGSTATEMACHINE__
#define __PAL_C_CODINGSTATEMACHINE__

#include "palCDetectorDefine.h"

#define GETCLASS(c) GETFROMPCK(((BRUCHAR)(c)), mModel->classTable)

class palCCodingStateMachine
#ifdef EMSDK_USE_OBJ_MEM_OPERATOR
	: public common_IHeapOp
#endif
{
public:
	palCCodingStateMachine(const MW_SMModel* sm){
		mCurrentState = eSS_Start;
		mModel = sm;

		mCurrentBytePos = 0;
		mCurrentCharLen = 0;
	};
	virtual ~palCCodingStateMachine(){};

	ESM_State NextState(BRCHAR c){
		//for each byte we get its class , if it is first byte, we also get byte length
		BRUINT32 byteCls = GETCLASS(c);
		if (mCurrentState == eSS_Start)
		{ 
			mCurrentBytePos = 0; 
			mCurrentCharLen = mModel->charLenTable[byteCls];
		}
		//from byte's class and stateTable, we get its next state
		mCurrentState=(ESM_State)GETFROMPCK(mCurrentState*(mModel->classFactor)+byteCls, mModel->stateTable);
		mCurrentBytePos++;
		return mCurrentState;
	};
	BRUINT32  GetCurrentCharLen() {return mCurrentCharLen;};
	BRVOID      Reset() {mCurrentState = eSS_Start;};
	//const BRCHAR * GetCodingStateMachine() {return mModel->name;};

protected:
	ESM_State mCurrentState;
	BRUINT32 mCurrentCharLen;
	BRUINT32 mCurrentBytePos;

	const MW_SMModel *mModel;
};

#endif // __PAL_C_CODINGSTATEMACHINE__


