/* -*- Mode: C; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is mozilla.org code.
 *
 * The Initial Developer of the Original Code is
 * Netscape Communications Corporation.
 * Portions created by the Initial Developer are Copyright (C) 1998
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */


#include "palCEscCharsetProber.h"
#include "palCDetectorUtility.h"

const BRUINT32 MW_HZ_cls[ 256 / 8 ] = {
 	MW_PCK4BITS(1,0,0,0,0,0,0,0),  // 00 - 07
 	MW_PCK4BITS(0,0,0,0,0,0,0,0),  // 08 - 0f
 	MW_PCK4BITS(0,0,0,0,0,0,0,0),  // 10 - 17
 	MW_PCK4BITS(0,0,0,1,0,0,0,0),  // 18 - 1f
 	MW_PCK4BITS(0,0,0,0,0,0,0,0),  // 20 - 27
 	MW_PCK4BITS(0,0,0,0,0,0,0,0),  // 28 - 2f
 	MW_PCK4BITS(0,0,0,0,0,0,0,0),  // 30 - 37
 	MW_PCK4BITS(0,0,0,0,0,0,0,0),  // 38 - 3f
 	MW_PCK4BITS(0,0,0,0,0,0,0,0),  // 40 - 47
 	MW_PCK4BITS(0,0,0,0,0,0,0,0),  // 48 - 4f
 	MW_PCK4BITS(0,0,0,0,0,0,0,0),  // 50 - 57
 	MW_PCK4BITS(0,0,0,0,0,0,0,0),  // 58 - 5f
 	MW_PCK4BITS(0,0,0,0,0,0,0,0),  // 60 - 67
 	MW_PCK4BITS(0,0,0,0,0,0,0,0),  // 68 - 6f
 	MW_PCK4BITS(0,0,0,0,0,0,0,0),  // 70 - 77
 	MW_PCK4BITS(0,0,0,4,0,5,2,0),  // 78 - 7f
 	MW_PCK4BITS(1,1,1,1,1,1,1,1),  // 80 - 87
 	MW_PCK4BITS(1,1,1,1,1,1,1,1),  // 88 - 8f
 	MW_PCK4BITS(1,1,1,1,1,1,1,1),  // 90 - 97
 	MW_PCK4BITS(1,1,1,1,1,1,1,1),  // 98 - 9f
 	MW_PCK4BITS(1,1,1,1,1,1,1,1),  // a0 - a7
 	MW_PCK4BITS(1,1,1,1,1,1,1,1),  // a8 - af
 	MW_PCK4BITS(1,1,1,1,1,1,1,1),  // b0 - b7
 	MW_PCK4BITS(1,1,1,1,1,1,1,1),  // b8 - bf
 	MW_PCK4BITS(1,1,1,1,1,1,1,1),  // c0 - c7
 	MW_PCK4BITS(1,1,1,1,1,1,1,1),  // c8 - cf
 	MW_PCK4BITS(1,1,1,1,1,1,1,1),  // d0 - d7
 	MW_PCK4BITS(1,1,1,1,1,1,1,1),  // d8 - df
 	MW_PCK4BITS(1,1,1,1,1,1,1,1),  // e0 - e7
 	MW_PCK4BITS(1,1,1,1,1,1,1,1),  // e8 - ef
 	MW_PCK4BITS(1,1,1,1,1,1,1,1),  // f0 - f7
 	MW_PCK4BITS(1,1,1,1,1,1,1,1)   // f8 - ff
 };

const BRUINT32 HZ_st [ 6] = {
 	MW_PCK4BITS(eSS_Start,eSS_Error,     3,eSS_Start,eSS_Start,eSS_Start,eSS_Error,eSS_Error),//00-07
 	MW_PCK4BITS(eSS_Error,eSS_Error,eSS_Error,eSS_Error,eSS_ItsMe,eSS_ItsMe,eSS_ItsMe,eSS_ItsMe),//08-0f
 	MW_PCK4BITS(eSS_ItsMe,eSS_ItsMe,eSS_Error,eSS_Error,eSS_Start,eSS_Start,     4,eSS_Error),//10-17
 	MW_PCK4BITS(     5,eSS_Error,     6,eSS_Error,     5,     5,     4,eSS_Error),//18-1f
 	MW_PCK4BITS(     4,eSS_Error,     4,     4,     4,eSS_Error,     4,eSS_Error),//20-27
 	MW_PCK4BITS(     4,eSS_ItsMe,eSS_Start,eSS_Start,eSS_Start,eSS_Start,eSS_Start,eSS_Start) //28-2f
 	};
 	
 const BRUINT32 HZCharLenTable[] = {0, 0, 0, 0, 0, 0};
 	
const BRUINT32 MW_ISO2022CN_cls [ 256 / 8 ] = {
	MW_PCK4BITS(2,0,0,0,0,0,0,0),  // 00 - 07
	MW_PCK4BITS(0,0,0,0,0,0,0,0),  // 08 - 0f
	MW_PCK4BITS(0,0,0,0,0,0,0,0),  // 10 - 17
	MW_PCK4BITS(0,0,0,1,0,0,0,0),  // 18 - 1f
 	MW_PCK4BITS(0,0,0,0,0,0,0,0),  // 20 - 27
 	MW_PCK4BITS(0,3,0,0,0,0,0,0),  // 28 - 2f
 	MW_PCK4BITS(0,0,0,0,0,0,0,0),  // 30 - 37
 	MW_PCK4BITS(0,0,0,0,0,0,0,0),  // 38 - 3f
 	MW_PCK4BITS(0,0,0,4,0,0,0,0),  // 40 - 47
 	MW_PCK4BITS(0,0,0,0,0,0,0,0),  // 48 - 4f
 	MW_PCK4BITS(0,0,0,0,0,0,0,0),  // 50 - 57
 	MW_PCK4BITS(0,0,0,0,0,0,0,0),  // 58 - 5f
 	MW_PCK4BITS(0,0,0,0,0,0,0,0),  // 60 - 67
 	MW_PCK4BITS(0,0,0,0,0,0,0,0),  // 68 - 6f
 	MW_PCK4BITS(0,0,0,0,0,0,0,0),  // 70 - 77
 	MW_PCK4BITS(0,0,0,0,0,0,0,0),  // 78 - 7f
 	MW_PCK4BITS(2,2,2,2,2,2,2,2),  // 80 - 87
 	MW_PCK4BITS(2,2,2,2,2,2,2,2),  // 88 - 8f
 	MW_PCK4BITS(2,2,2,2,2,2,2,2),  // 90 - 97
 	MW_PCK4BITS(2,2,2,2,2,2,2,2),  // 98 - 9f
 	MW_PCK4BITS(2,2,2,2,2,2,2,2),  // a0 - a7
 	MW_PCK4BITS(2,2,2,2,2,2,2,2),  // a8 - af
 	MW_PCK4BITS(2,2,2,2,2,2,2,2),  // b0 - b7
 	MW_PCK4BITS(2,2,2,2,2,2,2,2),  // b8 - bf
 	MW_PCK4BITS(2,2,2,2,2,2,2,2),  // c0 - c7
 	MW_PCK4BITS(2,2,2,2,2,2,2,2),  // c8 - cf
 	MW_PCK4BITS(2,2,2,2,2,2,2,2),  // d0 - d7
 	MW_PCK4BITS(2,2,2,2,2,2,2,2),  // d8 - df
 	MW_PCK4BITS(2,2,2,2,2,2,2,2),  // e0 - e7
 	MW_PCK4BITS(2,2,2,2,2,2,2,2),  // e8 - ef
 	MW_PCK4BITS(2,2,2,2,2,2,2,2),  // f0 - f7
 	MW_PCK4BITS(2,2,2,2,2,2,2,2)   // f8 - ff
 };
 	
 	
 const BRUINT32 ISO2022CN_st [ 8] = {
 	MW_PCK4BITS(eSS_Start,     3,eSS_Error,eSS_Start,eSS_Start,eSS_Start,eSS_Start,eSS_Start),//00-07
 	MW_PCK4BITS(eSS_Start,eSS_Error,eSS_Error,eSS_Error,eSS_Error,eSS_Error,eSS_Error,eSS_Error),//08-0f
 	MW_PCK4BITS(eSS_Error,eSS_Error,eSS_ItsMe,eSS_ItsMe,eSS_ItsMe,eSS_ItsMe,eSS_ItsMe,eSS_ItsMe),//10-17
 	MW_PCK4BITS(eSS_ItsMe,eSS_ItsMe,eSS_ItsMe,eSS_Error,eSS_Error,eSS_Error,     4,eSS_Error),//18-1f
 	MW_PCK4BITS(eSS_Error,eSS_Error,eSS_Error,eSS_ItsMe,eSS_Error,eSS_Error,eSS_Error,eSS_Error),//20-27
 	MW_PCK4BITS(     5,     6,eSS_Error,eSS_Error,eSS_Error,eSS_Error,eSS_Error,eSS_Error),//28-2f
 	MW_PCK4BITS(eSS_Error,eSS_Error,eSS_Error,eSS_ItsMe,eSS_Error,eSS_Error,eSS_Error,eSS_Error),//30-37
 	MW_PCK4BITS(eSS_Error,eSS_Error,eSS_Error,eSS_Error,eSS_Error,eSS_ItsMe,eSS_Error,eSS_Start) //38-3f
 };
 	
 const BRUINT32 ISO2022CNCharLenTable[] = {0, 0, 0, 0, 0, 0, 0, 0, 0};
 	

 const BRUINT32 MW_ISO2022JP_cls [ 256 / 8 ] = {
 	MW_PCK4BITS(2,0,0,0,0,0,0,0),  // 00 - 07
 	MW_PCK4BITS(0,0,0,0,0,0,2,2),  // 08 - 0f
 	MW_PCK4BITS(0,0,0,0,0,0,0,0),  // 10 - 17
 	MW_PCK4BITS(0,0,0,1,0,0,0,0),  // 18 - 1f
 	MW_PCK4BITS(0,0,0,0,7,0,0,0),  // 20 - 27
 	MW_PCK4BITS(3,0,0,0,0,0,0,0),  // 28 - 2f
 	MW_PCK4BITS(0,0,0,0,0,0,0,0),  // 30 - 37
 	MW_PCK4BITS(0,0,0,0,0,0,0,0),  // 38 - 3f
 	MW_PCK4BITS(6,0,4,0,8,0,0,0),  // 40 - 47
 	MW_PCK4BITS(0,9,5,0,0,0,0,0),  // 48 - 4f
 	MW_PCK4BITS(0,0,0,0,0,0,0,0),  // 50 - 57
 	MW_PCK4BITS(0,0,0,0,0,0,0,0),  // 58 - 5f
 	MW_PCK4BITS(0,0,0,0,0,0,0,0),  // 60 - 67
 	MW_PCK4BITS(0,0,0,0,0,0,0,0),  // 68 - 6f
 	MW_PCK4BITS(0,0,0,0,0,0,0,0),  // 70 - 77
 	MW_PCK4BITS(0,0,0,0,0,0,0,0),  // 78 - 7f
 	MW_PCK4BITS(2,2,2,2,2,2,2,2),  // 80 - 87
 	MW_PCK4BITS(2,2,2,2,2,2,2,2),  // 88 - 8f
 	MW_PCK4BITS(2,2,2,2,2,2,2,2),  // 90 - 97
 	MW_PCK4BITS(2,2,2,2,2,2,2,2),  // 98 - 9f
 	MW_PCK4BITS(2,2,2,2,2,2,2,2),  // a0 - a7
 	MW_PCK4BITS(2,2,2,2,2,2,2,2),  // a8 - af
 	MW_PCK4BITS(2,2,2,2,2,2,2,2),  // b0 - b7
 	MW_PCK4BITS(2,2,2,2,2,2,2,2),  // b8 - bf
 	MW_PCK4BITS(2,2,2,2,2,2,2,2),  // c0 - c7
 	MW_PCK4BITS(2,2,2,2,2,2,2,2),  // c8 - cf
 	MW_PCK4BITS(2,2,2,2,2,2,2,2),  // d0 - d7
 	MW_PCK4BITS(2,2,2,2,2,2,2,2),  // d8 - df
 	MW_PCK4BITS(2,2,2,2,2,2,2,2),  // e0 - e7
 	MW_PCK4BITS(2,2,2,2,2,2,2,2),  // e8 - ef
 	MW_PCK4BITS(2,2,2,2,2,2,2,2),  // f0 - f7
 	MW_PCK4BITS(2,2,2,2,2,2,2,2)   // f8 - ff
 };
 	
 	
 const BRUINT32 ISO2022JP_st [ 9] = {
 	MW_PCK4BITS(eSS_Start,     3,eSS_Error,eSS_Start,eSS_Start,eSS_Start,eSS_Start,eSS_Start),//00-07
 	MW_PCK4BITS(eSS_Start,eSS_Start,eSS_Error,eSS_Error,eSS_Error,eSS_Error,eSS_Error,eSS_Error),//08-0f
 	MW_PCK4BITS(eSS_Error,eSS_Error,eSS_Error,eSS_Error,eSS_ItsMe,eSS_ItsMe,eSS_ItsMe,eSS_ItsMe),//10-17
 	MW_PCK4BITS(eSS_ItsMe,eSS_ItsMe,eSS_ItsMe,eSS_ItsMe,eSS_ItsMe,eSS_ItsMe,eSS_Error,eSS_Error),//18-1f
 	MW_PCK4BITS(eSS_Error,     5,eSS_Error,eSS_Error,eSS_Error,     4,eSS_Error,eSS_Error),//20-27
 	MW_PCK4BITS(eSS_Error,eSS_Error,eSS_Error,     6,eSS_ItsMe,eSS_Error,eSS_ItsMe,eSS_Error),//28-2f
 	MW_PCK4BITS(eSS_Error,eSS_Error,eSS_Error,eSS_Error,eSS_Error,eSS_Error,eSS_ItsMe,eSS_ItsMe),//30-37
 	MW_PCK4BITS(eSS_Error,eSS_Error,eSS_Error,eSS_ItsMe,eSS_Error,eSS_Error,eSS_Error,eSS_Error),//38-3f
 	MW_PCK4BITS(eSS_Error,eSS_Error,eSS_Error,eSS_Error,eSS_ItsMe,eSS_Error,eSS_Start,eSS_Start) //40-47
 };
 	
 const BRUINT32 ISO2022JPCharLenTable[] = {0, 0, 0, 0, 0, 0, 0, 0};
 	
 	
 const BRUINT32 ISO2022KR_cls [ 256 / 8 ] = {
 	MW_PCK4BITS(2,0,0,0,0,0,0,0),  // 00 - 07
 	MW_PCK4BITS(0,0,0,0,0,0,0,0),  // 08 - 0f
 	MW_PCK4BITS(0,0,0,0,0,0,0,0),  // 10 - 17
 	MW_PCK4BITS(0,0,0,1,0,0,0,0),  // 18 - 1f
 	MW_PCK4BITS(0,0,0,0,3,0,0,0),  // 20 - 27
 	MW_PCK4BITS(0,4,0,0,0,0,0,0),  // 28 - 2f
 	MW_PCK4BITS(0,0,0,0,0,0,0,0),  // 30 - 37
 	MW_PCK4BITS(0,0,0,0,0,0,0,0),  // 38 - 3f
 	MW_PCK4BITS(0,0,0,5,0,0,0,0),  // 40 - 47
 	MW_PCK4BITS(0,0,0,0,0,0,0,0),  // 48 - 4f
 	MW_PCK4BITS(0,0,0,0,0,0,0,0),  // 50 - 57
 	MW_PCK4BITS(0,0,0,0,0,0,0,0),  // 58 - 5f
 	MW_PCK4BITS(0,0,0,0,0,0,0,0),  // 60 - 67
 	MW_PCK4BITS(0,0,0,0,0,0,0,0),  // 68 - 6f
 	MW_PCK4BITS(0,0,0,0,0,0,0,0),  // 70 - 77
 	MW_PCK4BITS(0,0,0,0,0,0,0,0),  // 78 - 7f
 	MW_PCK4BITS(2,2,2,2,2,2,2,2),  // 80 - 87
 	MW_PCK4BITS(2,2,2,2,2,2,2,2),  // 88 - 8f
 	MW_PCK4BITS(2,2,2,2,2,2,2,2),  // 90 - 97
 	MW_PCK4BITS(2,2,2,2,2,2,2,2),  // 98 - 9f
 	MW_PCK4BITS(2,2,2,2,2,2,2,2),  // a0 - a7
 	MW_PCK4BITS(2,2,2,2,2,2,2,2),  // a8 - af
 	MW_PCK4BITS(2,2,2,2,2,2,2,2),  // b0 - b7
 	MW_PCK4BITS(2,2,2,2,2,2,2,2),  // b8 - bf
 	MW_PCK4BITS(2,2,2,2,2,2,2,2),  // c0 - c7
 	MW_PCK4BITS(2,2,2,2,2,2,2,2),  // c8 - cf
 	MW_PCK4BITS(2,2,2,2,2,2,2,2),  // d0 - d7
 	MW_PCK4BITS(2,2,2,2,2,2,2,2),  // d8 - df
 	MW_PCK4BITS(2,2,2,2,2,2,2,2),  // e0 - e7
 	MW_PCK4BITS(2,2,2,2,2,2,2,2),  // e8 - ef
 	MW_PCK4BITS(2,2,2,2,2,2,2,2),  // f0 - f7
 	MW_PCK4BITS(2,2,2,2,2,2,2,2)   // f8 - ff
 };
 	
 	
 const BRUINT32 ISO2022KR_st [ 5] = {
 	MW_PCK4BITS(eSS_Start,     3,eSS_Error,eSS_Start,eSS_Start,eSS_Start,eSS_Error,eSS_Error),//00-07
 	MW_PCK4BITS(eSS_Error,eSS_Error,eSS_Error,eSS_Error,eSS_ItsMe,eSS_ItsMe,eSS_ItsMe,eSS_ItsMe),//08-0f
 	MW_PCK4BITS(eSS_ItsMe,eSS_ItsMe,eSS_Error,eSS_Error,eSS_Error,     4,eSS_Error,eSS_Error),//10-17
 	MW_PCK4BITS(eSS_Error,eSS_Error,eSS_Error,eSS_Error,     5,eSS_Error,eSS_Error,eSS_Error),//18-1f
 	MW_PCK4BITS(eSS_Error,eSS_Error,eSS_Error,eSS_ItsMe,eSS_Start,eSS_Start,eSS_Start,eSS_Start) //20-27
 };
 	
 const BRUINT32 ISO2022KRCharLenTable[] = {0, 0, 0, 0, 0, 0};
 	

palCEscCharsetProber::palCEscCharsetProber()
{
	//1. HSZ 
	m_pSMModel[0] = KN_MALLOC_EX1(MW_SMModel);

	nsPkgInt* pPkgInt = KN_MALLOC_EX1(nsPkgInt);
	pPkgInt->idxsft = eIdxSft4bits;
	pPkgInt->sftmsk = eSftMsk4bits;
	pPkgInt->bitsft = eBitSft4bits;
	pPkgInt->unitmsk = eUnitMsk4bits;
	pPkgInt->data = MW_HZ_cls;
	m_pSMModel[0]->classTable = pPkgInt;

	m_pSMModel[0]->classFactor = 6;

	pPkgInt = KN_MALLOC_EX1(nsPkgInt);
	pPkgInt->idxsft = eIdxSft4bits;
	pPkgInt->sftmsk = eSftMsk4bits;
	pPkgInt->bitsft = eBitSft4bits;
	pPkgInt->unitmsk = eUnitMsk4bits;
	pPkgInt->data = HZ_st;
	m_pSMModel[0]->stateTable = pPkgInt;

	m_pSMModel[0]->charLenTable = HZCharLenTable;
	///////////////////////////////////////////////

	//2. ISO2022CN 
	m_pSMModel[1] = KN_MALLOC_EX1(MW_SMModel);

	pPkgInt = KN_MALLOC_EX1(nsPkgInt);
	pPkgInt->idxsft = eIdxSft4bits;
	pPkgInt->sftmsk = eSftMsk4bits;
	pPkgInt->bitsft = eBitSft4bits;
	pPkgInt->unitmsk = eUnitMsk4bits;
	pPkgInt->data = MW_ISO2022CN_cls;
	m_pSMModel[1]->classTable = pPkgInt;

	m_pSMModel[1]->classFactor = 9;

	pPkgInt = KN_MALLOC_EX1(nsPkgInt);
	pPkgInt->idxsft = eIdxSft4bits;
	pPkgInt->sftmsk = eSftMsk4bits;
	pPkgInt->bitsft = eBitSft4bits;
	pPkgInt->unitmsk = eUnitMsk4bits;
	pPkgInt->data = ISO2022CN_st;
	m_pSMModel[1]->stateTable = pPkgInt;

	m_pSMModel[1]->charLenTable = ISO2022CNCharLenTable;
	///////////////////////////////////////////////

	//3. ISO2022JP 
	m_pSMModel[2] = KN_MALLOC_EX1(MW_SMModel);

	pPkgInt = KN_MALLOC_EX1(nsPkgInt);
	pPkgInt->idxsft = eIdxSft4bits;
	pPkgInt->sftmsk = eSftMsk4bits;
	pPkgInt->bitsft = eBitSft4bits;
	pPkgInt->unitmsk = eUnitMsk4bits;
	pPkgInt->data = MW_ISO2022JP_cls;
	m_pSMModel[2]->classTable = pPkgInt;

	m_pSMModel[2]->classFactor = 10;

	pPkgInt = KN_MALLOC_EX1(nsPkgInt);
	pPkgInt->idxsft = eIdxSft4bits;
	pPkgInt->sftmsk = eSftMsk4bits;
	pPkgInt->bitsft = eBitSft4bits;
	pPkgInt->unitmsk = eUnitMsk4bits;
	pPkgInt->data = ISO2022JP_st;
	m_pSMModel[2]->stateTable = pPkgInt;

	m_pSMModel[2]->charLenTable = ISO2022JPCharLenTable;
	///////////////////////////////////////////////

	//4. ISO2022KR
	m_pSMModel[3] = KN_MALLOC_EX1(MW_SMModel);

	pPkgInt = KN_MALLOC_EX1(nsPkgInt);
	pPkgInt->idxsft = eIdxSft4bits;
	pPkgInt->sftmsk = eSftMsk4bits;
	pPkgInt->bitsft = eBitSft4bits;
	pPkgInt->unitmsk = eUnitMsk4bits;
	pPkgInt->data = ISO2022KR_cls;
	m_pSMModel[3]->classTable = pPkgInt;

	m_pSMModel[3]->classFactor = 6;

	pPkgInt = KN_MALLOC_EX1(nsPkgInt);
	pPkgInt->idxsft = eIdxSft4bits;
	pPkgInt->sftmsk = eSftMsk4bits;
	pPkgInt->bitsft = eBitSft4bits;
	pPkgInt->unitmsk = eUnitMsk4bits;
	pPkgInt->data = ISO2022KR_st;
	m_pSMModel[3]->stateTable = pPkgInt;

	m_pSMModel[3]->charLenTable = ISO2022KRCharLenTable;
	///////////////////////////////////////////////

	m_nActiveSM = NUM_OF_ESC_CHARSETS;
	m_eState = ePS_DETECTING;
	m_eDetectedCharset = eMC_UNKNOWN;

	//m_pCodingSM = KN_NEW palCCodingStateMachine(&UTF8SMModel);
	m_pCodingSM[0] = KN_NEW palCCodingStateMachine(m_pSMModel[0]);
	m_pCodingSM[1] = KN_NEW palCCodingStateMachine(m_pSMModel[1]);
	m_pCodingSM[2] = KN_NEW palCCodingStateMachine(m_pSMModel[2]);
	m_pCodingSM[3] = KN_NEW palCCodingStateMachine(m_pSMModel[3]);
}

palCEscCharsetProber::~palCEscCharsetProber()
{
	for (BRUINT32 i = 0; i < NUM_OF_ESC_CHARSETS; i++)
	{
		KN_MFREE(m_pSMModel[i]->classTable);
		KN_MFREE(m_pSMModel[i]->stateTable);
		KN_MFREE(m_pSMModel[i]);
		KN_SAFE_DEL(m_pCodingSM[i]);
	}
}

BRVOID palCEscCharsetProber::Reset()
{
	m_eState = ePS_DETECTING;
	for (BRUINT32 i = 0; i < NUM_OF_ESC_CHARSETS; i++)
		m_pCodingSM[i]->Reset(); 

	m_nActiveSM = NUM_OF_ESC_CHARSETS;
	m_eDetectedCharset = eMC_UNKNOWN;
}

EProbingState palCEscCharsetProber::HandleData(BRCSTR a_pBuf, BRUINT32 a_nLen)
{
	ESM_State codingState;

	BRINT32 j = 0;
	BRUINT32 i = 0;

	for (i = 0; i < a_nLen && m_eState == ePS_DETECTING; i++)
	{
		for (j = m_nActiveSM-1; j>= 0; j--)
		{
			//byte is feed to all active state machine
			codingState = m_pCodingSM[j]->NextState(a_pBuf[i]);
			if (codingState == eSS_Error)
			{
				//got negative answer for this state machine, make it inactive
				m_nActiveSM--;
				if(m_nActiveSM == 0)
				{
					m_eState = ePS_NOTME;
					return m_eState;
				}
				else if( j != (BRINT32)m_nActiveSM)
				{
					palCCodingStateMachine* tempCodingSM;
					tempCodingSM = m_pCodingSM[m_nActiveSM];
					m_pCodingSM[m_nActiveSM] = m_pCodingSM[j];
					m_pCodingSM[j] = tempCodingSM;
				}
			}
			else if(codingState == eSS_ItsMe)
			{
				m_eState = ePS_FOUNDIT;

				switch(j)
				{
				case 0: m_eDetectedCharset = eMC_HZ_GB_2312; break;
				case 1: m_eDetectedCharset = eMC_ISO_2022_CN; break;
				case 2: m_eDetectedCharset = eMC_ISO_2022_JP; break;
				case 3: m_eDetectedCharset = eMC_ISO_2022_KR; break;
				}

				//m_eDetectedCharset = m_pCodingSM[j]->GetCodingStateMachine();
				return m_eState;
			}
		}
	}

	return m_eState;
}
