#include <nds.h>
#include <nds/registers_alt.h>

#include "hio.h"

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdarg.h>

void rx_wait(u32 n,void *buf){
	u32 i;
	for(i=0;i<n;i++){
		for(;;){
			if(*((vu8 *)0x0A000001) & 1){
				*((u8 *)buf+i)=*((vu8 *)0x0A000000);
				break;
			}
		}
	}
}

static void tx_wait(u32 n,void *buf){
	u32 i;
	for(i=0;i<n;i++){
		for(;;){
			if((*((vu8 *)0x0A000001) & 2)==0){
				*((vu8 *)0x0A000000)=*((u8 *)buf+i);
				break;
			}
		}
	}
}

s32 PcOpen(s8 *filename,s32 mode){
	u32 i;
	u8 buf[64];
	u32 len;
	
	buf[0]=0xa1;
	for(len=0;;len++) if(filename[len]==0) break;
	buf[1]=len;
	
	for(i=0;i<len;i++){
		buf[2+i]=filename[i];
	}
	buf[2+len]=mode;
	buf[3+len]=mode>>8;
	tx_wait(4+len,buf);
	rx_wait(4,&len);
	return(len);
}

s32 PcClose(s32 fh){
	u8 buf[5];
	buf[0]=0xa2;
	buf[1]=fh;
	buf[2]=fh>>8;
	buf[3]=fh>>16;
	buf[4]=fh>>24;
	tx_wait(5,buf);
	return(0);
}

s32 PcRead(s32 fh,void *buffer,s32 size){
	s32 len;
	s32 zan,ofs;
	u8 buf[257];
	buf[0]=0xa3;
	buf[1]=fh;
	buf[2]=fh>>8;
	buf[3]=fh>>16;
	buf[4]=fh>>24;
	buf[5]=size;
	buf[6]=size>>8;
	buf[7]=size>>16;
	buf[8]=size>>24;
	tx_wait(9,buf);
	rx_wait(4,&size);
	if(size>0){
		zan=size;
		ofs=0;
		for(;;){
			if(zan>256){
				len=256;
			}
			else{
				len=zan;
			}
			rx_wait(len,buf);
			memcpy((u8 *)buffer+ofs,buf,len);
			ofs+=len;
			zan-=len;
			if(zan==0) break;
		}
	}
	return(size);
}

s32 PcWrite(s32 fh,void *buffer,s32 size){
	u8 buf[256];
	s32 len,zan,ofs;
	zan=size;
	ofs=0;
	for(;;){
		if(zan>256){
			len=256;
		}
		else{
			len=zan;
		}
		buf[0]=0xa4;
		buf[1]=fh;
		buf[2]=fh>>8;
		buf[3]=fh>>16;
		buf[4]=fh>>24;
		buf[5]=len;
		buf[6]=len>>8;
		buf[7]=len>>16;
		buf[8]=len>>24;
		tx_wait(9,buf);
		memcpy(buf,(u8 *)buffer+ofs,len);
		tx_wait(len,buf);
		ofs+=len;
		zan-=len;
		if(zan==0) break;
	}
	return(size);
}

s32 PcLseek(s32 fh,s32 offset,s32 where){
	u32 buf[13];
	buf[0]=0xa5;
	buf[1]=fh;
	buf[2]=fh>>8;
	buf[3]=fh>>16;
	buf[4]=fh>>24;
	buf[5]=offset;
	buf[6]=offset>>8;
	buf[7]=offset>>16;
	buf[8]=offset>>24;
	buf[9]=where;
	buf[10]=where>>8;
	buf[11]=where>>16;
	buf[12]=where>>24;
	tx_wait(13,buf);
	rx_wait(4,buf);
	return(*((u32 *)buf));
}

s32 PcBRead(s32 fh,void *buffer,s32 size){//xɓǂ߂̂0x100000(1M)܂
	u32 i;
	u8 buf[257];
	buf[0]=0xa6;
	buf[1]=fh;
	buf[2]=fh>>8;
	buf[3]=fh>>16;
	buf[4]=fh>>24;
	buf[5]=size;
	buf[6]=size>>8;
	buf[7]=size>>16;
	buf[8]=size>>24;
	tx_wait(9,buf);
	rx_wait(4,&size);
	for(i=0;i<size;i++){
		*((u8 *)buffer+i)=*((u8 *)0x08000000+i);
	}
	return(size);
}

s32 PcBWrite(s32 fh,void *buffer,s32 size){//xɏ̂0x100000(1M)܂
	u32 i;
	u8 buf[10];
	buf[0]=0xa7;
	buf[1]=fh;
	buf[2]=fh>>8;
	buf[3]=fh>>16;
	buf[4]=fh>>24;
	buf[5]=size;
	buf[6]=size>>8;
	buf[7]=size>>16;
	buf[8]=size>>24;
	for(i=0;i<(size+3)/4;i++){
		*((u32 *)0x08000000+i)=*((u32 *)buffer+i);
	}
	tx_wait(9,buf);
	rx_wait(1,buf);	//RAM؂ւ҂
	return(size);
}

void PcPrint(const char *str)
{
  s8 buf[2];
  buf[0]=0xa0;
  buf[1]=strlen(str)+1;
  tx_wait(2,buf);
  tx_wait(buf[1],(void*)str);
}

void PcPrintf(const char* format, ...){
  char strbuf[256];
  
  va_list args;
  
  va_start( args, format );
  vsprintf( strbuf, format, args );
  
  PcPrint(strbuf);
}

